/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.requestnote;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.ReqNoteEnum;

public class ReqNoteSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("spotinfo");
        selector.add("spotcurrencytypein");
        selector.add("spotcurrencytypeout");
        selector.add("spotamountin");
        selector.add("spotamountout");
        selector.add("spbizdate");
        selector.add("swapsinfo");
        selector.add("currin");
        selector.add("currout");
        selector.add("amtin");
        selector.add("amtout");
        selector.add("swbizdate");
        selector.add("swsettledate");
        selector.add("forwardinfo");
        selector.add("currencytypein");
        selector.add("currencytypeout");
        selector.add("amountin");
        selector.add("amountout");
        selector.add("fobizdate");
        selector.add("isoptionaltraction");
        selector.add("deliverydate");
        selector.add("deliveryenddate");
        selector.add("producttype");
        selector.add("limtno");
        selector.add("optionsinfo");
        selector.add("opcurrin");
        selector.add("opcurrout");
        selector.add("opamtin");
        selector.add("opamtout");
        selector.add("opbizdate");
        selector.add("opdeliverydate");
        selector.add("opbustype");
        selector.add("exerate");
        selector.add("deliverystartdate");
        selector.add("deliveryenddate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDException {
        for (ExtendedDataEntity data : entities) {
            DynamicObject entity = data.getDataEntity();
            DynamicObject product = entity.getDynamicObject("producttype");
            String number = product.getString("number");
            String entryName = ReqNoteEnum.getEntryByNumber((String)number);
            String entityName = ReqNoteEnum.getEnityByNumber((String)number);
            DynamicObjectCollection entry = entity.getDynamicObjectCollection(entryName);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u7533\u8bf7\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqNoteSubmitValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            this.checkDeldate(data, entityName, entry);
            this.checkBusinesstype(data, entity);
            this.checkLimit(data);
        }
    }

    private void checkLimit(ExtendedDataEntity data) {
        DynamicObject dataEntity = data.getDataEntity();
        DynamicObject product = dataEntity.getDynamicObject("producttype");
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            return;
        }
        String number = product.getString("number");
        if (ProductTypeEnum.FOREXSPOT.getValue().equals(number)) {
            this.checkLimitDate(data, "spotinfo", "spbizdate");
        }
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number)) {
            this.checkLimitDate(data, "forwardinfo", "fobizdate");
        }
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
            this.checkLimitDate(data, "swapsinfo", "swbizdate");
        }
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
            this.checkLimitDate(data, "optionsinfo", "opbizdate");
        }
    }

    protected void checkLimitDate(ExtendedDataEntity data, String entryName, String bizdateName) {
        DynamicObject entity = data.getDataEntity();
        DynamicObjectCollection rows = entity.getDynamicObjectCollection(entryName);
        DynamicObject limit = entity.getDynamicObject("limtno");
        if (EmptyUtil.isEmpty((DynamicObject)limit)) {
            return;
        }
        long limitid = limit.getLong("id");
        DynamicObject limitno = TmcDataServiceHelper.loadSingle((Object)entity.getDynamicObject("limtno").getPkValue(), (String)"tm_reqlimit");
        if (EmptyUtil.isEmpty((DynamicObject)limitno)) {
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)rows)) {
            return;
        }
        for (DynamicObject row : rows) {
            Date bizdate = row.getDate(bizdateName);
            Date vastdate = limitno.getDate("valistdate");
            Date vaenddate = limitno.getDate("valienddate");
            Date setstdate = limitno.getDate("setstdate");
            Date setenddate = limitno.getDate("setenddate");
            String status = limitno.getString("billstatus");
            if (!TcBillStatusEnum.AUDIT.getValue().equals(status)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReqNoteSubmitValidator_8", (String)"tmc-tm-business", (Object[])new Object[0]));
                return;
            }
            if (EmptyUtil.isEmpty((Object)bizdate)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqNoteSubmitValidator_7", (String)"tmc-tm-business", (Object[])new Object[0]));
                return;
            }
            if (!this.isEffectiveDate(bizdate, vastdate, vaenddate)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u4e0d\u5728\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355\u7684\u6709\u6548\u533a\u95f4\u5185\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u3002", (String)"ReqNoteSubmitValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
                return;
            }
            Date settledate = this.getSettleDate(row, entryName);
            if (EmptyUtil.isEmpty((Object)settledate)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u6216\u5230\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqNoteSubmitValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
                return;
            }
            if (this.isEffectiveDate(settledate, setstdate, setenddate)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u5728\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355\u7684\u4ea4\u6613\u5b58\u7eed\u671f\u5185\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u3002", (String)"ReqNoteSubmitValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
    }

    private Date getSettleDate(DynamicObject row, String entryName) {
        if ("forwardinfo".equals(entryName)) {
            boolean isopdate = row.getBoolean("isoptionaltraction");
            return isopdate ? row.getDate("deliveryenddate") : row.getDate("deliverydate");
        }
        if ("swapsinfo".equals(entryName)) {
            return row.getDate("swsettledate");
        }
        if ("optionsinfo".equals(entryName)) {
            return row.getDate("opdeliverydate");
        }
        return row.getDate("spotapplydeliverydate");
    }

    private boolean isEffectiveDate(Date date, Date startDate, Date endDate) {
        if (startDate == null) {
            if (endDate == null) {
                return true;
            }
            return !date.after(endDate);
        }
        if (endDate == null) {
            return !date.before(startDate);
        }
        return !date.before(startDate) && !date.after(endDate);
    }

    private void checkBusinesstype(ExtendedDataEntity data, DynamicObject entity) {
        DynamicObjectCollection spotInfos = entity.getDynamicObjectCollection("spotinfo");
        DynamicObjectCollection forwardInfos = entity.getDynamicObjectCollection("forwardinfo");
        if (spotInfos != null) {
            for (DynamicObject spotInfo : spotInfos) {
                this.validateAmount(data, spotInfo, "spotamountin", "spotamountout");
            }
        }
        if (forwardInfos != null) {
            for (DynamicObject forwardInfo : forwardInfos) {
                this.validateAmount(data, forwardInfo, "amountin", "amountout");
            }
        }
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(entity.getDynamicObject("producttype").get("number"))) {
            for (DynamicObject forwardInfo : entity.getDynamicObjectCollection("optionsinfo")) {
                this.validateAmount(data, forwardInfo, "opamtin", "opamtout");
                if (!EmptyUtil.isEmpty((Object)forwardInfo.get("exerate"))) continue;
                this.addErrorMessage(data, "");
            }
        }
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(entity.getDynamicObject("producttype").get("number"))) {
            for (DynamicObject forwardInfo : entity.getDynamicObjectCollection("swapsinfo")) {
                this.validateAmount(data, forwardInfo, "amtin", "amtout");
            }
        }
    }

    protected void validateAmount(ExtendedDataEntity data, DynamicObject info, String amountInName, String amountOutName) {
        BigDecimal amountIn = info.getBigDecimal(amountInName);
        BigDecimal amountOut = info.getBigDecimal(amountOutName);
        if (EmptyUtil.isEmpty((BigDecimal)amountIn) && EmptyUtil.isEmpty((BigDecimal)amountOut)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e70\u5165\u91d1\u989d\u548c\u5356\u51fa\u91d1\u989d\u81f3\u5c11\u586b\u4e00\u4e2a\u3002", (String)"ReqNoteSubmitValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void checkDeldate(ExtendedDataEntity data, String entityName, DynamicObjectCollection entry) {
        if ("tm_reqnote_forward".equals(entityName)) {
            for (DynamicObject row : entry) {
                if (row.getBoolean("isoptionaltraction")) {
                    Date delstdate = row.getDate("deliverystartdate");
                    Date delenddate = row.getDate("deliveryenddate");
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{delstdate, delenddate})) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u533a\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqNoteSubmitValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                    continue;
                }
                Date deldate = row.getDate("deliverydate");
                if (!EmptyUtil.isEmpty((Object)deldate)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqNoteSubmitValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }
}

