/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.structdeposit;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.MarkPriceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.resource.TeBizResource;

public class StructDepositSubmitOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("zone.seq");
        sic.add("zone.obstacle");
        sic.add("observe.obsdate");
        sic.add("pricey");
        sic.add("pricex");
        sic.add("markprice");
        sic.add("marktime");
        sic.add("markzone");
        sic.add("redeemtype");
        sic.add("structtype");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String error1 = new TeBizResource().checkStructDepositZoneSizeErr();
        String error2 = new TeBizResource().checkStructDepositZoneYErr();
        String error3 = new TeBizResource().checkStructDepositZoneXErr();
        String error4 = new TeBizResource().checkStructDepositZoneXYErr();
        String error5 = new TeBizResource().checkStructDepositZoneObstacle();
        String error6 = new TeBizResource().checkNotNullObsDate();
        String error7 = new TeBizResource().checkNotNullMarkTime();
        String error8 = new TeBizResource().checkNotNullMarkZone();
        String error9 = new TeBizResource().checkNotNullRedeemType();
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection zones = bill.getDynamicObjectCollection("zone");
            if (zones.size() < 2) {
                this.addErrorMessage(data, error1);
            }
            for (int index = 0; index < zones.size(); ++index) {
                DynamicObject nextZone;
                DynamicObject zone = (DynamicObject)zones.get(index);
                if (zone.getInt("seq") == 1 && EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricey"))) {
                    this.addErrorMessage(data, error2);
                }
                if (zone.getInt("seq") == zones.size() && zone.getInt("seq") != 1 && EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricex"))) {
                    this.addErrorMessage(data, error3);
                }
                if (zone.getInt("seq") != 1 && zone.getInt("seq") != 0 && zone.getInt("seq") != zones.size() && (EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricey")) || EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricex")))) {
                    this.addErrorMessage(data, error4);
                }
                if (zones.size() <= 2 || index >= zones.size() - 2 || (nextZone = (DynamicObject)zones.get(index + 1)).getBigDecimal("pricey").compareTo(zone.getBigDecimal("pricey")) > 0) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684y\u503c\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u4e0b\u4e00\u884c\u7684y\u503c\u3002", (String)"StructDepositSubmitOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[]{zone.getInt("seq")}));
            }
            String markPrice = bill.getString("markprice");
            if (MarkPriceEnum.ctu_price.getValue().equals(markPrice)) {
                boolean firstObs = ((DynamicObject)zones.get(0)).getBoolean("obstacle");
                boolean lastObs = ((DynamicObject)zones.get(zones.size() - 1)).getBoolean("obstacle");
                if (!firstObs && !lastObs) {
                    this.addErrorMessage(data, error5);
                }
            }
            DynamicObjectCollection observe = bill.getDynamicObjectCollection("observe");
            for (DynamicObject obj : observe) {
                if (!EmptyUtil.isEmpty((Object)obj.getDate("obsdate"))) continue;
                this.addErrorMessage(data, error6);
            }
            if (MarkPriceEnum.spec_point.getValue().equals(markPrice)) {
                if (-1 == bill.getInt("marktime")) {
                    this.addErrorMessage(data, error7);
                }
                if (EmptyUtil.isEmpty((Object)bill.get("markzone"))) {
                    this.addErrorMessage(data, error8);
                }
            }
            if (!"break".equals(bill.getString("structtype")) || !EmptyUtil.isEmpty((String)bill.getString("redeemtype"))) continue;
            this.addErrorMessage(data, error9);
        }
    }
}

