/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.trade;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class BuySettleOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("isbuysettle");
        sic.add("paysettletype");
        sic.add("paybankacct");
        sic.add("paybank");
        sic.add("recsettletype");
        sic.add("recbankacct");
        sic.add("recbank");
        sic.add("buysettledate");
        sic.add("buysettleamt");
        sic.add("isbuysettle");
        sic.add("rateswaptype");
        sic.add("initpriextype");
        sic.add("plamt");
        sic.add("ishis");
        sic.add("plcurrency");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String tipSettleDate = ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuySettleOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]);
        String tipSettleAmt = ResManager.loadKDString((String)"\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuySettleOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]);
        String tipSettleType = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuySettleOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]);
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject bill = data.getDataEntity();
            String entityName = bill.getDataEntityType().getName();
            if ("tm_rateswap".equals(entityName)) {
                this.checkRateSwap(data, bill);
            }
            if ("tm_bond_fix".equals(entityName) || "tm_bond_float".equals(entityName) || "tm_structdeposit".equals(entityName)) {
                if (EmptyUtil.isEmpty((Object)bill.get("paysettletype"))) {
                    this.addErrorMessage(data, tipSettleType);
                }
                if (EmptyUtil.isEmpty((Object)bill.get("buysettledate"))) {
                    this.addErrorMessage(data, tipSettleDate);
                }
                if (EmptyUtil.isEmpty((Object)bill.get("buysettleamt"))) {
                    this.addErrorMessage(data, tipSettleAmt);
                }
            }
            if (!"tm_forex_options".equals(entityName)) continue;
            this.checkForexOption(data, bill);
        }
    }

    private void checkRateSwap(ExtendedDataEntity data, DynamicObject bill) {
        String swapType = bill.getString("rateswaptype");
        String initPriExType = bill.getString("initpriextype");
        if (!SwapTypeEnum.currency.getValue().equals(swapType) || !SwapExchangeType.Actual.getValue().equals(initPriExType)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8d27\u5e01\u4e92\u6362\u5e76\u4e14\u671f\u521d\u672c\u91d1\u4ea4\u6362\u662f\u5b9e\u9645\u672c\u91d1\u7684\u5355\u636e\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"BuySettleOpValidator_9", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
        if (!TcBillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u8fdb\u884c\u7ed3\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuySettleOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
        if (bill.getBoolean("isbuysettle")) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6ca1\u6709\u4e70\u5165\u7ed3\u7b97\u7684\u5355\u636e\u8fdb\u884c\u7ed3\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuySettleOpValidator_8", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bill.get("paysettletype"), bill.get("recsettletype")})) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuySettleOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)bill.get("buysettledate"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuySettleOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((DynamicObject)bill.getDynamicObject("plcurrency"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u635f\u76ca\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuySettleOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void checkForexOption(ExtendedDataEntity data, DynamicObject bill) {
        if (bill.getBoolean("ishis")) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u4e14\u5386\u53f2\u5355\u636e\u4e3a\u5426\u7684\u5355\u636e\u8fdb\u884c\u7ed3\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuySettleOpValidator_11", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isEmpty((Object)bill.get("buysettleamt"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5355\u636e\u671f\u6743\u8d39\u4e3a0\uff0c\u65e0\u9700\u8fdb\u884c\u7ed3\u7b97\u64cd\u4f5c\u3002", (String)"BuySettleOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
        if (!TcBillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u8fdb\u884c\u7ed3\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuySettleOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
        if (bill.getBoolean("isbuysettle")) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6ca1\u6709\u8fdb\u884c\u671f\u6743\u8d39\u7ed3\u7b97\u7684\u5355\u636e\u8fdb\u884c\u7ed3\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuySettleOpValidator_7", (String)"tmc-tm-business", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isEmpty((Object)bill.get("paysettletype"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuySettleOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)bill.get("buysettledate"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BuySettleOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

