/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.trade;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;

public class BuyUnSettleOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("tradedirect");
        sic.add("isbuysettle");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        block12: for (ExtendedDataEntity data : dataEntity) {
            String entityName;
            DynamicObject bill = data.getDataEntity();
            switch (entityName = bill.getDataEntityType().getName()) {
                case "tm_bond_fix": 
                case "tm_bond_float": 
                case "tm_structdeposit": {
                    this.checkPayBill(bill, data);
                    continue block12;
                }
                case "tm_rateswap": {
                    if (!this.checkStatus(bill, data)) continue block12;
                    this.checkPayBill(bill, data);
                    this.checkRecBill(bill, data);
                    this.checkExchangeBill(bill, data);
                    continue block12;
                }
                case "tm_forex_options": {
                    if (!bill.getBoolean("isbuysettle")) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u7ed3\u7b97\u671f\u6743\u8d39\u7684\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuyUnSettleOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                        continue block12;
                    }
                    if (!TcBillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuyUnSettleOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
                        continue block12;
                    }
                    String tradeDir = bill.getString("tradedirect");
                    if (TradeDirectionEnum.buy.getValue().equals(tradeDir)) {
                        this.checkPayBill(bill, data);
                    }
                    if (!TradeDirectionEnum.sell.getValue().equals(tradeDir)) continue block12;
                    this.checkRecBill(bill, data);
                }
            }
        }
    }

    private boolean checkStatus(DynamicObject bill, ExtendedDataEntity data) {
        if (!TcBillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuyUnSettleOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
            return false;
        }
        if (!bill.getBoolean("isbuysettle")) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u4e70\u5165\u7ed3\u7b97\u7684\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BuyUnSettleOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void checkRecBill(DynamicObject bill, ExtendedDataEntity data) {
        DynamicObjectCollection recbills = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_recbill", (String)"billstatus");
        if (recbills != null && recbills.size() > 0) {
            for (DynamicObject recbill : recbills) {
                if (TcBillStatusEnum.SAVE.getValue().equals(recbill.getString("billstatus"))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5173\u8054\u7684\u6536\u6b3e\u5355\u5df2\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\uff0c\u5355\u636e\u5220\u9664\u5931\u8d25\u3002", (String)"BuyUnSettleOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkPayBill(DynamicObject bill, ExtendedDataEntity data) {
        DynamicObjectCollection paybills = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_paybill", (String)"billstatus");
        if (paybills != null && paybills.size() > 0) {
            for (DynamicObject paybill : paybills) {
                if (TcBillStatusEnum.SAVE.getValue().equals(paybill.getString("billstatus"))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u5df2\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\uff0c\u5355\u636e\u5220\u9664\u5931\u8d25\u3002", (String)"BuyUnSettleOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkExchangeBill(DynamicObject bill, ExtendedDataEntity data) {
        DynamicObjectCollection paybills = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_exchangebill", (String)"billstatus");
        if (paybills != null && paybills.size() > 0) {
            for (DynamicObject paybill : paybills) {
                if (TcBillStatusEnum.SAVE.getValue().equals(paybill.getString("billstatus"))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5173\u8054\u7684\u5916\u5e01\u5151\u6362\u5355\u5df2\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\uff0c\u5355\u636e\u5220\u9664\u5931\u8d25\u3002", (String)"BuyUnSettleOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }
}

