/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.trade;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;

public class ForexTradeExpireDeyOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("billstatus");
        return sic;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        Date currentDate = DateUtils.getCurrentDate();
        Object[] ids = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).map(DataEntityBase::getPkValue).toArray();
        DynamicObjectCollection col = QueryServiceHelper.query((String)"tm_bizrecord", (String)"tradeBillId", (QFilter[])new QFilter("tradeBillId", "in", (Object)ids).and("restAmt", ">", (Object)BigDecimal.ZERO).and(new QFilter("bizDate", "=", (Object)currentDate).and(QFilter.isNull((String)"endDate")).or(new QFilter("bizDate", "<=", (Object)currentDate).and("endDate", ">=", (Object)currentDate))).toArray(), (String)"lv,seqNo");
        Set tradeBillIdSet = col.stream().map(o -> o.get("tradeBillId")).collect(Collectors.toSet());
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject tradeBill = data.getDataEntity();
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(tradeBill.get("billstatus"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e(%s): \u4e0d\u7b26\u5408\u6761\u4ef6\uff1a \u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5b58\u7eed\u3002", (String)"AbsForexTrade2ExpireDeyConvertPlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{tradeBill.get("billno")}));
                continue;
            }
            if (tradeBillIdSet.contains(tradeBill.getPkValue())) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"%1$s\u65e5\u975e\u201c%2$s\u201d\u7684\u4ea4\u5272\u65e5\u6216\u4e0d\u5728\u4ea4\u5272\u65e5\u533a\u95f4\u5185\u3002", (String)"AbsForexTrade2ExpireDeyConvertPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{DateUtils.formatString((Date)currentDate, (String)"yyyy-MM-dd"), tradeBill.get("billno")}));
        }
    }
}

