/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.trade;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class TradeBillCfgOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("protecttype");
        sic.add("premium");
        sic.add("isbuysettle");
        sic.add("rateswaptype");
        sic.add("initpriextype");
        sic.add("ishis");
        return sic;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            BigDecimal premium;
            DynamicObject bill = data.getDataEntity();
            DynamicObject productType = bill.getDynamicObject("protecttype");
            String entityName = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
            if ("tm_forex_options".equals(entityName) && !bill.getBoolean("ishis") && (premium = bill.getBigDecimal("premium")).compareTo(BigDecimal.ZERO) != 0 && !bill.getBoolean("isbuysettle")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u786e\u8ba4\u524d\u8bf7\u5148\u8fdb\u884c\u671f\u6743\u8d39\u7ed3\u7b97\u3002", (String)"TradeBillCfgOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            if (("tm_structdeposit".equals(entityName) || "tm_bond_fix".equals(entityName) || "tm_bond_float".equals(entityName)) && !bill.getBoolean("isbuysettle")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u786e\u8ba4\u524d\u8bf7\u5148\u8fdb\u884c\u4e70\u5165\u7ed3\u7b97\u3002", (String)"TradeBillCfgOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            if (!"tm_rateswap".equals(entityName)) continue;
            String initPriExType = bill.getString("initpriextype");
            if (!SwapTypeEnum.currency.getValue().equals(bill.getString("rateswaptype")) || !SwapExchangeType.Actual.getValue().equals(initPriExType) || bill.getBoolean("isbuysettle")) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u786e\u8ba4\u524d\u8bf7\u5148\u8fdb\u884c\u4e70\u5165\u7ed3\u7b97\u3002", (String)"TradeBillCfgOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

