/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BizBillWriteBackRecService {
    public void execute(Object params) {
        String operate;
        List disposeData = (List)params;
        Map applyMap = (Map)disposeData.get(0);
        switch (operate = applyMap.get("operation").toString()) {
            case "receive": {
                this.recSynRecInfo(applyMap);
                break;
            }
            case "cancelreceive": {
                this.cancelRecSynRecInfo(applyMap);
            }
        }
    }

    private void recSynRecInfo(Map<String, Object> applyMap) {
        Long targetpk = (Long)applyMap.get("targetpk");
        DynamicObject recData = TmcDataServiceHelper.loadSingle((Object)targetpk, (String)"cas_recbill");
        String curBillNo = recData.getString("billno");
        DynamicObject sourBill = this.getSourBill(recData);
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            QFilter filter;
            String exChangeBillNo;
            String recBillNo;
            boolean canUpdate = true;
            String payBillNo = sourBill.getString("paybillno");
            if (EmptyUtil.isNoEmpty((String)payBillNo)) {
                QFilter payFilter = new QFilter("billstatus", "!=", (Object)"D");
                if (payBillNo.contains(",")) {
                    List payBillNos = Arrays.stream(payBillNo.split(",")).collect(Collectors.toList());
                    payFilter.and("billno", "in", payBillNos);
                } else {
                    payFilter.and("billno", "=", (Object)payBillNo);
                }
                boolean isPay = TmcDataServiceHelper.exists((String)"cas_paybill", (QFilter[])payFilter.toArray());
                if (isPay) {
                    canUpdate = false;
                }
            }
            if (EmptyUtil.isNoEmpty((String)(recBillNo = sourBill.getString("recbillno"))) && canUpdate) {
                QFilter recFilter = new QFilter("billstatus", "!=", (Object)"D");
                if (recBillNo.contains(",")) {
                    List recBillNos = Arrays.stream(payBillNo.split(",")).filter(s -> !curBillNo.equals(s)).collect(Collectors.toList());
                    recFilter.and("billno", "in", recBillNos);
                    boolean isRec = TmcDataServiceHelper.exists((String)"cas_recbill", (QFilter[])recFilter.toArray());
                    if (isRec) {
                        canUpdate = false;
                    }
                }
            }
            if (EmptyUtil.isNoEmpty((String)(exChangeBillNo = sourBill.getString("exchangebillno"))) && canUpdate && TmcDataServiceHelper.exists((String)"cas_exchangebill", (QFilter[])(filter = new QFilter("billstatus", "!=", (Object)"F").and("billno", "=", (Object)exChangeBillNo)).toArray())) {
                canUpdate = false;
            }
            if (canUpdate) {
                sourBill.set("billstatus", (Object)TcBillStatusEnum.SETTLE_DONE.getValue());
                this.saveSourBill(sourBill);
            }
        }
    }

    private void cancelRecSynRecInfo(Map<String, Object> applyMap) {
        Long targetpk = (Long)applyMap.get("targetpk");
        DynamicObject recData = TmcDataServiceHelper.loadSingle((Object)targetpk, (String)"cas_recbill");
        DynamicObject sourBill = this.getSourBill(recData);
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            sourBill.set("billstatus", (Object)TcBillStatusEnum.SETTLE_ING.getValue());
            this.saveSourBill(sourBill);
        }
    }

    private DynamicObject getSourBill(DynamicObject recData) {
        Long sourId = recData.getLong("sourcebillid");
        QFilter qFilter = new QFilter("id", "=", (Object)sourId);
        return TmcDataServiceHelper.loadSingle((String)"tm_businessbill", (String)"id,recbillno,paybillno,exchangebillno,billstatus", (QFilter[])qFilter.toArray());
    }

    private void saveSourBill(DynamicObject sourBill) {
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourBill});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

