/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.service.paywriteback;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;
import kd.tmc.tm.business.service.bizbill.BizBillWriteBackPayHelper;
import kd.tmc.tm.common.enums.SettleTagEnum;
import kd.tmc.tm.service.paywriteback.AbstractSettlePayBillWriteBackService;
import org.apache.commons.lang3.tuple.Pair;

public class BizBillWriteBackPayService
extends AbstractSettlePayBillWriteBackService {
    private static final Log logger = LogFactory.getLog(BizBillWriteBackPayService.class);

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return BusinessDataServiceHelper.loadSingle((String)"tm_businessbill", (String)String.join((CharSequence)",", BizBillWriteBackPayHelper.BIZ_BILL_PROPS), (QFilter[])new QFilter("id", "=", (Object)payBillInfo.getSourceBillId()).toArray());
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return null;
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return null;
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.validate(param, sourceBill);
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.validate(param, sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.validate(param, sourceBill);
    }

    protected void doCancelPayExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.cancelPaySynPayInfo(param, sourceBill);
    }

    protected void doPayExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.paySynPayInfo(param, sourceBill);
    }

    private void amtAndCurrencyValidate(PayBillWriteBackParam param, DynamicObject sourceBill) {
        int amtPrecision;
        long bizBillCurrencyId;
        logger.info("\u9632\u8d85\u989d\u6821\u9a8c\u548c\u5e01\u79cd\u6821\u9a8c start");
        PayBillWriteBackParam.PayBillInfo payBillInfo = param.getPayBill();
        long payBillCurrencyId = payBillInfo.getCurrencypk();
        Long payBillId = payBillInfo.getPayBillId();
        long sourceBillId = payBillInfo.getSourceBillId();
        BigDecimal actPayAmt = payBillInfo.getAmount();
        boolean isDiffCur = payBillInfo.isDiffCur();
        String settleTag = payBillInfo.getSettleTag();
        if (EmptyUtil.isEmpty((String)settleTag)) {
            return;
        }
        logger.info("payBillCurrencyId={}, payBillId={}, settleTag={}, sourceBillId={}, actPayAmt={}", new Object[]{payBillCurrencyId, payBillId, settleTag, sourceBillId, actPayAmt});
        DynamicObject bizBill = sourceBill;
        Pair AmtAndCurrencyColName = (Pair)BizBillWriteBackPayHelper.getAmtAndCurrencyColName((DynamicObject)bizBill, (String)settleTag).get(0);
        String payAmtColumn = (String)AmtAndCurrencyColName.getKey();
        String payCurrencyColumn = (String)AmtAndCurrencyColName.getValue();
        logger.info("payAmtColumn={}, payCurrencyColumn={}", new Object[]{payAmtColumn, payCurrencyColumn});
        if ("currency".equals(payCurrencyColumn) || "sellcurrency".equals(payCurrencyColumn)) {
            bizBillCurrencyId = bizBill.getDynamicObject("tradebill").getDynamicObject(payCurrencyColumn).getLong("id");
            amtPrecision = bizBill.getDynamicObject("tradebill").getDynamicObject(payCurrencyColumn).getInt("amtprecision");
        } else {
            bizBillCurrencyId = bizBill.getDynamicObject(payCurrencyColumn).getLong("id");
            amtPrecision = bizBill.getDynamicObject(payCurrencyColumn).getInt("amtprecision");
        }
        BigDecimal sourceBillLockPayAmount = this.getSourceBillLockPayAmount(sourceBillId, payBillId, settleTag);
        BigDecimal amt = bizBill.getBigDecimal(payAmtColumn).abs().setScale(amtPrecision, RoundingMode.HALF_UP);
        logger.info("sourceBillLockPayAmount={}, actPayAmt={}, amt={}", new Object[]{sourceBillLockPayAmount, actPayAmt, amt});
        if (sourceBillLockPayAmount.add(actPayAmt).compareTo(amt) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4e0a\u6e38\u751f\u547d\u5468\u671f\u5355\u91d1\u989d\u3002", (String)"BizBillWriteBackPayService_2", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
        logger.info("payBillCurrencyId={}, bizBillCurrencyId={}", new Object[]{payBillCurrencyId, bizBillCurrencyId});
        if (payBillCurrencyId != bizBillCurrencyId) {
            if (isDiffCur) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d/\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4e0a\u6e38\u751f\u547d\u5468\u671f\u5355\u91d1\u989d\u3002", (String)"BizBillWriteBackPayService_4", (String)"tmc-tm-mservice", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd\u9700\u8981\u548c\u4e0a\u6e38\u751f\u547d\u5468\u671f\u5355\u4fdd\u6301\u4e00\u81f4\u3002", (String)"BizBillWriteBackPayService_3", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
        logger.info("\u9632\u8d85\u989d\u6821\u9a8c\u548c\u5e01\u79cd\u6821\u9a8c end");
    }

    protected BigDecimal getSourceBillLockPayAmount(Object bizBillId, Long payBillId, String settleTag) {
        Object[] targetBillIds = TmcBotpHelper.getTargetBillIds((String)"tm_businessbill", (Object)bizBillId, (String)"cas_paybill");
        if (EmptyUtil.isEmpty((Object[])targetBillIds)) {
            return BigDecimal.ZERO;
        }
        targetBillIds = (Long[])Arrays.stream(targetBillIds).filter(targetBillId -> targetBillId.longValue() != payBillId.longValue()).toArray(Long[]::new);
        logger.info("targetBillIds size = {}", (Object)targetBillIds.length);
        if (EmptyUtil.isEmpty((Object[])targetBillIds)) {
            return BigDecimal.ZERO;
        }
        QFilter filter = new QFilter("id", "in", (Object)targetBillIds).and(new QFilter("settletag", "=", (Object)settleTag).or(QFilter.isNull((String)"settletag")));
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"actpayamt", (QFilter[])filter.toArray());
        return payBills.stream().map(p -> p.getBigDecimal("actpayamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void paySynPayInfo(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.ensureSettleTag(param);
        PayBillWriteBackParam.PayBillInfo payBillInfo = param.getPayBill();
        String curBillNo = payBillInfo.getPayBillNo();
        DynamicObject sourBill = sourceBill;
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            QFilter filter;
            String exChangeBillNo;
            String payBillNo;
            boolean canUpdate = true;
            String recBillNo = sourBill.getString("recbillno");
            if (EmptyUtil.isNoEmpty((String)recBillNo)) {
                QFilter recFilter = new QFilter("billstatus", "!=", (Object)"D");
                if (recBillNo.contains(",")) {
                    List recBillNos = Arrays.stream(recBillNo.split(",")).collect(Collectors.toList());
                    recFilter.and("billno", "in", recBillNos);
                } else {
                    recFilter.and("billno", "=", (Object)recBillNo);
                }
                boolean isRec = TmcDataServiceHelper.exists((String)"cas_recbill", (QFilter[])recFilter.toArray());
                if (isRec) {
                    canUpdate = false;
                }
            }
            if (EmptyUtil.isNoEmpty((String)(payBillNo = sourBill.getString("paybillno"))) && canUpdate) {
                QFilter payFilter = new QFilter("billstatus", "!=", (Object)"D");
                if (payBillNo.contains(",")) {
                    List payBillNos = Arrays.stream(payBillNo.split(",")).filter(s -> !curBillNo.equals(s)).collect(Collectors.toList());
                    payFilter.and("billno", "in", payBillNos);
                    boolean isPay = TmcDataServiceHelper.exists((String)"cas_paybill", (QFilter[])payFilter.toArray());
                    if (isPay) {
                        canUpdate = false;
                    }
                }
            }
            if (EmptyUtil.isNoEmpty((String)(exChangeBillNo = sourBill.getString("exchangebillno"))) && canUpdate && TmcDataServiceHelper.exists((String)"cas_exchangebill", (QFilter[])(filter = new QFilter("billstatus", "!=", (Object)"F").and("billno", "=", (Object)exChangeBillNo)).toArray())) {
                canUpdate = false;
            }
            if (canUpdate) {
                sourBill.set("billstatus", (Object)TcBillStatusEnum.SETTLE_DONE.getValue());
                this.saveSourBill(sourBill);
            }
        }
    }

    private void cancelPaySynPayInfo(PayBillWriteBackParam param, DynamicObject sourceBill) {
        DynamicObject sourBill = sourceBill;
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            sourBill.set("billstatus", (Object)TcBillStatusEnum.SETTLE_ING.getValue());
            this.saveSourBill(sourBill);
        }
    }

    private void saveSourBill(DynamicObject sourBill) {
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourBill});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void validate(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.ensureSettleTag(param);
        this.repeatValidate(param, sourceBill);
        this.amtAndCurrencyValidate(param, sourceBill);
    }

    private void ensureSettleTag(PayBillWriteBackParam param) {
        PayBillWriteBackParam.PayBillInfo paybillInfo = param.getPayBill();
        if (EmptyUtil.isEmpty((String)paybillInfo.getSettleTag())) {
            DynamicObject payBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"settletag", (QFilter[])new QFilter("id", "=", (Object)paybillInfo.getPayBillId()).toArray());
            paybillInfo.setSettleTag(payBill.getString("settletag"));
        }
    }

    private void repeatValidate(PayBillWriteBackParam param, DynamicObject sourceBill) {
        PayBillWriteBackParam.PayBillInfo paybillInfo = param.getPayBill();
        if ("saveValidate".equals(param.getOperate()) || "submitValidate".equals(param.getOperate())) {
            Long payBillId = paybillInfo.getPayBillId();
            Long sourceBillId = paybillInfo.getSourceBillId();
            String settleTag = paybillInfo.getSettleTag();
            if (EmptyUtil.isEmpty((String)settleTag) || SettleTagEnum.NON_PL.getValue().equals(settleTag)) {
                Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"tm_businessbill", (Long[])new Long[]{sourceBillId});
                HashSet exchangebills = null;
                if (botpMap.containsKey("cas_exchangebill")) {
                    exchangebills = (HashSet)botpMap.get("cas_exchangebill");
                    exchangebills.remove(payBillId);
                }
                if (EmptyUtil.isNoEmpty(exchangebills)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u5916\u5e01\u5151\u6362\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"RateSwapGenExchangeBillOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected String getSourceType() {
        return "tm_businessbill";
    }
}

