/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.service.paywriteback;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;
import kd.tmc.tm.service.paywriteback.AbstractSettlePayBillWriteBackService;

public class ForexOptionPaybillWriteBackService
extends AbstractSettlePayBillWriteBackService {
    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        Long sourceBillId = this.getSourceBillId(payBillInfo);
        return TmcDataServiceHelper.loadSingle((Object)sourceBillId, (String)"tm_forex_options", (String)"billno,buysettleamt,premiumcurrency,bizdate,paybillno,lockpayamt,billstatus,buysettleamt,isbuysettle");
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("premiumcurrency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        DynamicObject currency = sourceBill.getDynamicObject("premiumcurrency");
        int amtprecision = currency.getInt("amtprecision");
        return sourceBill.getBigDecimal("buysettleamt").setScale(amtprecision, RoundingMode.HALF_UP).abs();
    }

    @Override
    protected String getSourceType() {
        return "tm_forex_options";
    }

    protected void checkPayBill(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.validateForexOptionConditionsOfSettle(sourceBill);
        super.checkPayBill(param, sourceBill);
    }

    private void validateForexOptionConditionsOfSettle(DynamicObject sourceBill) {
        BigDecimal buySettleAmt = sourceBill.getBigDecimal("buysettleamt");
        if (EmptyUtil.isEmpty((BigDecimal)buySettleAmt)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613\u5355\u636e\u671f\u6743\u8d39\u4e3a0\uff0c\u65e0\u9700\u8fdb\u884c\u7ed3\u7b97\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (buySettleAmt.compareTo(BigDecimal.ZERO) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u91d1\u989d\u4e3a\u6b63\u6570\uff0c\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"AbstractRecOrPayOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

