/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.service.paywriteback;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.service.paywriteback.AbstractSettlePayBillWriteBackService;

public class RateSwapPaybillWriteBackService
extends AbstractSettlePayBillWriteBackService {
    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        Long sourceBillId = this.getSourceBillId(payBillInfo);
        return TmcDataServiceHelper.loadSingle((Object)sourceBillId, (String)"tm_rateswap", (String)"id,billno,recinitexamount,currency,reccurrency,bizdate,paybillno,lockpayamt,billstatus,rateswaptype,initpriextype,isbuysettle");
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return sourceBill.getDynamicObject("reccurrency").getLong("id");
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        DynamicObject reccurrency = sourceBill.getDynamicObject("reccurrency");
        int amtprecision = reccurrency.getInt("amtprecision");
        return sourceBill.getBigDecimal("recinitexamount").setScale(amtprecision, RoundingMode.HALF_UP).abs();
    }

    @Override
    protected String getSourceType() {
        return "tm_rateswap";
    }

    private void validateRepeatedPushExchangeBill(Long sourcebillid, Long targetId) {
        Long payBillTableId = TmcBotpHelper.getTableIdByEntityKey((String)"cas_paybill");
        Long exchangeBillTableId = TmcBotpHelper.getTableIdByEntityKey((String)"cas_exchangebill");
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"tm_rateswap", (Long[])new Long[]{sourcebillid});
        if (dirtTargetBills != null && !CollectionUtils.isEmpty((Map)dirtTargetBills)) {
            List bfRows = (List)dirtTargetBills.get(sourcebillid);
            for (BFRow bfRow : bfRows) {
                Long exchangeBillId;
                BFRowId tRow = bfRow.getId();
                if (Objects.equals(tRow.getMainTableId(), payBillTableId)) {
                    Long paybillId = tRow.getBillId();
                    if (Objects.equals(paybillId, targetId)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"RateSwapPaybillWriteBackService_1", (String)"tmc-tm-mservice", (Object[])new Object[0]));
                }
                if (!Objects.equals(tRow.getMainTableId(), exchangeBillTableId) || Objects.equals(exchangeBillId = tRow.getBillId(), targetId)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u5916\u5e01\u5151\u6362\u5355\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"RateSwapPaybillWriteBackService_0", (String)"tmc-tm-mservice", (Object[])new Object[0]));
            }
        }
    }

    protected void checkPayBill(PayBillWriteBackParam param, DynamicObject sourceBill) {
        Long payBillId = param.getPayBill().getPayBillId();
        this.validateSwapConditionsOfSettle(sourceBill);
        this.validateRepeatedPushExchangeBill(sourceBill.getLong("id"), payBillId);
        super.checkPayBill(param, sourceBill);
    }

    private void validateSwapConditionsOfSettle(DynamicObject sourceBill) {
        String swapType = sourceBill.getString("rateswaptype");
        String initPriExType = sourceBill.getString("initpriextype");
        if (!SwapTypeEnum.currency.getValue().equals(swapType) || !SwapExchangeType.Actual.getValue().equals(initPriExType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u671f\u521d\u672c\u91d1\u4ea4\u6362\u4e3a\u5b9e\u9645\u672c\u91d1\u7684\u8d27\u5e01\u4e92\u6362\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

