/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.service.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.ProductTypeEnum;

public class DataUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DataUpgradeService.class);
    private static final List<String> FOREXLIST = new ArrayList<String>(4);
    private static final List<String> RATELIST = new ArrayList<String>(1);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle handle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            result.setEl("warning");
            try {
                result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u7ec4\u5408\u4ea4\u6613\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"DataUpgradeService_0", (String)"tmc-tm-mservice", (Object[])new Object[0]));
                this.dataUpgrade();
                result.setLog(ResManager.loadKDString((String)"\u7ec4\u5408\u4ea4\u6613\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"DataUpgradeService_1", (String)"tmc-tm-mservice", (Object[])new Object[0]));
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.info(e.getMessage());
                logger.info(result.getErrorInfo());
                handle.markRollback();
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private void dataUpgrade() {
        String synSelectStr = "select a.fid id , b.ftradebillentity tradebillentity from t_tm_combtrade a ,t_tm_combtrade_info b where a.fid=b.fid group by a.fid,b.ftradebillentity";
        DataSet ds = DB.queryDataSet((String)"DataUpgradeService", (DBRoute)DBRouteConst.TC, (String)synSelectStr);
        HashMap map = new HashMap(16);
        while (ds.hasNext()) {
            ArrayList<String> list;
            Row row = ds.next();
            Long id = row.getLong("id");
            String tradebillentity = row.getString("tradebillentity");
            if (map.containsKey(id)) {
                list = (ArrayList<String>)map.get(id);
                list.add(tradebillentity);
                continue;
            }
            list = new ArrayList<String>(8);
            list.add(tradebillentity);
            map.put(id, list);
        }
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Long key = (Long)entry.getKey();
            List list = (List)entry.getValue();
            boolean isForex = true;
            boolean isRate = true;
            for (String tradebillentity : list) {
                if (!FOREXLIST.contains(tradebillentity)) {
                    isForex = false;
                }
                if (RATELIST.contains(tradebillentity)) continue;
                isRate = false;
            }
            String insertSql = "INSERT INTO T_TM_COMBTRADE_L (fpkid,fid,flocaleid,fvariety) VALUES (?,?,?,?);";
            String updateSql = "UPDATE T_TM_COMBTRADE set fcategory='1',fvariety=?,ftype='5' where fid=?";
            String deleteSql = "DELETE FROM T_TM_COMBTRADE_L where fid=?";
            String id = ID.genStringId();
            String variety = null;
            if (isForex) {
                variety = ResManager.loadKDString((String)"\u5916\u6c47", (String)"TradeBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
            }
            if (isRate) {
                variety = ResManager.loadKDString((String)"\u5229\u7387", (String)"TradeBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
            }
            if (!isForex && !isRate) {
                variety = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"CombTradeEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
            }
            Object[] updateParamIns = new Object[]{variety, key};
            DB.execute((DBRoute)DBRouteConst.TC, (String)updateSql, (Object[])updateParamIns);
            Object[] deleteParamIns = new Object[]{key};
            DB.execute((DBRoute)DBRouteConst.TC, (String)deleteSql, (Object[])deleteParamIns);
            Object[] paramIns = new Object[]{id, key, "zh_CN", variety};
            DB.execute((DBRoute)DBRouteConst.TC, (String)insertSql, (Object[])paramIns);
        }
    }

    static {
        FOREXLIST.add(ProductTypeEnum.FOREXSPOT.getEntity());
        FOREXLIST.add(ProductTypeEnum.FOREXFORWARD.getEntity());
        FOREXLIST.add(ProductTypeEnum.FOREXSWAPS.getEntity());
        FOREXLIST.add(ProductTypeEnum.FOREXOPTION.getEntity());
        RATELIST.add(ProductTypeEnum.SWAP.getEntity());
    }
}

