/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.service.upgrade;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.CombReqNoteEnum;

public class LimitDataUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(LimitDataUpgradeService.class);
    private static final String SELECT_LIMIT_SQL = "select fid,fbillno,fvalistdate,fvalienddate,fsetstdate,fsetenddate,fcurrencyid,fapplylimit,fuseamt,fremainamt from t_tm_reqlimit t where t.fbillstatus='C' and fid not in(select fid from t_tm_reqlimit_entry e where t.fid=e.fid)";
    private static final String UPDATE_LIMIT_SQL = "update t_tm_reqlimit set fvaliterm=?,fsetterm=? where fid =?";
    private static final String INSERT_LIMIT_ENTRY_SQL = "insert into t_tm_reqlimit_entry(fid,fentryid,fseq,fcurrencyid,flimitamt,fuseamt,fremainamt) values(?,?,?,?,?,?,?)";
    private static final String SELECT_REQNOTE_SQL = "select fid,fbillno,fproducttype,fbillstatus from t_tm_reqnote where fbillstatus in('B','C') and flimitno=";
    private static final String SELECT_LIMIT_USE_SQL = "select fid,fbillno,fcurrencyid from t_tm_reqlimit_use where fcurrencyid=? and flimitid=?";
    private static final String INSERT_LIMIT_USE_SQL = "insert into t_tm_reqlimit_use(fid,flimitid,fbillno,fcurrencyid,fbillstatus,flimitamt,fuseamt,fremainamt) values(?,?,?,?,?,?,?,?)";
    private static final String INSERT_LIMIT_USE_ENTRY_SQL = "insert into t_tm_reqlimit_use_entry(fid,fentryid,fbillno,fbilltype,fbillid,fproducttypeid,fbilluseamt,fuseamtratio) values(?,?,?,?,?,?,?,?)";
    private static final String SELECT_LIMIT_USE_ENTRY_SQL = "select fid from t_tm_reqlimit_use_entry where fid=? and fbillid=?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle handle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            result.setEl("warning");
            try {
                result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"LimitDataUpgradeService_0", (String)"tmc-tm-mservice", (Object[])new Object[0]));
                this.dataUpgrade();
                result.setLog(ResManager.loadKDString((String)"\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"LimitDataUpgradeService_1", (String)"tmc-tm-mservice", (Object[])new Object[0]));
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setSuccess(false);
                logger.info(e.getMessage());
                logger.info(result.getErrorInfo());
                handle.markRollback();
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private void dataUpgrade() {
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(1000);
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(1000);
        ArrayList<Object[]> insertLimitUseParamList = new ArrayList<Object[]>(1000);
        ArrayList<Object[]> insertLimitUseEntryParamList = new ArrayList<Object[]>(1000);
        DataSet limitDs = DB.queryDataSet((String)"LimitDataUpgradeService_Limit", (DBRoute)DBRouteConst.TC, (String)SELECT_LIMIT_SQL);
        while (limitDs.hasNext()) {
            Row row = limitDs.next();
            Map<Long, BigDecimal> limitMap = this.insertLimitUse(insertLimitUseParamList, insertLimitUseEntryParamList, row);
            this.updateLimit(insertParamList, updateParamList, row, limitMap);
        }
        if (updateParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TC, (String)UPDATE_LIMIT_SQL, updateParamList);
        }
        if (insertParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TC, (String)INSERT_LIMIT_ENTRY_SQL, insertParamList);
        }
        if (insertLimitUseParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TC, (String)INSERT_LIMIT_USE_SQL, insertLimitUseParamList);
        }
        if (insertLimitUseEntryParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TC, (String)INSERT_LIMIT_USE_ENTRY_SQL, insertLimitUseEntryParamList);
        }
    }

    private void updateLimit(List<Object[]> insertParamList, List<Object[]> updateParamList, Row limit, Map<Long, BigDecimal> limitMap) {
        Long limitId = limit.getLong("fid");
        BigDecimal fapplylimit = limit.getBigDecimal("fapplylimit");
        Long fcurrencyid = limit.getLong("fcurrencyid");
        Date fvalistdate = limit.getDate("fvalistdate");
        Date fvalienddate = limit.getDate("fvalienddate");
        Date fsetstdate = limit.getDate("fsetstdate");
        Date fsetenddate = limit.getDate("fsetenddate");
        String fvaliterm = "";
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{fvalistdate, fvalienddate})) {
            fvaliterm = TcDateUtils.getDiffYMD((Date)fvalistdate, (Date)fvalienddate);
        }
        String fsetterm = "";
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{fsetstdate, fsetenddate})) {
            fsetterm = TcDateUtils.getDiffYMD((Date)fsetstdate, (Date)fsetenddate);
        }
        Object[] updateParams = new Object[]{fvaliterm, fsetterm, limitId};
        BigDecimal useamt = limitMap.get(fcurrencyid);
        useamt = useamt == null ? BigDecimal.ZERO : useamt;
        BigDecimal remainamt = fapplylimit.subtract(useamt);
        Object[] insertParams = new Object[]{limitId, DBServiceHelper.genGlobalLongId(), 1, fcurrencyid, fapplylimit, useamt, remainamt};
        insertParamList.add(insertParams);
        updateParamList.add(updateParams);
        if (insertParamList.size() == 1000) {
            DB.executeBatch((DBRoute)DBRouteConst.TC, (String)UPDATE_LIMIT_SQL, updateParamList);
            DB.executeBatch((DBRoute)DBRouteConst.TC, (String)INSERT_LIMIT_ENTRY_SQL, insertParamList);
            updateParamList.clear();
            insertParamList.clear();
        }
    }

    private Map<Long, BigDecimal> insertLimitUse(List<Object[]> insertLimitUseParamList, List<Object[]> insertLimitUseEntryParamList, Row limit) {
        Long limitId = limit.getLong("fid");
        DataSet reqNotes = DB.queryDataSet((String)"LimitDataUpgradeService_ReqNote", (DBRoute)DBRouteConst.TC, (String)(SELECT_REQNOTE_SQL + limitId));
        String limitBillNo = limit.getString("fbillno");
        BigDecimal fapplylimit = limit.getBigDecimal("fapplylimit");
        BigDecimal fuseamt = limit.getBigDecimal("fuseamt");
        BigDecimal fremainamt = limit.getBigDecimal("fremainamt");
        HashMap<Long, BigDecimal> limitMap = new HashMap<Long, BigDecimal>(500);
        HashMap<String, Long> limitUseMap = new HashMap<String, Long>(500);
        HashMap<String, Long> limitUseEntryMap = new HashMap<String, Long>(500);
        while (reqNotes.hasNext()) {
            Row reqNote = reqNotes.next();
            Long reqNoteId = reqNote.getLong("fid");
            Long fproducttype = reqNote.getLong("fproducttype");
            String reqNoteNo = reqNote.getString("fbillno");
            String fproducttypeStr = String.valueOf(fproducttype);
            CombReqNoteEnum combReqNoteEnum = CombReqNoteEnum.getByProductTypeId((String)fproducttypeStr);
            String entity = this.getReqNoteEntity(combReqNoteEnum);
            String reqNoteEntrySelectStr = this.getReqNoteEntrySelect(combReqNoteEnum);
            DataSet reqNoteEntries = this.getReqNoteEntries(reqNoteEntrySelectStr + reqNoteId);
            Map<Long, BigDecimal> reqnoteCurrencyMap = this.getReqnoteCurrencyMap(reqNoteEntries, combReqNoteEnum);
            Set<Map.Entry<Long, BigDecimal>> entries = reqnoteCurrencyMap.entrySet();
            for (Map.Entry<Long, BigDecimal> entry : entries) {
                Long currencyId = entry.getKey();
                BigDecimal amt = entry.getValue();
                if (limitMap.containsKey(currencyId)) {
                    BigDecimal useamt = (BigDecimal)limitMap.get(currencyId);
                    useamt = useamt.add(amt);
                    limitMap.put(currencyId, useamt);
                } else {
                    limitMap.put(currencyId, amt);
                }
                if (EmptyUtil.isEmpty((BigDecimal)amt)) continue;
                DataSet limitUseDs = this.getLimitUseDs(new Object[]{currencyId, limitId});
                if (limitUseDs.hasNext()) {
                    Row limitUse = limitUseDs.next();
                    Long limitUseId = limitUse.getLong("fid");
                    DataSet limitUseEntryDs = this.getLimitUseEntryDs(new Object[]{limitUseId, reqNoteId});
                    if (!limitUseEntryDs.hasNext() && !limitUseEntryMap.containsKey(limitUseId + reqNoteNo)) {
                        BigDecimal fuseamtratio = amt.multiply(BigDecimal.valueOf(100L)).divide(fapplylimit, 2, RoundingMode.HALF_UP);
                        Object[] insertLimitUseEntryParams = new Object[]{limitUseId, DBServiceHelper.genGlobalLongId(), reqNoteNo, entity, reqNoteId, fproducttype, amt, fuseamtratio};
                        insertLimitUseEntryParamList.add(insertLimitUseEntryParams);
                        limitUseEntryMap.put(limitUseId + reqNoteNo, reqNoteId);
                    }
                } else {
                    Long limitUseId = null;
                    if (limitUseMap.containsKey(limitBillNo + currencyId)) {
                        limitUseId = (Long)limitUseMap.get(limitBillNo + currencyId);
                    } else {
                        limitUseId = DBServiceHelper.genGlobalLongId();
                        Object[] insertLimitUseParams = new Object[]{limitUseId, limitId, limitBillNo, currencyId, "C", fapplylimit, fuseamt, fremainamt};
                        insertLimitUseParamList.add(insertLimitUseParams);
                        limitUseMap.put(limitBillNo + currencyId, limitUseId);
                    }
                    BigDecimal fuseamtratio = amt.multiply(BigDecimal.valueOf(100L)).divide(fapplylimit, 2, RoundingMode.HALF_UP);
                    Object[] insertLimitUseEntryParams = new Object[]{limitUseId, DBServiceHelper.genGlobalLongId(), reqNoteNo, entity, reqNoteId, fproducttype, amt, fuseamtratio};
                    insertLimitUseEntryParamList.add(insertLimitUseEntryParams);
                }
                if (insertLimitUseParamList.size() == 500) {
                    this.exeSql(INSERT_LIMIT_USE_SQL, insertLimitUseParamList);
                    insertLimitUseParamList.clear();
                }
                if (insertLimitUseEntryParamList.size() != 1000) continue;
                this.exeSql(INSERT_LIMIT_USE_ENTRY_SQL, insertLimitUseEntryParamList);
                insertLimitUseEntryParamList.clear();
            }
        }
        return limitMap;
    }

    private void exeSql(String sql, List<Object[]> paramList) {
        DB.executeBatch((DBRoute)DBRouteConst.TC, (String)sql, paramList);
    }

    private DataSet getLimitUseEntryDs(Object[] params) {
        return DB.queryDataSet((String)"LimitDataUpgradeService_LimituseEntry", (DBRoute)DBRouteConst.TC, (String)SELECT_LIMIT_USE_ENTRY_SQL, (Object[])params);
    }

    private DataSet getLimitUseDs(Object[] objects) {
        return DB.queryDataSet((String)"LimitDataUpgradeService_Limituse", (DBRoute)DBRouteConst.TC, (String)SELECT_LIMIT_USE_SQL, (Object[])objects);
    }

    private DataSet getReqNoteEntries(String sql) {
        return DB.queryDataSet((String)"LimitDataUpgradeService_ReqNoteEntry", (DBRoute)DBRouteConst.TC, (String)sql);
    }

    private String getReqNoteEntity(CombReqNoteEnum combReqNoteEnum) {
        String entity = "";
        switch (combReqNoteEnum) {
            case SPOT: {
                entity = "tm_reqnote_spot";
                break;
            }
            case FORWARD: {
                entity = "tm_reqnote_forward";
                break;
            }
            case SWAPS: {
                entity = "tm_reqnote_swaps";
                break;
            }
            case OPTIONS: {
                entity = "tm_reqnote_options";
            }
        }
        return entity;
    }

    private Map<Long, BigDecimal> getReqnoteCurrencyMap(DataSet reqNoteEntries, CombReqNoteEnum combReqNoteEnum) {
        HashMap<Long, BigDecimal> reqnoteCurrencyMap = new HashMap<Long, BigDecimal>();
        for (Row reqNoteEntry : reqNoteEntries) {
            Long currin = reqNoteEntry.getLong(combReqNoteEnum.getEntryBuyCurrName());
            Long currout = reqNoteEntry.getLong(combReqNoteEnum.getEntrySellCurrName());
            BigDecimal amtin = reqNoteEntry.getBigDecimal(combReqNoteEnum.getEntryBuyAmtName());
            BigDecimal amtout = reqNoteEntry.getBigDecimal(combReqNoteEnum.getEntrySellAmtName());
            if (!reqnoteCurrencyMap.containsKey(currin)) {
                reqnoteCurrencyMap.put(currin, amtin);
            } else {
                BigDecimal currinamt = (BigDecimal)reqnoteCurrencyMap.get(currin);
                currinamt = currinamt.add(amtin);
                reqnoteCurrencyMap.put(currin, currinamt);
            }
            if (!reqnoteCurrencyMap.containsKey(currout)) {
                reqnoteCurrencyMap.put(currout, amtout);
                continue;
            }
            BigDecimal curroutamt = (BigDecimal)reqnoteCurrencyMap.get(currout);
            curroutamt = curroutamt.add(amtout);
            reqnoteCurrencyMap.put(currout, curroutamt);
        }
        return reqnoteCurrencyMap;
    }

    private String getReqNoteEntrySelect(CombReqNoteEnum combReqNoteEnum) {
        String select = "select";
        switch (combReqNoteEnum) {
            case SPOT: {
                select = "select fincurrencyid spotcurrencytypein,foutcurrencyid spotcurrencytypeout,famountin spotamountin,famountout spotamountout from t_tm_reqnote_spot where fid=";
                break;
            }
            case FORWARD: {
                select = "select fincurrencyid currencytypein,foutcurrencyid currencytypeout,famountin amountin,famountout amountout from t_tm_reqnote_fwd where fid=";
                break;
            }
            case SWAPS: {
                select = "select fincurrencyid currin,foutcurrencyid currout,famtin amtin,ffinalamtout amtout from t_tm_reqnote_swaps where fid=";
                break;
            }
            case OPTIONS: {
                select = "select fincurrencyid opcurrin,foutcurrencyid opcurrout,famtin opamtin,famtout opamtout from t_tm_reqnote_options where fid=";
            }
        }
        return select;
    }
}

