/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.forwrateagree;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.tbo.report.helper.ReportHelper;
import kd.tmc.tm.common.enums.BizOperateEnum;

public class ForwRateAgreeListRpt
extends AbstractTmcTreeReportDataPlugin {
    private static final String COMMA_SEPARATOR = ",";
    private static final String UNDERLINE_SEPARATOR = "_";
    private final List<QFilter> filterList = new ArrayList<QFilter>(12);
    private String dimensions;
    private String[] dimensionArr;
    private String orderString = null;
    public static final String SUFFIX_TEXT = "text";
    private String showType;
    private List<String> groups;
    private DynamicObject coamtcurrency = null;
    private DynamicObject plcurrency = null;
    private Map<String, Object> paramMap = null;
    private static final String BILL_INFO = "id,billno,org.id as org,org.name as orgtext,bizdate,billstatus,currency,currency.number,currency.name currencytext,amount,referindex,referindex.name referindextext,bizrestamt";
    private static final String PL_INFO = "id,org,tradebill.id as tradeid,bizrecord as bizrecordid,entrys.biztype,entrys.bizbillplcurrency bizbillplcurrency,entrys.bizbillplcurrency.number bizbillplcurrencynumber, entrys.plamt,entrys.bizdate,swapdir";
    private static final String TM_CASHFLOW = "id,billid,billno,cfdirection,cfispay,cfbizrecordid bizrecordid";
    private static final String TM_BUSINESS_BILL = "tradebill,bizdate,billstatus";
    private static final String PL_HISTORY_INFO = "plbill,updatedate,floatplamt,plcurrency as currency,plcurrency.number as plcurrencyNumber";
    private final List<Long> currencyIds = new ArrayList<Long>();
    private final List<Object[]> rateList = new ArrayList<Object[]>();
    private final List<Long> plCurrencyIds = new ArrayList<Long>();
    private final List<Object[]> plRateList = new ArrayList<Object[]>();
    private final LinkedHashSet<String> tipPairs = new LinkedHashSet(16);

    public DataSet queryDataSet(ReportQueryParam param) {
        this.init(param);
        DataSet billDatas = this.queryBillData();
        DataSet billDataSet = this.exchangeRateConversion(billDatas, this.paramMap);
        billDataSet = this.buildHistoryAmt(this.paramMap, billDataSet);
        DataSet plDataSet = this.queryPlInfoData(billDataSet);
        plDataSet = this.plExchangeRateConversion(this.paramMap, plDataSet);
        String[] swapBillNames = billDataSet.getRowMeta().getFieldNames();
        DataSet allBills = billDataSet.leftJoin(plDataSet).on("id", "tradeid").select(swapBillNames, this.getPlFields()).finish();
        Date startDate = (Date)this.paramMap.get("filter_startdate");
        DataSet bills = startDate != null ? allBills.filter("to_char(bizdate, 'yyyyMMdd') >=" + TcDateUtils.formatString((Date)startDate, (String)"yyyyMMdd")) : allBills;
        String unit = (String)this.paramMap.get("filter_currencyunit");
        List<String> amountFields = this.getAmountFields(this.groups);
        List<String> endAmountFields = amountFields.stream().filter(e -> e.contains("_end_")).collect(Collectors.toList());
        List<String> notendAmountFields = amountFields.stream().filter(e -> !e.contains("_end_")).collect(Collectors.toList());
        DataSet allDataSet = this.sumDataSet(bills, notendAmountFields, unit, false);
        DataSet endAllDataSet = this.sumDataSet(allBills, endAmountFields, unit, true);
        JoinDataSet joinDataSet = endAllDataSet.leftJoin(allDataSet);
        for (String group : this.groups) {
            joinDataSet.on(group, group);
        }
        String[] fields = ReportHelper.concat(allDataSet.getRowMeta().getFieldNames(), endAmountFields.toArray(new String[0]));
        DataSet finish = joinDataSet.select(fields).finish();
        finish = finish.filter("conamt_report != 0 and conamt_report !=null or hisamt_end_report != 0 and hisamt_end_report != null or floatpl_end_report != 0 and floatpl_end_report!=null");
        return finish;
    }

    private DataSet sumDataSet(DataSet bills, List<String> fields, String amtUnit, boolean isAddFields) {
        if (isAddFields) {
            bills = bills.addFields((String[])fields.stream().map(e -> e.replaceAll("end_", "")).toArray(String[]::new), fields.toArray(new String[0]));
        }
        GroupbyDataSet groupbyDataSet = bills.groupBy(this.groups.toArray(new String[0]));
        ArrayList<String> amountUnitExprs = new ArrayList<String>(fields.size());
        for (String amountField : fields) {
            groupbyDataSet.sum(amountField);
            amountUnitExprs.add(String.format(amountField + "/%s", amtUnit));
        }
        DataSet allDataSet = groupbyDataSet.finish();
        allDataSet = allDataSet.updateFields(fields.toArray(new String[0]), amountUnitExprs.toArray(new String[0]));
        return allDataSet;
    }

    protected boolean isNeedOrgTree() {
        return "org".equals(this.dimensions) && "step".equals(this.showType);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        return dataSet.addFields(new String[]{String.valueOf(this.coamtcurrency.getLong("id")), String.valueOf(this.plcurrency.getLong("id"))}, new String[]{"coamtcurrency", "plcurrency"});
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        boolean showTotal = (Boolean)paramMap.get("filter_istotal");
        int dimensionLength = this.dimensionArr.length;
        if (!showTotal || dimensionLength < 2) {
            return bizDs;
        }
        DataSet subTotalDs = bizDs.copy();
        String[] orderBy = this.getOrderBy(paramMap);
        for (int i = 0; i < dimensionLength - 1; ++i) {
            List<String> groups = this.getSubGroups(this.dimensionArr, i);
            subTotalDs = this.addSubTotalDataSet(subTotalDs, groups, this.getAmountFields(groups), this.isText(this.dimensionArr[0]) ? this.dimensionArr[0] : this.dimensionArr[0] + SUFFIX_TEXT);
            bizDs = bizDs.union(subTotalDs).orderBy(this.getSubOrderBy(orderBy, i));
        }
        return bizDs.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{this.uniqueRow, "'0'", "'0'"});
    }

    private String[] getOrderBy(Map<String, Object> paramMap) {
        return this.dimensionArr;
    }

    protected List<String> getSelectFields() {
        ArrayList<String> list = new ArrayList<String>(10);
        List<String> noSelectFileds = Arrays.asList("org", "currency", "referindex");
        for (String dimension : this.dimensionArr) {
            if (noSelectFileds.contains(dimension)) continue;
            if (this.isText(dimension)) {
                list.add(dimension);
                continue;
            }
            list.add(dimension);
            list.add(dimension + ".name " + dimension + SUFFIX_TEXT);
        }
        return list;
    }

    private String[] getSubOrderBy(String[] dimensions, int level) {
        if (dimensions.length < level) {
            return dimensions;
        }
        String[] orders = new String[dimensions.length - level - 1];
        System.arraycopy(dimensions, 0, orders, 0, dimensions.length - level - 1);
        return orders;
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        boolean showTotal = (Boolean)paramMap.get("filter_istotal");
        if (showTotal) {
            bizDs = super.addSumRowDataSet(bizDs, paramMap);
        }
        DynamicObject conCurrency = (DynamicObject)paramMap.get("filter_coamtcurrency");
        DynamicObject plCurrency = (DynamicObject)paramMap.get("filter_plcurrency");
        bizDs = bizDs.addFields(new String[]{String.valueOf(plCurrency.getLong("id")), String.valueOf(conCurrency.getLong("id"))}, new String[]{"plcurrency", "contcurrency"});
        return bizDs;
    }

    public List<String> groupFields() {
        return Arrays.stream(this.dimensionArr).collect(Collectors.toList());
    }

    public String sumNameField() {
        return this.getTotalField();
    }

    public List<String> sumAmountFields() {
        ArrayList<String> field = new ArrayList<String>(10);
        field.add("conamt_report");
        field.add("hisamt_report");
        field.add("hisamt_end_report");
        field.add("floatpl_report");
        field.add("floatpl_end_report");
        field.add("pl_report");
        field.add("totalpl_report");
        return field;
    }

    private List<String> getAmountFields(List<String> groups) {
        ArrayList<String> list = new ArrayList<String>();
        boolean containCurrency = groups.stream().anyMatch(e -> e.contains("currency"));
        if (containCurrency) {
            list.add("conamt_original");
            list.add("hisamt_original");
            list.add("hisamt_end_original");
            list.add("floatpl_original");
            list.add("floatpl_end_original");
            list.add("pl_original");
            list.add("totalpl_original");
        }
        list.add("conamt_report");
        list.add("hisamt_report");
        list.add("hisamt_end_report");
        list.add("floatpl_report");
        list.add("floatpl_end_report");
        list.add("pl_report");
        list.add("totalpl_report");
        return list;
    }

    private String[] getPlFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("floatpl_original");
        list.add("floatpl_report");
        list.add("pl_original");
        list.add("pl_report");
        list.add("totalpl_original");
        list.add("totalpl_report");
        return list.toArray(new String[0]);
    }

    private DataSet plExchangeRateConversion(Map<String, Object> paramMap, DataSet plInfoData) {
        DynamicObject currency = (DynamicObject)paramMap.get("filter_plcurrency");
        DynamicObject forexQuote = (DynamicObject)paramMap.get("filter_forexquote");
        Date startDate = (Date)paramMap.get("filter_startdate");
        Date enddate = (Date)paramMap.get("filter_enddate");
        String dateRangeStr = this.getDateRangeStr("entrys.bizdate", startDate, enddate);
        DataSet exchgRateDataSet = ReportHelper.calRateDataSet(this.plCurrencyIds, this.plRateList, plInfoData, forexQuote, currency, Arrays.asList("currency", "bizbillplcurrency"), Arrays.asList("plcurrencyNumber", "bizbillplcurrencynumber"), enddate, this.tipPairs);
        if (!EmptyUtil.isEmpty(this.tipPairs)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"ForwRateAgreeListRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]), String.join((CharSequence)"\u3001", this.tipPairs), forexQuote.getString("number")));
        }
        String[] plInfoNames = plInfoData.getRowMeta().getFieldNames();
        DataSet plDataSet = plInfoData.copy().leftJoin(exchgRateDataSet.distinct()).on("currency", "currency").select(plInfoNames, new String[]{"rate"}).finish();
        plDataSet = plDataSet.addFields(new String[]{"floatplamt", "floatplamt*rate", "case when " + dateRangeStr + " then entrys.plamt else 0 end pl_original"}, new String[]{"floatpl_original", "floatpl_report", "pl_original"});
        plDataSet = plDataSet.leftJoin(exchgRateDataSet.distinct()).on("bizbillplcurrency", "currency").select(plDataSet.getRowMeta().getFieldNames(), new String[]{"rate as plexrate"}).finish();
        plDataSet = plDataSet.addFields(new String[]{"pl_original*plexrate"}, new String[]{"pl_report"});
        GroupbyDataSet groupbyDataSet = plDataSet.groupBy(new String[]{"id", "tradeid", "bizrecordid", "org"});
        groupbyDataSet.max("floatpl_original");
        groupbyDataSet.max("floatpl_report");
        groupbyDataSet.sum("pl_original");
        groupbyDataSet.sum("pl_report");
        DataSet allDataSet = groupbyDataSet.finish();
        allDataSet = allDataSet.addFields(new String[]{"floatpl_original + pl_original", "floatpl_report + pl_report"}, new String[]{"totalpl_original", "totalpl_report"});
        return allDataSet;
    }

    private String getDateRangeStr(String field, Date startDate, Date enddate) {
        StringBuilder sb = new StringBuilder();
        String enddateStr = TcDateUtils.formatString((Date)enddate, (String)"yyyyMMdd");
        if (startDate != null) {
            String startDateStr = TcDateUtils.formatString((Date)startDate, (String)"yyyyMMdd");
            sb.append("to_char(").append(field).append(", 'yyyyMMdd') >= ").append(startDateStr).append(" and to_char(").append(field).append(", 'yyyyMMdd') <= ").append(enddateStr);
        } else {
            sb.append("to_char(").append(field).append(", 'yyyyMMdd') <= ").append(enddateStr);
        }
        return sb.toString();
    }

    private DataSet buildHistoryAmt(Map<String, Object> paramMap, DataSet bills) {
        Date endDate = (Date)paramMap.get("filter_enddate");
        Set<Long> swapIds = ReportHelper.getDataSetIds(bills, "id");
        QFilter payFilter = new QFilter("billid", "in", swapIds);
        DataSet payCashFlows = QueryServiceHelper.queryDataSet((String)"tm_cashflow_forwrateagree_data", (String)"tm_cashflow", (String)TM_CASHFLOW, (QFilter[])payFilter.toArray(), null);
        payCashFlows = payCashFlows.updateField("billno", "cast(billno as long)");
        DataSet lastCashFlows = payCashFlows.groupBy(new String[]{"billid", "bizrecordid"}).maxP("billno", "id").maxP("billno", "cfispay").finish();
        DataSet payedLastCashFlows = lastCashFlows.copy().filter("cfispay=true");
        Set<Long> billds = ReportHelper.getDataSetIds(payedLastCashFlows, "billid");
        QFilter businessFilter = new QFilter("operate", "in", (Object)BizOperateEnum.interestpay.getValue());
        businessFilter.and("tradebill", "in", billds);
        DataSet businessBills = QueryServiceHelper.queryDataSet((String)"tm_businessbill_forwrateagree_data", (String)"tm_businessbill", (String)TM_BUSINESS_BILL, (QFilter[])businessFilter.toArray(), null);
        String[] cashFlowFieldNames = lastCashFlows.getRowMeta().getFieldNames();
        DataSet dataset = lastCashFlows.leftJoin(businessBills).on("billid", "tradebill").select(cashFlowFieldNames, new String[]{"bizdate", "billstatus"}).finish();
        dataset = dataset.addField(String.format("case when cfispay=true and billstatus in ('C','F','I') and to_char(bizdate, 'yyyyMMdd') <= %s then true else false end", TcDateUtils.formatString((Date)endDate, (String)"yyyyMMdd")), "isend");
        String[] swapBillFieldNames = bills.getRowMeta().getFieldNames();
        DataSet finish = bills.leftJoin(dataset).on("id", "billid").select(swapBillFieldNames, new String[]{"isend", "bizrecordid"}).finish();
        finish = finish.addFields(new String[]{"case when isend=false then conamt_original else 0 end", "case when isend=false then conamt_report else 0 end"}, new String[]{"hisamt_original", "hisamt_report"});
        return finish;
    }

    private void init(ReportQueryParam reportQueryParam) {
        this.paramMap = this.transQueryParam(reportQueryParam);
        FilterInfo filters = reportQueryParam.getFilter();
        FilterItemInfo filterCoamtcurrency = filters.getFilterItem("filter_coamtcurrency");
        FilterItemInfo filterPlcurrency = filters.getFilterItem("filter_plcurrency");
        FilterItemInfo filterShowType = filters.getFilterItem("filter_showttype");
        this.showType = (String)filterShowType.getValue();
        this.coamtcurrency = (DynamicObject)filterCoamtcurrency.getValue();
        this.plcurrency = (DynamicObject)filterPlcurrency.getValue();
        this.dimensions = (String)filters.getFilterItem("filter_dimension").getValue();
        this.dimensionArr = this.dimensions.split(UNDERLINE_SEPARATOR);
        this.groups = this.buildGroup(this.dimensionArr);
        this.orderString = this.dimensions.replaceAll(UNDERLINE_SEPARATOR, COMMA_SEPARATOR);
        List orgIds = this.getQueryOrgIds(reportQueryParam);
        this.filterList.add(new QFilter("org", "in", (Object)orgIds));
        ReportHelper.dealFilter(this.filterList, "currency.id", filters.getFilterItem("filter_currency"));
        ReportHelper.dealFilter(this.filterList, "referindex.id", filters.getFilterItem("filter_referindex"));
        this.filterList.add(new QFilter("protecttype.id", "in", (Object)Long.parseLong(ProductTypeEnum.FORWRATEAGREE.getId())));
        this.filterList.add(new QFilter("billstatus", "in", (Object)new String[]{TcBillStatusEnum.SURVIVAL.getValue(), TcBillStatusEnum.FINISH.getValue()}));
        Date endDate = (Date)this.paramMap.get("filter_enddate");
        if (endDate != null) {
            this.filterList.add(new QFilter("bizdate", "<=", (Object)endDate));
        }
    }

    protected List<String> buildGroup(String[] dimensions) {
        ArrayList<String> list = new ArrayList<String>();
        for (String dimension : dimensions) {
            if (this.isText(dimension)) {
                list.add(dimension);
                continue;
            }
            list.add(dimension);
            list.add(dimension + SUFFIX_TEXT);
        }
        return list;
    }

    protected boolean isText(String field) {
        return false;
    }

    private List<String> getSubGroups(String[] dimensions, int level) {
        ArrayList<String> groups = new ArrayList<String>(6);
        List<String> subGroups = Arrays.asList(dimensions).subList(0, dimensions.length - level - 1);
        groups.addAll(subGroups);
        for (int i = 0; i < subGroups.size(); ++i) {
            String group = subGroups.get(i);
            if (i == 0 || this.isText(group)) continue;
            groups.add(group + SUFFIX_TEXT);
        }
        return groups;
    }

    private DataSet queryBillData() {
        String selectFields = String.join((CharSequence)COMMA_SEPARATOR, this.getSelectFields());
        String allSelectFields = "";
        allSelectFields = EmptyUtil.isEmpty((String)selectFields) ? BILL_INFO : selectFields + COMMA_SEPARATOR + BILL_INFO;
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "tm_forwrateagree_bill"), (String)"tm_forwrateagree", (String)allSelectFields, (QFilter[])this.filterList.toArray(new QFilter[0]), (String)this.orderString);
    }

    private DataSet queryPlInfoData(DataSet dataSet) {
        DataSet dataDataCopy = dataSet.copy();
        HashSet<Long> tradeIds = new HashSet<Long>(16);
        HashSet<Long> hisTradeIds = new HashSet<Long>(16);
        for (Row row : dataDataCopy) {
            tradeIds.add(row.getLong("id"));
            BigDecimal hisamtpay = row.getBigDecimal("hisamt_original");
            if (EmptyUtil.isEmpty((BigDecimal)hisamtpay)) continue;
            hisTradeIds.add(row.getLong("id"));
        }
        QFilter qFilter = new QFilter("tradebill.id", "in", tradeIds);
        qFilter.and(new QFilter("bizrecord", "!=", (Object)0L).or(QFilter.isNotNull((String)"bizrecord")));
        DataSet plDataSet = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_data", (String)"tbo_plinfo", (String)PL_INFO, (QFilter[])qFilter.toArray(), null);
        QFilter plFilter = new QFilter("tradebill.id", "in", hisTradeIds);
        Date endDate = (Date)this.paramMap.get("filter_enddate");
        plFilter.and("updatedate", "<=", (Object)endDate);
        String[] fieldNames = plDataSet.getRowMeta().getFieldNames();
        DataSet plHistoryDataSet = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_history_data", (String)"tbo_plinfo_history", (String)PL_HISTORY_INFO, (QFilter[])plFilter.toArray(), (String)"plbill,updatedate");
        DataSet plHDataSet = plHistoryDataSet.groupBy(new String[]{"plbill"}).maxP("updatedate", "floatplamt").maxP("updatedate", "currency").maxP("updatedate", "plcurrencyNumber").finish();
        return plDataSet.leftJoin(plHDataSet).on("id", "plbill").select(fieldNames, new String[]{"floatplamt", "currency", "plcurrencyNumber"}).finish();
    }

    private String getTotalField() {
        String dimension = (String)this.paramMap.get("filter_dimension");
        String[] split = dimension.split(UNDERLINE_SEPARATOR);
        return split[0] + SUFFIX_TEXT;
    }

    public DataSet exchangeRateConversion(DataSet forexData, Map<String, Object> paramMap) {
        DynamicObject currency = (DynamicObject)paramMap.get("filter_coamtcurrency");
        DynamicObject forexQuote = (DynamicObject)paramMap.get("filter_forexquote");
        Date endDate = (Date)paramMap.get("filter_enddate");
        String[] fieldNames = forexData.getRowMeta().getFieldNames();
        DataSet exchgRateDataSet = ReportHelper.calRateDataSet(this.currencyIds, this.rateList, forexData, forexQuote, currency, Collections.singletonList("currency"), Collections.singletonList("currency.number"), endDate, this.tipPairs);
        DataSet finish = forexData.copy().leftJoin(exchgRateDataSet).on("currency", "currency").select(fieldNames, new String[]{"rate"}).finish();
        finish = finish.addFields(new String[]{"amount", "amount*rate"}, new String[]{"conamt_original", "conamt_report"});
        return finish;
    }
}

