/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.plcount;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tbo.common.enums.DateRangeEnum;
import kd.tmc.tbo.report.helper.ReportHelper;

public class ForexPlCountFilterRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit protectType = (BasedataEdit)this.getView().getControl("protecttype_filter");
        protectType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl("fquote_filter");
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
    }

    public void afterSetModelValue(DynamicObject scheme) {
        ReportHelper.setDateFilterAfterSchemeLoad(this.getView(), scheme, "daterange_filter", "startdate_filter", "enddate_filter");
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        Long orgId = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (comIdList.contains(orgId)) {
            this.getModel().setItemValueByID("filter_org", (Object)orgId);
            this.setPlCurrencyByOrg(orgId);
        }
        this.protectTypeFilterChanged();
        this.dimensionFilterChanged();
        this.setMinDateForEndDate();
        this.setMaxDateForStartDate();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("detail".equals(itemKey)) {
            this.handleDetail(evt);
        }
    }

    private Long getProtectTypeId(DynamicObject rowData) {
        String protecttypeid;
        switch (protecttypeid = rowData.getString("protecttypeid")) {
            case "1": {
                return Long.valueOf(ProductTypeEnum.FOREXSPOT.getId());
            }
            case "2": {
                return Long.valueOf(ProductTypeEnum.FOREXFORWARD.getId());
            }
            case "3": 
            case "4": {
                return Long.valueOf(ProductTypeEnum.FOREXSWAPS.getId());
            }
            case "5": {
                return Long.valueOf(ProductTypeEnum.FOREXOPTION.getId());
            }
        }
        return 0L;
    }

    private void setFar(ReportQueryParam reportQueryParam, DynamicObject rowData) {
        String protecttypeid = rowData.getString("protecttypeid");
        if ("3".equals(protecttypeid)) {
            reportQueryParam.getFilter().addFilterItem("dir_filter", (Object)"isnear");
        } else if ("4".equals(protecttypeid)) {
            reportQueryParam.getFilter().addFilterItem("dir_filter", (Object)"isfar");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "dimension_filter": {
                this.dimensionFilterChanged();
                break;
            }
            case "amtunit_filter": {
                this.search();
                break;
            }
            case "protecttype_filter": {
                this.protectTypeFilterChanged();
                break;
            }
            case "filter_org": {
                this.orgFilterChanged();
                break;
            }
            case "daterange_filter": {
                this.daterangeChanged();
                break;
            }
            case "startdate_filter": {
                this.setMinDateForEndDate();
                break;
            }
            case "enddate_filter": {
                this.setMaxDateForStartDate();
            }
        }
    }

    private void daterangeChanged() {
        Date currentDate = TcDateUtils.getCurrentDate();
        this.getModel().setValue("enddate_filter", (Object)currentDate);
        if (DateRangeEnum.WEEK.getValue().equals(this.getModel().getValue("daterange_filter"))) {
            this.getModel().setValue("startdate_filter", (Object)TcDateUtils.getFirstDayOfWeek((Date)currentDate));
        } else if (DateRangeEnum.MONTH.getValue().equals(this.getModel().getValue("daterange_filter"))) {
            this.getModel().setValue("startdate_filter", (Object)TcDateUtils.getFirstDayOfMonth((Date)currentDate));
        } else if (DateRangeEnum.YEAR.getValue().equals(this.getModel().getValue("daterange_filter"))) {
            this.getModel().setValue("startdate_filter", (Object)TcDateUtils.getFirstYearDate((Date)currentDate));
        } else {
            this.getModel().setValue("startdate_filter", null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setHelperText();
    }

    private void setHelperText() {
        this.setHelperText("bizrecord_filter", ResManager.loadKDString((String)"\u4e0d\u9009\u62e9\u65f6\u62a5\u8868\u4e0d\u663e\u793a\u751f\u547d\u5468\u671f\u64cd\u4f5c\u5bf9\u5e94\u7684\u7edf\u8ba1\u91d1\u989d", (String)"ForexPlCountFilterRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]));
        this.setHelperText("swaps_filter", ResManager.loadKDString((String)"\u82e5\u5916\u6c47\u6389\u671f\u8fd1\u7aef\u6216\u8fdc\u7aef\u4e3a\u5373\u671f\u4ea4\u6613\uff0c\u6253\u5f00\u590d\u9009\u6846\u8868\u660e\u5373\u671f\u53c2\u4e0e\u62a5\u8868\u7edf\u8ba1", (String)"ForexPlCountFilterRpt_1", (String)"tmc-tm-report", (Object[])new Object[0]));
        this.setHelperText("gainloss_filter", ResManager.loadKDString((String)"\u6253\u5f00\u590d\u9009\u6846\u5219\u5206\u522b\u6309\u7167\u6d6e\u52a8\u76c8\u5229\u548c\u6d6e\u52a8\u4e8f\u635f\u8fdb\u884c\u7edf\u8ba1\uff0c\u4e0d\u6253\u5f00\u5219\u53ea\u6309\u7167\u6d6e\u52a8\u635f\u76ca\u7edf\u8ba1", (String)"ForexPlCountFilterRpt_2", (String)"tmc-tm-report", (Object[])new Object[0]));
        this.setHelperText("wipecom_filter", ResManager.loadKDString((String)"\u6253\u5f00\u590d\u9009\u6846\u5219\u671f\u6743\u7ec4\u5408\u548c\u7ec4\u5408\u4ea4\u6613\u5747\u4e0d\u53c2\u4e0e\u7edf\u8ba1", (String)"ForexPlCountFilterRpt_3", (String)"tmc-tm-report", (Object[])new Object[0]));
    }

    private void setHelperText(String fieldName, String content) {
        FieldEdit control = (FieldEdit)this.getControl(fieldName);
        Tips tips = new Tips();
        tips.setContent(new LocaleString(content));
        tips.setType("text");
        control.addTips(tips);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"protecttype_filter")) {
            showParameter.getTreeFilterParameter().getQFilters().add(new QFilter("longnumber", "like", (Object)"TRADE.01FOREX%"));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List orgIds = new ArrayList(16);
        if (queryParam.getFilter().getFilterItem("filter_org").getValue() == null) {
            String appId = this.getView().getFormShowParameter().getAppId();
            orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            if (orgIds.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u6ca1\u6709\u67e5\u8be2\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"ForexPlCountFilterRpt_5", (String)"tmc-tm-report", (Object[])new Object[]{this.getView().getFormShowParameter().getFormName()}));
                return;
            }
        }
        queryParam.getFilter().addFilterItem("fields", this.getAllFields());
        queryParam.getFilter().addFilterItem("orgs", orgIds);
        queryParam.getFilter().addFilterItem("dimension_filter", this.getModel().getValue("dimension_filter"));
        queryParam.getFilter().addFilterItem("amtunit_filter", this.getModel().getValue("amtunit_filter"));
        queryParam.getFilter().addFilterItem("org_filter", this.getModel().getValue("filter_org"));
        super.beforeQuery(queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        Map<String, LocaleString> columnFieldMap = ReportHelper.getColumnField(event);
        String dimension = (String)this.getModel().getValue("dimension_filter");
        String[] split = dimension.split(",");
        List<String> fields = this.getFields();
        List collect = Arrays.stream(split).collect(Collectors.toList());
        fields.removeAll(collect);
        List columns = event.getColumns();
        columns.removeIf(columm -> {
            ReportColumn reportColumn = (ReportColumn)columm;
            if ("orgtext".equals(reportColumn.getFieldKey()) && !"org".equals(split[0])) {
                reportColumn.setCaption((LocaleString)columnFieldMap.get(split[0]));
            }
            return fields.contains(reportColumn.getFieldKey()) || reportColumn.getFieldKey().equals(split[0]);
        });
    }

    private List<String> getAllFields() {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        return columns.stream().map(s -> ((ReportColumn)s).getFieldKey()).collect(Collectors.toList());
    }

    private List<String> getFields() {
        List<String> fields = this.getAllFields();
        HashSet<String> noSelectFields = new HashSet<String>(16);
        noSelectFields.add("orgtext");
        noSelectFields.add("sumlevel");
        noSelectFields.add("hbizamt");
        noSelectFields.add("contractamt");
        noSelectFields.add("coamtcurrency");
        noSelectFields.add("plcurrency");
        ArrayList<String> selectField = new ArrayList<String>(16);
        for (String field : fields) {
            if (noSelectFields.contains(field)) continue;
            selectField.add(field);
        }
        return selectField;
    }

    public boolean verifyQuery(ReportQueryParam param) {
        FilterInfo filters = param.getFilter();
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("coamtcurrency_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u7ea6\u91d1\u989d\u62a5\u544a\u5e01\u79cd", (String)"ForexPlCountFilterRpt_6", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("plcurrency_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u635f\u76ca\u62a5\u544a\u5e01\u79cd", (String)"ForexPlCountFilterRpt_7", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("fquote_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5916\u6c47\u62a5\u4ef7", (String)"ForexPlCountFilterRpt_8", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("daterange_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u533a\u95f4", (String)"ForexPlCountFilterRpt_9", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        Date endDate = (Date)filters.getFilterItem("enddate_filter").getValue();
        Date startDate = (Date)filters.getFilterItem("startdate_filter").getValue();
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u622a\u6b62\u65e5\u671f", (String)"ForexPlCountFilterRpt_10", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (!EmptyUtil.isEmpty((Object)startDate) && startDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc7\u622a\u6b62\u65e5\u671f\u3002", (String)"ForexPlCountFilterRpt_11", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setPlCurrencyByOrg(Long orgId) {
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        this.getModel().setValue("plcurrency_filter", (Object)localCurrencyId);
    }

    private void dimensionFilterChanged() {
        String dimension;
        switch (dimension = (String)this.getModel().getValue("dimension_filter")) {
            case "org": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"protecttype_filter", "biztype_filter"});
                this.getModel().setValue("protecttype_filter", null);
                this.getModel().setValue("biztype_filter", null);
                break;
            }
            case "org,protecttype": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"biztype_filter"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"protecttype_filter"});
                this.getModel().setValue("biztype_filter", null);
                break;
            }
            case "org,protecttype,biztype": 
            case "protecttype,biztype": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"protecttype_filter", "biztype_filter"});
                break;
            }
            case "protecttype": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"biztype_filter"});
                this.getModel().setValue("biztype_filter", null);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"protecttype_filter"});
            }
        }
    }

    private void protectTypeFilterChanged() {
        DynamicObjectCollection protectType = (DynamicObjectCollection)this.getModel().getValue("protecttype_filter");
        boolean isShow = false;
        Set collect = protectType.stream().filter(s -> ProductTypeEnum.FOREXSWAPS.getValue().equals(s.getDynamicObject("fbasedataid").getString("number"))).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)protectType) || EmptyUtil.isNoEmpty((DynamicObjectCollection)protectType) && collect.size() > 0) {
            isShow = true;
        }
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"swaps_filter"});
    }

    private void orgFilterChanged() {
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("filter_org");
        if (org.size() == 1) {
            this.setPlCurrencyByOrg(((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getLong("id"));
        }
    }

    private void setMinDateForEndDate() {
        Date startDate = (Date)this.getModel().getValue("startdate_filter");
        if (startDate != null) {
            ((DateEdit)this.getView().getControl("enddate_filter")).setMinDate(startDate);
        } else {
            ((DateEdit)this.getView().getControl("enddate_filter")).setMinDate(TcDateUtils.stringToDate((String)"1900-01-01", (String)"yyyy-MM-dd"));
        }
    }

    private void setMaxDateForStartDate() {
        Date endDate = (Date)this.getModel().getValue("enddate_filter");
        if (endDate != null) {
            ((DateEdit)this.getView().getControl("startdate_filter")).setMaxDate(endDate);
        } else {
            ((DateEdit)this.getView().getControl("startdate_filter")).setMaxDate(TcDateUtils.stringToDate((String)"2999-12-31", (String)"yyyy-MM-dd"));
        }
    }

    private void handleDetail(ItemClickEvent evt) {
        ReportList reportlistap = (ReportList)this.getControl("reportlistap");
        int rowCount = reportlistap.getReportModel().getRowCount();
        if (rowCount <= 0) {
            return;
        }
        int[] selectedRows = reportlistap.getEntryState().getSelectedRows();
        ReportQueryParam reportQueryParam = reportlistap.getReportModel().getReportQueryParam();
        ReportShowParameter param = new ReportShowParameter();
        if (selectedRows.length > 0) {
            IReportListModel reportModel = reportlistap.getReportModel();
            DynamicObject rowData = reportModel.getRowData(selectedRows[0]);
            String dimensionStr = (String)this.getModel().getValue("dimension_filter");
            String[] dimensionArr = dimensionStr.split(",");
            int sumlevel = rowData.getInt("sumlevel");
            Object isGroupNode = rowData.get("isgroupnode");
            if (isGroupNode != null) {
                param.setCustomParam("isgroupnode", isGroupNode);
            }
            if (sumlevel == 0) {
                String[] stringArray = dimensionArr;
                int n = stringArray.length;
                block10: for (int i = 0; i < n; ++i) {
                    String dimension;
                    switch (dimension = stringArray[i]) {
                        case "org": {
                            FilterItemInfo filterItem = reportQueryParam.getFilter().getFilterItem("filter_org");
                            DynamicObjectCollection orgs = new DynamicObjectCollection();
                            orgs.add((Object)rowData.getDynamicObject("org"));
                            filterItem.setValue((Object)orgs);
                            continue block10;
                        }
                        case "protecttype": {
                            FilterItemInfo protecttype = reportQueryParam.getFilter().getFilterItem("protecttype_filter");
                            protecttype.setValue((Object)this.getProtectTypeId(rowData));
                            this.setFar(reportQueryParam, rowData);
                            continue block10;
                        }
                        case "biztype": {
                            FilterItemInfo biztype = reportQueryParam.getFilter().getFilterItem("biztype_filter");
                            biztype.setValue((Object)rowData.getString("biztype"));
                            continue block10;
                        }
                        default: {
                            String name = dimension + "_filter";
                            Control control = this.getControl(name);
                            FilterItemInfo other = reportQueryParam.getFilter().getFilterItem(dimension + "_filter");
                            if (control instanceof MulBasedataEdit) {
                                DynamicObjectCollection others = new DynamicObjectCollection();
                                others.add((Object)rowData.getDynamicObject(dimension));
                                other.setValue((Object)others);
                                continue block10;
                            }
                            other.setValue(rowData.get(dimension));
                        }
                    }
                }
            }
        }
        param.setFormId("tbo_forextradedetail_rpt");
        param.setQueryParam(reportQueryParam);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("detail", (Object)true);
        param.setCustomParam("queryDetail", (Object)true);
        boolean hasDetailPermission = this.validDetailPermission(reportQueryParam);
        if (hasDetailPermission) {
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private boolean validDetailPermission(ReportQueryParam queryParam) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"tbo_forextradedetail_rpt", (String)"47150e89000000ac");
        if (orgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u672a\u914d\u7f6e\u6743\u9650\uff0c\u8bf7\u5148\u914d\u7f6e\u6743\u9650\u540e\u518d\u8fdb\u884c\u660e\u7ec6\u8868\u8054\u67e5", (String)"ForexPlCountFilterRpt_12", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        Map<Object, Object> orgMap = new HashMap();
        DynamicObjectCollection orgs = this.getModel().getDataEntity().getDynamicObjectCollection("filter_org");
        if (orgs != null) {
            orgMap = orgs.stream().collect(Collectors.toMap(e -> e.getDynamicObject("fbasedataid").getLong("id"), e -> e.getDynamicObject("fbasedataid").getString("name")));
        } else {
            FilterItemInfo filterItem = queryParam.getFilter().getFilterItem("orgs");
            List ids = (List)filterItem.getValue();
            ids.removeIf(orgIds::contains);
            if (EmptyUtil.isNoEmpty((Object)ids)) {
                for (Long id : ids) {
                    DynamicObject org = TmcOrgDataHelper.getOrgById((long)id);
                    orgMap.put(id, org.getString("name"));
                }
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<Object, Object>> entries = orgMap.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Long key = (Long)entry.getKey();
            String value = (String)entry.getValue();
            if (orgIds.contains(key)) continue;
            list.add(value);
        }
        if (EmptyUtil.isNoEmpty(list)) {
            String orgTip = String.join((CharSequence)"\u3001", list);
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s \u4ea4\u6613\u4e3b\u4f53\u5728\u660e\u7ec6\u8868\u4e2d\u672a\u914d\u7f6e\u6743\u9650\uff0c\u8bf7\u5148\u914d\u7f6e\u6743\u9650\u540e\u518d\u8fdb\u884c\u660e\u7ec6\u8868\u8054\u67e5", (String)"ForexPlCountFilterRpt_13", (String)"tmc-tm-report", (Object[])new Object[]{orgTip}));
            return false;
        }
        return true;
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("fquote_filter".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_forexquote";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void search() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }
}

