/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.plcount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.tbo.common.enums.ForexDetailRptPlColumnEnum;
import kd.tmc.tbo.report.helper.ReportHelper;
import kd.tmc.tm.common.enums.BizOperateEnum;

public class ForexPlDetailListRpt
extends AbstractTmcTreeReportDataPlugin {
    private boolean isContainsForexSwaps;
    private boolean isContainsForexOptions;
    private boolean isShowContract;
    private final List<String> plInfoList = new ArrayList<String>();
    private final List<String> bizRecordAmtList = new ArrayList<String>();
    private final List<String> bizRecordPlList = new ArrayList<String>();
    private Date startDate;
    private Date endDate;
    private String sumNameField;
    private List<String> orderColumnList;
    private static final List<String> STANDARD_PRODUCT_FILTERS = new ArrayList<String>();
    private static final String DIR_ORDER = "dir_order";
    private static final String COMBINED_ORDER = "combined_order";
    private List<String> dimensionColumns = new ArrayList<String>();
    private static final String[] HEAD_SELECT_FIELDS;
    private static final String TM_FOREX_FIELDS = ",org.name as orgtext,id,pair,amount,settledelay,billstatus,bizdate,protecttype.number,protecttype.name,'' as dir,billno,counterparty.name as counterparty,case when protecttype.id=941773368233832448 then adjustsettledate when protecttype.id=937487193708953600 and isdaterange='1' then settledate_start else settledate end as settledate,case when protecttype.id=937487193708953600 and isdaterange='1' then settledate_end else null end as settledate_end,tradedirect,tradetype,fxquote,currency.id as currency,currency.number as currencytext";
    private static final String TM_SWAPS_FIELDS = ",org.name as orgtext,id,pair,amount,swaptype,settledelay,billstatus,bizdate,protecttype.number,protecttype.name,buyamount_far,'isnear' as dir,billno,counterparty.name as counterparty,settledate,settledate_far,null as settledate_end,tradedirect,tradetype,fxquote,currency.id as currency,currency.number as currencytext";
    private static final String PL_INFO_FIELDS = "id,org,tradebill.id as tradeid,entrys.biztype,entrys.bizbillplcurrency,entrys.bizbillplcurrency.number as bizbillplcurrencynumber,entrys.plamt,entrys.bizdate,swapdir,bizrecord as bizrecordid";
    private static final String[] GROUPED_TRADE_FIELDS;
    private static final String[] GROUPED_PL_INFO_FIELDS;
    private static final String BIZ_RECORD_FIELDS = "id as bizrecordid,srcbizbill,exrate,lv,seqno,restamt,desc as contract,tradebillid,swapdir,entryentity.bizop,entryentity.opdate,entryentity.amount as amount";
    private List<Long> currencyIds = new ArrayList<Long>();
    private List<Object[]> rateList = new ArrayList<Object[]>();
    private List<Long> plCurrencyIds = new ArrayList<Long>();
    private List<Object[]> plRateList = new ArrayList<Object[]>();
    private final LinkedHashSet<String> tipPairs = new LinkedHashSet(16);

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.startDate = (Date)paramMap.get("startdate_filter");
        if (this.startDate == null) {
            this.startDate = DateUtils.stringToDate((String)"1900-01-01", (String)"yyyy-MM-dd");
        }
        this.endDate = (Date)paramMap.get("enddate_filter");
        this.buildBizRecordList(paramMap);
        this.buildPlInfoList(paramMap);
        DataSet forexData = this.queryForexData(paramMap);
        DataSet totalForexData = this.unionSwapsData(forexData, paramMap);
        DataSet processedForexData = this.forexProcess(totalForexData, paramMap).distinct();
        processedForexData = this.filterTradeDirect(paramMap, processedForexData);
        DataSet bizRecordData = this.queryBizRecordData(totalForexData);
        processedForexData = this.dealBizRecordDataSet(processedForexData, bizRecordData, paramMap);
        processedForexData = processedForexData.filter(String.format("to_char(bizdate, 'yyyyMMdd') <= %s", DateUtils.formatString((Date)this.endDate, (String)"yyyyMMdd")));
        processedForexData = this.filterSettleDate(paramMap, processedForexData);
        processedForexData = processedForexData.updateField("settledate", "case when settledate_end is not null then to_char(settledate, 'yyyy-MM-dd') +' ~ '+ to_char(settledate_end, 'yyyy-MM-dd') else to_char(settledate, 'yyyy-MM-dd') end");
        DataSet groupedDataSet = processedForexData.copy().groupBy(new String[]{"billno", "dir"}).sum("bizrestamt").finish();
        processedForexData = processedForexData.leftJoin(groupedDataSet).on("billno", "billno").on("dir", "dir").select(processedForexData.getRowMeta().getFieldNames(), new String[]{"bizrestamt as totalrestamt"}).finish();
        if (!((Boolean)paramMap.get("containsfinished_filter")).booleanValue()) {
            processedForexData = processedForexData.filter("totalrestamt > 0");
        }
        processedForexData = processedForexData.updateField("billstatus", "case when totalrestamt>0 then 'D' else 'E' end");
        DataSet originalPlDataSet = this.queryPlInfoData(processedForexData, paramMap);
        DataSet processedPlDataSet = this.plProcess(originalPlDataSet, paramMap);
        String[] fields = this.concat(HEAD_SELECT_FIELDS, this.bizRecordAmtList.toArray(new String[0]), this.plInfoList.toArray(new String[0]), this.bizRecordPlList.toArray(new String[0]));
        fields = this.appendSecondaryDevFields(paramMap, fields);
        DataSet dateSet = processedForexData.leftJoin(processedPlDataSet).on("bizrecordid", "bizrecordid").select(fields).finish();
        String dimension_filter = (String)paramMap.get("dimension_filter");
        String[] dimensions = dimension_filter.split(",");
        this.dimensionColumns = Arrays.stream(dimension_filter.replaceFirst("org", "orgtext").split(",")).collect(Collectors.toList());
        List<String> contractSubTotalGroupedFields = Arrays.stream(new String[]{"org", "billno", "currency", "counterparty", "currencytext", "dir"}).collect(Collectors.toList());
        this.orderColumnList = new ArrayList<String>(3);
        for (String column : dimensions) {
            if ("protecttype".equals(column)) {
                this.orderColumnList.add("protecttype");
                this.orderColumnList.add("protecttypeid");
                continue;
            }
            if ("biztype".equals(column)) {
                this.orderColumnList.add("biztype");
                this.orderColumnList.add("biztypeid");
                continue;
            }
            if ("org".equals(column)) {
                this.orderColumnList.add("orgtext");
                this.orderColumnList.add("org");
                dateSet = dateSet.updateField("org", "org+''");
                continue;
            }
            this.orderColumnList.add(column);
            this.orderColumnList.add(column + "_order");
            contractSubTotalGroupedFields.add(column + "_order");
            dateSet = dateSet.addField(column + "+''", column + "_order");
        }
        List<String> sumFields = this.buildSumFields(false);
        DataSet contractDs = this.addContractSubTotalDataSet(paramMap, sumFields, dateSet, contractSubTotalGroupedFields);
        dateSet = dateSet.updateField("protecttypeid", "protecttypeid+''");
        dateSet = dateSet.updateField("biztypeid", "biztypeid+''");
        dateSet = dateSet.updateField("org", "org+''");
        String string = this.sumNameField = "org".equals(dimensions[0]) ? "orgtext" : dimensions[0];
        if (contractDs != null) {
            dateSet = dateSet.union(contractDs);
        }
        return dateSet;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam param) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        Map paramMap = this.transQueryParam(param);
        String dimension_filter = (String)paramMap.get("dimension_filter");
        String[] dimensions = dimension_filter.split(",");
        StringBuilder combinedOrderExpression = this.buildCombinedOrderExpression(dimensions);
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"sumlevel = 2", "sumlevel != 2"}, false);
        DataSet sumDataSet = dataSets[0];
        DataSet bizDs = dataSets[1];
        bizDs = bizDs.addField(combinedOrderExpression.toString(), COMBINED_ORDER);
        bizDs = bizDs.addField("case when dir = 'isnear' then 1 when dir = 'isfar' then 2 when dir is null then 3 else 0 end", DIR_ORDER);
        bizDs = bizDs.orderBy(this.getOrderBy(paramMap));
        bizDs = bizDs.removeFields(new String[]{COMBINED_ORDER, DIR_ORDER});
        bizDs = bizDs.updateField(this.sumNameField, String.format("case when billno is null then '%s' else %s end", ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ForexPlDetailListRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]), this.sumNameField));
        bizDs = bizDs.updateField(this.sumNameField, String.format("case when lv=999 then '%s' else %s end", ResManager.loadKDString((String)"\u5408\u7ea6\u5c0f\u8ba1", (String)"ForexPlDetailListRpt_1", (String)"tmc-tm-report", (Object[])new Object[0]), this.sumNameField));
        if (sumDataSet != null) {
            bizDs = bizDs.union(sumDataSet);
        }
        if (!dimension_filter.contains("counterparty")) {
            bizDs = bizDs.updateField("counterparty", "case when lv=999 then null else counterparty end");
        }
        if (!dimension_filter.contains("currencytext")) {
            bizDs = bizDs.updateField("currencytext", "case when lv=999 then null else currencytext end");
        }
        bizDs = bizDs.updateField("billstatus", "case when contract is not null and (lv!=0 or seqno!=0) then null else billstatus end");
        DynamicObject plCurrency = (DynamicObject)paramMap.get("plcurrency_filter");
        DynamicObject coAmtCurrency = (DynamicObject)paramMap.get("coamtcurrency_filter");
        return bizDs.addFields(new String[]{String.valueOf(coAmtCurrency.getLong("id")), String.valueOf(plCurrency.getLong("id"))}, new String[]{"coamtcurrency", "plreportcurrency"});
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        bizDs = bizDs.updateField(this.sumField, "case when lv=999 then 1 else sumlevel end");
        if (!((Boolean)paramMap.get("total_filter")).booleanValue()) {
            return bizDs;
        }
        while (this.orderColumnList.size() > 0) {
            DataSet subTotalRows = this.addSubTotalDataSet(bizDs.copy().filter("sumlevel = 0"), this.orderColumnList, this.buildSumFields(true));
            bizDs = bizDs.union(subTotalRows);
            if (this.orderColumnList.size() == 0) continue;
            this.orderColumnList.remove(this.orderColumnList.size() - 1);
            this.orderColumnList.remove(this.orderColumnList.size() - 1);
        }
        return bizDs;
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        if (((Boolean)paramMap.get("total_filter")).booleanValue()) {
            return super.addSumRowDataSet(bizDs, paramMap);
        }
        return bizDs;
    }

    public String sumNameField() {
        return this.sumNameField;
    }

    public List<String> groupFields() {
        return Collections.singletonList("org");
    }

    public List<String> sumAmountFields() {
        return this.buildSumFields(true);
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    private DataSet filterSettleDate(Map<String, Object> paramMap, DataSet processedForexData) {
        Date start = (Date)paramMap.get("start_settledate_filter");
        Date end = (Date)paramMap.get("end_settledate_filter");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{start, end})) {
            String startDateStr = TcDateUtils.formatString((Date)start, (String)"yyyyMMdd");
            String endDateStr = TcDateUtils.formatString((Date)end, (String)"yyyyMMdd");
            StringBuilder filterBuilder = new StringBuilder();
            filterBuilder.append(String.format("(to_char(settledate, 'yyyyMMdd') >= %s and to_char(settledate, 'yyyyMMdd') <= %s)", startDateStr, endDateStr));
            filterBuilder.append(" or ");
            filterBuilder.append(String.format("(settledate_end is not null and to_char(settledate_end, 'yyyyMMdd') >= %s and to_char(settledate_end, 'yyyyMMdd') <= %s)", startDateStr, endDateStr));
            processedForexData = processedForexData.filter(filterBuilder.toString());
        }
        return processedForexData;
    }

    private StringBuilder buildCombinedOrderExpression(String[] ss) {
        ArrayList<String> mixtureOrderColumns = new ArrayList<String>(4);
        mixtureOrderColumns.add("counterparty");
        mixtureOrderColumns.add("currencytext");
        mixtureOrderColumns.add("billno");
        for (String column : ss) {
            mixtureOrderColumns.remove(column);
        }
        StringBuilder combinedOrderExpression = new StringBuilder();
        for (int i = 0; i < mixtureOrderColumns.size(); ++i) {
            String mixtureOrderColumn = (String)mixtureOrderColumns.get(i);
            combinedOrderExpression.append(mixtureOrderColumn);
            if (i == mixtureOrderColumns.size() - 1) continue;
            combinedOrderExpression.append("+");
        }
        return combinedOrderExpression;
    }

    private DataSet addContractSubTotalDataSet(Map<String, Object> paramMap, List<String> sumFields, DataSet dateSet, List<String> contractSubTotalGroupedFields) {
        DataSet contractTotalRows = null;
        if (((Boolean)paramMap.get("sumbycontract_filter")).booleanValue()) {
            contractTotalRows = this.buildContractSubTotal(dateSet.copy(), sumFields, contractSubTotalGroupedFields);
            contractTotalRows = contractTotalRows.updateField("protecttypeid", "protecttypeid+''");
            contractTotalRows = contractTotalRows.updateField("biztypeid", "biztypeid+''");
            contractTotalRows = contractTotalRows.updateField("org", "org+''");
        }
        return contractTotalRows;
    }

    private List<String> buildSumFields(boolean isOnlySumReportAmt) {
        ArrayList<String> sumFields = new ArrayList<String>(16);
        sumFields.add("amount");
        sumFields.add("amount_report");
        sumFields.add("bizrestamt");
        sumFields.add("bizrestamt_report");
        sumFields.addAll(this.bizRecordAmtList);
        for (String column2 : this.plInfoList) {
            if (!column2.contains("report")) continue;
            sumFields.add(column2);
        }
        sumFields.addAll(this.bizRecordPlList);
        if (isOnlySumReportAmt) {
            sumFields.removeIf(column -> !column.contains("report"));
        }
        return sumFields;
    }

    private DataSet filterTradeDirect(Map<String, Object> paramMap, DataSet processedForexData) {
        String[] tradeDirects;
        String tradeDirect = (String)paramMap.get("tradedirect_filter");
        if (EmptyUtil.isNoEmpty((String)tradeDirect) && (tradeDirects = tradeDirect.replaceFirst(",", "").split(",")).length == 1) {
            processedForexData = processedForexData.filter(String.format("tradedirect = '%s'", tradeDirects[0]));
        }
        return processedForexData;
    }

    protected DataSet addSubTotalDataSet(DataSet rowSet, List<String> groupFields, List<String> sumFields) {
        DataSet dsTemp = rowSet;
        GroupbyDataSet gdsTemp = dsTemp.groupBy(groupFields.toArray(new String[groupFields.size()]));
        for (String sumField : sumFields) {
            gdsTemp.sum(sumField);
        }
        DataSet ds = gdsTemp.finish();
        LinkedList<String> selectField = new LinkedList<String>();
        Field[] fields = rowSet.getRowMeta().getFields();
        String lastGroupField = groupFields.get(groupFields.size() - 1);
        for (Field field : fields) {
            if (field.getName().equals(lastGroupField)) {
                selectField.add(lastGroupField + "+'0' as " + lastGroupField);
                continue;
            }
            if (groupFields.contains(field.getName()) || sumFields.contains(field.getName())) {
                selectField.add(field.getName());
                continue;
            }
            if (field.getName().equals(this.sumField)) {
                selectField.add("1 as " + this.sumField);
                continue;
            }
            selectField.add("NULL as " + field.getName());
        }
        ds = ds.select(String.join((CharSequence)",", selectField));
        return ds;
    }

    protected DataSet buildContractSubTotal(DataSet rowSet, List<String> sumFields, List<String> orderColumnList) {
        Field[] fields;
        DataSet dsTemp = rowSet.copy();
        GroupbyDataSet gdsTemp = dsTemp.groupBy((String[])orderColumnList.stream().toArray(String[]::new));
        for (String sumField : sumFields) {
            gdsTemp.sum(sumField);
        }
        gdsTemp.max("id");
        gdsTemp.max("lv");
        gdsTemp.max("protecttypeid");
        gdsTemp.max("biztypeid");
        gdsTemp.count("count");
        DataSet ds = gdsTemp.finish();
        LinkedList<String> selectField = new LinkedList<String>();
        for (Field field : fields = rowSet.getRowMeta().getFields()) {
            if ("protecttypeid".equals(field.getName()) || "biztypeid".equals(field.getName()) || "id".equals(field.getName()) || orderColumnList.contains(field.getName()) || sumFields.contains(field.getName())) {
                selectField.add(field.getName());
                continue;
            }
            if (field.getName().equals(this.sumField)) {
                selectField.add("1 as " + this.sumField);
                continue;
            }
            if (field.getName().equals("lv")) {
                selectField.add("999 as " + field.getName());
                continue;
            }
            selectField.add("NULL as " + field.getName());
        }
        selectField.add("count");
        return ds.select(String.join((CharSequence)",", selectField)).filter("count>1").removeFields(new String[]{"count"});
    }

    private String[] concat(String[] ... arrays) {
        if (arrays.length == 0) {
            return new String[0];
        }
        String[] result = arrays[0];
        for (int i = 1; i < arrays.length; ++i) {
            result = ReportHelper.concat(result, arrays[i]);
        }
        return result;
    }

    private String[] getOrderBy(Map<String, Object> paramMap) {
        ArrayList<String> orderColumnList1 = new ArrayList<String>(3);
        orderColumnList1.add("org");
        orderColumnList1.add("protecttypeid");
        String dimension_filter = (String)paramMap.get("dimension_filter");
        String[] dimensions = dimension_filter.split(",");
        ArrayList<String> list = new ArrayList<String>(16);
        for (String column : dimensions) {
            if ("protecttype".equals(column)) {
                list.add("protecttypeid");
                orderColumnList1.remove("protecttypeid");
                continue;
            }
            if ("biztype".equals(column)) {
                list.add("biztypeid");
                continue;
            }
            if ("org".equals(column)) {
                list.add("org");
                orderColumnList1.remove("org");
                continue;
            }
            list.add(column + "_order");
        }
        list.addAll(orderColumnList1);
        list.add(COMBINED_ORDER);
        if (!dimension_filter.contains("biztype")) {
            list.add("biztypeid");
        }
        list.add(DIR_ORDER);
        list.add("lv");
        list.add("seqno");
        return (String[])list.stream().toArray(String[]::new);
    }

    private void buildBizRecordList(Map<String, Object> paramMap) {
        String bizRecordFilter = (String)paramMap.get("bizrecord_filter");
        if (EmptyUtil.isNoEmpty((String)bizRecordFilter)) {
            String[] bizRecords = bizRecordFilter.replaceFirst(",", "").split(",");
            this.bizRecordAmtList.addAll(Arrays.stream(bizRecords).map(b -> b + "_amt").collect(Collectors.toList()));
            this.bizRecordPlList.addAll(Arrays.stream(bizRecords).map(b -> b + "_pl").collect(Collectors.toList()));
        }
    }

    private void buildPlInfoList(Map<String, Object> paramMap) {
        boolean gainLossFilter = (Boolean)paramMap.get("gainloss_filter");
        if (gainLossFilter) {
            this.plInfoList.add(ForexDetailRptPlColumnEnum.GAINPLAMT.getValue());
            this.plInfoList.add(ForexDetailRptPlColumnEnum.GAINPLAMT_REPORT.getValue());
            this.plInfoList.add(ForexDetailRptPlColumnEnum.LOSSPLAMT.getValue());
            this.plInfoList.add(ForexDetailRptPlColumnEnum.LOSSPLAMT_REPORT.getValue());
        } else {
            this.plInfoList.add(ForexDetailRptPlColumnEnum.FLOATPLAMT.getValue());
            this.plInfoList.add(ForexDetailRptPlColumnEnum.FLOATPLAMT_REPORT.getValue());
        }
        this.plInfoList.add(ForexDetailRptPlColumnEnum.PLAMT_REPORT.getValue());
        this.plInfoList.add(ForexDetailRptPlColumnEnum.TOTALPLAMT_REPORT.getValue());
    }

    private DataSet queryForexData(Map<String, Object> paramMap) {
        QFilter forexFilter = this.buildForexBaseFilter(paramMap);
        this.buildQueryFilterByForex(paramMap, forexFilter);
        this.buildForexFilterByWipeCom(paramMap, forexFilter);
        String selectField = String.join((CharSequence)",", this.getSelectFields(paramMap));
        return QueryServiceHelper.queryDataSet((String)"tm_forex_info", (String)"tm_forex_forward", (String)(selectField + TM_FOREX_FIELDS), (QFilter[])forexFilter.toArray(), null);
    }

    private DataSet unionSwapsData(DataSet forexData, Map<String, Object> paramMap) {
        String[] dirArray;
        int len;
        String dirFilter;
        String bizType;
        Set typeNum;
        DynamicObjectCollection protectTypes = (DynamicObjectCollection)paramMap.get("protecttype_filter");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)protectTypes) && (typeNum = protectTypes.stream().filter(f -> ProductTypeEnum.FOREXSWAPS.getId().equals(String.valueOf(f.getLong("id")))).map(s -> s.getLong("id")).collect(Collectors.toSet())).size() == 0) {
            this.isContainsForexSwaps = false;
            return forexData;
        }
        this.isContainsForexSwaps = true;
        this.isShowContract = true;
        QFilter swapsFilter = this.buildForexBaseFilter(paramMap);
        this.buildQueryFilterBySwaps(paramMap, swapsFilter);
        this.buildForexFilterByWipeCom(paramMap, swapsFilter);
        String selectField = String.join((CharSequence)",", this.getSelectFields(paramMap));
        DataSet spotDataSet = QueryServiceHelper.queryDataSet((String)"tm_swaps_info", (String)"tm_forex_swaps", (String)(selectField + TM_SWAPS_FIELDS), (QFilter[])swapsFilter.toArray(), null);
        spotDataSet = spotDataSet.addField("case when swaptype = 'SpotToSpot' or swaptype = 'SpotToFwd' then 1 else 0 end", "spotflag");
        DataSet farDataSet = spotDataSet.copy().updateFields(new String[]{"biztype", "tradedirect", "amount", "settledate", "dir"}, new String[]{"case when biztype = 'buy' then 'sell' when biztype = 'sell' then 'buy' else 'diff' end", "case when tradedirect = 'buy' then 'sell' when tradedirect = 'sell' then 'buy' else '' end", "buyamount_far", "settledate_far", "'isfar'"});
        farDataSet = farDataSet.updateField("spotflag", "case when swaptype = 'SpotToSpot' then 1 else 0 end");
        DataSet swapsData = spotDataSet.union(farDataSet).removeFields(new String[]{"settledate_far"});
        if (!((Boolean)paramMap.get("swaps_filter")).booleanValue()) {
            swapsData = swapsData.filter("spotflag != 1");
        }
        if (EmptyUtil.isNoEmpty((String)(bizType = (String)paramMap.get("biztype_filter")))) {
            CharSequence[] bizTypeArray = bizType.replaceFirst(",", "").split(",");
            String join = String.join((CharSequence)"','", bizTypeArray);
            swapsData = swapsData.filter("biztype in ('" + join + "')");
        }
        if (EmptyUtil.isNoEmpty((String)(dirFilter = (String)paramMap.get("dir_filter"))) && (len = (dirArray = dirFilter.replaceFirst(",", "").split(",")).length) == 1) {
            swapsData = swapsData.filter(String.format("dir='%s'", dirArray[0]));
        }
        return forexData.union(swapsData.select(selectField + ",orgtext,id,pair,amount,settledelay,billstatus,bizdate,protecttype.number,protecttype.name,dir,billno,counterparty,settledate,settledate_end,tradedirect,tradetype,fxquote,currency,currencytext"));
    }

    private DataSet queryBizRecordData(DataSet forexData) {
        Set<Long> dataSetIds = ForexPlDetailListRpt.getDataSetIds(forexData);
        QFilter qFilter = new QFilter("tradebillid", "in", dataSetIds);
        return QueryServiceHelper.queryDataSet((String)"tm_bizrecord_data", (String)"tm_bizrecord", (String)BIZ_RECORD_FIELDS, (QFilter[])qFilter.toArray(), null);
    }

    private DataSet dealBizRecordDataSet(DataSet processedForexData, DataSet bizRecordData, Map<String, Object> paramMap) {
        Set<Long> ids = this.getSrcBizBillIds(bizRecordData.copy());
        DataSet bizBillDataSet = QueryServiceHelper.queryDataSet((String)"tm_businessbill_info", (String)"tm_businessbill", (String)"id as srcbizbill,bizdate as bizbillopdate,case when isdaterange='1' then expired_start else expireddate end as expireddate,case when isdaterange='1' then expired_end else null end as expired_end", (QFilter[])new QFilter("id", "in", ids).toArray(), null);
        bizRecordData = bizRecordData.leftJoin(bizBillDataSet).on("srcbizbill", "srcbizbill").select(new String[]{"bizrecordid", "srcbizbill", "exrate", "lv", "seqno", "restamt", "contract", "tradebillid", "swapdir", "entryentity.bizop", "entryentity.opdate", "amount", "bizbillopdate", "expireddate", "expired_end"}).finish();
        String currUnit = (String)paramMap.get("amtunit_filter");
        String unit = ReportHelper.getUnit(currUnit);
        ArrayList<String> reportCurrencyAmtFields = new ArrayList<String>(8);
        ArrayList<String> reportCurrencyAmtExpressions = new ArrayList<String>(8);
        StringBuilder bizRecordFields = new StringBuilder();
        bizRecordFields.append("bizrecordid,contract");
        bizRecordFields.append(String.format(",restamt/%s as restamt", unit));
        bizRecordFields.append(String.format(",amount/%s as amount", unit));
        bizRecordFields.append(",lv,exrate,seqno,tradebillid,swapdir,bizbillopdate,expireddate,expired_end");
        for (String bizRecord : this.bizRecordAmtList) {
            String op = bizRecord.split("_")[0];
            String field = String.format(",case when entryentity.bizop in ('%s','%s_n','%s_f') and to_char(entryentity.opdate, 'yyyyMMdd') >= '%s' and to_char(entryentity.opdate, 'yyyyMMdd') <= '%s' then amount/%s else 0 end as %s", op, op, op, TcDateUtils.formatString((Date)this.startDate, (String)"yyyyMMdd"), TcDateUtils.formatString((Date)this.endDate, (String)"yyyyMMdd"), unit, bizRecord);
            bizRecordFields.append(field);
            reportCurrencyAmtFields.add(bizRecord + "_report");
            reportCurrencyAmtExpressions.add(bizRecord + "*rate");
        }
        String sectionOpAmt = String.format(",case when to_char(entryentity.opdate, 'yyyyMMdd') >= '%s' and to_char(entryentity.opdate, 'yyyyMMdd') <= '%s' then %s else 0 end as section_op_amt", TcDateUtils.formatString((Date)this.startDate, (String)"yyyyMMdd"), TcDateUtils.formatString((Date)this.endDate, (String)"yyyyMMdd"), String.format("amount/%s", unit));
        bizRecordFields.append(sectionOpAmt);
        GroupbyDataSet groupSet = bizRecordData.select(bizRecordFields.toString()).groupBy(new String[]{"tradebillid", "swapdir", "bizrecordid", "contract", "lv", "seqno", "bizbillopdate", "expireddate", "expired_end"});
        groupSet.max("exrate");
        groupSet.max("restamt");
        groupSet.sum("amount");
        groupSet.sum("section_op_amt");
        for (String sum : this.bizRecordAmtList) {
            groupSet.sum(sum);
        }
        DataSet bizRecordDataSet = groupSet.finish();
        bizRecordDataSet = bizRecordDataSet.addField("restamt+amount", "bizamt");
        bizRecordDataSet = bizRecordDataSet.updateField("section_op_amt", "case when section_op_amt is null then 0 else section_op_amt end");
        bizRecordDataSet = bizRecordDataSet.addField("bizamt-section_op_amt", "bizrestamt");
        String[] fields = ReportHelper.concat(GROUPED_TRADE_FIELDS, this.bizRecordAmtList.toArray(new String[0]));
        fields = this.appendSecondaryDevFields(paramMap, fields);
        processedForexData = processedForexData.rightJoin(bizRecordDataSet).on("id", "tradebillid").on("dir", "swapdir").select(fields).finish();
        processedForexData = processedForexData.filter("id is not null");
        if (!reportCurrencyAmtFields.isEmpty()) {
            processedForexData = processedForexData.addFields(reportCurrencyAmtExpressions.toArray(new String[0]), reportCurrencyAmtFields.toArray(new String[0]));
            this.bizRecordAmtList.addAll(reportCurrencyAmtFields);
        }
        processedForexData = processedForexData.updateFields(new String[]{"bizdate", "settledate", "settledate_end", "amount", "amount_report"}, new String[]{"case when lv=0 and seqno=0 then bizdate else bizbillopdate end", "case when lv=0 and seqno=0 then settledate else expireddate end", "case when lv=0 and seqno=0 then settledate_end else expired_end end", "case when lv=0 and seqno=0 then amount else 0 end", "case when lv=0 and seqno=0 then amount_report else 0 end"});
        processedForexData = processedForexData.addField("bizrestamt*rate", "bizrestamt_report");
        return processedForexData;
    }

    private Set<Long> getSrcBizBillIds(DataSet ds) {
        HashSet<Long> ids = new HashSet<Long>(16);
        for (Row row : ds) {
            ids.add(row.getLong("srcbizbill"));
        }
        return ids;
    }

    private DataSet queryPlInfoData(DataSet forexData, Map<String, Object> paramMap) {
        DataSet forexDataCopy = forexData.copy();
        HashSet<Long> tradeIds = new HashSet<Long>(16);
        HashSet<Long> bizRecordIds = new HashSet<Long>(16);
        for (Row row : forexDataCopy) {
            tradeIds.add(row.getLong("id"));
            BigDecimal bizRestAmt = row.getBigDecimal("bizrestamt");
            if (bizRestAmt == null || bizRestAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            bizRecordIds.add(row.getLong("bizrecordid"));
        }
        QFilter qFilter = new QFilter("tradebill.id", "in", tradeIds);
        qFilter.and(new QFilter("bizrecord", "!=", (Object)0L).or(QFilter.isNotNull((String)"bizrecord")));
        DataSet plDataSet = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_data", (String)"tbo_plinfo", (String)PL_INFO_FIELDS, (QFilter[])qFilter.toArray(), null);
        Date endDate = (Date)paramMap.get("enddate_filter");
        QFilter plFilter = new QFilter("bizrecord", "in", bizRecordIds).and("updatedate", "<=", (Object)endDate);
        DataSet plHistoryDataSet = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_history_data", (String)"tbo_plinfo_history", (String)"plbill,updatedate,plcurrency,plcurrency.number as plcurrencyNumber,floatplamt", (QFilter[])plFilter.toArray(), (String)"plbill,updatedate");
        DataSet maxDatePlDataSet = plHistoryDataSet.groupBy(new String[]{"plbill"}).maxP("updatedate", "plcurrency").maxP("updatedate", "plcurrencyNumber").maxP("updatedate", "floatplamt").finish();
        DataSet dataSet = plDataSet.leftJoin(maxDatePlDataSet).on("id", "plbill").select("id,org,tradeid,plcurrency,plcurrencyNumber,entrys.biztype,entrys.bizbillplcurrency,bizbillplcurrencynumber,entrys.plamt,entrys.bizdate,swapdir,bizrecordid".split(","), new String[]{"floatplamt"}).finish();
        return dataSet;
    }

    private static Set<Long> getDataSetIds(DataSet dataSet) {
        DataSet fsDS = dataSet.copy();
        HashSet<Long> ids = new HashSet<Long>(16);
        for (Row row : fsDS) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    private List<String> getSelectFields(Map<String, Object> paramMap) {
        List fields = (List)paramMap.get("fields");
        HashSet<String> noSelectFields = new HashSet<String>(23);
        noSelectFields.add("orgtext");
        noSelectFields.add("sumlevel");
        noSelectFields.add("coamtcurrency");
        noSelectFields.add("plcurrency");
        noSelectFields.add("plreportcurrency");
        noSelectFields.add("billno");
        noSelectFields.add("billstatus");
        noSelectFields.add("contract");
        noSelectFields.add("dir");
        noSelectFields.add("bizdate");
        noSelectFields.add("counterparty");
        noSelectFields.add("settledate");
        noSelectFields.add("tradedirect");
        noSelectFields.add("tradetype");
        noSelectFields.add("currency");
        noSelectFields.add("pair");
        noSelectFields.add("fxquote");
        noSelectFields.add("exrate");
        noSelectFields.add("currencytext");
        noSelectFields.add("bizamt");
        noSelectFields.add("amount");
        noSelectFields.add("amount_report");
        noSelectFields.add("bizrestamt");
        noSelectFields.add("bizrestamt_report");
        noSelectFields.add("id");
        noSelectFields.add("protecttypeid");
        ArrayList<String> selectField = new ArrayList<String>(16);
        for (String field : fields) {
            if (noSelectFields.contains(field)) continue;
            selectField.add(field);
        }
        return selectField;
    }

    private QFilter buildForexBaseFilter(Map<String, Object> paramMap) {
        DynamicObjectCollection counterPartyCollection;
        QFilter filter = new QFilter("billstatus", "in", (Object)new String[]{TcBillStatusEnum.SURVIVAL.getValue(), TcBillStatusEnum.FINISH.getValue()});
        this.appendSecondaryDevFilters(paramMap, filter);
        List<Long> orgIds = this.getAuthorizedOrgIds(this.getQueryParam());
        filter.and("org", "in", orgIds);
        DynamicObjectCollection buyCurrencyCollection = (DynamicObjectCollection)paramMap.get("buycurrency_filter");
        if (buyCurrencyCollection != null && buyCurrencyCollection.size() > 0) {
            filter.and("currency", "in", buyCurrencyCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if ((counterPartyCollection = (DynamicObjectCollection)paramMap.get("counterparty_filter")) != null && counterPartyCollection.size() > 0) {
            filter.and("counterparty", "in", counterPartyCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        filter.and("bizdate", ">=", (Object)this.startDate).and("bizdate", "<=", (Object)this.endDate);
        return filter;
    }

    private void appendSecondaryDevFilters(Map<String, Object> paramMap, QFilter filter) {
        ArrayList<String> secondaryDevFilters = new ArrayList<String>(2);
        for (String s : paramMap.keySet()) {
            if (!s.contains("_filter") || STANDARD_PRODUCT_FILTERS.contains(s)) continue;
            secondaryDevFilters.add(s);
        }
        if (secondaryDevFilters.size() > 0) {
            for (String s : secondaryDevFilters) {
                String qcp = "in";
                String field = s.substring(0, s.length() - 7);
                String[] v = paramMap.get(s);
                if (EmptyUtil.isEmpty((Object)v)) continue;
                if (v instanceof DynamicObject) {
                    v = ((DynamicObject)v).getPkValue();
                }
                if (v instanceof DynamicObjectCollection) {
                    v = ((DynamicObjectCollection)v).stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                }
                if (v instanceof String) {
                    if (((String)v).contains(",")) {
                        v = ((String)v).replaceFirst(",", "").split(",");
                    } else {
                        qcp = "=";
                    }
                }
                filter.and(field, qcp, v);
            }
        }
    }

    private void buildQueryFilterByForex(Map<String, Object> paramMap, QFilter filter) {
        DynamicObjectCollection protectTypes = (DynamicObjectCollection)paramMap.get("protecttype_filter");
        Set<Object> typeNum = new HashSet<Long>(4);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)protectTypes)) {
            typeNum = protectTypes.stream().filter(f -> !ProductTypeEnum.FOREXSWAPS.getId().equals(String.valueOf(f.getLong("id")))).map(s -> s.getLong("id")).collect(Collectors.toSet());
        } else {
            typeNum.add(Long.parseLong(ProductTypeEnum.FOREXSPOT.getId()));
            typeNum.add(Long.parseLong(ProductTypeEnum.FOREXFORWARD.getId()));
            typeNum.add(Long.parseLong(ProductTypeEnum.FOREXOPTION.getId()));
        }
        this.isContainsForexOptions = typeNum.contains(Long.parseLong(ProductTypeEnum.FOREXOPTION.getId()));
        this.isShowContract = typeNum.contains(Long.parseLong(ProductTypeEnum.FOREXFORWARD.getId()));
        filter.and("protecttype.id", "in", typeNum);
        String bizType = (String)paramMap.get("biztype_filter");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            String[] bizTypeArray = bizType.replaceFirst(",", "").split(",");
            filter.and("biztype", "in", Arrays.stream(bizTypeArray).collect(Collectors.toSet()));
        }
    }

    private void buildQueryFilterBySwaps(Map<String, Object> paramMap, QFilter filter) {
        filter.and("protecttype.id", "=", (Object)Long.parseLong(ProductTypeEnum.FOREXSWAPS.getId()));
        String bizType = (String)paramMap.get("biztype_filter");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            String[] bizTypeArray = bizType.replaceFirst(",", "").split(",");
            Set bizTypeSet = Arrays.stream(bizTypeArray).collect(Collectors.toSet());
            if (bizType.contains("buy") && !bizType.contains("sell")) {
                bizTypeSet.add("sell");
            }
            if (!bizType.contains("buy") && bizType.contains("sell")) {
                bizTypeSet.add("buy");
            }
            filter.and("biztype", "in", bizTypeSet);
        }
    }

    private void buildForexFilterByWipeCom(Map<String, Object> paramMap, QFilter forexFilter) {
        DynamicObjectCollection optioncombs;
        Set opIdSet;
        boolean wipecomFilter = (Boolean)paramMap.get("wipecom_filter");
        if (!wipecomFilter) {
            return;
        }
        QFilter filter = new QFilter("billstatus", "=", (Object)TcBillStatusEnum.AUDIT.getValue());
        filter.and("auditdate", "<", (Object)TcDateUtils.getNextDay((Date)this.endDate, (int)1)).and("auditdate", ">=", (Object)this.startDate);
        HashSet idSet = new HashSet(16);
        Object[] combtrades = TmcDataServiceHelper.load((String)"tm_combtrade", (String)"billno,entryentity,entryentity.tradebill", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])combtrades)) {
            for (Object combtrade : combtrades) {
                DynamicObjectCollection entryentity = combtrade.getDynamicObjectCollection("entryentity");
                Set collect = entryentity.stream().map(e -> e.getLong("tradebill")).collect(Collectors.toSet());
                idSet.addAll(collect);
            }
        }
        if (EmptyUtil.isNoEmpty(opIdSet = (optioncombs = QueryServiceHelper.query((String)"tm_optioncomb", (String)"billno,entrys,entrys.tradeno", (QFilter[])filter.toArray())).stream().map(e -> e.getLong("entrys.tradeno")).collect(Collectors.toSet()))) {
            idSet.addAll(opIdSet);
        }
        if (idSet.size() > 0) {
            forexFilter.and("id", "not in", idSet);
        }
    }

    private DataSet forexProcess(DataSet forexData, Map<String, Object> paramMap) {
        DynamicObject currency = (DynamicObject)paramMap.get("coamtcurrency_filter");
        DynamicObject forexQuote = (DynamicObject)paramMap.get("fquote_filter");
        String currUnit = (String)paramMap.get("amtunit_filter");
        String unit = ReportHelper.getUnit(currUnit);
        DataSet exchgRateDataSet = ReportHelper.calRateDataSet(this.currencyIds, this.rateList, forexData, forexQuote, currency, Collections.singletonList("currency"), Collections.singletonList("currencytext"), this.endDate, this.tipPairs);
        String[] selectField = new String[]{"id", "org", "orgtext", "protecttype.name as protecttype", "biztype", "rate", "case when protecttype.number = '01FOREXSPOT' then 1 when protecttype.number = '02FOREXFORWARD' then 2 when protecttype.number = '03FOREXSWAPS' then 3 else 4 end as protecttypeid", "case when biztype = 'buy' then 1 when biztype = 'sell' then 2 when biztype = 'diff' then 3 else 4 end as biztypeid", "billstatus", "bizdate", "dir", "billno", "pair", "counterparty", "settledate", "settledate_end", "tradedirect", "tradetype", "fxquote", "currency", "currencytext", String.format("amount/%s as amount", unit), String.format("amount*rate/%s as amount_report", unit)};
        selectField = this.appendSecondaryDevFields(paramMap, selectField);
        DataSet finish = forexData.leftJoin(exchgRateDataSet).on("currency", "currency").select(selectField).finish();
        finish = finish.addField(currency.getString("id"), "coamtcurrency");
        return finish;
    }

    private String[] appendSecondaryDevFields(Map<String, Object> paramMap, String[] selectFields) {
        ArrayList<String> secondaryDevFields = new ArrayList<String>(2);
        List<String> fields = this.getSelectFields(paramMap);
        for (String field : fields) {
            if (this.contains(selectFields, field)) continue;
            secondaryDevFields.add(field);
        }
        if (secondaryDevFields.size() > 0) {
            selectFields = ReportHelper.concat((String[])secondaryDevFields.stream().toArray(String[]::new), selectFields);
        }
        return selectFields;
    }

    private boolean contains(String[] selectFields, String field) {
        for (String s : selectFields) {
            String[] ss;
            if (!(s.contains(" as ") ? (ss = s.split(" as "))[1].trim().equals(field) : s.equals(field))) continue;
            return true;
        }
        return false;
    }

    private DataSet plProcess(DataSet originalPlDataSet, Map<String, Object> paramMap) {
        DynamicObject currency = (DynamicObject)paramMap.get("plcurrency_filter");
        DynamicObject forexQuote = (DynamicObject)paramMap.get("fquote_filter");
        String currUnit = (String)paramMap.get("amtunit_filter");
        String unit = ReportHelper.getUnit(currUnit);
        DataSet exchgRateDataSet = ReportHelper.calRateDataSet(this.plCurrencyIds, this.plRateList, originalPlDataSet, forexQuote, currency, Arrays.asList("plcurrency", "entrys.bizbillplcurrency"), Arrays.asList("plcurrencyNumber", "bizbillplcurrencynumber"), this.endDate, this.tipPairs);
        if (!EmptyUtil.isEmpty(this.tipPairs)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"ForwRateAgreeListRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]), String.join((CharSequence)"\u3001", this.tipPairs), forexQuote.getString("number")));
        }
        String[] selectField = new String[]{"id", "tradeid", "org", "plcurrency", "swapdir", "rate as floatplexrate", "bizrecordid", "entrys.bizbillplcurrency", "bizbillplcurrencynumber", String.format("floatplamt/%s as floatplamt", unit), String.format("case when floatplamt > 0 then floatplamt/%s else 0 end as gainplamt", unit), String.format("case when floatplamt < 0 then floatplamt/%s else 0 end as lossplamt", unit), String.format("case when to_char(entrys.bizdate, 'yyyyMMdd') >= '%s' and to_char(entrys.bizdate, 'yyyyMMdd') <= '%s' then %s else 0 end as plamt", TcDateUtils.formatString((Date)this.startDate, (String)"yyyyMMdd"), TcDateUtils.formatString((Date)this.endDate, (String)"yyyyMMdd"), String.format("entrys.plamt/%s", unit))};
        DataSet plDataSet = originalPlDataSet.copy().leftJoin(exchgRateDataSet.distinct()).on("plcurrency", "currency").select(selectField).finish();
        plDataSet = plDataSet.leftJoin(exchgRateDataSet.distinct()).on("entrys.bizbillplcurrency", "currency").select(plDataSet.getRowMeta().getFieldNames(), new String[]{"rate as plexrate"}).finish();
        plDataSet = plDataSet.addField("plamt*plexrate", ForexDetailRptPlColumnEnum.PLAMT_REPORT.getValue());
        DataSet plInfoGroup = plDataSet.groupBy(new String[]{"tradeid", "org", "bizrecordid", "swapdir", "plcurrency"}).max("floatplexrate").max(ForexDetailRptPlColumnEnum.FLOATPLAMT.getValue()).max(ForexDetailRptPlColumnEnum.GAINPLAMT.getValue()).max(ForexDetailRptPlColumnEnum.LOSSPLAMT.getValue()).sum(ForexDetailRptPlColumnEnum.PLAMT_REPORT.getValue()).finish().addFields(new String[]{"floatplamt*floatplexrate", "gainplamt*floatplexrate", "lossplamt*floatplexrate"}, new String[]{ForexDetailRptPlColumnEnum.FLOATPLAMT_REPORT.getValue(), ForexDetailRptPlColumnEnum.GAINPLAMT_REPORT.getValue(), ForexDetailRptPlColumnEnum.LOSSPLAMT_REPORT.getValue()}).addField("floatplamt_report+plamt_report", ForexDetailRptPlColumnEnum.TOTALPLAMT_REPORT.getValue());
        if (this.bizRecordPlList.size() > 0) {
            DataSet distinct = exchgRateDataSet.distinct();
            plInfoGroup = this.dealBizRecordPlDataSet(plInfoGroup.copy(), originalPlDataSet, distinct, paramMap);
        }
        return plInfoGroup;
    }

    private DataSet dealBizRecordPlDataSet(DataSet plInfoGroup, DataSet originalPlDataSet, DataSet exchgRateDataSet, Map<String, Object> paramMap) {
        String currUnit = (String)paramMap.get("amtunit_filter");
        String unit = ReportHelper.getUnit(currUnit);
        StringBuilder plFields = new StringBuilder();
        plFields.append("tradeid;swapdir;rate;bizrecordid;entrys.bizbillplcurrency");
        for (String bizRecord : this.bizRecordPlList) {
            String op = bizRecord.split("_")[0];
            String field = String.format(";case when entrys.biztype in ('%s','%s_n','%s_f') and to_char(entrys.bizdate, 'yyyyMMdd') >= '%s' and to_char(entrys.bizdate, 'yyyyMMdd') <= '%s' then entrys.plamt/%s else 0 end as %s", op, op, op, TcDateUtils.formatString((Date)this.startDate, (String)"yyyyMMdd"), TcDateUtils.formatString((Date)this.endDate, (String)"yyyyMMdd"), unit, bizRecord);
            plFields.append(field);
        }
        GroupbyDataSet groupSet = originalPlDataSet.leftJoin(exchgRateDataSet).on("entrys.bizbillplcurrency", "currency").select(plFields.toString().split(";")).finish().groupBy(new String[]{"tradeid", "bizrecordid", "swapdir", "entrys.bizbillplcurrency"});
        groupSet.max("rate");
        String[] reportCurrencyAmtExpressions = new String[this.bizRecordPlList.size()];
        String[] reportCurrencyAmtFields = new String[this.bizRecordPlList.size()];
        for (int i = 0; i < this.bizRecordPlList.size(); ++i) {
            String column = this.bizRecordPlList.get(i);
            groupSet.sum(column);
            reportCurrencyAmtExpressions[i] = column + "*rate";
            reportCurrencyAmtFields[i] = column + "_report";
        }
        DataSet finish = groupSet.finish();
        DataSet bizRecordPlDataSet = finish.addFields(reportCurrencyAmtExpressions, reportCurrencyAmtFields);
        GroupbyDataSet groupbyDataSet = bizRecordPlDataSet.groupBy(new String[]{"bizrecordid"});
        for (String field : reportCurrencyAmtFields) {
            groupbyDataSet.sum(field);
        }
        DataSet ds = groupbyDataSet.finish();
        this.bizRecordPlList.clear();
        this.bizRecordPlList.addAll(Arrays.stream(reportCurrencyAmtFields).collect(Collectors.toList()));
        String[] fields = this.concat(GROUPED_PL_INFO_FIELDS, reportCurrencyAmtFields, this.plInfoList.toArray(new String[0]));
        return plInfoGroup.leftJoin(ds).on("bizrecordid", "bizrecordid").select(fields).finish();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportColumn column_reportCurrency;
        ReportColumn column2;
        ReportColumnGroup columnGroup;
        for (String key : this.plInfoList) {
            if (!key.contains("_report")) continue;
            String prop = key.split("_report")[0];
            if (this.plInfoList.contains(prop)) {
                columnGroup = this.newReportColumnGroup(prop + "_group", new LocaleString(ForexDetailRptPlColumnEnum.getName((String)prop)));
                column2 = this.newReportColumn(prop, "plcurrency", new LocaleString(ResManager.loadKDString((String)"\u539f\u5e01", (String)"ForexPlDetailListRpt_2", (String)"tmc-tm-report", (Object[])new Object[0])));
                column_reportCurrency = this.newReportColumn(prop + "_report", "plreportcurrency", new LocaleString(ResManager.loadKDString((String)"\u62a5\u544a\u5e01", (String)"ForexPlDetailListRpt_3", (String)"tmc-tm-report", (Object[])new Object[0])));
                columnGroup.getChildren().add(column2);
                columnGroup.getChildren().add(column_reportCurrency);
                columns.add((AbstractReportColumn)columnGroup);
                continue;
            }
            ReportColumn column3 = this.newReportColumn(key, "plreportcurrency", new LocaleString(ForexDetailRptPlColumnEnum.getName((String)key)));
            columns.add((AbstractReportColumn)column3);
        }
        for (String bizRecordAmt : this.bizRecordAmtList) {
            String[] ss = bizRecordAmt.split("_");
            if (ss.length != 2) continue;
            columnGroup = this.newReportColumnGroup(bizRecordAmt + "_group", new LocaleString(String.format(ResManager.loadKDString((String)"%s", (String)"ForexPlDetailListRpt_4", (String)"tmc-tm-report", (Object[])new Object[0]), BizOperateEnum.getName((String)ss[0]))));
            column2 = this.newReportColumn(bizRecordAmt, "currency", new LocaleString(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u91d1\u989d\uff08\u539f\u5e01\uff09", (String)"ForexPlDetailListRpt_6", (String)"tmc-tm-report", (Object[])new Object[0]), new Object[0])));
            column_reportCurrency = this.newReportColumn(bizRecordAmt + "_report", "coamtcurrency", new LocaleString(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u91d1\u989d\uff08\u62a5\u544a\u5e01\uff09", (String)"ForexPlDetailListRpt_7", (String)"tmc-tm-report", (Object[])new Object[0]), new Object[0])));
            ReportColumn pl_reportCurrency = this.newReportColumn(ss[0] + "_pl_report", "plreportcurrency", new LocaleString(String.format(ResManager.loadKDString((String)"\u635f\u76ca\uff08\u62a5\u544a\u5e01\uff09", (String)"ForexPlDetailListRpt_8", (String)"tmc-tm-report", (Object[])new Object[0]), new Object[0])));
            columnGroup.getChildren().add(column2);
            columnGroup.getChildren().add(column_reportCurrency);
            columnGroup.getChildren().add(pl_reportCurrency);
            columns.add((AbstractReportColumn)columnGroup);
        }
        if (!this.isContainsForexSwaps) {
            columns.removeIf(column -> column instanceof ReportColumn && ((ReportColumn)column).getFieldKey().equals("dir"));
        }
        if (!this.isContainsForexOptions) {
            columns.removeIf(column -> column instanceof ReportColumn && ((ReportColumn)column).getFieldKey().equals("tradetype"));
        }
        if (!this.isShowContract) {
            columns.removeIf(column -> column instanceof ReportColumn && ((ReportColumn)column).getFieldKey().equals("contract"));
        }
        HashMap<String, AbstractReportColumn> dimensionReportColumnMap = new HashMap<String, AbstractReportColumn>(3);
        Iterator<AbstractReportColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            AbstractReportColumn column4 = iterator.next();
            if (!(column4 instanceof ReportColumn) || !this.dimensionColumns.contains(((ReportColumn)column4).getFieldKey())) continue;
            dimensionReportColumnMap.put(((ReportColumn)column4).getFieldKey(), column4);
            iterator.remove();
        }
        for (int i = this.dimensionColumns.size() - 1; i >= 0; --i) {
            columns.add(0, (AbstractReportColumn)dimensionReportColumnMap.get(this.dimensionColumns.get(i)));
        }
        return columns;
    }

    private ReportColumnGroup newReportColumnGroup(String fieldKey, LocaleString caption) {
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setFieldKey(fieldKey);
        reportColumnGroup.setCaption(caption);
        return reportColumnGroup;
    }

    private ReportColumn newReportColumn(String fieldKey, String currencyField, LocaleString caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("amount");
        reportColumn.setZeroShow(false);
        reportColumn.setCurrencyField(currencyField);
        reportColumn.setCaption(caption);
        return reportColumn;
    }

    public List<Long> getAuthorizedOrgIds(ReportQueryParam queryParam) {
        List<Object> orgIds = new ArrayList(10);
        Long userId = RequestContext.get().getCurrUserId();
        String formId = (String)queryParam.getCustomParam().get("formid");
        String appId = (String)queryParam.getCustomParam().get("appid");
        String queryWay = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        Object queryDetail = queryParam.getCustomParam().get("queryDetail");
        Object isGroupNode = queryParam.getCustomParam().get("isgroupnode");
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay)) {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem("filter_orgview").getValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                orgIds = (List)queryParam.getFilter().getFilterItem("filter_org").getValue();
                if (EmptyUtil.isEmpty(orgIds)) {
                    orgIds = TmcOrgDataHelper.getAuthorizedAndSubordinateOrgByView((Long)orgView.getLong("id"), (Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac", (boolean)true, (boolean)true);
                } else if (EmptyUtil.isEmpty(isGroupNode) || EmptyUtil.isNoEmpty(isGroupNode) && ((Boolean)isGroupNode).booleanValue()) {
                    orgIds = TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIds, (boolean)true, (boolean)true);
                }
            }
        } else {
            boolean queryLower;
            orgIds = (List)queryParam.getFilter().getFilterItem("filter_org").getValue();
            if (EmptyUtil.isEmpty(orgIds)) {
                orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
            }
            boolean isIncludeLower = queryParam.getFilter().containProp("filter_isincludelower") && (Boolean)queryParam.getFilter().getFilterItem("filter_isincludelower").getValue() != false;
            boolean bl = queryLower = isGroupNode != null && (Boolean)isGroupNode != false && queryDetail != null && (Boolean)queryDetail != false;
            if (queryLower) {
                FilterItemInfo orgFilter = queryParam.getFilter().getFilterItem("org_filter");
                Object orgList = orgFilter.getValue();
                if (EmptyUtil.isNoEmpty((Object)orgList)) {
                    List selOrgIds = ((DynamicObjectCollection)orgList).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                    List subOrgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)8L, orgIds, (boolean)true);
                    selOrgIds.retainAll(subOrgIds);
                    orgIds = selOrgIds;
                } else {
                    List allOrgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)8L, orgIds, (boolean)true);
                    List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
                    authOrgIds.retainAll(allOrgIds);
                    orgIds = authOrgIds;
                }
            }
            if (isIncludeLower) {
                orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)8L, orgIds, (boolean)true);
            }
        }
        return orgIds;
    }

    static {
        STANDARD_PRODUCT_FILTERS.add("dimension_filter");
        STANDARD_PRODUCT_FILTERS.add("enddate_filter");
        STANDARD_PRODUCT_FILTERS.add("startdate_filter");
        STANDARD_PRODUCT_FILTERS.add("total_filter");
        STANDARD_PRODUCT_FILTERS.add("plcurrency_filter");
        STANDARD_PRODUCT_FILTERS.add("wipecom_filter");
        STANDARD_PRODUCT_FILTERS.add("containsfinished_filter");
        STANDARD_PRODUCT_FILTERS.add("protecttype_filter");
        STANDARD_PRODUCT_FILTERS.add("biztype_filter");
        STANDARD_PRODUCT_FILTERS.add("fquote_filter");
        STANDARD_PRODUCT_FILTERS.add("org_filter");
        STANDARD_PRODUCT_FILTERS.add("daterange_filter");
        STANDARD_PRODUCT_FILTERS.add("bizrecord_filter");
        STANDARD_PRODUCT_FILTERS.add("swaps_filter");
        STANDARD_PRODUCT_FILTERS.add("counterparty_filter");
        STANDARD_PRODUCT_FILTERS.add("buycurrency_filter");
        STANDARD_PRODUCT_FILTERS.add("gainloss_filter");
        STANDARD_PRODUCT_FILTERS.add("tradedirect_filter");
        STANDARD_PRODUCT_FILTERS.add("end_settledate_filter");
        STANDARD_PRODUCT_FILTERS.add("coamtcurrency_filter");
        STANDARD_PRODUCT_FILTERS.add("amtunit_filter");
        STANDARD_PRODUCT_FILTERS.add("sumbycontract_filter");
        STANDARD_PRODUCT_FILTERS.add("start_settledate_filter");
        STANDARD_PRODUCT_FILTERS.add("dir_filter");
        HEAD_SELECT_FIELDS = new String[]{"id", "org", "orgtext", "protecttypeid", "protecttype", "biztype", "biztypeid", "bizamt", "coamtcurrency", "plcurrency", "billno", "billstatus", "bizdate", "pair", "counterparty", "settledate", "tradedirect", "tradetype", "fxquote", "dir", "currency", "currencytext", "amount", "amount_report", "contract", "exrate", "bizrestamt", "bizrestamt_report", "lv", "seqno"};
        GROUPED_TRADE_FIELDS = new String[]{"id", "org", "orgtext", "protecttypeid", "protecttype", "biztype", "biztypeid", "rate", "bizamt", "coamtcurrency", "billstatus", "bizdate", "dir", "billno", "pair", "counterparty", "settledate", "settledate_end", "tradedirect", "tradetype", "fxquote", "currency", "currencytext", "amount", "amount_report", "contract", "lv", "seqno", "restamt", "exrate", "bizrestamt", "bizrecordid", "bizbillopdate", "expireddate", "expired_end"};
        GROUPED_PL_INFO_FIELDS = new String[]{"tradeid", "swapdir", "org", "plcurrency", "bizrecordid"};
    }
}

