/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.plprovision;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeMenuParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PlProvisionList
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            if (filterColumn.getFieldName().equals("tradetypefilter.name")) {
                CommonBaseDataFilterColumn temp;
                if (EmptyUtil.isEmpty((String)this.getView().getPageCache().get("inittype"))) {
                    QFilter filter = new QFilter("longnumber", "like", (Object)"TRADE.01FOREX%").and(new QFilter("number", "!=", (Object)ProductTypeEnum.FOREXSPOT.getValue()));
                    filter = filter.or(new QFilter("longnumber", "like", (Object)"TRADE.03RATE%").and(new QFilter("longnumber", "!=", (Object)"TRADE.03RATE.03RATEBOUND")));
                    filter = filter.and(new QFilter("isbiznode", "=", (Object)Character.valueOf('1')));
                    DynamicObject[] protectTypes = TmcDataServiceHelper.load((String)"tbd_tradetype", (String)"id", (QFilter[])new QFilter[]{filter});
                    temp = (CommonBaseDataFilterColumn)filterColumn;
                    List items = temp.getComboItems();
                    items.clear();
                    for (DynamicObject protectType : protectTypes) {
                        items.add(new ComboItem(new LocaleString(protectType.getString("name")), protectType.getString("id")));
                    }
                    if (this.getView().getFormShowParameter().getCustomParams().containsKey("productType")) {
                        String productType = (String)this.getView().getFormShowParameter().getCustomParams().get("productType");
                        if (ProductTypeMenuParamEnum.RATE.getValue().equals(productType)) {
                            temp.setDefaultValues(Arrays.asList(ProductTypeEnum.FORWRATEAGREE.getId(), ProductTypeEnum.SWAP.getId()));
                        }
                        if (ProductTypeMenuParamEnum.FOREX.getValue().equals(productType)) {
                            temp.setDefaultValues(Arrays.asList(ProductTypeEnum.FOREXFORWARD.getId(), ProductTypeEnum.FOREXSWAPS.getId(), ProductTypeEnum.FOREXOPTION.getId()));
                        }
                    }
                    this.getView().getPageCache().put("inittype", SerializationUtils.toJsonString((Object)items));
                } else {
                    String inittype = this.getView().getPageCache().get("inittype");
                    List data = SerializationUtils.fromJsonStringToList((String)inittype, ComboItem.class);
                    temp = (CommonBaseDataFilterColumn)filterColumn;
                    temp.getComboItems().clear();
                    temp.getComboItems().addAll(data);
                }
            }
            if (!filterColumn.getFieldName().equals("org.id")) continue;
            if (this.getView().getFormShowParameter().getCustomParams().containsKey("trade_org_id")) {
                filterColumn.setDefaultValues(new Object[]{this.getView().getFormShowParameter().getCustomParams().get("trade_org_id")});
                continue;
            }
            if (!this.getView().getFormShowParameter().getCustomParams().containsKey("trade_org_ids")) continue;
            JSONArray tradeOrgIds = (JSONArray)this.getView().getFormShowParameter().getCustomParams().get("trade_org_ids");
            filterColumn.setDefaultValues(tradeOrgIds.stream().toArray());
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if (EmptyUtil.isNoEmpty(this.getView().getFormShowParameter().getCustomParams().get("orgId"))) {
            args.setMainOrgQFilter(new QFilter("id", "=", (Object)Long.valueOf((String)this.getView().getFormShowParameter().getCustomParams().get("orgId"))));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object tradeTypeFilter = null;
        String tradeTypeFilterProp = null;
        for (QFilter qFilter : e.getQFilters()) {
            if (!qFilter.getProperty().contains("tradetypefilter")) continue;
            tradeTypeFilter = qFilter.getValue();
            tradeTypeFilterProp = qFilter.getProperty();
            break;
        }
        if (tradeTypeFilter != null && tradeTypeFilterProp != null) {
            String prop = "entryentity." + tradeTypeFilterProp.replaceAll("tradetypefilter", "tradetype");
            e.getQFilters().add(new QFilter(prop, "in", tradeTypeFilter));
        }
        e.getQFilters().removeIf(o -> o.getProperty().contains("tradetypefilter"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if (op.getOperateKey().equals("submit")) {
            op.getOption().setVariableValue("do_submit_by_list_view", "yes");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && opResult.isSuccess() && "writeoff".equals(operateKey)) {
            ((BillList)this.getControl("billlistap")).refresh();
        }
        if (opResult != null && opResult.isSuccess() && "unwriteoff".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("close_view".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_view"));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("writeoffbill_billno".equals(args.getFieldName())) {
            args.setCancel(true);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("tbo_pl_provision");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
            DynamicObject row = QueryServiceHelper.queryOne((String)"tbo_pl_provision", (String)"writeoffbill", (QFilter[])new QFilter("id", "=", currentRow.getPrimaryKeyValue()).toArray());
            showParameter.setPkId(row.get("writeoffbill"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close_view");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

