/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.pnl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.enums.ReturnValTypeEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.helper.PlInfoCalculateHelper;

public class PlForwRateAgreeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        if (!this.validateProductType()) {
            return;
        }
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getControl("yieldcurve");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit forexquote = (BasedataEdit)this.getControl("forexquote");
        forexquote.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if (!this.validateProductType()) {
            return;
        }
        String key = event.getProperty().getName();
        DynamicObject plcurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if ("yieldcurve".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter filter = new QFilter("currency", "=", plcurrency.getPkValue()).and(new QFilter("enable", "=", (Object)"1"));
            showParameter.getListFilterParameter().setFilter(filter);
        } else if ("forexquote".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.setCustomParam("need_status_filter", (Object)true);
        }
    }

    public void afterBindData(EventObject e) {
        if (!this.validateProductType()) {
            return;
        }
        super.afterBindData(e);
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        Date bizdate = tradeBill.getDate("bizdate");
        ((DateEdit)this.getView().getControl("updatedate")).setMinDate(bizdate);
        if (!this.getModel().getDataEntityType().getName().equals("tbo_plinfo_history")) {
            boolean dataChanged = this.getModel().getDataChanged();
            Date currentDate = DateUtils.getCurrentDate();
            this.getModel().setValue("updatedate", (Object)currentDate);
            this.getModel().setDataChanged(dataChanged);
        }
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (localCurrency.getLong("id") != plCurrency.getLong("id")) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"forexquote", "exrate_local"});
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"referexrate"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        if (!this.validateProductType()) {
            return;
        }
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "referexrate": {
                DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
                this.getModel().setValue("floatplamt", (Object)PlInfoCalculateHelper.calFloatPlAmt_ForwRateAgree((DynamicObject)this.getModel().getDataEntity(), (Long)tradeBill.getLong("id")));
                break;
            }
            case "forexquote": {
                this.forexquoteChgEvt();
                break;
            }
            case "updatedate": {
                this.updateDateChangedEvt();
                this.forexquoteChgEvt();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!this.validateProductType()) {
            return;
        }
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("refreshfq".equals(operateKey)) {
            DynamicObject forexquote = (DynamicObject)this.getModel().getValue("forexquote");
            Date updateDate = (Date)this.getModel().getValue("updatedate");
            DynamicObject localCurr = (DynamicObject)this.getModel().getValue("localcurrency");
            DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
            if (EmptyUtil.isEmpty((Object)updateDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlRateSwapEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (plCurrency.getLong("id") != localCurr.getLong("id") && EmptyUtil.isEmpty((DynamicObject)forexquote)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u6c47\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlRateSwapEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (!this.validateProductType()) {
            return;
        }
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("refreshfq".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.updateDateChangedEvt();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        if (!this.validateProductType()) {
            return;
        }
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "updatedate": {
                break;
            }
            case "forexquote": {
                this.forexquoteChgValid(e);
            }
        }
    }

    private void updateDateChangedEvt() {
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject cashFlowEntry = this.getCashFlow(tradeBill.getLong("id"));
        QFilter filter = new QFilter("id", "=", tradeBill.getPkValue());
        tradeBill = QueryServiceHelper.queryOne((String)"tm_forwrateagree", (String)"pricerule,market", (QFilter[])filter.toArray());
        DynamicObject yieldCurve = (DynamicObject)this.getModel().getValue("yieldcurve");
        Long pricerule = tradeBill.getLong("pricerule");
        if (EmptyUtil.isNoEmpty((Long)pricerule)) {
            DynamicObject priceRuleInfo = TmcDataServiceHelper.loadSingle((Object)pricerule, (String)"md_pricerule");
            Long market = tradeBill.getLong("market");
            yieldCurve = this.getYields(market, priceRuleInfo);
            this.getModel().setValue("yieldcurve", (Object)yieldCurve);
        }
        Date updateDate = (Date)this.getModel().getValue("updatedate");
        BigDecimal predictRate = this.getPredictRate(cashFlowEntry, yieldCurve, updateDate);
        this.getModel().setValue("referexrate", (Object)predictRate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal getPredictRate(DynamicObject cashFlowEntry, DynamicObject yieldCurve, Date updateDate) {
        Date cfratefixdate = cashFlowEntry.getDate("cfratefixdate");
        DynamicObject cfratefixindex = cashFlowEntry.getDynamicObject("cfratefixindex");
        String cfreferindexfreq = cfratefixindex.getString("term");
        BigDecimal referRate = BigDecimal.ZERO;
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{updateDate, cfratefixdate})) return referRate;
        if (!updateDate.before(cfratefixdate)) return cashFlowEntry.getBigDecimal("cfuserate");
        if (yieldCurve == null) return BigDecimal.ZERO;
        if (!EmptyUtil.isNoEmpty((Object)yieldCurve.getPkValue())) return BigDecimal.ZERO;
        Date nextDateByPayfreq = PayFrequeEnum.getNextDateByPayfreq((Date)cfratefixdate, (PayFrequeEnum)PayFrequeEnum.getEnumByName((String)RateTermEnum.getName((String)cfreferindexfreq)));
        return MarketDataHelper.yieldCurve((long)yieldCurve.getLong("id"), (YieldTypeEnum)YieldTypeEnum.ref, (ReturnValTypeEnum)ReturnValTypeEnum.furrate, (Date)updateDate, (Date)cfratefixdate, (Date)nextDateByPayfreq);
    }

    private DynamicObject getCashFlow(Long tradeBillId) {
        DynamicObject cashflowCol = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"entrys.cfratefixdate,entrys.cfratefixindex,entrys.cfperioddays,entrys.cfuserate", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)tradeBillId)});
        DynamicObjectCollection entrys = cashflowCol.getDynamicObjectCollection("entrys");
        DynamicObject cashFlowEntry = (DynamicObject)entrys.get(0);
        return cashFlowEntry;
    }

    private void forexquoteChgValid(BeforeFieldPostBackEvent e) {
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (localCurrency.getLong("id") != plCurrency.getLong("id")) {
            String fxquote_local = plCurrency.getString("number").trim() + "/" + localCurrency.getString("number").trim();
            String fxquote_local_rev = localCurrency.getString("number").trim() + "/" + plCurrency.getString("number").trim();
            DynamicObject forexquote = (DynamicObject)this.getModel().getValue("forexquote");
            if (EmptyUtil.isNoEmpty((DynamicObject)forexquote)) {
                QFilter quotetype = new QFilter("define.fquotetype", "=", (Object)fxquote_local).or("define.fquotetype", "=", (Object)fxquote_local_rev);
                if (EmptyUtil.isEmpty((DynamicObject)(forexquote = BusinessDataServiceHelper.load((String)"md_forexquote", (String)"id,issuetime,define.fquotetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)forexquote.getLong("id")), quotetype})[0]))) {
                    this.getModel().setValue("forexquote", null);
                    e.setCancel(true);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u635f\u76ca\u5e01\u79cd/\u672c\u4f4d\u5e01%1$s\u5728\u5916\u6c47\u62a5\u4ef7%2$s\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u6216\u91cd\u65b0\u9009\u62e9\u5916\u6c47\u62a5\u4ef7", (String)"PlForwRateAgreeEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]), localCurrency.getString("number"), forexquote.getString("billno")));
                }
            }
        }
    }

    private void forexquoteChgEvt() {
        Date updateDate;
        DynamicObject forexquote;
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, localCurrency, forexquote = (DynamicObject)this.getModel().getValue("forexquote"), updateDate = (Date)this.getModel().getValue("updatedate")}) && localCurrency.getLong("id") != plCurrency.getLong("id")) {
            String fxquote_local = plCurrency.getString("number").trim() + "/" + localCurrency.getString("number").trim();
            ForexQuoteInfo fqInfo_local = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)forexquote.getLong("id"), (String)fxquote_local, (Date)updateDate, null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issuedate", (Object)fqInfo_local.getIssuetime());
        }
    }

    private boolean validateProductType() {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        return ProductTypeEnum.FORWRATEAGREE.getValue().equals(number);
    }

    private DynamicObject getYields(Long market, DynamicObject priceRule) {
        if (priceRule != null) {
            DynamicObjectCollection yields = priceRule.getDynamicObjectCollection("yield");
            for (DynamicObject yield : yields) {
                DynamicObject yieldMarket = yield.getDynamicObject("market");
                if (!yieldMarket.getPkValue().equals(market) || !YieldTypeEnum.ref.getValue().equals(yield.get("type"))) continue;
                return yield.getDynamicObject("yields");
            }
        }
        return null;
    }
}

