/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.pnl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.ExRateDirEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tbo.common.constant.ParamKeyConst;
import kd.tmc.tbo.formplugin.pnl.common.PlProvisionHelper;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;

public class PlInfoEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(PlInfoEdit.class);
    public static final String REFRESH_FQ = "refreshfq";
    private static final String DELETE_HISTORY = "deletehistory";
    private static final String VIEW_HISTORY_LIST = "viewhistorylist";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tradebill = (BasedataEdit)this.getView().getControl("tradebill");
        Optional.ofNullable(tradebill).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl("forexquote");
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        BasedataEdit yieldcurve = (BasedataEdit)this.getView().getControl("yieldcurve");
        Optional.ofNullable(yieldcurve).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        BasedataEdit payyields = (BasedataEdit)this.getView().getControl("payyields");
        Optional.ofNullable(payyields).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        BasedataEdit recyields = (BasedataEdit)this.getView().getControl("recyields");
        Optional.ofNullable(recyields).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
        this.initHistoryBillListFilter();
        BillList historyBillList = (BillList)this.getControl("historybilllist");
        if (historyBillList == null) {
            return;
        }
        historyBillList.addHyperClickListener((HyperLinkClickListener)this);
        historyBillList.addHyperClickListener(evt -> {
            String fieldName = evt.getFieldName();
            BillList billList = (BillList)evt.getSource();
            if (StringUtils.equals((CharSequence)"updatedate", (CharSequence)fieldName)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setPkId(billList.getFocusRowPkId());
                DynamicObject bill = QueryServiceHelper.queryOne((String)"tbo_plinfo_history", (String)"tradetype", (QFilter[])new QFilter("id", "=", billList.getFocusRowPkId()).toArray());
                if (ProductTypeEnum.FOREXSPOT.getId().equals(bill.getString("tradetype")) || ProductTypeEnum.FOREXFORWARD.getId().equals(bill.getString("tradetype")) || ProductTypeEnum.FOREXSWAPS.getId().equals(bill.getString("tradetype"))) {
                    parameter.setFormId("tbo_plinfo_h_forexfwd_l");
                } else if (ProductTypeEnum.FOREXOPTION.getId().equals(bill.getString("tradetype"))) {
                    parameter.setFormId("tbo_pl_h_forexoption_l");
                } else if (ProductTypeEnum.FORWRATEAGREE.getId().equals(bill.getString("tradetype"))) {
                    parameter.setFormId("tbo_pl_h_forwrateag_l");
                } else if (ProductTypeEnum.SWAP.getId().equals(bill.getString("tradetype"))) {
                    parameter.setFormId("tbo_plinfo_h_swap_l");
                }
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                StyleCss css = new StyleCss();
                parameter.getOpenStyle().setInlineStyleCss(css);
                parameter.setBillStatus(BillOperationStatus.EDIT);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "history"));
                parameter.setCaption(ResManager.loadKDString((String)"\u6d6e\u52a8\u635f\u76ca\u8be6\u60c5", (String)"PlInfoEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)parameter);
            }
        });
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter showParam = (BillShowParameter)e.getFormShowParameter();
        String entityType = showParam.getFormConfig().getEntityTypeId();
        Object pkId = ((BillShowParameter)e.getFormShowParameter()).getPkId();
        if (pkId == null) {
            return;
        }
        DynamicObject plBill = QueryServiceHelper.queryOne((String)entityType, (String)"tradetype", (QFilter[])new QFilter("id", "=", pkId).toArray());
        if (plBill == null) {
            return;
        }
        String layoutFm = e.getFormShowParameter().getFormId();
        boolean isHisType = "tbo_plinfo_history".equals(entityType);
        if (ProductTypeEnum.FOREXSPOT.getId().equals(plBill.getString("tradetype")) || ProductTypeEnum.FOREXFORWARD.getId().equals(plBill.getString("tradetype")) || ProductTypeEnum.FOREXSWAPS.getId().equals(plBill.getString("tradetype"))) {
            layoutFm = isHisType ? "tbo_plinfo_h_forexfwd_l" : "tbo_plinfo_forexfwd_l";
        } else if (ProductTypeEnum.FOREXOPTION.getId().equals(plBill.getString("tradetype"))) {
            layoutFm = isHisType ? "tbo_pl_h_forexoption_l" : "tbo_plinfo_forexoption_l";
        } else if (ProductTypeEnum.STRUCTDEPOSIT.getId().equals(plBill.getString("tradetype"))) {
            layoutFm = "tbo_pl_structdeposit_l";
        } else if (ProductTypeEnum.SWAP.getId().equals(plBill.getString("tradetype"))) {
            layoutFm = isHisType ? "tbo_plinfo_h_swap_l" : "tbo_plinfo_swap_l";
        } else if (ProductTypeEnum.FORWRATEAGREE.getId().equals(plBill.getString("tradetype"))) {
            layoutFm = isHisType ? "tbo_pl_h_forwrateag_l" : "tbo_plinfo_forwrateag_l";
        }
        e.getFormShowParameter().setFormId(layoutFm);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("tbo_select_date_dialog".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Date provisionDate = (Date)closedCallBackEvent.getReturnData();
            OperateOption option = OperateOption.create();
            option.setVariableValue("provisionDate", DateUtils.formatString((Date)provisionDate, (String)"yyyy-MM-dd"));
            this.getView().invokeOperation("singleprovision", option);
        } else {
            this.refreshHistoryBillList();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initHistoryBillListFilter();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable_pLCurrency();
    }

    private void setEnable_pLCurrency() {
        boolean isEnable = this.isEnable_pLCurrency();
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"plcurrency"});
    }

    private boolean isEnable_pLCurrency() {
        String swapType;
        boolean isEnable = !QueryServiceHelper.exists((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", this.getModel().getDataEntity().getPkValue()).toArray());
        BigDecimal bizRestAmt = (BigDecimal)this.getModel().getValue("bizrestamt");
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        if ((ProductTypeEnum.FOREXFORWARD.getId().equals(tradeType.getString("id")) || ProductTypeEnum.FOREXSWAPS.getId().equals(tradeType.getString("id")) || ProductTypeEnum.FOREXOPTION.getId().equals(tradeType.getString("id"))) && EmptyUtil.isEmpty((BigDecimal)bizRestAmt)) {
            isEnable = false;
        }
        if (isEnable && ProductTypeEnum.SWAP.getId().equals(tradeType.getString("id")) && "rate".equals(swapType = (String)this.getModel().getValue("swaptype"))) {
            isEnable = false;
        }
        return isEnable;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "updatedate": {
                DynamicObjectCollection dateCol;
                Set existDates;
                if (e.getValue() == null || !(existDates = (dateCol = QueryServiceHelper.query((String)"tbo_plinfo_history", (String)"updatedate", (QFilter[])new QFilter("plbill", "=", this.getModel().getDataEntity().getPkValue()).toArray())).stream().map(o -> TcDateUtils.truncateDate((Date)o.getDate("updatedate"))).collect(Collectors.toSet())).contains(TcDateUtils.stringToDate((String)((String)e.getValue()), (String)"yyyy-MM-dd"))) break;
                e.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65e5\u671f\u5df2\u5b58\u5728\u6d6e\u52a8\u635f\u76ca\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlInfoEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("updatedate");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        this.aliveValidate();
        switch (keyName = e.getProperty().getName()) {
            case "floatplamt": 
            case "exrate_local": {
                this.calFloatPlLocalAmt();
                break;
            }
            case "plcurrency": {
                boolean isEnable = this.isEnable_pLCurrency();
                if (!isEnable) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u635f\u76ca\u5355\u636e\u7684\u635f\u76ca\u5e01\u79cd\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PlInfoEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                }
                this.setLocalInfo();
                break;
            }
            case "forexquote": {
                this.setLocalInfo();
                break;
            }
            case "updatedate": {
                String traceId = RequestContext.get().getTraceId();
                if (ParamKeyConst.SKIP_PROPERTY_CHANGED_EVENT.equals(this.getView().getPageCache().get(traceId))) break;
                try {
                    this.setLocalInfo();
                    break;
                }
                catch (Exception ex) {
                    if (EmptyUtil.isNoEmpty((String)traceId)) {
                        this.getView().getPageCache().put(traceId, ParamKeyConst.SKIP_PROPERTY_CHANGED_EVENT);
                        this.getModel().setValue("updatedate", e.getChangeSet()[0].getOldValue());
                        this.getView().showErrorNotification(ex.getMessage());
                        logger.error((Throwable)ex);
                        break;
                    }
                    throw ex;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter qfilter;
        Long id;
        BillList historyBillList;
        super.beforeDoOperation(args);
        this.aliveValidate();
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey()) && "tbo_plinfo_history".equals(this.getView().getFormShowParameter().getFormConfig().getEntityTypeId()) && this.getModel().getValue("org") != null) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)org.getLong("id"), (String)"tm", (String)"tbo_plinfo", (String)"0=KX5+QVF5+R") != 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u201c\u635f\u76ca\u4fe1\u606f\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PlInfoEdit_22", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
        if (op.getOperateKey().equals(DELETE_HISTORY) && EmptyUtil.isEmpty((Collection)(historyBillList = (BillList)this.getControl("historybilllist")).getSelectedRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"PlInfoEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (op.getOperateKey().equals(VIEW_HISTORY_LIST) && (historyBillList = (BillList)this.getControl("historybilllist")).queryBillDataCount() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u6570\u636e\u3002", (String)"PlInfoEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (op.getOperateKey().equals("refresh") && !EmptyUtil.isEmpty((Long)(id = (Long)this.getModel().getValue("id"))) && !TmcDataServiceHelper.exists((String)"tbo_plinfo", (QFilter[])(qfilter = new QFilter("id", "=", (Object)id)).toArray())) {
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u635f\u76ca\u4fe1\u606f\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"PlInfoEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])});
        }
        if (op.getOperateKey().equals("singleprovision")) {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
            if (ProductTypeEnum.FOREXSPOT.getId().equals(tradeType.getString("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u6c47\u5373\u671f\uff0c\u65e0\u9700\u8fdb\u884c\u635f\u76ca\u8ba1\u63d0\u3002", (String)"PlInfoEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (ProductTypeEnum.FOREXSWAPS.getId().equals(tradeType.getString("id")) && ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(tradeBill.get("swaptype")) || ProductTypeEnum.FOREXSWAPS.getId().equals(tradeType.getString("id")) && ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(tradeBill.get("swaptype")) && "isnear".equals(this.getModel().getValue("swapdir"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u6c47\u6389\u671f\u8fd1\u7aef\uff08\u8fdc\u7aef\uff09\u4e3a\u5373\u671f\uff0c\u65e0\u9700\u8fdb\u884c\u635f\u76ca\u8ba1\u63d0\u3002", (String)"PlInfoEdit_7", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!op.getOption().containsVariable("provisionDate")) {
                args.setCancel(true);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("tbo_select_date_dialog");
                String caption = ResManager.loadKDString((String)"\u635f\u76ca\u8ba1\u63d0", (String)"PlInfoEdit_8", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                showParameter.setCaption(caption);
                showParameter.setCustomParam("date_title", (Object)ResManager.loadKDString((String)"\u8ba1\u63d0\u65e5", (String)"PlInfoEdit_9", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tbo_select_date_dialog");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else if (!op.getOption().containsVariable("validate_finished")) {
                String provisionDateStr = op.getOption().getVariableValue("provisionDate");
                Date provisionDate = DateUtils.stringToDate((String)provisionDateStr, (String)"yyyy-MM-dd");
                Date bizDate = (Date)this.getModel().getValue("tradebizdate");
                if (bizDate != null && provisionDate.compareTo(bizDate) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u65e5\u5c0f\u4e8e\u4ea4\u6613\u65e5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlInfoEdit_10", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                }
                if (QueryServiceHelper.exists((String)"tbo_pl_provision", (QFilter[])new QFilter("provisiondate", "=", (Object)provisionDate).and("entryentity.plinfo.plbill", "=", this.getModel().getDataEntity().getPkValue()).toArray())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u65e5\u671f\u5df2\u53d1\u751f\u8fc7\u635f\u76ca\u8ba1\u63d0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlInfoEdit_11", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                }
                if (!QueryServiceHelper.exists((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", this.getModel().getValue("id")).and("updatedate", "=", (Object)provisionDate).toArray())) {
                    args.setCancel(true);
                    this.getView().getPageCache().put("provisionDate", provisionDateStr);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728%s\u65e5\u671f\u7684\u6d6e\u52a8\u635f\u76ca\u7684\u4ea4\u6613\uff0c\u662f\u5426\u81ea\u52a8\u751f\u6210\u8be5\u65e5\u6d6e\u52a8\u635f\u76ca\uff1f", (String)"PlInfoEdit_12", (String)"tmc-tm-formplugin", (Object[])new Object[]{provisionDateStr}), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("singleprovision", (IFormPlugin)this));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("traceplprovision".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObjectCollection plInfoHistoryCol = QueryServiceHelper.query((String)"tbo_plinfo_history", (String)"id,org", (QFilter[])new QFilter("plbill", "=", this.getModel().getDataEntity().getPkValue()).toArray());
            Object[] ids = plInfoHistoryCol.stream().map(o -> o.get("id")).toArray();
            if (EmptyUtil.isEmpty((Object[])ids) || !QueryServiceHelper.exists((String)"tbo_pl_provision", (QFilter[])new QFilter("entryentity.plinfo", "in", (Object)ids).toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u635f\u76ca\u5355\u5c1a\u672a\u8fdb\u884c\u635f\u76ca\u8ba1\u63d0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlInfoEdit_13", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tbo_pl_provision", (boolean)true, (int)0, (boolean)false);
            parameter.getListFilterParameter().getQFilters().add(new QFilter("entryentity.plinfo", "in", (Object)ids));
            parameter.getCustomParams().put("orgId", ((DynamicObject)plInfoHistoryCol.get(0)).getString("org"));
            this.getView().showForm((FormShowParameter)parameter);
        }
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.refreshHistoryBillList();
            this.setEnable_pLCurrency();
        }
        if (REFRESH_FQ.equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.setLocalInfo();
        }
        if (DELETE_HISTORY.equals(operateKey) && args.getOperationResult().isSuccess()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DELETE_HISTORY, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"PlInfoEdit_14", (String)"tmc-tm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
        }
        DynamicObject tradetype = (DynamicObject)this.getModel().getValue("tradetype");
        String tradetypeId = tradetype.getString("id");
        if (VIEW_HISTORY_LIST.equals(operateKey) && args.getOperationResult().isSuccess()) {
            String entity = "tbo_plinfo_history";
            if (ProductTypeEnum.SWAP.getId().equals(tradetypeId)) {
                entity = "tbo_plinfo_h_swap_l";
            } else if (ProductTypeEnum.FORWRATEAGREE.getId().equals(tradetypeId)) {
                entity = "tbo_pl_h_forwrateag_l";
            } else if (ProductTypeEnum.FOREXOPTION.getId().equals(tradetypeId)) {
                entity = "tbo_pl_h_forexoption_l";
            } else if (ProductTypeEnum.FOREXSPOT.getId().equals(tradetypeId) || ProductTypeEnum.FOREXFORWARD.getId().equals(tradetypeId) || ProductTypeEnum.FOREXSWAPS.getId().equals(tradetypeId)) {
                entity = "tbo_plinfo_h_forexfwd_l";
            }
            ListShowParameter param = ShowFormHelper.createShowListForm((String)entity, (boolean)true, (int)0, (boolean)false);
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setFilter(new QFilter("plbill", "=", this.getModel().getDataEntity().getPkValue()));
            param.setCaption(ResManager.loadKDString((String)"\u6d6e\u52a8\u635f\u76ca\u5386\u53f2\u6570\u636e", (String)"PlInfoEdit_15", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            param.setListFilterParameter(filterParameter);
            this.getView().showForm((FormShowParameter)param);
        }
        if ("calculate".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String message = args.getOperationResult().getValidateResult().getMessage();
            if (EmptyUtil.isNoEmpty((String)message)) {
                String currentDateStr = DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd");
                JSONObject messageJson = JSONObject.parseObject((String)message);
                if (messageJson.containsKey((Object)"already_provision_bills")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5df2\u64cd\u4f5c\u635f\u76ca\u8ba1\u63d0\uff0c\u65e0\u6cd5\u66f4\u65b0\u6d6e\u52a8\u635f\u76ca\u3002", (String)"PlInfoEdit_16", (String)"tmc-tm-formplugin", (Object[])new Object[]{currentDateStr}));
                } else if (messageJson.containsKey((Object)"already_exist_bills")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728%s\u65e5\u7684\u6d6e\u52a8\u635f\u76ca\uff0c\u66f4\u65b0\u8df3\u8fc7\u3002", (String)"PlInfoEdit_17", (String)"tmc-tm-formplugin", (Object[])new Object[]{currentDateStr}));
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6d6e\u52a8\u635f\u76ca\u6210\u529f\uff01", (String)"PlInfoEdit_18", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
        if ("singleprovision".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String provisionDateStr = op.getOption().getVariableValue("provisionDate");
            Date provisionDate = DateUtils.stringToDate((String)provisionDateStr, (String)"yyyy-MM-dd");
            DynamicObject plBill = BusinessDataServiceHelper.loadSingle((String)"tbo_plinfo_history", (String)"plbill,billno,org,buycurrency,sellcurrency,plcurrency,localcurrency,tradebill,tradetype,floatplamt,voucher_pl,floatpllocalamt,provision,plprovisioninfo,plprovisioncurrency,plprovisionamt,plcalcmethod", (QFilter[])new QFilter("plbill", "in", this.getModel().getDataEntity().getPkValue()).and("updatedate", "=", (Object)provisionDate).toArray());
            if (plBill == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u4eca\u65e5\u6d6e\u52a8\u635f\u76ca\uff0c\u518d\u8fdb\u884c\u8ba1\u63d0\u64cd\u4f5c\u3002", (String)"PlInfoEdit_19", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject currency = plBill.getDynamicObject("localcurrency");
            BigDecimal amount = plBill.getBigDecimal("floatplamt");
            int precision = currency.getInt("amtprecision");
            BigDecimal newAmount = amount.setScale(precision, RoundingMode.HALF_UP);
            DynamicObject pl = plBill.getDynamicObject("plbill");
            if (pl != null && newAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u635f\u76ca\u5355%s\u7684\u6d6e\u52a8\u635f\u76ca\u4e3a0\uff0c\u65e0\u6cd5\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"PlInfoEdit_20", (String)"tmc-tm-formplugin", (Object[])new Object[]{pl.getString("billno")}));
                return;
            }
            DynamicObject plProvisionBill = PlProvisionHelper.buildPlProvisionBill(provisionDate, new DynamicObject[]{plBill});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plProvisionBill});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plBill});
            BillShowParameter param = new BillShowParameter();
            param.setFormId("tbo_pl_provision");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setPkId(plProvisionBill.get("id"));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        BillList historyBillList;
        Set selectedRowIds;
        super.confirmCallBack(messageBoxClosedEvent);
        if (DELETE_HISTORY.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && EmptyUtil.isNoEmpty(selectedRowIds = (historyBillList = (BillList)this.getControl("historybilllist")).getSelectedRows().stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet()))) {
            DynamicObject[] deleteRows = BusinessDataServiceHelper.load((Object[])selectedRowIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tbo_plinfo_history"));
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"tbo_plinfo_history", (DynamicObject[])deleteRows, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                this.refreshHistoryBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PlInfoEdit_21", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                historyBillList.clearSelection();
                this.setEnable_pLCurrency();
            } else {
                StringBuilder strBuilder = new StringBuilder();
                if (result.getValidateResult() != null && result.getValidateResult().getValidateErrors() != null) {
                    for (ValidateResult validateError : result.getValidateResult().getValidateErrors()) {
                        for (OperateErrorInfo operateErrorInfo : validateError.getAllErrorInfo()) {
                            strBuilder.append(operateErrorInfo.getMessage());
                            strBuilder.append("\n");
                        }
                    }
                }
                if (strBuilder.length() == 0) {
                    strBuilder.append(result.getMessage());
                }
                this.getView().showErrorNotification(strBuilder.toString());
            }
        }
        if (StringUtils.equals((CharSequence)"singleprovision", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.autoGenPl();
            OperateOption option = OperateOption.create();
            String provisionDateStr = this.getView().getPageCache().get("provisionDate");
            option.setVariableValue("provisionDate", provisionDateStr);
            option.setVariableValue("validate_finished", "true");
            this.getView().invokeOperation("singleprovision", option);
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("tradebill".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
            String number = tradeType.getString("number");
            String formid = "tm_trade";
            if (ProductTypeEnum.FOREXSPOT.getValue().equals(number)) {
                formid = "tm_forex_l";
            } else if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number)) {
                formid = "tm_forex_forward_l";
            } else if (ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
                formid = "tm_forex_swaps_l";
            } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
                formid = "tm_forex_options_l";
            } else if (ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(number)) {
                formid = "tm_structdeposit_l";
            } else if (ProductTypeEnum.SWAP.getValue().equals(number)) {
                formid = "tm_rateswap_l";
            } else if (ProductTypeEnum.FORWRATEAGREE.getValue().equals(number)) {
                formid = "tm_forwrateagree_l";
            }
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else if ("forexquote".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_forexquote";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else if ("yieldcurve".equals(key) || "payyields".equals(key) || "recyields".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_yieldline";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void refreshHistoryBillList() {
        BillList historyBillList = (BillList)this.getControl("historybilllist");
        if (historyBillList == null) {
            return;
        }
        historyBillList.addSetFilterListener(evt -> {
            QFilter sourceIdFilter = new QFilter("plbill", "=", this.getModel().getDataEntity().getPkValue());
            evt.getQFilters().add(sourceIdFilter);
        });
        historyBillList.refreshData();
    }

    private void setLocalInfo() {
        logger.info("PlInfoEdit.setLocalInfo");
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        if (ProductTypeEnum.FOREXSPOT.getValue().equals(number)) {
            return;
        }
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
        Date updateDate = (Date)this.getModel().getValue("updatedate");
        DynamicObject forexQuote = (DynamicObject)this.getModel().getValue("forexquote");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, localCurrency, forexQuote}) && (ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(number) || !ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(number) && EmptyUtil.isNoEmpty((Object)updateDate)) && localCurrency.getLong("id") != plCurrency.getLong("id")) {
            String pl_local_fq = plCurrency.getString("number").trim() + "/" + localCurrency.getString("number").trim();
            ForexQuoteInfo pl_local_fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)forexQuote.getLong("id"), (String)pl_local_fq, (Date)updateDate, null);
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
            BigDecimal exRate = ExRateDirEnum.MIDDLE_PRICE.getValue().equals(exRateDir) ? pl_local_fqInfo.getMiddleprice() : (plCurrency.getString("number").equals(pl_local_fqInfo.getFxquote().split("/")[0]) ? pl_local_fqInfo.getBuyPrice() : pl_local_fqInfo.getSellPrice());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fxquote_local", (Object)pl_local_fqInfo.getFxquote());
            this.getModel().setValue("exrate_local", (Object)exRate);
            if ("tbo_plinfo".equals(this.getModel().getDataEntityType().getName()) && ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(number)) {
                this.getModel().setValue("issuedate_local", (Object)pl_local_fqInfo.getIssuetime());
            }
        } else {
            this.getModel().setValue("exrate_local", (Object)BigDecimal.ZERO);
        }
    }

    private void calFloatPlLocalAmt() {
        logger.info("PlInfoEdit.calFloatPlLocalAmt");
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
        Long localCurrencyId = localCurrency.getLong("id");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        String fxquote_local = (String)this.getModel().getValue("fxquote_local");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{fxquote_local, plCurrency}) && !localCurrencyId.equals(plCurrency.getLong("id"))) {
            BigDecimal exrate_local = (BigDecimal)this.getModel().getValue("exrate_local");
            BigDecimal floatPlAmt = (BigDecimal)this.getModel().getValue("floatplamt");
            BigDecimal floatPlLocalAmt = plCurrency.getString("number").equals(fxquote_local.split("/")[0]) ? floatPlAmt.multiply(exrate_local) : (BigDecimal.ZERO.compareTo(exrate_local) == 0 ? BigDecimal.ZERO : floatPlAmt.divide(exrate_local, 10, 4));
            logger.info("\u8ba1\u7b97\u6298\u672c\u4f4d\u5e01\u6d6e\u52a8\u635f\u76ca\uff1a\u6d6e\u52a8\u635f\u76ca\uff1a{}\uff1b\u6298\u7b97\u6c47\u7387\uff1a{}\uff1b\u6298\u672c\u4f4d\u5e01\u6d6e\u52a8\u635f\u76ca\uff1a{}", new Object[]{floatPlAmt.toPlainString(), exrate_local.toPlainString(), floatPlLocalAmt.toPlainString()});
            this.getModel().setValue("floatpllocalamt", (Object)floatPlLocalAmt);
        }
    }

    private void initHistoryBillListFilter() {
        BillList historyBillList = (BillList)this.getControl("historybilllist");
        if (historyBillList == null) {
            return;
        }
        historyBillList.addSetFilterListener(evt -> {
            QFilter sourceIdFilter = new QFilter("plbill", "=", this.getModel().getDataEntity().getPkValue());
            evt.getQFilters().add(sourceIdFilter);
        });
    }

    private void autoGenPl() {
        String provisionDateStr = this.getView().getPageCache().get("provisionDate");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tbo_plinfo");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (DynamicObjectType)entityType);
        OperateOption op = OperateOption.create();
        op.setVariableValue("updatedate", provisionDateStr);
        OperationResult result = OperationServiceHelper.executeOperate((String)"calculate", (String)"tbo_plinfo", (DynamicObject[])new DynamicObject[]{bill}, (OperateOption)op);
        if (!result.isSuccess()) {
            StringBuilder strBuilder = new StringBuilder();
            if (result.getValidateResult() != null && result.getValidateResult().getValidateErrors() != null) {
                for (ValidateResult validateError : result.getValidateResult().getValidateErrors()) {
                    for (OperateErrorInfo operateErrorInfo : validateError.getAllErrorInfo()) {
                        strBuilder.append(operateErrorInfo.getMessage());
                        strBuilder.append("\n");
                    }
                }
            }
            if (strBuilder.length() == 0) {
                strBuilder.append(result.getMessage());
            }
            throw new KDBizException(strBuilder.toString());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        this.aliveValidate();
        String fieldName = evt.getFieldName();
        if ("plprovisioninfo_billno".equals(fieldName)) {
            BillList historyBillList = (BillList)this.getControl("historybilllist");
            Object primaryKeyValue = historyBillList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject currentPlRow = QueryServiceHelper.queryOne((String)"tbo_plinfo_history", (String)"plprovisioninfo", (QFilter[])new QFilter("id", "=", primaryKeyValue).toArray());
            BillShowParameter param = new BillShowParameter();
            param.setFormId("tbo_pl_provision");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setPkId(currentPlRow.get("plprovisioninfo"));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void aliveValidate() {
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getDataEntity().getPkValue()) && !QueryServiceHelper.exists((String)this.getModel().getDataEntity().getDataEntityType().getName(), (Object)this.getModel().getDataEntity().getPkValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PlInfoEdit_23", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }
}

