/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.pnl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeMenuParamEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.model.OpConfirmDialogInfo;

public class PlInfoList
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(PlInfoList.class);
    private static final String[] PRODUCTS = new String[]{"01FOREXSPOT", "02FOREXFORWARD", "03FOREXSWAPS", "04FOREXOPTION", "01FORWRATEAGREE", "02SWAP", "01STRUCTDEPOSIT"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Object billId = e.getParameter().getPkId();
        if (billId != null) {
            DynamicObject bill = QueryServiceHelper.queryOne((String)"tbo_plinfo", (String)"tradetype", (QFilter[])new QFilter("id", "=", billId).toArray());
            String tradeType = bill.getString("tradetype");
            if (ProductTypeEnum.FOREXSPOT.getId().equals(tradeType) || ProductTypeEnum.FOREXFORWARD.getId().equals(tradeType) || ProductTypeEnum.FOREXSWAPS.getId().equals(tradeType)) {
                e.getParameter().setFormId("tbo_plinfo_forexfwd_l");
            } else if (ProductTypeEnum.FOREXOPTION.getId().equals(tradeType)) {
                e.getParameter().setFormId("tbo_plinfo_forexoption_l");
            } else if (ProductTypeEnum.STRUCTDEPOSIT.getId().equals(tradeType)) {
                e.getParameter().setFormId("tbo_pl_structdeposit_l");
            } else if (ProductTypeEnum.FORWRATEAGREE.getId().equals(tradeType)) {
                e.getParameter().setFormId("tbo_plinfo_forwrateag_l");
            } else if (ProductTypeEnum.SWAP.getId().equals(tradeType)) {
                e.getParameter().setFormId("tbo_plinfo_swap_l");
            }
            e.getParameter().setCaption(ResManager.loadKDString((String)"\u635f\u76ca\u4fe1\u606f", (String)"PlInfoList_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("tradebill_number".equals(fieldName)) {
            args.setCancel(true);
            BillListHyperLinkClickEvent e = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = e.getCurrentRow();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            DynamicObject cur = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"tradebill", (QFilter[])new QFilter("id", "=", currentRow.getPrimaryKeyValue()).toArray());
            DynamicObject tradeBill = cur.getDynamicObject("tradebill");
            showParameter.setPkId(tradeBill.getPkValue());
            Long protectTypeId = tradeBill.getDynamicObject("protecttype").getLong("id");
            QFilter filter = new QFilter("tradetype.id", "=", (Object)protectTypeId);
            Map setColl = TmcDataServiceHelper.loadFromCache((String)"tbd_tradeset", (QFilter[])filter.toArray());
            setColl.forEach((key, tradeSet) -> {
                if (EmptyUtil.isNoEmpty((DynamicObject)tradeSet) && !tradeSet.getDynamicObject("bill").getString("number").endsWith("_l")) {
                    showParameter.setFormId(tradeSet.getDynamicObject("bill").getString("number"));
                }
            });
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            if (filterColumn.getFieldName().equals("tradetype.name")) {
                CommonBaseDataFilterColumn temp;
                if (EmptyUtil.isEmpty((String)this.getView().getPageCache().get("inittype"))) {
                    QFilter filter = new QFilter("longnumber", "like", (Object)"TRADE.01FOREX%");
                    filter = filter.or(new QFilter("longnumber", "like", (Object)"TRADE.03RATE%").and(new QFilter("longnumber", "!=", (Object)"TRADE.03RATE.03RATEBOUND")));
                    filter = filter.or(new QFilter("longnumber", "=", (Object)"TRADE.05STRUCT.01STRUCTDEPOSIT"));
                    filter = filter.and(new QFilter("isbiznode", "=", (Object)Character.valueOf('1')));
                    DynamicObject[] protectTypes = TmcDataServiceHelper.load((String)"tbd_tradetype", (String)"id", (QFilter[])new QFilter[]{filter});
                    temp = (CommonBaseDataFilterColumn)filterColumn;
                    List items = temp.getComboItems();
                    items.clear();
                    for (DynamicObject protectType : protectTypes) {
                        items.add(new ComboItem(new LocaleString(protectType.getString("name")), protectType.getString("id")));
                    }
                    if (this.getView().getFormShowParameter().getCustomParams().containsKey("productType")) {
                        String productType = (String)this.getView().getFormShowParameter().getCustomParams().get("productType");
                        if (ProductTypeMenuParamEnum.STRUCT.getValue().equals(productType)) {
                            temp.setDefaultValue(ProductTypeEnum.STRUCTDEPOSIT.getId());
                        }
                        if (ProductTypeMenuParamEnum.RATE.getValue().equals(productType)) {
                            temp.setDefaultValues(Arrays.asList(ProductTypeEnum.FORWRATEAGREE.getId(), ProductTypeEnum.SWAP.getId()));
                        }
                        if (ProductTypeMenuParamEnum.FOREX.getValue().equals(productType)) {
                            temp.setDefaultValues(Arrays.asList(ProductTypeEnum.FOREXSPOT.getId(), ProductTypeEnum.FOREXFORWARD.getId(), ProductTypeEnum.FOREXSWAPS.getId(), ProductTypeEnum.FOREXOPTION.getId()));
                        }
                    }
                    this.getView().getPageCache().put("inittype", SerializationUtils.toJsonString((Object)items));
                } else {
                    String inittype = this.getView().getPageCache().get("inittype");
                    List data = SerializationUtils.fromJsonStringToList((String)inittype, ComboItem.class);
                    temp = (CommonBaseDataFilterColumn)filterColumn;
                    temp.getComboItems().clear();
                    temp.getComboItems().addAll(data);
                }
            }
            if (!filterColumn.getFieldName().equals("org.id")) continue;
            if (this.getView().getFormShowParameter().getCustomParams().containsKey("trade_org_id")) {
                filterColumn.setDefaultValues(new Object[]{this.getView().getFormShowParameter().getCustomParams().get("trade_org_id")});
                continue;
            }
            if (!this.getView().getFormShowParameter().getCustomParams().containsKey("trade_org_ids")) continue;
            JSONArray tradeOrgIds = (JSONArray)this.getView().getFormShowParameter().getCustomParams().get("trade_org_ids");
            filterColumn.setDefaultValues(tradeOrgIds.stream().toArray());
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String fieldName = event.getFieldName();
        if ("tradetype.id".equals(fieldName) || "tradetype.number".equals(fieldName) || "tradetype.name".equals(fieldName)) {
            String productType = (String)this.getView().getFormShowParameter().getCustomParams().get("productType");
            if (ProductTypeMenuParamEnum.STRUCT.getValue().equals(productType)) {
                event.getQfilters().add(new QFilter("id", "in", (Object)Long.valueOf(ProductTypeEnum.STRUCTDEPOSIT.getId())));
            }
            if (ProductTypeMenuParamEnum.RATE.getValue().equals(productType)) {
                event.getQfilters().add(new QFilter("id", "in", Arrays.asList(Long.valueOf(ProductTypeEnum.FORWRATEAGREE.getId()), Long.valueOf(ProductTypeEnum.SWAP.getId()))));
            }
            if (ProductTypeMenuParamEnum.FOREX.getValue().equals(productType)) {
                event.getQfilters().add(new QFilter("id", "in", Arrays.asList(Long.valueOf(ProductTypeEnum.FOREXSPOT.getId()), Long.valueOf(ProductTypeEnum.FOREXFORWARD.getId()), Long.valueOf(ProductTypeEnum.FOREXSWAPS.getId()), Long.valueOf(ProductTypeEnum.FOREXOPTION.getId()))));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("calculate".equals(op.getOperateKey()) && !op.getOption().containsVariable("after_select_date")) {
            args.setCancel(true);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tbo_select_date_dialog");
            showParameter.setCaption(ResManager.loadKDString((String)"\u6d6e\u52a8\u635f\u76ca\u66f4\u65b0", (String)"PlInfoList_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("date_title", (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f", (String)"PlInfoList_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "select_date_before_update_pl");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("select_date_before_update_pl".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Date date = (Date)closedCallBackEvent.getReturnData();
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            DynamicObjectCollection selectPlBills = QueryServiceHelper.query((String)"tbo_plinfo", (String)"billno,tradebizdate", (QFilter[])new QFilter("id", "in", selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet())).and(QFilter.isNotNull((String)"tradebizdate")).toArray(), (String)"tradebizdate asc", (int)1);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)selectPlBills)) {
                Date bizDate = ((DynamicObject)selectPlBills.get(0)).getDate("tradebizdate");
                logger.info("select_date_before_update_pl\uff1a\u4ea4\u6613\u65e5\u6700\u5c0f\u7684\u635f\u76ca\u5355\u53f7={}\uff0c\u4ea4\u6613\u65e5={}", new Object[]{((DynamicObject)selectPlBills.get(0)).getString("billno"), bizDate});
                if (date.compareTo(bizDate) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f\u5c0f\u4e8e\u9009\u5b9a\u4ea4\u6613\u7684\u4ea4\u6613\u65e5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlInfoList_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                }
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("after_select_date", "true");
            option.setVariableValue("updatedate", DateUtils.formatString((Date)date, (String)"yyyy-MM-dd"));
            this.getView().invokeOperation("calculate", option);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("calculate".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String message = args.getOperationResult().getValidateResult().getMessage();
            if (EmptyUtil.isNoEmpty((String)message)) {
                HashMap<String, String> rowMap;
                String reason;
                List billNos;
                ArrayList data = new ArrayList(8);
                JSONObject messageJson = JSONObject.parseObject((String)message);
                if (messageJson.containsKey((Object)"already_provision_bills")) {
                    billNos = (List)messageJson.get((Object)"already_provision_bills");
                    reason = ResManager.loadKDString((String)"\u5df2\u64cd\u4f5c\u635f\u76ca\u8ba1\u63d0\uff0c\u65e0\u6cd5\u66f4\u65b0\u6d6e\u52a8\u635f\u76ca\u3002", (String)"PlInfoList_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                    for (String billNo : billNos) {
                        rowMap = new HashMap<String, String>(2);
                        rowMap.put("billNo", billNo);
                        rowMap.put("reason", reason);
                        data.add(rowMap);
                    }
                }
                if (messageJson.containsKey((Object)"already_exist_bills")) {
                    billNos = (List)messageJson.get((Object)"already_exist_bills");
                    reason = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u65e5\u7684\u6d6e\u52a8\u635f\u76ca\uff0c\u66f4\u65b0\u8df3\u8fc7\u3002", (String)"PlInfoList_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                    for (String billNo : billNos) {
                        rowMap = new HashMap(2);
                        rowMap.put("billNo", billNo);
                        rowMap.put("reason", reason);
                        data.add(rowMap);
                    }
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("tbo_op_confirm_dialog");
                ArrayList<String[]> columns = new ArrayList<String[]>(2);
                columns.add(new String[]{"billNo", ResManager.loadKDString((String)"\u635f\u76ca\u5355\u53f7", (String)"PlInfoList_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])});
                columns.add(new String[]{"reason", ResManager.loadKDString((String)"\u539f\u56e0", (String)"PlInfoList_7", (String)"tmc-tm-formplugin", (Object[])new Object[0])});
                OpConfirmDialogInfo dialogInfo = new OpConfirmDialogInfo(ResManager.loadKDString((String)"\u4e0b\u5217\u635f\u76ca\u5355\u5df2\u8df3\u8fc7\u5904\u7406\uff1a", (String)"PlInfoList_8", (String)"tmc-tm-formplugin", (Object[])new Object[0]), columns, data);
                dialogInfo.getShowBtnList().clear();
                dialogInfo.getShowBtnList().add("btnclose");
                showParameter.setCustomParam("dialogInfo", (Object)dialogInfo);
                showParameter.setCaption(ResManager.loadKDString((String)"\u5904\u7406\u7ed3\u679c", (String)"PlInfoList_9", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(showParameter);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6d6e\u52a8\u635f\u76ca\u6210\u529f\uff01", (String)"PlInfoList_10", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            ((BillList)this.getControl("billlistap")).refresh();
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dataList = super.getData(start, limit);
            if (dataList.isEmpty()) {
                return dataList;
            }
            for (DynamicObject data : dataList) {
                BigDecimal bizRestAmt;
                if (data.containsProperty("tradebill") && data.containsProperty("maxhistoryplinfo")) {
                    String billstatus = data.getString("tradebill.billstatus");
                    if (TcBillStatusEnum.FINISH.getValue().equals(billstatus)) {
                        data.set("maxhistoryplinfo", null);
                        continue;
                    }
                }
                if (!data.containsProperty("bizrestamt") || !data.containsProperty("maxhistoryplinfo") || !(data.get("tradetype") instanceof DynamicObject) || !ProductTypeEnum.FOREXFORWARD.getId().equals(data.getDynamicObject("tradetype").getString("id")) && !ProductTypeEnum.FOREXSWAPS.getId().equals(data.getDynamicObject("tradetype").getString("id")) && !ProductTypeEnum.FOREXOPTION.getId().equals(data.getDynamicObject("tradetype").getString("id")) || (bizRestAmt = data.getBigDecimal("bizrestamt")) == null || bizRestAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                data.set("maxhistoryplinfo", null);
            }
            return dataList;
        }
    }
}

