/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.pnl;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;

public class PlStructDepositEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        if (!this.validateProductType()) {
            return;
        }
        super.afterBindData(e);
        this.setColumnsNameByType();
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"type"});
        DynamicObject tradeBill = QueryServiceHelper.queryOne((String)"tm_structdeposit", (String)"intdate,settledate,billstatus", (QFilter[])new QFilter("id", "=", ((DynamicObject)this.getModel().getValue("tradebill")).getPkValue()).toArray());
        this.getView().setEnable(Boolean.valueOf(!TcBillStatusEnum.FINISH.getValue().equals(tradeBill.get("billstatus"))), new String[]{"type"});
        DateEdit calcDate = (DateEdit)this.getView().getControl("floatplamtcalcdate");
        calcDate.setMinDate(tradeBill.getDate("intdate"));
        calcDate.setMaxDate(tradeBill.getDate("settledate"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (!this.validateProductType()) {
            return;
        }
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("refresh".equals(operateKey)) {
            this.refresh_structDeposit();
        }
    }

    private void refresh_structDeposit() {
        DynamicObject tradeBill = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)this.getModel().getValue("tradebill")).getPkValue(), (String)"tm_structdeposit");
        this.getModel().setValue("lastobsdate", tradeBill.get("zoneobsdate"));
        QFilter filterCashFlow = new QFilter("billid", "=", tradeBill.getPkValue());
        DynamicObject[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfpayamount,entrys.cfuserate", (QFilter[])new QFilter[]{filterCashFlow});
        DynamicObject cashFlow2 = this.get(cashFlows, "2");
        DynamicObject cashFlow2_1 = (DynamicObject)((DynamicObjectCollection)cashFlow2.get("entrys")).get(0);
        this.getModel().setValue("referexrate", cashFlow2_1.get("cfuserate"));
        this.getModel().setValue("floatplamtcalcdate", (Object)new Date());
        this.getModel().setValue("floatplamt", (Object)this.calcFloatPlAmt_StructDeposit());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        if (!this.validateProductType()) {
            return;
        }
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "floatplamtcalcdate": 
            case "referexrate": {
                this.getModel().setValue("floatplamt", (Object)this.calcFloatPlAmt_StructDeposit());
                break;
            }
            case "type": {
                this.setColumnsNameByType();
                this.getModel().setValue("floatplamt", (Object)this.calcFloatPlAmt_StructDeposit());
            }
        }
    }

    private void setColumnsNameByType() {
        Object type = this.getModel().getValue("type");
        if (EmptyUtil.isEmpty((Object)type)) {
            return;
        }
        if ("AC".equals(type)) {
            ((FieldEdit)this.getView().getControl("floatplamtcalcdate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u5229\u606f\u644a\u9500\u8ba1\u7b97\u65e5", (String)"PlStructDepositEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getView().getControl("floatplamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u5229\u606f\u644a\u9500", (String)"PlStructDepositEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getView().getControl("floatpllocalamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6298\u672c\u4f4d\u5e01\u5229\u606f\u644a\u9500", (String)"PlStructDepositEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        } else {
            ((FieldEdit)this.getView().getControl("floatplamtcalcdate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6d6e\u52a8\u635f\u76ca\u8ba1\u7b97\u65e5", (String)"PlStructDepositEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getView().getControl("floatplamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6d6e\u52a8\u635f\u76ca", (String)"PlStructDepositEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
            ((FieldEdit)this.getView().getControl("floatpllocalamt")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6298\u672c\u4f4d\u5e01\u6d6e\u52a8\u635f\u76ca", (String)"PlStructDepositEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        }
    }

    private BigDecimal calcFloatPlAmt_StructDeposit() {
        DynamicObject tradeBill = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)this.getModel().getValue("tradebill")).getPkValue(), (String)"tm_structdeposit");
        if (TcBillStatusEnum.FINISH.getValue().equals(tradeBill.get("billstatus"))) {
            return BigDecimal.ZERO;
        }
        if ("AC".equals(this.getModel().getValue("type"))) {
            return this.calcFloatPlAmt_StructDeposit_2(tradeBill);
        }
        return this.calcFloatPlAmt_StructDeposit_1(tradeBill);
    }

    private BigDecimal calcFloatPlAmt_StructDeposit_1(DynamicObject tradeBill) {
        int days = 0;
        Date intDate = tradeBill.getDate("intdate");
        Date calcDate = (Date)this.getModel().getValue("floatplamtcalcdate");
        if (calcDate != null) {
            days = TcDateUtils.getDiffDays((Date)intDate, (Date)calcDate);
        }
        int yrBasis = TradeBusinessHelper.getBasis_YearDay((int)Calendar.getInstance().get(1), (BasisEnum)BasisEnum.valueOf((String)tradeBill.getString("basis")));
        BigDecimal amt = tradeBill.getBigDecimal("amount").multiply((BigDecimal)this.getModel().getValue("referexrate")).multiply(new BigDecimal(days)).divide(new BigDecimal("100").multiply(new BigDecimal(yrBasis)), 4);
        return amt;
    }

    private BigDecimal calcFloatPlAmt_StructDeposit_2(DynamicObject tradeBill) {
        BigDecimal ytm;
        BigDecimal CCB;
        BigDecimal diff;
        Date floatplamtcalcdate = (Date)this.getModel().getValue("floatplamtcalcdate");
        if (floatplamtcalcdate == null) {
            return BigDecimal.ZERO;
        }
        int k = TcDateUtils.getDiffDays((Date)tradeBill.getDate("intdate"), (Date)floatplamtcalcdate);
        int n = TcDateUtils.getDiffDays((Date)tradeBill.getDate("intdate"), (Date)tradeBill.getDate("settledate"));
        QFilter filterCashFlow = new QFilter("billid", "=", tradeBill.getPkValue());
        DynamicObject[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfpayamount,entrys.cfuserate,entrys.cfperioddays", (QFilter[])new QFilter[]{filterCashFlow});
        if (cashFlows.length != 3) {
            return BigDecimal.ZERO;
        }
        DynamicObject cashFlow2 = this.get(cashFlows, "2");
        DynamicObject cashFlow2_1 = (DynamicObject)((DynamicObjectCollection)cashFlow2.get("entrys")).get(0);
        DynamicObject cashFlow3 = this.get(cashFlows, "3");
        BigDecimal amount = cashFlow3.getBigDecimal("cfpayamount");
        int cfPeriodDays = cashFlow2_1.getInt("cfperioddays");
        int yrBasis = TradeBusinessHelper.getBasis_YearDay((int)Calendar.getInstance().get(1), (BasisEnum)BasisEnum.valueOf((String)tradeBill.getString("basis")));
        if (n <= 0 || k <= 0 || amount.compareTo(BigDecimal.ZERO) <= 0 || cfPeriodDays == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal referExRate = (BigDecimal)this.getModel().getValue("referexrate");
        BigDecimal interest = amount.multiply(referExRate).multiply(new BigDecimal(cfPeriodDays)).divide(new BigDecimal(yrBasis), 10, 4).divide(new BigDecimal(100), 10, 4);
        BigDecimal CCB_n = amount.add(interest);
        BigDecimal actual_365 = new BigDecimal("365");
        BigDecimal ytm_min = BigDecimal.ZERO;
        BigDecimal ytm_max = interest.divide(amount, 10, 4).divide(new BigDecimal(n), 10, 4).multiply(actual_365);
        BigDecimal diffMin = new BigDecimal("0.0000000001");
        int maxTimes = 100;
        int count = 0;
        while ((diff = (CCB = this.calcCCB(ytm = ytm_min.add(ytm_max).divide(new BigDecimal(2), 10, 4), amount, n)).subtract(CCB_n)).abs().compareTo(diffMin) > 0) {
            if (diff.compareTo(BigDecimal.ZERO) > 0) {
                if (ytm_max.compareTo(ytm) == 0) break;
                ytm_max = ytm;
            } else {
                if (ytm_min.compareTo(ytm) == 0) break;
                ytm_min = ytm;
            }
            if (++count != maxTimes) continue;
            break;
        }
        return this.calcAMk(ytm, amount, k);
    }

    private BigDecimal calcCCB(BigDecimal ytm, BigDecimal CCB, int n) {
        return this.calCCBAndAM(ytm, CCB, n).get("CCB");
    }

    private BigDecimal calcAMk(BigDecimal ytm, BigDecimal CCB, int k) {
        return this.calCCBAndAM(ytm, CCB, k).get("AM");
    }

    private Map<String, BigDecimal> calCCBAndAM(BigDecimal ytm, BigDecimal CCB, int k) {
        BigDecimal actual_365 = new BigDecimal("365");
        BigDecimal AM = BigDecimal.ZERO;
        for (int i = 0; i < k; ++i) {
            AM = ytm.multiply(CCB).divide(actual_365, 18, 4);
            CCB = CCB.add(AM);
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        result.put("CCB", CCB);
        result.put("AM", AM);
        return result;
    }

    private DynamicObject get(DynamicObject[] cashFlows, String billNo) {
        for (DynamicObject cashFlow : cashFlows) {
            if (!billNo.equals(cashFlow.get("billno"))) continue;
            return cashFlow;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u73b0\u91d1\u6d41\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PlStructDepositEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[]{billNo}));
    }

    private boolean validateProductType() {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        return ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(number);
    }
}

