/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.pnl.common;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.PlCalcMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.enums.PlProvisionTypeEnum;
import kd.tmc.tbo.common.enums.WriteOffStatusEnum;
import kd.tmc.tbo.formplugin.common.helper.AmountHelper;
import kd.tmc.tbo.formplugin.common.helper.Validator;
import kd.tmc.tm.common.enums.DeliveryWayEnum;

public class PlProvisionHelper {
    public static DynamicObject buildPlProvisionBill(Date provisionDate, DynamicObject[] plBills) {
        Validator.validate(plBills, "billno", "localcurrency", "plcurrency", "tradetype");
        DynamicObject plProvisionBill = BusinessDataServiceHelper.newDynamicObject((String)"tbo_pl_provision");
        long id = DB.genLongId((String)"t_tbo_pl_provision");
        plProvisionBill.set("id", (Object)id);
        plProvisionBill.set("type", (Object)PlProvisionTypeEnum.PROVISION.getValue());
        plProvisionBill.set("writeoffstatus", (Object)WriteOffStatusEnum.UNWRITEOFF.getValue());
        plProvisionBill.set("provisiondate", (Object)provisionDate);
        plProvisionBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        plProvisionBill.set("createtime", (Object)new Date());
        plProvisionBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        plProvisionBill.set("org", plBills[0].get("org"));
        plProvisionBill.set("plcurrency", plBills[0].get("plcurrency"));
        plProvisionBill.set("localcurrency", plBills[0].get("localcurrency"));
        plProvisionBill.set("plprovisioncurrency", plBills[0].get("plcurrency"));
        DynamicObjectCollection entryEntity = plProvisionBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject plBill : plBills) {
            DynamicObject entryRow = entryEntity.addNew();
            entryRow.set("plinfo", plBill.getPkValue());
            entryRow.set("tradebill", plBill.get("tradebill"));
            entryRow.set("tradetype", plBill.get("tradetype"));
            entryRow.set("plcurrencyfloatplamt", plBill.get("floatplamt"));
            DynamicObject localCurrency = plBill.getDynamicObject("localcurrency");
            DynamicObject plCurrency = plBill.getDynamicObject("plcurrency");
            long localCurrencyId = localCurrency.getLong("id");
            long plCurrencyId = plCurrency.getLong("id");
            if (ProductTypeEnum.FORWRATEAGREE.getId().equals(plBill.getDynamicObject("tradetype").getString("id")) || ProductTypeEnum.SWAP.getId().equals(plBill.getDynamicObject("tradetype").getString("id"))) {
                if (plCurrencyId != localCurrencyId) {
                    entryRow.set("localcurrencyfloatplamt", plBill.get("floatpllocalamt"));
                } else {
                    entryRow.set("localcurrencyfloatplamt", plBill.get("floatplamt"));
                }
            } else if (ProductTypeEnum.FOREXFORWARD.getId().equals(plBill.getDynamicObject("tradetype").getString("id")) || ProductTypeEnum.FOREXSWAPS.getId().equals(plBill.getDynamicObject("tradetype").getString("id")) || ProductTypeEnum.FOREXOPTION.getId().equals(plBill.getDynamicObject("tradetype").getString("id"))) {
                Validator.validate(plBill, "billno", "buycurrency", "sellcurrency");
                DynamicObject buyCurrency = plBill.getDynamicObject("buycurrency");
                DynamicObject sellCurrency = plBill.getDynamicObject("sellcurrency");
                long buyCurrencyId = buyCurrency.getLong("id");
                long sellCurrencyId = sellCurrency.getLong("id");
                boolean b = true;
                if (ProductTypeEnum.FOREXOPTION.getId().equals(plBill.getDynamicObject("tradetype").getString("id"))) {
                    Validator.validate(plBill, "billno", "plcalcmethod");
                    if (PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(plBill.get("plcalcmethod"))) {
                        b = false;
                    }
                }
                DynamicObject tradeBill = plBill.getDynamicObject("tradebill");
                String deliveryWay = tradeBill.getString("deliveryway");
                if (b && buyCurrencyId != localCurrencyId && sellCurrencyId != localCurrencyId && DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    entryRow.set("localcurrencyfloatplamt", plBill.get("voucher_pl"));
                } else if (plCurrencyId != localCurrencyId) {
                    entryRow.set("localcurrencyfloatplamt", plBill.get("floatpllocalamt"));
                } else {
                    entryRow.set("localcurrencyfloatplamt", plBill.get("floatplamt"));
                }
            }
            AmountHelper.setScale(plProvisionBill, "plcurrency", entryRow, "plcurrencyfloatplamt");
            AmountHelper.setScale(plProvisionBill, "localcurrency", entryRow, "localcurrencyfloatplamt");
            plBill.set("plprovisioncurrency", plBill.get("plcurrency"));
            plBill.set("plprovisionamt", entryRow.get("plcurrencyfloatplamt"));
            plBill.set("provision", (Object)"1");
            plBill.set("plprovisioninfo", (Object)id);
        }
        Object[] tradeTypeIds = Arrays.stream(plBills).filter(o -> o.getDynamicObject("tradetype") != null).map(o -> o.getDynamicObject("tradetype").getPkValue()).distinct().toArray();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tbd_tradetype");
        DynamicObject[] tradeTypeCol = BusinessDataServiceHelper.load((Object[])tradeTypeIds, (DynamicObjectType)entityType);
        IDataEntityType mainType = plProvisionBill.getDataEntityType();
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.getProperties().get((Object)"tradetypes");
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection tradeTypes = (DynamicObjectCollection)mulBasedataProp.getValue((Object)plProvisionBill);
        for (DynamicObject tradeTypeBill : tradeTypeCol) {
            DynamicObject tradeType = new DynamicObject(subEntityType);
            tradeTypes.add((Object)tradeType);
            basedataProp.setValue((Object)tradeType, (Object)tradeTypeBill);
        }
        plProvisionBill.set("tradetypes", (Object)tradeTypes);
        BigDecimal totalProvisionAmt = Arrays.stream(plBills).map(o -> o.getBigDecimal("plprovisionamt")).reduce(BigDecimal::add).get();
        if (BigDecimal.ZERO.compareTo(totalProvisionAmt) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u635f\u76ca\u5355\u6d6e\u52a8\u635f\u76ca\u5408\u8ba1\u91d1\u989d\u4e3a0\uff0c\u65e0\u6cd5\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"PlProvisionHelper_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        plProvisionBill.set("totalprovisionamt", (Object)totalProvisionAmt);
        String billNo = CodeRuleServiceHelper.getNumber((String)"tbo_pl_provision", (DynamicObject)plProvisionBill, null);
        if (EmptyUtil.isEmpty((String)billNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5df2\u6b63\u786e\u8bbe\u7f6e\u635f\u76ca\u8ba1\u63d0\u5355\u636e\u7f16\u53f7\u89c4\u5219\u3002", (String)"PlProvisionHelper_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        plProvisionBill.set("billno", (Object)billNo);
        return plProvisionBill;
    }
}

