/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.OptionTypeEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.common.helper.PlHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class ExerciseBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init_ForexOptions();
        this.initControl_ForexOptions();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        switch (propName) {
            case "bizdate": {
                this.calDeliveryDateValue(tradebill);
                this.setExecExrate(tradebill);
                this.calSettleAmount_ForexOptionForBusinessBill();
                Map result = PlHelper.calPlAmt_Ex_ForexOptionForBusinessBill((DynamicObject)tradebill, (DynamicObject)this.getModel().getDataEntity());
                for (Map.Entry e : result.entrySet()) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)e.getKey()), e.getValue());
                }
                this.setBaseInfo_PL(tradebill);
                this.setControl_DeliveryDate_ForexOptions(tradebill);
                break;
            }
            case "deliverydate": {
                this.setExecExrate(tradebill);
                this.calSettleAmount_ForexOptionForBusinessBill();
                this.calPlAmt();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                this.setControl_DeliveryDate_ForexOptions(tradebill);
                break;
            }
            case "bizamt1": 
            case "execexrate": {
                this.calSettleAmount_ForexOptionForBusinessBill();
                this.calPlAmt();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "settleamount": 
            case "premium_pl": {
                this.calPlAmt();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "plamt": 
            case "baseexrate": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "plcurrency": {
                this.getModel().setValue("settlecurrency", this.getModel().getValue("plcurrency"));
                this.calSettleAmount_ForexOptionForBusinessBill();
                Map result = PlHelper.calPlAmt_Ex_ForexOptionForBusinessBill((DynamicObject)tradebill, (DynamicObject)this.getModel().getDataEntity());
                for (Map.Entry e : result.entrySet()) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)e.getKey()), e.getValue());
                }
                this.setBaseInfo_PL(tradebill);
                this.setControl_DeliveryDate_ForexOptions(tradebill);
                break;
            }
            case "premium_pl_exrate": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl", (Object)BusinessBillHelper.calPremium_PL((DynamicObject)this.getModel().getDataEntity()));
                this.calPlAmt();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
            }
        }
    }

    private void init_ForexOptions() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject settleCurrency = tradebill.getDynamicObject("settlecurrency");
            DynamicObject premCurrency = tradebill.getDynamicObject("premiumcurrency");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premcurrency_src", (Object)premCurrency);
            BigDecimal premium = tradebill.getBigDecimal("premium");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_src", (Object)premium);
            Date expireDate = tradebill.getDate("adjexpiredate");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expireddate", (Object)expireDate);
            if (!this.isFromLifeCycleApply()) {
                Date bizdate;
                Date curDate = TcDateUtils.getCurrentDate();
                if (!curDate.before(bizdate = tradebill.getDate("bizdate")) && !curDate.after(expireDate)) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", (Object)curDate);
                }
                this.calDeliveryDateValue(tradebill);
            }
            this.setExecExrate(tradebill);
            String deliveryWay = tradebill.getString("deliveryway");
            if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                DynamicObjectCollection entryDetail = this.getModel().getEntryEntity("entrydetail");
                List buyList = entryDetail.stream().filter(s -> "buy".equals(s.getString("direct_detail"))).map(a -> a.getDynamicObject("currency_detail")).collect(Collectors.toList());
                List sellList = entryDetail.stream().filter(s -> "sell".equals(s.getString("direct_detail"))).map(a -> a.getDynamicObject("currency_detail")).collect(Collectors.toList());
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reccurrency", buyList.get(0));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paycurrency", sellList.get(0));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plcurrency", (Object)tradebill.get("sellcurrency"));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reccurrency", (Object)settleCurrency);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paycurrency", (Object)settleCurrency);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plcurrency", (Object)settleCurrency);
            }
            this.getModel().setValue("settlecurrency", this.getModel().getValue("plcurrency"));
            this.calSettleAmount_ForexOptionForBusinessBill();
            Map result = PlHelper.calPlAmt_Ex_ForexOptionForBusinessBill((DynamicObject)tradebill, (DynamicObject)this.getModel().getDataEntity());
            for (Map.Entry e : result.entrySet()) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)e.getKey()), e.getValue());
            }
            this.setBaseInfo_PL(tradebill);
        }
    }

    private void initControl_ForexOptions() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        this.setControl_BizDate_ForexOptions(tradebill);
        this.setControl_DeliveryDate_ForexOptions(tradebill);
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexOptions(DynamicObject tradebill) {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bizdate");
        Date bizdate = tradebill.getDate("bizdate");
        Date expireDate = tradebill.getDate("adjexpiredate");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(expireDate);
    }

    private void setControl_DeliveryDate_ForexOptions(DynamicObject tradebill) {
        DateEdit dateEdit = (DateEdit)this.getControl("deliverydate");
        String optionType = tradebill.getString("optiontype");
        if (OptionTypeEnum.european.getValue().equals(optionType)) {
            Date adjustSettleDate = tradebill.getDate("adjustsettledate");
            dateEdit.setMinDate(adjustSettleDate);
        } else if (OptionTypeEnum.american.getValue().equals(optionType)) {
            Date optDate = (Date)this.getModel().getValue("bizdate");
            dateEdit.setMinDate(optDate);
        }
    }

    private void calDeliveryDateValue(DynamicObject tradebill) {
        Date optDate;
        String optionType = tradebill.getString("optiontype");
        Date adjustSettleDate = tradebill.getDate("adjustsettledate");
        if (OptionTypeEnum.european.getValue().equals(optionType)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deliverydate", (Object)adjustSettleDate);
        } else if (OptionTypeEnum.american.getValue().equals(optionType) && (optDate = (Date)this.getModel().getValue("bizdate")) != null) {
            DynamicObjectCollection wc = tradebill.getDynamicObjectCollection("workcalendar");
            int settleDelay = tradebill.getInt("settledelay");
            Date dm = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)optDate, (int)settleDelay);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deliverydate", (Object)dm);
        }
    }

    private void setExecExrate(DynamicObject tradebill) {
        Date optDate = (Date)this.getModel().getValue("bizdate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execexrate", (Object)BusinessBillHelper.getExRateOption((DynamicObject)tradebill, (Date)optDate, (Date)deliveryDate));
    }

    private boolean isFromLifeCycleApply() {
        return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()) instanceof BillView && "tm_lifecycle_apply".equals(((BillView)this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())).getFormId()) || this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()) instanceof ListView && "tm_lifecycle_apply".equals(((ListView)this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())).getBillFormId());
    }

    public void calSettleAmount_ForexOptionForBusinessBill() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        BigDecimal amt = BusinessBillHelper.calSettleAmount_ForexOptionForBusinessBill((DynamicObject)tradebill, (DynamicObject)this.getModel().getDataEntity());
        this.getModel().setValue("settleamount", (Object)amt);
    }

    public void calPlAmt() {
        DynamicObject premiumCur;
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)plCurrency)) {
            return;
        }
        Long plId = plCurrency.getLong("id");
        BigDecimal premium = !plId.equals((premiumCur = tradebill.getDynamicObject("premiumcurrency")).getLong("id")) ? (BigDecimal)this.getModel().getValue("premium_pl") : tradebill.getBigDecimal("premium");
        BigDecimal settleAmount = (BigDecimal)this.getModel().getValue("settleamount");
        BigDecimal firstAmount = (BigDecimal)this.getModel().getValue("bizamt1");
        BigDecimal buyAmt = tradebill.getBigDecimal("amount");
        premium = premium.multiply(firstAmount).divide(buyAmt, 10, 4);
        String tradeDirect = tradebill.getString("tradedirect");
        if (TradeDirectionEnum.buy.getValue().equals(tradeDirect)) {
            premium = premium.negate();
        }
        BigDecimal pl = settleAmount.add(premium);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plamt", (Object)pl);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "premium_pl_exrate": 
            case "execexrate": {
                BigDecimal v = EmptyUtil.isNoEmpty((Object)value) ? new BigDecimal(String.valueOf(value)) : BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(v) < 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6570\u503c\u3002", (String)"BizBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{2000}));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }
}

