/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.BizRecordDescEnum;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;
import org.apache.commons.lang3.StringUtils;

public class ForexBSBizBillEdit
extends BizBillEdit
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrybiz");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getModel().setValue("restamt_src", this.getModel().getValue("restamt_biz", evt.getRow()));
        this.getModel().setValue("exrate_src", this.getModel().getValue("exrate_biz", evt.getRow()));
        this.getModel().setValue("date_src", this.getModel().getValue("date_biz", evt.getRow()));
        this.getModel().setValue("enddate_src", this.getModel().getValue("enddate_biz", evt.getRow()));
        this.getModel().setValue("bizdate_src", this.getModel().getValue("bizdate_biz", evt.getRow()));
        this.getModel().setValue("bizrecordid", this.getModel().getValue("record_biz", evt.getRow()));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initSwapDir();
        this.initBizRecord();
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue() && !this.isFromLifeCycleApply()) {
            this.buildDeliveryInfo();
        } else {
            this.loadDeliveryInfo();
        }
        this.autoCalcBizAmtIfNull();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long bizrecordid = (Long)this.getModel().getValue("bizrecordid");
        CardEntry grid = (CardEntry)this.getView().getControl("entrybiz");
        if (EmptyUtil.isEmpty((Long)bizrecordid)) {
            grid.selectCard(Integer.valueOf(0));
        } else {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrybiz");
            for (int i = 0; i < entrys.size(); ++i) {
                if (((DynamicObject)entrys.get(i)).getLong("record_biz") != bizrecordid.longValue()) continue;
                grid.selectCard(Integer.valueOf(i));
                break;
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ((StringUtils.equals((CharSequence)"submit", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"unsubmit", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"audit", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"unaudit", (CharSequence)formOperate.getOperateKey())) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        if (key.equals("bizamt_detail")) {
            BigDecimal limitAmt;
            if (EmptyUtil.isEmpty((Object)value)) {
                return;
            }
            int rowIndex = e.getRowIndex();
            BigDecimal restAmtSrc = (BigDecimal)this.getModel().getValue("restamt_src");
            BigDecimal newValue = new BigDecimal((String)value);
            if (rowIndex == 0) {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency_detail", 0);
                limitAmt = restAmtSrc.setScale(currency.getInt("amtprecision"), 4);
            } else {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency_detail", 1);
                BigDecimal exrateSrc = (BigDecimal)this.getModel().getValue("exrate_src");
                DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
                StringBuilder minValBulder = new StringBuilder();
                minValBulder.append("0.");
                for (int i = 0; i < currency.getInt("amtprecision") - 2; ++i) {
                    minValBulder.append("0");
                }
                minValBulder.append("1");
                String minValStr = minValBulder.toString();
                limitAmt = this.isSameFx(tradebill) ? restAmtSrc.multiply(exrateSrc).add(new BigDecimal(minValStr)) : restAmtSrc.divide(exrateSrc, currency.getInt("amtprecision"), 4).add(new BigDecimal(minValStr));
            }
            if (newValue.compareTo(limitAmt) > 0 || newValue.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u4e8e\u96f6\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u672a\u4ea4\u5272\u91d1\u989d\u7684\u6570\u503c\u3002", (String)"BizForexDeliveryBizAmtVerify", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("bizamt_detail", rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "bizamt_detail": {
                this.bizAmtChange(args.getChangeSet()[0].getRowIndex());
                break;
            }
            case "bizrecordid": {
                this.buildDeliveryInfo();
                break;
            }
            case "spotrate_dey": {
                this.spotRateChange();
            }
        }
    }

    private void autoCalcBizAmtIfNull() {
        if (this.getModel().getEntryEntity("entrydetail").size() != 2) {
            return;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("bizamt_detail", 0)) && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("bizamt_detail", 1))) {
            this.bizAmtChange(1);
        } else if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("bizamt_detail", 0)) && EmptyUtil.isEmpty((Object)this.getModel().getValue("bizamt_detail", 1))) {
            this.bizAmtChange(0);
        }
    }

    private void initBizRecord() {
        Map<Object, Object> srcBizBillMap;
        QFilter filter;
        boolean isAudit = false;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!TcBillStatusEnum.SAVE.getValue().equals(billStatus) || this.isFromLifeCycleApply() || TmcBotpHelper.getSourceBills((String)"tm_businessbill", (Object)this.getModel().getValue("id"), (String)"tm_lifecycle_apply", null) != null) {
            isAudit = true;
            Long bizRecordId = (Long)this.getModel().getValue("bizrecordid");
            filter = new QFilter("id", "=", (Object)bizRecordId);
        } else {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            filter = new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"));
            String swapDir = (String)this.getModel().getValue("swapdir");
            if (EmptyUtil.isNoEmpty((String)swapDir)) {
                QFilter filter_swap = new QFilter("swapdir", "=", (Object)swapDir);
                filter = filter.and(filter_swap);
            }
            filter = filter.and(new QFilter("restamt", "!=", (Object)0));
        }
        DynamicObject[] bizrecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)"id,bizdate,enddate,exrate,restamt,currency,desc,createtime,srcbizbill", (QFilter[])new QFilter[]{filter}, (String)"createtime");
        Object[] srcBizBillIds = Arrays.stream(bizrecords).map(oneRecord -> oneRecord.get("srcbizbill")).toArray();
        if (srcBizBillIds.length == 1 && (Long)srcBizBillIds[0] == 0L) {
            srcBizBillMap = Collections.EMPTY_MAP;
        } else {
            DynamicObjectCollection srcBizBillCol = QueryServiceHelper.query((String)"tm_businessbill", (String)"id,bizdate", (QFilter[])new QFilter("id", "in", (Object)srcBizBillIds).toArray());
            srcBizBillMap = srcBizBillCol.stream().collect(Collectors.toMap(o -> o.get("id"), o -> o.get("bizdate")));
        }
        this.getModel().deleteEntryData("entrybiz");
        this.getModel().batchCreateNewEntryRow("entrybiz", bizrecords.length);
        Long bizRecordId = (Long)this.getModel().getValue("bizrecordid");
        int selectRowIndex = 0;
        for (int i = 0; i < bizrecords.length; ++i) {
            DynamicObject oneRecord2 = bizrecords[i];
            Long tempId = oneRecord2.getLong("id");
            if (tempId.equals(bizRecordId)) {
                selectRowIndex = i;
            }
            this.getModel().setValue("record_biz", oneRecord2.get("id"), i);
            this.getModel().setValue("title_biz", (Object)BizRecordDescEnum.getName((String)oneRecord2.getString("desc")), i);
            this.getModel().setValue("date_biz", oneRecord2.get("bizdate"), i);
            this.getModel().setValue("enddate_biz", oneRecord2.get("enddate"), i);
            this.getModel().setValue("exrate_biz", oneRecord2.get("exrate"), i);
            this.getModel().setValue("restamt_biz", oneRecord2.get("restamt"), i);
            this.getModel().setValue("currency_biz", oneRecord2.get("currency"), i);
            if (srcBizBillMap.containsKey(oneRecord2.get("srcbizbill"))) {
                this.getModel().setValue("bizdate_biz", srcBizBillMap.get(oneRecord2.get("srcbizbill")), i);
            } else {
                this.getModel().setValue("bizdate_biz", ((DynamicObject)this.getModel().getValue("tradebill")).get("bizdate"), i);
            }
            if (EmptyUtil.isEmpty((Object)oneRecord2.get("enddate"))) {
                ((Label)this.getView().getControl("datelab")).setText(ResManager.loadKDString((String)"\u8c03\u6574\u4ea4\u5272\u65e5\uff1a", (String)"ForexBSBizBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                continue;
            }
            ((Label)this.getView().getControl("datelab")).setText(ResManager.loadKDString((String)"\u8c03\u6574\u4ea4\u5272\u65e5\u533a\u95f4\uff1a", (String)"ForexBSBizBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if (isAudit) {
            BigDecimal bizAmt1 = (BigDecimal)this.getModel().getValue("bizamt1");
            BigDecimal restAmt1 = (BigDecimal)this.getModel().getValue("restamt1");
            this.getModel().setValue("restamt_biz", (Object)bizAmt1.add(restAmt1), selectRowIndex);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizrecordid", (Object)this.getModel().getValue("record_biz", selectRowIndex));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"restamt_src", (Object)this.getModel().getValue("restamt_biz", selectRowIndex));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exrate_src", (Object)this.getModel().getValue("exrate_biz", selectRowIndex));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"date_src", (Object)this.getModel().getValue("date_biz", selectRowIndex));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate_src", (Object)this.getModel().getValue("enddate_biz", selectRowIndex));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate_src", (Object)this.getModel().getValue("bizdate_biz", selectRowIndex));
    }

    private boolean isFromLifeCycleApply() {
        return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()) instanceof BillView && "tm_lifecycle_apply".equals(((BillView)this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())).getFormId()) || this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()) instanceof ListView && "tm_lifecycle_apply".equals(((ListView)this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())).getBillFormId());
    }

    private void loadDeliveryInfo() {
        this.getModel().deleteEntryData("entrydetail");
        this.getModel().batchCreateNewEntryRow("entrydetail", 2);
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        String number = protectType.getString("number");
        String dir = tradebill.getString("tradedirect");
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
            String tradeType = tradebill.getString("tradetype");
            if (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType)) {
                this.getModel().setValue("direct_detail", (Object)"buy", 0);
                this.getModel().setValue("direct_detail", (Object)"sell", 1);
            } else {
                this.getModel().setValue("direct_detail", (Object)"sell", 0);
                this.getModel().setValue("direct_detail", (Object)"buy", 1);
            }
        } else if (TradeDirectionEnum.buy.getValue().equals(dir)) {
            this.getModel().setValue("direct_detail", (Object)"buy", 0);
            this.getModel().setValue("direct_detail", (Object)"sell", 1);
        } else {
            this.getModel().setValue("direct_detail", (Object)"sell", 0);
            this.getModel().setValue("direct_detail", (Object)"buy", 1);
        }
        String op = (String)this.getModel().getValue("operate");
        if (op.indexOf("_f") > 0) {
            if (TradeDirectionEnum.buy.getValue().equals(dir)) {
                this.getModel().setValue("direct_detail", (Object)"sell", 0);
                this.getModel().setValue("direct_detail", (Object)"buy", 1);
            } else {
                this.getModel().setValue("direct_detail", (Object)"buy", 0);
                this.getModel().setValue("direct_detail", (Object)"sell", 1);
            }
        }
        BigDecimal bizAmt1 = (BigDecimal)this.getModel().getValue("bizamt1");
        BigDecimal restAmt1 = (BigDecimal)this.getModel().getValue("restamt1");
        BigDecimal bizAmt2 = (BigDecimal)this.getModel().getValue("bizamt2");
        BigDecimal restAmt2 = (BigDecimal)this.getModel().getValue("restamt2");
        this.getModel().beginInit();
        this.getModel().setValue("currency_detail", (Object)tradebill.getDynamicObject("currency"), 0);
        this.getModel().setValue("bizamt_detail", (Object)bizAmt1, 0);
        this.getModel().setValue("restamt_detail", (Object)restAmt1, 0);
        this.getModel().setValue("currency_detail", (Object)tradebill.getDynamicObject("sellcurrency"), 1);
        this.getModel().setValue("bizamt_detail", (Object)bizAmt2, 1);
        this.getModel().setValue("restamt_detail", (Object)restAmt2, 1);
        this.getModel().endInit();
        this.getView().updateView("entrydetail");
    }

    private void buildDeliveryInfo() {
        this.getModel().deleteEntryData("entrydetail");
        this.getModel().batchCreateNewEntryRow("entrydetail", 2);
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        BigDecimal restamt_src = (BigDecimal)this.getModel().getValue("restamt_src");
        BigDecimal exrate_src = (BigDecimal)this.getModel().getValue("exrate_src");
        String op = (String)this.getModel().getValue("operate");
        if (BizOperateEnum.bdelivery.getValue().equals(op) || BizOperateEnum.bdelivery_f.getValue().equals(op) || BizOperateEnum.bdelivery_n.getValue().equals(op) || BizOperateEnum.defer.getValue().equals(op) || BizOperateEnum.maudate.getValue().equals(op) || BizOperateEnum.defer_f.getValue().equals(op) || BizOperateEnum.maudate_f.getValue().equals(op) || BizOperateEnum.defer_n.getValue().equals(op) || BizOperateEnum.maudate_n.getValue().equals(op)) {
            exrate_src = (BigDecimal)this.getModel().getValue("spotrate_dey");
        }
        BigDecimal bizAmt2 = this.isSameFx(tradebill) ? restamt_src.multiply(exrate_src) : (EmptyUtil.isEmpty((BigDecimal)exrate_src) ? BigDecimal.ZERO : restamt_src.divide(exrate_src, 10, 4));
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        String number = protectType.getString("number");
        String dir = tradebill.getString("tradedirect");
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
            String tradeType = tradebill.getString("tradetype");
            if (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType)) {
                this.getModel().setValue("direct_detail", (Object)"buy", 0);
                this.getModel().setValue("direct_detail", (Object)"sell", 1);
            } else {
                this.getModel().setValue("direct_detail", (Object)"sell", 0);
                this.getModel().setValue("direct_detail", (Object)"buy", 1);
            }
        } else if (TradeDirectionEnum.buy.getValue().equals(dir)) {
            this.getModel().setValue("direct_detail", (Object)"buy", 0);
            this.getModel().setValue("direct_detail", (Object)"sell", 1);
        } else {
            this.getModel().setValue("direct_detail", (Object)"sell", 0);
            this.getModel().setValue("direct_detail", (Object)"buy", 1);
        }
        if (op.indexOf("_f") > 0) {
            if (TradeDirectionEnum.buy.getValue().equals(dir)) {
                this.getModel().setValue("direct_detail", (Object)"sell", 0);
                this.getModel().setValue("direct_detail", (Object)"buy", 1);
            } else {
                this.getModel().setValue("direct_detail", (Object)"buy", 0);
                this.getModel().setValue("direct_detail", (Object)"sell", 1);
            }
        }
        this.getModel().beginInit();
        this.getModel().setValue("currency_detail", (Object)tradebill.getDynamicObject("currency"), 0);
        this.getModel().setValue("bizamt_detail", (Object)restamt_src, 0);
        this.getModel().setValue("currency_detail", (Object)tradebill.getDynamicObject("sellcurrency"), 1);
        this.getModel().setValue("bizamt_detail", (Object)bizAmt2, 1);
        this.getModel().endInit();
        this.getView().updateView("entrydetail");
        this.getModel().setValue("bizamt1", (Object)restamt_src);
        this.getModel().setValue("bizamt2", (Object)bizAmt2);
        this.getModel().setValue("restamt1", (Object)BigDecimal.ZERO);
        this.getModel().setValue("restamt2", (Object)BigDecimal.ZERO);
    }

    private void bizAmtChange(int rowIndex) {
        BigDecimal restAmt2;
        BigDecimal bizAmt2;
        BigDecimal restAmt1;
        BigDecimal bizAmt1;
        DynamicObject currency;
        BigDecimal exRateSrc;
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        BigDecimal exRate = exRateSrc = (BigDecimal)this.getModel().getValue("exrate_src");
        String op = (String)this.getModel().getValue("operate");
        if (BizOperateEnum.bdelivery.getValue().equals(op) || BizOperateEnum.bdelivery_f.getValue().equals(op) || BizOperateEnum.bdelivery_n.getValue().equals(op) || BizOperateEnum.defer.getValue().equals(op) || BizOperateEnum.maudate.getValue().equals(op) || BizOperateEnum.defer_f.getValue().equals(op) || BizOperateEnum.maudate_f.getValue().equals(op) || BizOperateEnum.defer_n.getValue().equals(op) || BizOperateEnum.maudate_n.getValue().equals(op)) {
            exRate = (BigDecimal)this.getModel().getValue("spotrate_dey");
        }
        BigDecimal restAmtSrc1 = (BigDecimal)this.getModel().getValue("restamt_src");
        if (rowIndex == 0) {
            currency = (DynamicObject)this.getModel().getValue("currency_detail", 1);
            int amtPrecision = currency.getInt("amtprecision");
            bizAmt1 = (BigDecimal)this.getModel().getValue("bizamt_detail", 0);
            restAmt1 = restAmtSrc1.subtract(bizAmt1);
            if (this.isSameFx(tradebill)) {
                bizAmt2 = bizAmt1.multiply(exRate);
                bizAmt2 = bizAmt2.setScale(amtPrecision, 4);
                restAmt2 = restAmt1.multiply(exRateSrc);
            } else {
                bizAmt2 = EmptyUtil.isEmpty((BigDecimal)exRate) ? BigDecimal.ZERO : bizAmt1.divide(exRate, 10, 4);
                bizAmt2 = bizAmt2.setScale(amtPrecision, 4);
                restAmt2 = EmptyUtil.isEmpty((BigDecimal)exRateSrc) ? BigDecimal.ZERO : restAmt1.divide(exRateSrc, 10, 4);
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizamt_detail", (Object)bizAmt2, (int)1);
        } else {
            currency = (DynamicObject)this.getModel().getValue("currency_detail", 0);
            int amtPrecision = currency.getInt("amtprecision");
            bizAmt2 = (BigDecimal)this.getModel().getValue("bizamt_detail", 1);
            if (this.isSameFx(tradebill)) {
                bizAmt1 = EmptyUtil.isEmpty((BigDecimal)exRate) ? BigDecimal.ZERO : bizAmt2.divide(exRate, 10, 4);
                bizAmt1 = bizAmt1.setScale(amtPrecision, 4);
                restAmt1 = restAmtSrc1.subtract(bizAmt1);
                restAmt2 = restAmt1.multiply(exRateSrc);
            } else {
                bizAmt1 = bizAmt2.multiply(exRate);
                bizAmt1 = bizAmt1.setScale(amtPrecision, 4);
                restAmt1 = restAmtSrc1.subtract(bizAmt1);
                restAmt2 = EmptyUtil.isEmpty((BigDecimal)exRateSrc) ? BigDecimal.ZERO : restAmt1.divide(exRateSrc, 10, 4);
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizamt_detail", (Object)bizAmt1, (int)0);
        }
        this.getModel().setValue("restamt_detail", (Object)restAmt1, 0);
        this.getModel().setValue("restamt_detail", (Object)restAmt2, 1);
        currency = (DynamicObject)this.getModel().getValue("currency_detail", 0);
        this.getModel().setValue("bizamt1", (Object)bizAmt1);
        this.getModel().setValue("restamt1", (Object)restAmt1.setScale(currency.getInt("amtprecision"), 4));
        this.getModel().setValue("bizamt2", (Object)bizAmt2);
        this.getModel().setValue("restamt2", (Object)restAmt2);
    }
}

