/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.DateEdit;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class ForexFlatBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_forex".equals(srcEntityType)) {
            this.init_Forex();
            this.initControl_Forex();
        }
        if ("tm_forex_forward".equals(srcEntityType)) {
            this.init_ForexFwd();
            this.initControl_ForexFwd();
        }
        if ("tm_forex_swaps".equals(srcEntityType)) {
            this.init_ForexSwap();
            this.initControl_ForexSwap();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        switch (propName) {
            case "execexrate": 
            case "bizamt1": {
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id")) || ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setPlAmt_ForexFwd();
                }
                if (!ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id"))) break;
                this.setPlAmt_Forex();
                break;
            }
            case "plamt": 
            case "baseexrate": {
                this.getModel().setValue("baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "bizdate": {
                Date opdate;
                if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id"))) {
                    this.setControl_BizDate_Forex();
                    this.setControl_SettleDate_Forex();
                    opdate = (Date)this.getModel().getValue("bizdate");
                    this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)opdate, (Date)tradebill.getDate("settledate"), (boolean)true));
                }
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.setControl_SettleDate_ForexFwd();
                    opdate = (Date)this.getModel().getValue("bizdate");
                    this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)opdate, (Date)this.getDeyDateSrc_ForexFwd(), (boolean)true));
                }
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setControl_BizDate_ForexSwap();
                    this.setControl_SettleDate_ForexSwap();
                    this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)((DynamicObject)this.getModel().getValue("tradebill")), (Date)((Date)this.getModel().getValue("bizdate")), (Date)((Date)this.getModel().getValue("date_src")), (boolean)BusinessBillHelper.isSwapNear((String)((String)this.getModel().getValue("operate")))));
                }
                this.getModel().setValue("plsettledate", this.getModel().getValue("bizdate"));
                break;
            }
            case "bizrecordid": {
                if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id"))) {
                    this.setDefault_Forex();
                    this.initControl_Forex();
                }
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setDefault_ForexSwap();
                    this.initControl_ForexSwap();
                }
                if (!ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) break;
                this.setDefault_ForexFwd();
                this.initControl_ForexFwd();
            }
        }
    }

    private void init_ForexFwd() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_ForexFwd();
        }
    }

    private void setDefault_ForexFwd() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date deydate = this.getDeyDateSrc_ForexFwd();
        Date curdate = TcDateUtils.getCurrentDate();
        if (this.isBetween(curdate, (Date)this.getModel().getValue("bizdate_src"), deydate, false)) {
            this.getModel().setValue("bizdate", (Object)curdate);
        } else {
            this.getModel().setValue("bizdate", null);
        }
        Date opdate = (Date)this.getModel().getValue("bizdate");
        this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)opdate, (Date)this.getDeyDateSrc_ForexFwd(), (boolean)true));
        this.getModel().setValue("plsettledate", (Object)opdate);
        if (DeliveryWayEnum.non_deliverable.getValue().equals(tradebill.get("deliveryway"))) {
            this.getModel().setValue("plcurrency", tradebill.get("settlecurrency"));
        } else {
            this.getModel().setValue("plcurrency", tradebill.get("sellcurrency"));
        }
        this.setPlAmt_ForexFwd();
        this.setBaseInfo_PL(tradebill);
    }

    private void setPlAmt_Forex() {
        BigDecimal execExrate = (BigDecimal)this.getModel().getValue("execexrate");
        BigDecimal spotExrate = (BigDecimal)this.getModel().getValue("exrate_src");
        BigDecimal plAmt = this.calPlAmtWithPlCurrency(execExrate, spotExrate);
        this.getModel().setValue("plamt", (Object)plAmt);
    }

    private void setPlAmt_ForexFwd() {
        BigDecimal execExrate = (BigDecimal)this.getModel().getValue("execexrate");
        BigDecimal fwdExrate = (BigDecimal)this.getModel().getValue("exrate_src");
        BigDecimal plAmt = this.calAmt_PL(execExrate, fwdExrate);
        String operate = (String)this.getModel().getValue("operate");
        if (BusinessBillHelper.isSwapFar((String)operate).booleanValue()) {
            plAmt = plAmt.negate();
        }
        plAmt = this.dealPlAmt_PlCurrencyNotSrc(plAmt);
        this.getModel().setValue("plamt", (Object)plAmt);
    }

    private void init_Forex() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_Forex();
        }
    }

    private void setDefault_Forex() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date settledate = tradebill.getDate("settledate");
        Date curDate = TcDateUtils.getCurrentDate();
        if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), settledate, false)) {
            this.getModel().setValue("bizdate", (Object)curDate);
        } else {
            this.getModel().setValue("bizdate", null);
        }
        Date opdate = (Date)this.getModel().getValue("bizdate");
        this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)opdate, (Date)tradebill.getDate("settledate"), (boolean)true));
        this.getModel().setValue("plsettledate", this.getModel().getValue("bizdate"));
        this.getModel().setValue("plcurrency", tradebill.get("sellcurrency"));
        this.setPlAmt_Forex();
        this.setBaseInfo_PL(tradebill);
    }

    private void initControl_Forex() {
        this.setControl_BizDate_Forex();
        this.setControl_SettleDate_Forex();
        this.initControl_PL();
    }

    private void setControl_BizDate_Forex() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date bizdate = (Date)this.getModel().getValue("bizdate_src");
        Date settledate = tradebill.getDate("settledate");
        DateEdit bizdateEdit = (DateEdit)this.getView().getControl("bizdate");
        bizdateEdit.setMinDate(bizdate);
        bizdateEdit.setMaxDate(settledate);
    }

    private void initControl_ForexFwd() {
        this.setControl_BizDate_ForexFwd();
        this.setControl_SettleDate_ForexFwd();
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexFwd() {
        Date usedDate = this.getDeyDateSrc_ForexFwd();
        DateEdit bizdateEdit = (DateEdit)this.getView().getControl("bizdate");
        bizdateEdit.setMinDate((Date)this.getModel().getValue("bizdate_src"));
        bizdateEdit.setMaxDate(usedDate);
    }

    private void setControl_SettleDate_ForexFwd() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        DateEdit settledateEdit = (DateEdit)this.getView().getControl("plsettledate");
        settledateEdit.setMinDate(bizdate);
    }

    private void init_ForexSwap() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_ForexSwap();
        }
    }

    private void setDefault_ForexSwap() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date settledate = tradebill.getDate("settledate");
        Date curDate = TcDateUtils.getCurrentDate();
        if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), settledate, false)) {
            this.getModel().setValue("bizdate", (Object)curDate);
        } else {
            this.getModel().setValue("bizdate", null);
        }
        Date opdate = (Date)this.getModel().getValue("bizdate");
        Date delveryDate = (Date)this.getModel().getValue("date_src");
        String operate = (String)this.getModel().getValue("operate");
        this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)opdate, (Date)delveryDate, (boolean)BusinessBillHelper.isSwapNear((String)operate)));
        this.getModel().setValue("plsettledate", (Object)opdate);
        this.getModel().setValue("plcurrency", tradebill.get("sellcurrency"));
        this.setPlAmt_ForexFwd();
        this.setBaseInfo_PL(tradebill);
    }

    private void initControl_ForexSwap() {
        this.setControl_BizDate_ForexSwap();
        this.setControl_SettleDate_ForexSwap();
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexSwap() {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bizdate");
        Date bizdate = (Date)this.getModel().getValue("bizdate_src");
        Date deydate = (Date)this.getModel().getValue("date_src");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(deydate);
    }

    private void setControl_SettleDate_Forex() {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("plsettledate");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        dateEdit.setMinDate(bizdate);
    }

    private void setControl_SettleDate_ForexSwap() {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("plsettledate");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        dateEdit.setMinDate(bizdate);
    }
}

