/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class ForexFwdDeferEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_forex_forward".equals(srcEntityType)) {
            this.initDefault_ForexFwd();
            this.initControl_ForexFwd();
        }
        if ("tm_forex_swaps".equals(srcEntityType)) {
            this.initDefault_ForexSwap();
            this.initControl_ForexSwap();
        }
    }

    private void initDefault_ForexSwap() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_ForexSwap();
        }
    }

    private void setDefault_ForexSwap() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exratecalmtd", (Object)ExRateCalMethodEnum.SrcPlusSwapPips);
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date curDate = TcDateUtils.getCurrentDate();
        Date date_src = (Date)this.getModel().getValue("date_src");
        if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), date_src, false)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", (Object)curDate);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", null);
        }
        this.getModel().setValue("spotrate_dey", this.getModel().getValue("exrate_src"));
        this.setAmt_PL();
        this.setBaseInfo_PL(tradebill);
    }

    private void initControl_ForexSwap() {
        this.setControl_BizDate_ForexSwap();
        this.setControl_ExpiredDate_ForexSwap();
        this.setControl_SettleDate_ForexSwap();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdaterange"});
        this.setExexExRateTitle();
        ComboEdit comboEdit = (ComboEdit)this.getControl("exratecalmtd");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.SrcPlusSwapPips.getName()), ExRateCalMethodEnum.SrcPlusSwapPips.getValue()));
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.RatePlusFwdPips.getName()), ExRateCalMethodEnum.RatePlusFwdPips.getValue()));
        comboEdit.setComboItems(data);
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexSwap() {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bizdate");
        Date bizdate = (Date)this.getModel().getValue("bizdate_src");
        Date srcdate = (Date)this.getModel().getValue("date_src");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(srcdate);
    }

    private void setControl_ExpiredDate_ForexSwap() {
        Date deydate = (Date)this.getModel().getValue("date_src");
        Date mindate = TcDateUtils.getNextDay((Date)deydate, (int)1);
        DateEdit dateEdit = (DateEdit)this.getView().getControl("expireddate");
        dateEdit.setMinDate(mindate);
    }

    private void setControl_SettleDate_ForexFwd() {
        Date opdate = (Date)this.getModel().getValue("bizdate");
        Date deydate = this.getModel().getValue("enddate_src") != null ? (Date)this.getModel().getValue("enddate_src") : (Date)this.getModel().getValue("date_src");
        DateEdit settleDateEdit = (DateEdit)this.getView().getControl("plsettledate");
        settleDateEdit.setMinDate(opdate);
        settleDateEdit.setMaxDate(deydate);
    }

    private void setControl_SettleDate_ForexSwap() {
        Date opdate = (Date)this.getModel().getValue("bizdate");
        Date deydate = (Date)this.getModel().getValue("date_src");
        DateEdit settleDateEdit = (DateEdit)this.getView().getControl("plsettledate");
        settleDateEdit.setMinDate(opdate);
        settleDateEdit.setMaxDate(deydate);
    }

    private void setExexExRateTitle() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        DecimalEdit exrateEdit = (DecimalEdit)this.getView().getControl("execexrate");
        if (ExRateCalMethodEnum.SrcPlusSwapPips.getValue().equals(exrateCalMtd)) {
            exrateEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53c2\u8003\u5c55\u671f\u6c47\u7387", (String)"ForexFwdDeferEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            exrateEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e73\u4ed3\u8fdc\u671f\u6c47\u7387", (String)"FlatFwdExrate", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fp_pnl"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fp_pnl"});
            this.getModel().setValue("plsettledate", null);
            this.getModel().setValue("plamt", null);
            this.getModel().setValue("baseplamt", null);
            this.getModel().setValue("baseexrate", null);
        }
    }

    private void initControl_ForexFwd() {
        this.setControl_BizDate_ForexFwd();
        this.setControl_ExpiredDate_ForexFwd();
        this.setControl_SettleDate_ForexFwd();
        this.setExexExRateTitle();
        ComboEdit comboEdit = (ComboEdit)this.getControl("exratecalmtd");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.SrcPlusSwapPips.getName()), ExRateCalMethodEnum.SrcPlusSwapPips.getValue()));
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.RatePlusFwdPips.getName()), ExRateCalMethodEnum.RatePlusFwdPips.getValue()));
        comboEdit.setComboItems(data);
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexFwd() {
        Date usedDate = this.getDeyDateSrc_ForexFwd();
        DateEdit bizdateEdit = (DateEdit)this.getView().getControl("bizdate");
        bizdateEdit.setMinDate((Date)this.getModel().getValue("bizdate_src"));
        bizdateEdit.setMaxDate(usedDate);
    }

    private void initDefault_ForexFwd() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_ForexFwd();
        }
    }

    private void setDefault_ForexFwd() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exratecalmtd", (Object)ExRateCalMethodEnum.SrcPlusSwapPips);
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date deydate = this.getDeyDateSrc_ForexFwd();
        Date curdate = TcDateUtils.getCurrentDate();
        if (this.isBetween(curdate, (Date)this.getModel().getValue("bizdate_src"), deydate, false)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", (Object)curdate);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", null);
        }
        this.getModel().setValue("spotrate_dey", this.getModel().getValue("exrate_src"));
        this.setAmt_PL();
        this.setBaseInfo_PL(tradebill);
    }

    private void setViewSettleDate() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"plsettledate"});
        }
        if (ExRateCalMethodEnum.SrcPlusSwapPips.getValue().equals(exrateCalMtd)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"plsettledate"});
        }
    }

    private void setExecExrateByDate() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            String operate = (String)this.getModel().getValue("operate");
            BigDecimal exRate = BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, (Date)this.getDeyDateSrc_ForexFwd(), (BusinessBillHelper.isSwapFar((String)operate) == false ? 1 : 0) != 0);
            this.getModel().setValue("execexrate", (Object)exRate);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execexrate", (Object)BigDecimal.ZERO);
        }
    }

    private void setDeferExrateByDate() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        String operate = (String)this.getModel().getValue("operate");
        BigDecimal deferExrate = BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, (Date)this.getDeyDate_ForexFwd(), (boolean)BusinessBillHelper.isSwapFar((String)operate));
        this.getModel().setValue("spotrate_dey", (Object)deferExrate);
    }

    private void setPipsByExRate() {
        BigDecimal deferExrate;
        String exRateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.SrcPlusSwapPips.getValue().equals(exRateCalMtd)) {
            BigDecimal fwdRate = (BigDecimal)this.getModel().getValue("exrate_src");
            deferExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)deferExrate.subtract(fwdRate).multiply(Constants.TEN_THOUSAND));
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exRateCalMtd)) {
            BigDecimal execExrate = (BigDecimal)this.getModel().getValue("execexrate");
            deferExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)deferExrate.subtract(execExrate).multiply(Constants.TEN_THOUSAND));
        }
    }

    private void setAmt_PL() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (EmptyUtil.isEmpty((String)exrateCalMtd)) {
            return;
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            BigDecimal execExrate = (BigDecimal)this.getModel().getValue("execexrate");
            BigDecimal fwdExrate = (BigDecimal)this.getModel().getValue("exrate_src");
            BigDecimal plAmt = this.calAmt_PL(execExrate, fwdExrate);
            String operate = (String)this.getModel().getValue("operate");
            if (BusinessBillHelper.isSwapFar((String)operate).booleanValue()) {
                plAmt = plAmt.negate();
            }
            plAmt = this.dealPlAmt_PlCurrencyNotSrc(plAmt);
            this.getModel().setValue("plamt", (Object)plAmt);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        switch (propName) {
            case "bizamt1": {
                this.setAmt_PL();
                break;
            }
            case "plamt": 
            case "baseexrate": {
                this.getModel().setValue("baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "spotrate_dey": 
            case "exrate_src": 
            case "execexrate": {
                this.setAmt_PL();
                this.setPipsByExRate();
                break;
            }
            case "exratecalmtd": {
                this.setPlCurrency(tradebill);
                this.setExexExRateTitle();
                this.setDeferExrateByDate();
                this.setExecExrateByDate();
                this.setPipsByExRate();
                this.setViewSettleDate();
                if (!ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(this.getModel().getValue("exratecalmtd"))) break;
                this.getModel().setValue("plsettledate", this.getModel().getValue("bizdate"));
                this.setBaseexratePl();
                break;
            }
            case "pips": {
                this.pipsChangedEvt();
                this.spotRateChange();
                this.setAmt_PL();
                break;
            }
            case "expireddate": {
                this.setAdjDate(propName, "deliverydate");
                break;
            }
            case "expired_start": {
                this.setAdjDate(propName, "deydate_start");
                break;
            }
            case "expired_end": {
                this.setAdjDate(propName, "deydate_end");
                break;
            }
            case "bizdate": {
                if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(this.getModel().getValue("exratecalmtd"))) {
                    this.getModel().setValue("plsettledate", this.getModel().getValue("bizdate"));
                }
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setControl_ExpiredDate_ForexSwap();
                    this.setControl_SettleDate_ForexSwap();
                }
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.setControl_ExpiredDate_ForexFwd();
                    this.setControl_SettleDate_ForexFwd();
                }
                this.setDeferExrateByDate();
                this.setExecExrateByDate();
                this.clearDeliveryDate();
                break;
            }
            case "deliverydate": {
                if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) break;
                this.setDeferExrateByDate();
                break;
            }
            case "deydate_end": {
                if (!((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) break;
                this.setDeferExrateByDate();
                break;
            }
            case "bizrecordid": {
                this.clear();
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setDefault_ForexSwap();
                    this.initControl_ForexSwap();
                }
                if (!ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) break;
                this.setDefault_ForexFwd();
                this.initControl_ForexFwd();
                break;
            }
            case "date_src": {
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setControl_BizDate_ForexSwap();
                    this.setControl_ExpiredDate_ForexSwap();
                }
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.setControl_BizDate_ForexFwd();
                    this.setControl_ExpiredDate_ForexFwd();
                }
                this.setExecExrateByDate();
                break;
            }
            case "isdaterange": {
                this.setControl_ExpiredDate_ForexFwd();
                if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) {
                    this.getModel().setValue("expireddate", null);
                    break;
                }
                this.getModel().setValue("expired_start", null);
                this.getModel().setValue("expired_end", null);
            }
        }
    }

    private void clearDeliveryDate() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expireddate", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expired_start", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expired_end", null);
        this.getView().updateView("expiredrange");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deliverydate", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deydate_start", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deydate_end", null);
        this.getView().updateView("deliveryrange");
    }

    private void clear() {
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>(8);
        paramMap.put("expireddate", null);
        paramMap.put("expired_start", null);
        paramMap.put("expired_end", null);
        paramMap.put("deliverydate", null);
        paramMap.put("deydate_start", null);
        paramMap.put("deydate_end", null);
        paramMap.put("plsettledate", null);
        paramMap.put("execexrate", BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), paramMap);
        this.getView().updateView("expiredrange");
        this.getView().updateView("deliveryrange");
    }

    private void pipsChangedEvt() {
        BigDecimal pips;
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.SrcPlusSwapPips.getValue().equals(exrateCalMtd)) {
            BigDecimal fwdExrate = (BigDecimal)this.getModel().getValue("exrate_src");
            pips = (BigDecimal)this.getModel().getValue("pips");
            BigDecimal deferExrate = fwdExrate.add(pips.divide(Constants.TEN_THOUSAND, 10, 4));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotrate_dey", (Object)deferExrate);
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            BigDecimal deferExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            pips = (BigDecimal)this.getModel().getValue("pips");
            BigDecimal execExrate = deferExrate.subtract(pips.divide(Constants.TEN_THOUSAND, 10, 4));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execexrate", (Object)execExrate);
        }
    }

    private void setPlCurrency(DynamicObject tradebill) {
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(this.getModel().getValue("exratecalmtd"))) {
            if (DeliveryWayEnum.non_deliverable.getValue().equals(tradebill.get("deliveryway"))) {
                this.getModel().setValue("plcurrency", tradebill.get("settlecurrency"));
            } else {
                this.getModel().setValue("plcurrency", tradebill.get("sellcurrency"));
            }
        } else {
            this.getModel().setValue("plcurrency", null);
        }
    }

    private void setAdjDate(String dateProp, String adjDateProp) {
        Date expiredDate = (Date)this.getModel().getValue(dateProp);
        if (EmptyUtil.isNoEmpty((Object)expiredDate)) {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObjectCollection wc = tradeBill.getDynamicObjectCollection("workcalendar");
            String adjMethod = tradeBill.getString("dateadjustmethod");
            Date deliveryDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)expiredDate, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)adjMethod));
            this.getModel().setValue(adjDateProp, (Object)deliveryDate);
        } else {
            this.getModel().setValue(adjDateProp, null);
        }
    }

    private void setControl_ExpiredDate_ForexFwd() {
        Date deydate = (Date)this.getModel().getValue("date_src");
        Date mindate = TcDateUtils.getNextDay((Date)deydate, (int)1);
        boolean isDateRange = (Boolean)this.getModel().getValue("isdaterange");
        if (isDateRange) {
            DateRangeEdit edit = (DateRangeEdit)this.getView().getControl("expiredrange");
            edit.setMinDate(mindate);
        } else {
            DateEdit edit = (DateEdit)this.getView().getControl("expireddate");
            edit.setMinDate(mindate);
        }
    }

    private void setBaseexratePl() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject priceRule = BusinessDataServiceHelper.loadSingle((Object)tradebill.getDynamicObject("pricerule").get("id"), (String)tradebill.getDynamicObject("pricerule").getDataEntityType().getName());
        Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
        String fxQuote = (String)this.getModel().getValue("basefq");
        if (EmptyUtil.isNoEmpty((String)fxQuote)) {
            ForexQuoteInfo fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, (Date)((Date)this.getModel().getValue("bizdate")), null);
            DynamicObject currencyPl = (DynamicObject)this.getModel().getValue("plcurrency");
            if (currencyPl != null) {
                if (fxInfo.getFxquote().startsWith(currencyPl.getString("number"))) {
                    this.getModel().setValue("baseexrate", (Object)fxInfo.getBuyPrice());
                } else {
                    this.getModel().setValue("baseexrate", (Object)fxInfo.getSellPrice());
                }
            }
        }
    }
}

