/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.common.helper.PlHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class GiveupBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init_ForexOptions();
        this.initControl_ForexOptions();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        switch (propName) {
            case "bizdate": {
                this.setExecExrate(tradebill);
                Map result = PlHelper.calPlAmt_GiveUp_ForexOptionForBusinessBill((DynamicObject)tradebill, (DynamicObject)this.getModel().getDataEntity());
                for (Map.Entry e : result.entrySet()) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)e.getKey()), e.getValue());
                }
                this.setBaseInfo_PL(tradebill);
                break;
            }
            case "bizamt1": 
            case "premium_pl": {
                this.calPlAmt();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "premium_pl_exrate": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl", (Object)BusinessBillHelper.calPremium_PL((DynamicObject)this.getModel().getDataEntity()));
                this.calPlAmt();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "plamt": 
            case "baseexrate": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "plcurrency": {
                Map result = PlHelper.calPlAmt_GiveUp_ForexOptionForBusinessBill((DynamicObject)tradebill, (DynamicObject)this.getModel().getDataEntity());
                for (Map.Entry e : result.entrySet()) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)e.getKey()), e.getValue());
                }
                this.setBaseInfo_PL(tradebill);
            }
        }
    }

    private void init_ForexOptions() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject premCurrency = tradebill.getDynamicObject("premiumcurrency");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premcurrency_src", (Object)premCurrency);
            BigDecimal premium = tradebill.getBigDecimal("premium");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_src", (Object)premium);
            DynamicObject settleCurrency = tradebill.getDynamicObject("settlecurrency");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settlecurrency", (Object)settleCurrency);
            Date expireDate = tradebill.getDate("adjexpiredate");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expireddate", (Object)expireDate);
            Date curDate = TcDateUtils.getCurrentDate();
            Date bizdate = tradebill.getDate("bizdate");
            if (!curDate.before(bizdate) && !curDate.after(expireDate)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", (Object)curDate);
            }
            this.setExecExrate(tradebill);
            DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"plcurrency", (QFilter[])new QFilter[]{new QFilter("tradebill", "=", (Object)tradebill.getLong("id"))});
            if (DeliveryWayEnum.non_deliverable.getValue().equals(tradebill.getString("deliveryway"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plcurrency", (Object)tradebill.getDynamicObject("settlecurrency"));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plcurrency", (Object)tradebill.get("sellcurrency"));
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reccurrency", (Object)plInfo.getDynamicObject("plcurrency"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paycurrency", (Object)plInfo.getDynamicObject("plcurrency"));
            Map result = PlHelper.calPlAmt_GiveUp_ForexOptionForBusinessBill((DynamicObject)tradebill, (DynamicObject)this.getModel().getDataEntity());
            for (Map.Entry e : result.entrySet()) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)e.getKey()), e.getValue());
            }
            this.setBaseInfo_PL(tradebill);
        }
    }

    private void initControl_ForexOptions() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        this.setControl_BizDate_ForexOptions(tradebill);
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexOptions(DynamicObject tradebill) {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bizdate");
        Date bizdate = tradebill.getDate("bizdate");
        Date expireDate = tradebill.getDate("adjexpiredate");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(expireDate);
    }

    private void setExecExrate(DynamicObject tradebill) {
        Date optDate = (Date)this.getModel().getValue("bizdate");
        Date adjustSettleDate = tradebill.getDate("adjustsettledate");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execexrate", (Object)BusinessBillHelper.getExRateOption((DynamicObject)tradebill, (Date)optDate, (Date)adjustSettleDate));
    }

    private void calPlAmt() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)plCurrency)) {
            return;
        }
        Long plId = plCurrency.getLong("id");
        DynamicObject premiumCur = tradebill.getDynamicObject("premiumcurrency");
        String tradeDirect = tradebill.getString("tradedirect");
        BigDecimal premium = !plId.equals(premiumCur.getLong("id")) ? (BigDecimal)this.getModel().getValue("premium_pl") : tradebill.getBigDecimal("premium");
        BigDecimal firstAmount = (BigDecimal)this.getModel().getValue("bizamt1");
        BigDecimal buyAmt = tradebill.getBigDecimal("amount");
        BigDecimal pl = premium.multiply(firstAmount).divide(buyAmt, 10, 4);
        if (TradeDirectionEnum.buy.getValue().equals(tradeDirect)) {
            pl = pl.negate();
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plamt", (Object)pl);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "premium_pl_exrate": 
            case "execexrate": {
                BigDecimal v = EmptyUtil.isNoEmpty((Object)value) ? new BigDecimal(String.valueOf(value)) : BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(v) < 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6570\u503c\u3002", (String)"BizBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{2000}));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }
}

