/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class PayForwRateAgreeBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_forwrateagree".equals(srcEntityType)) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject bill = TmcDataServiceHelper.loadSingle((String)"tm_forwrateagree", (String)"org,payrule,pricerule,startdate,currency,amount,basis,market,tradedirect,adjustsettledate,adjustenddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getLong("id"))});
            this.initBizEntry_forwRateAgree(bill);
            this.initPay_ForwRateAgree(bill);
            this.setControlBizDate(bill);
        }
        this.getModel().setDataChanged(false);
    }

    protected void initBizEntry_forwRateAgree(DynamicObject tradebill) {
        DynamicObjectCollection entrys;
        DynamicObject cashflowCol = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"entrys.cffixrate,entrys.cfperioddays", (QFilter[])new QFilter[]{new QFilter("billid", "=", tradebill.getPkValue())});
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id,exrate", (QFilter[])new QFilter[]{new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"))});
        if (EmptyUtil.isNoEmpty((DynamicObject)cashflowCol) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(entrys = cashflowCol.getDynamicObjectCollection("entrys")))) {
            DynamicObject cashflowEntry = (DynamicObject)entrys.get(0);
            int cfperioddays = cashflowEntry.getInt("cfperioddays");
            BigDecimal cffixrate = cashflowEntry.getBigDecimal("cffixrate");
            this.getModel().setValue("period_pay", (Object)cfperioddays);
            this.getModel().setValue("fixedrate_pay", (Object)cffixrate);
        }
        DynamicObjectCollection lifeCycleCards = this.getModel().getEntryEntity("entrybiz");
        lifeCycleCards.clear();
        DynamicObject lifeCycleCard = lifeCycleCards.addNew();
        lifeCycleCard.set("title_biz", (Object)ResManager.loadKDString((String)"\u539f\u5408\u7ea6", (String)"BizBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        lifeCycleCard.set("date_biz", (Object)tradebill.getDate("adjustsettledate"));
        lifeCycleCard.set("restamt_biz", tradebill.get("amount"));
        lifeCycleCard.set("currency_biz", tradebill.get("currency"));
        lifeCycleCard.set("exrate_biz", bizRecord.get("exrate"));
        lifeCycleCard.set("record_biz", (Object)bizRecord.getLong("id"));
        this.getModel().setValue("bizrecordid", (Object)bizRecord.getLong("id"));
    }

    private void setControlBizDate(DynamicObject tradebill) {
        DateEdit edit = (DateEdit)this.getView().getControl("bizdate");
        edit.setMinDate(tradebill.getDate("startdate"));
        edit.setMaxDate(tradebill.getDate("adjustenddate"));
    }

    private void initPay_ForwRateAgree(DynamicObject tradebill) {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            Date curDate = TcDateUtils.getCurrentDate();
            this.getModel().setValue("operate", (Object)BizOperateEnum.interestpay.getValue());
            if (curDate.before(tradebill.getDate("startdate")) || curDate.after(tradebill.getDate("adjustenddate"))) {
                this.getModel().setValue("bizdate", null);
            } else {
                this.getModel().setValue("bizdate", (Object)curDate);
            }
            DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id,exrate", (QFilter[])new QFilter[]{new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"))});
            DynamicObject cashflowCol = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"cfpaydate,entrys.cffixrate", (QFilter[])new QFilter[]{new QFilter("billid", "=", tradebill.getPkValue())});
            this.getModel().setValue("plsettledate", cashflowCol.get("cfpaydate"));
            String cfdirection = tradebill.getString("tradedirect");
            BigDecimal cffixrate = BigDecimal.ZERO;
            BigDecimal exrate = bizRecord.getBigDecimal("exrate");
            String directDetail = "";
            DynamicObjectCollection entrys = cashflowCol.getDynamicObjectCollection("entrys");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                DynamicObject cashflowEntry = (DynamicObject)entrys.get(0);
                cffixrate = cashflowEntry.getBigDecimal("cffixrate");
            }
            directDetail = this.getDirection(cfdirection, cffixrate, exrate);
            BigDecimal bizamtDetail = this.calAmtDetail(tradebill, false);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrydetail");
            DynamicObject dynamicObject = entryEntity.addNew();
            dynamicObject.set("direct_detail", (Object)directDetail);
            dynamicObject.set("currency_detail", tradebill.get("currency"));
            dynamicObject.set("bizamt_detail", (Object)bizamtDetail.abs());
            if ("pay".equals(directDetail)) {
                bizamtDetail = bizamtDetail.abs().negate();
            } else if ("rec".equals(directDetail)) {
                bizamtDetail = bizamtDetail.abs();
            }
            this.getModel().setValue("settleamount", (Object)bizamtDetail);
            this.setPL(tradebill);
        } else {
            this.loadEntryDetail(tradebill);
        }
    }

    private String getDirection(String cfdirection, BigDecimal cffixrate, BigDecimal exrate) {
        if (TradeDirectionEnum.buy.getValue().equals(cfdirection) && cffixrate.compareTo(exrate) >= 0 || TradeDirectionEnum.sell.getValue().equals(cfdirection) && cffixrate.compareTo(exrate) <= 0) {
            return "rec";
        }
        return "pay";
    }

    private BigDecimal calAmtDetail(DynamicObject tradebill, boolean isChange) {
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id,exrate", (QFilter[])new QFilter[]{new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"))});
        DynamicObject cashflowCol = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"cfpaydate,entrys.cffixrate,entrys.cfperioddays", (QFilter[])new QFilter[]{new QFilter("billid", "=", tradebill.getPkValue())});
        this.getModel().setValue("plsettledate", cashflowCol.get("cfpaydate"));
        BigDecimal cffixrate = BigDecimal.ZERO;
        BigDecimal exrate = bizRecord.getBigDecimal("exrate");
        int cfperioddays = 0;
        BigDecimal amount = tradebill.getBigDecimal("amount");
        DynamicObjectCollection entrys = cashflowCol.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            DynamicObject cashflowEntry = (DynamicObject)entrys.get(0);
            cffixrate = cashflowEntry.getBigDecimal("cffixrate");
            cfperioddays = cashflowEntry.getInt("cfperioddays");
        }
        int basis = TradeBusinessHelper.getBasis_YearDay((int)0, (BasisEnum)BasisEnum.getEnum((String)tradebill.getString("basis")));
        if (isChange) {
            cffixrate = (BigDecimal)this.getModel().getValue("fixedrate_pay");
        }
        BigDecimal periodDaysDivYrbasis = BigDecimal.valueOf(cfperioddays).divide(BigDecimal.valueOf(basis), 6, 4);
        BigDecimal amtDetail = cffixrate.subtract(exrate).multiply(amount).divide(Constants.ONE_HUNDRED).multiply(periodDaysDivYrbasis);
        String payrule = tradebill.getString("payrule");
        if ("advance".equals(payrule)) {
            return cffixrate.subtract(exrate).multiply(amount).divide(Constants.ONE_HUNDRED).multiply(periodDaysDivYrbasis).divide(cffixrate.divide(Constants.ONE_HUNDRED).multiply(periodDaysDivYrbasis).add(BigDecimal.ONE), 10, RoundingMode.HALF_UP);
        }
        return amtDetail;
    }

    private void setPL(DynamicObject tradebill) {
        BigDecimal bizamt = this.calAmtPL();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plamt", (Object)bizamt);
        DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"plcurrency", (QFilter[])new QFilter[]{new QFilter("tradebill", "=", (Object)tradebill.getLong("id"))});
        DynamicObject plcurrency = plInfo.getDynamicObject("plcurrency");
        this.getModel().setValue("plcurrency", (Object)plcurrency);
        this.getModel().setValue("settlecurrency", (Object)plcurrency);
        this.setBaseInfo_PL(tradebill);
    }

    private BigDecimal calAmtPL() {
        DynamicObjectCollection entryDetail = this.getModel().getEntryEntity("entrydetail");
        DynamicObject detail = (DynamicObject)entryDetail.get(0);
        BigDecimal bizamt = detail.getBigDecimal("bizamt_detail");
        String direct = detail.getString("direct_detail");
        bizamt = "pay".equals(direct) ? bizamt.abs().negate() : bizamt.abs();
        return bizamt;
    }

    private void loadEntryDetail(DynamicObject tradebill) {
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id,exrate", (QFilter[])new QFilter[]{new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"))});
        DynamicObject cashflowCol = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"cfpaydate,entrys.cffixrate", (QFilter[])new QFilter[]{new QFilter("billid", "=", tradebill.getPkValue())});
        this.getModel().setValue("plsettledate", cashflowCol.get("cfpaydate"));
        String cfdirection = tradebill.getString("tradedirect");
        BigDecimal cffixrate = BigDecimal.ZERO;
        BigDecimal exrate = bizRecord.getBigDecimal("exrate");
        String directDetail = "";
        DynamicObjectCollection entrys = cashflowCol.getDynamicObjectCollection("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            DynamicObject cashflowEntry = (DynamicObject)entrys.get(0);
            cffixrate = cashflowEntry.getBigDecimal("cffixrate");
        }
        directDetail = this.getDirection(cfdirection, cffixrate, exrate);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrydetail");
        DynamicObject dynamicObject = entryEntity.addNew();
        dynamicObject.set("direct_detail", (Object)directDetail);
        dynamicObject.set("currency_detail", tradebill.get("currency"));
        dynamicObject.set("bizamt_detail", (Object)((BigDecimal)this.getModel().getValue("plamt")).abs());
        if ("pay".equals(directDetail)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelpay"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelrec"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelpay"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry grid = (CardEntry)this.getView().getControl("entrybiz");
        grid.selectCard(Integer.valueOf(0));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        tradebill = TmcDataServiceHelper.loadSingle((String)"tm_forwrateagree", (String)"org,pricerule,startdate,currency,amount,basis,market,tradedirect,adjustsettledate,adjustenddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getLong("id"))});
        switch (propName) {
            case "fixedrate_pay": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrydetail");
                if (entryEntity.size() <= 0) break;
                this.getModel().setValue("bizamt_detail", (Object)this.calAmtDetail(tradebill, true), 0);
                BigDecimal amt = this.calAmtPL();
                this.getModel().setValue("plamt", (Object)amt);
                this.getModel().setValue("settleamount", (Object)amt);
                this.setBaseInfo_PL(tradebill);
                break;
            }
            case "bizamt_detail": {
                BigDecimal amt = this.calAmtPL();
                this.getModel().setValue("plamt", (Object)amt);
                this.getModel().setValue("settleamount", (Object)amt);
                this.setBaseInfo_PL(tradebill);
                break;
            }
            case "bizdate": {
                this.setControlSettledatepl(tradebill);
                this.setBaseInfo_PL(tradebill);
                break;
            }
            case "plamt": {
                this.getModel().setValue("baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "baseexrate": {
                this.getModel().setValue("baseplamt", (Object)this.calBaseAmt_PL());
            }
        }
    }

    private void setControlSettledatepl(DynamicObject tradebill) {
        Date adjustenddate = tradebill.getDate("adjustenddate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        Date plsettledate = (Date)this.getModel().getValue("plsettledate");
        DateEdit settledatepl = (DateEdit)this.getControl("plsettledate");
        settledatepl.setMinDate(bizDate);
        settledatepl.setMaxDate(adjustenddate);
        if (plsettledate != null && (plsettledate.before(bizDate) || plsettledate.after(adjustenddate))) {
            this.getModel().setValue("plsettledate", null);
        }
    }
}

