/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.PlConfirmStatusEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.common.helper.PlHelper;
import org.apache.commons.lang3.StringUtils;

public class PlConfirmEdit
extends AbstractTmcBillEdit {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ((StringUtils.equals((CharSequence)"plconfirm", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"unplconfirm", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"settle", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"unsettle", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"audit", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"unaudit", (CharSequence)formOperate.getOperateKey())) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Boolean isPlConfim;
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        if (propName.equals("exratecalmtd")) {
            if (BusinessBillHelper.cannotPlConfirm((DynamicObject)this.getModel().getDataEntity()).booleanValue()) {
                this.getModel().setValue("isplconfirm", (Object)Boolean.FALSE);
                this.getModel().setValue("plconfirmstatus", (Object)PlConfirmStatusEnum.None.getValue());
            } else {
                isPlConfim = (Boolean)this.getModel().getValue("isplconfirm");
                this.getModel().setValue("plconfirmstatus", (Object)(isPlConfim != false ? PlConfirmStatusEnum.Confirmed.getValue() : PlConfirmStatusEnum.ToBeConfirmed.getValue()));
            }
        }
        if (propName.equals("isplconfirm")) {
            isPlConfim = (Boolean)this.getModel().getValue("isplconfirm");
            this.getModel().setValue("plconfirmstatus", (Object)(isPlConfim != false ? PlConfirmStatusEnum.Confirmed.getValue() : PlConfirmStatusEnum.ToBeConfirmed.getValue()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            if (BusinessBillHelper.cannotPlConfirm((DynamicObject)this.getModel().getDataEntity()).booleanValue()) {
                this.getModel().setValue("isplconfirm", (Object)Boolean.FALSE);
                this.getModel().setValue("plconfirmstatus", (Object)PlConfirmStatusEnum.None.getValue());
                this.getModel().setDataChanged(false);
            } else {
                Boolean isPlConfim = (Boolean)this.getModel().getValue("isplconfirm");
                this.getModel().setValue("plconfirmstatus", (Object)(isPlConfim != false ? PlConfirmStatusEnum.Confirmed.getValue() : PlConfirmStatusEnum.ToBeConfirmed.getValue()));
            }
        }
        this.enableControl();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("settle".equals(operateKey) && this.getModel().getDataChanged()) {
            op.getOption().setVariableValue("DataChangedBeforeSettle", "true");
        }
    }

    protected void enableControl() {
        String entityType;
        String billStatus = this.getBillStatus();
        Boolean defaultSet = EmptyUtil.isEmpty((String)billStatus) || TcBillStatusEnum.SAVE.getValue().equals(billStatus) || TcBillStatusEnum.SUBMIT.getValue().equals(billStatus);
        this.getView().setEnable(defaultSet, new String[]{"execexrate", "plamt", "settleamount", "baseexrate", "baseplamt"});
        this.getView().setEnable(defaultSet, new String[]{"entrydetail", "fs_baseinfo", "panelrec", "panelpay", "isplconfirm", "plsettledate", "deliverydate"});
        this.getView().setVisible(defaultSet, new String[]{"bar_del", "bar_save", "bar_modify", "bar_submit"});
        Container panel = (Container)this.getView().getControl("field_head");
        if (EmptyUtil.isNoEmpty((Object)panel)) {
            panel.getItems().forEach(s -> this.getView().setEnable(defaultSet, new String[]{s.getKey()}));
        }
        if (defaultSet.booleanValue()) {
            return;
        }
        if (!PlHelper.isEnableCommonForPlConfirm((DynamicObject)this.getModel().getDataEntity()).booleanValue()) {
            return;
        }
        DynamicObject productType = ((DynamicObject)this.getModel().getValue("tradebill")).getDynamicObject("protecttype");
        switch (entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity()) {
            case "tm_forex": {
                this.enableControl_Forex();
                break;
            }
            case "tm_forex_forward": 
            case "tm_forex_swaps": {
                this.enableControl_ForexFwd();
                break;
            }
            case "tm_forex_options": {
                this.enableControl_ForexOption();
                break;
            }
            case "tm_structdeposit": {
                this.enableControl_StructDeposit();
                break;
            }
            case "tm_rateswap": {
                this.enableControl_RateSwap();
            }
        }
    }

    protected void enableControl_Forex() {
        String billStatus = this.getBillStatus();
        String op = (String)this.getModel().getValue("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case flat: {
                Boolean enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                this.getView().setEnable(enable, new String[]{"execexrate", "plamt"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"baseexrate", "baseplamt"});
            }
        }
    }

    protected void enableControl_ForexFwd() {
        Boolean enable = Boolean.FALSE;
        String billStatus = this.getBillStatus();
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        String deliveryWay = tradeBill.getString("deliveryway");
        String op = (String)this.getModel().getValue("operate");
        String calMtd = (String)this.getModel().getValue("exratecalmtd");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case expiredey: 
            case expiredey_n: 
            case expiredey_f: {
                if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                    enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                    break;
                }
                enable = Boolean.TRUE;
                break;
            }
            case flat: 
            case flat_n: 
            case flat_f: {
                enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                break;
            }
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                if (ExRateCalMethodEnum.Rate.getValue().equals(calMtd)) {
                    enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                    break;
                }
                enable = Boolean.TRUE;
                break;
            }
            case defer: 
            case defer_f: 
            case defer_n: 
            case maudate: 
            case maudate_f: 
            case maudate_n: {
                enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
            }
        }
        this.getView().setEnable(enable, new String[]{"execexrate", "plamt"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"baseexrate", "baseplamt"});
    }

    protected void enableControl_ForexOption() {
        String billStatus = this.getBillStatus();
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        String deliveryWay = tradeBill.getString("deliveryway");
        String op = (String)this.getModel().getValue("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case exercise: {
                Boolean enable = DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) ? Boolean.valueOf(TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) : Boolean.TRUE;
                this.getView().setEnable(enable, new String[]{"execexrate", "plamt", "settleamount"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"baseexrate", "baseplamt"});
                break;
            }
            case giveup: {
                Boolean enable = Boolean.TRUE;
                this.getView().setEnable(enable, new String[]{"execexrate", "plamt"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"baseexrate", "baseplamt"});
                break;
            }
            case flat: {
                Boolean enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                this.getView().setEnable(enable, new String[]{"settleamount", "plamt"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"baseexrate", "baseplamt"});
            }
        }
    }

    protected void enableControl_StructDeposit() {
        String op = (String)this.getModel().getValue("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case pay: {
                this.getView().setEnable(Boolean.TRUE, new String[]{"baseexrate", "baseplamt"});
            }
        }
    }

    protected void enableControl_RateSwap() {
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        String swapType = tradeBill.getString("rateswaptype");
        String billStatus = this.getBillStatus();
        String op = (String)this.getModel().getValue("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case capitalpay: 
            case interestpay: {
                Boolean enable = Boolean.TRUE;
                if (SwapTypeEnum.rate.getValue().equals(swapType)) {
                    enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                }
                this.getView().setEnable(enable, new String[]{"plamt"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"execexrate", "baseexrate", "baseplamt"});
            }
        }
    }

    private String getBillStatus() {
        Long id = (Long)this.getModel().getValue("id");
        if (EmptyUtil.isNoEmpty((Long)id) && TmcBotpHelper.isExistTargetBills((String)this.getModel().getDataEntityType().getName(), (Long)id, (String[])new String[]{"cas_recbill", "cas_paybill"})) {
            return TcBillStatusEnum.SETTLE_ING.getValue();
        }
        return (String)this.getModel().getValue("billstatus");
    }
}

