/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class RateCfgForwRateAgreeBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_forwrateagree".equals(srcEntityType)) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            QFilter[] tradebillFilter = new QFilter[]{new QFilter("id", "=", (Object)tradebill.getLong("id"))};
            tradebill = TmcDataServiceHelper.loadSingle((String)"tm_forwrateagree", (String)"id,amount,adjustsettledate,referindex,payrule,startdate,adjustenddate,currency", (QFilter[])tradebillFilter);
            DynamicObject cashflowCol = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"entrys.cfadjstartdate,entrys.cfadjenddate,entrys.cfratefixdate", (QFilter[])new QFilter[]{new QFilter("billid", "=", tradebill.getPkValue())});
            DynamicObjectCollection entrys = cashflowCol.getDynamicObjectCollection("entrys");
            DynamicObject cashflowEntry = (DynamicObject)entrys.get(0);
            this.initBizEntry(tradebill, cashflowEntry);
            if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) && EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                Date rateFixDate = cashflowEntry.getDate("cfratefixdate");
                DynamicObject refindex = tradebill.getDynamicObject("referindex");
                this.getModel().setValue("bizdate", (Object)rateFixDate);
                BigDecimal referratevalue = MarketDataServiceHelper.referRate((String)refindex.getString("number"), (Date)rateFixDate, (boolean)true);
                this.getModel().setValue("ratefixdate_pay", (Object)rateFixDate);
                this.getModel().setValue("referrate_pay", (Object)refindex);
                this.getModel().setValue("referratevalue_pay", (Object)referratevalue);
                this.getModel().setValue("fixedrate_pay", (Object)referratevalue);
            }
            Date cfadjstartdate = cashflowEntry.getDate("cfadjstartdate");
            Date startdate = tradebill.getDate("startdate");
            this.setBizDateRange(startdate, cfadjstartdate);
            this.getModel().setDataChanged(false);
        }
    }

    private void initBizEntry(DynamicObject tradebill, DynamicObject cashflowEntry) {
        Date rateFixDate = cashflowEntry.getDate("cfratefixdate");
        this.getModel().setValue("plsettledate", (Object)rateFixDate);
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"))});
        DynamicObjectCollection lifeCycleCards = this.getModel().getEntryEntity("entrybiz");
        DynamicObject lifeCycleCard = lifeCycleCards.addNew();
        lifeCycleCard.set("restamt_biz", tradebill.get("amount"));
        lifeCycleCard.set("date_biz", tradebill.get("adjustsettledate"));
        lifeCycleCard.set("currency_biz", tradebill.get("currency"));
        lifeCycleCard.set("title_biz", (Object)ResManager.loadKDString((String)"\u539f\u5408\u7ea6", (String)"BizBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("bizrecordid", (Object)bizRecord.getLong("id"));
    }

    private void setBizDateRange(Date startdate, Date enddate) {
        DateTimeEdit bizdate = (DateTimeEdit)this.getControl("bizdate");
        bizdate.setMinDate(startdate);
        bizdate.setMaxDate(enddate);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry grid = (CardEntry)this.getView().getControl("entrybiz");
        grid.selectCard(Integer.valueOf(0));
        this.setMustInput();
    }

    private void setMustInput() {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"fixedrate_pay"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "bizdate": {
                this.getModel().setValue("ratefixdate_pay", this.getModel().getValue(propName));
                break;
            }
            case "ratefixdate_pay": {
                DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
                tradebill = TmcDataServiceHelper.loadSingle((String)"tm_forwrateagree", (String)"referindex", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getLong("id"))});
                Date ratefixdate = (Date)this.getModel().getValue("ratefixdate_pay");
                DynamicObject referrate = tradebill.getDynamicObject("referindex");
                BigDecimal referratevalue = MarketDataServiceHelper.referRate((String)referrate.getString("number"), (Date)ratefixdate, (boolean)true);
                this.getModel().setValue("referratevalue_pay", (Object)referratevalue);
                break;
            }
            case "referratevalue_pay": {
                BigDecimal referRate = (BigDecimal)this.getModel().getValue("referratevalue_pay");
                if (!EmptyUtil.isNoEmpty((BigDecimal)referRate)) break;
                this.getModel().setValue("fixedrate_pay", (Object)referRate);
            }
        }
    }
}

