/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.cashflow;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;
import kd.tmc.tm.common.helper.CashFlowDAOHelper;
import kd.tmc.tm.common.resource.TeBizResource;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCashFlowPlugin
extends AbstractTmcBillEdit
implements TabSelectListener {
    private static final Log logger = LogFactory.getLog(AbstractCashFlowPlugin.class);

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject protectType = (DynamicObject)this.getModel().getValue("protecttype");
        if (EmptyUtil.isNoEmpty((DynamicObject)protectType)) {
            String protectTypeId = String.valueOf(protectType.getLong("id"));
            if (ProductTypeEnum.FOREXSPOT.getId().equals(protectTypeId) || ProductTypeEnum.FOREXFORWARD.getId().equals(protectTypeId) || ProductTypeEnum.FOREXSWAPS.getId().equals(protectTypeId) || ProductTypeEnum.FOREXOPTION.getId().equals(protectTypeId)) {
                this.tabSelected_cashFlow();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        if (tabap != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        if ("reset".equals(propName)) {
            this.visableResetColumns();
            this.visableResetData();
        }
    }

    protected void visableResetColumns() {
        EntryProp entrys = (EntryProp)EntityMetadataCache.getDataEntityType((String)"tm_cashflow").getProperty("entrys");
        DataEntityPropertyCollection props = entrys.getDynamicCollectionItemPropertyType().getProperties();
        ArrayList propList = new ArrayList();
        props.forEach(prop -> propList.add(prop.getName() + this.getExtendPropName()));
        ArrayList<String> visableList = new ArrayList<String>();
        propList.forEach(property -> {
            if (propList.contains(property) && !this.getNoSelectFields().contains(property) && !"no".equals(property) && !"no_s".equals(property)) {
                visableList.add((String)property);
            }
        });
        visableList.add("cfreferindexfreq");
        boolean visable = (Boolean)this.getModel().getValue("reset");
        this.getView().setVisible(Boolean.valueOf(visable), visableList.toArray(new String[visableList.size()]));
    }

    protected void visableResetData() {
        ArrayList seqList = new ArrayList();
        DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(this.getCashFlowTable());
        colls.forEach(cashFlow -> {
            if (EmptyUtil.isEmpty((Long)cashFlow.getLong("pid"))) {
                seqList.add(cashFlow.getInt("seq"));
            }
        });
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl(this.getCashFlowTable());
        int[] seqs = seqList.stream().mapToInt(Integer::intValue).toArray();
        boolean visable = (Boolean)this.getModel().getValue("reset");
        if (visable) {
            treeGrid.expand(seqs);
        } else {
            treeGrid.collapse(seqs);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals(this.getCashFlowTabName())) {
            this.tabSelected_cashFlow();
        }
    }

    private List<String> getChangedProps() {
        ArrayList<String> changedProps = new ArrayList<String>(10);
        Iterator bizChgPropIter = this.getModel().getDataEntity().getDataEntityState().getBizChangedProperties().iterator();
        while (bizChgPropIter.hasNext()) {
            changedProps.add(((IDataEntityProperty)bizChgPropIter.next()).getName());
        }
        return changedProps;
    }

    protected boolean isOnlyResetFlagChange() {
        return this.getChangedProps().size() == 1 && "reset".equals(this.getChangedProps().get(0));
    }

    private void tabSelected_cashFlow() {
        if (this.isTabSelectedLoad()) {
            boolean bizDataChanged;
            boolean relatedBizDateChanged;
            boolean isZeroCashflowOnDraft;
            String billstatus = this.getModel().getDataEntity().getString("billstatus");
            boolean isCopy = false;
            FormShowParameter formParam = this.getView().getFormShowParameter();
            boolean isZeroCashflow = this.getModel().getEntryRowCount(this.getCashFlowTable()) == 0;
            boolean bl = isZeroCashflowOnDraft = TcBillStatusEnum.SAVE.getValue().equals(billstatus) && isZeroCashflow;
            if (formParam.getCustomParams().containsKey("iscopy") && formParam.getStatus() == OperationStatus.ADDNEW) {
                isCopy = (Boolean)formParam.getCustomParam("iscopy") != false && isZeroCashflow;
            }
            boolean bl2 = relatedBizDateChanged = (bizDataChanged = this.getModel().getDataChanged()) && !this.isOnlyResetFlagChange();
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus) && !TcBillStatusEnum.FINISH.getValue().equals(billstatus) && (relatedBizDateChanged || isCopy || isZeroCashflowOnDraft)) {
                logger.info("\u52a0\u8f7d\u73b0\u91d1\u6d41\u6570\u636e1");
                if (this.isCanBuild(null) && this.isCreateCashFlow()) {
                    logger.info("\u52a0\u8f7d\u73b0\u91d1\u6d41\u6570\u636e2");
                    this.createCashFlowData();
                } else {
                    this.getModel().deleteEntryData(this.getCashFlowTable());
                }
            } else if (EmptyUtil.isEmpty((DynamicObjectCollection)this.getModel().getEntryEntity(this.getCashFlowTable()))) {
                logger.info("\u52a0\u8f7d\u73b0\u91d1\u6d41\u6570\u636e");
                this.loadCashFlowData();
            }
            if (!bizDataChanged) {
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("unAudit".equalsIgnoreCase(formOperate.getOperateKey()) && EmptyUtil.isNoEmpty((String)this.getView().getPageCache().get("isDataChangedBeforeUnAudit"))) {
            String isDataChangedBeforeUnAudit = this.getView().getPageCache().get("isDataChangedBeforeUnAudit");
            this.getModel().setDataChanged("true".equalsIgnoreCase(isDataChangedBeforeUnAudit));
        }
        if ((StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"submit", (CharSequence)formOperate.getOperateKey())) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getModel().setDataChanged(false);
        }
        if (StringUtils.equals((CharSequence)"refresh", (CharSequence)formOperate.getOperateKey())) {
            this.tabSelected_cashFlow();
            this.getModel().setDataChanged(false);
        }
        if (StringUtils.equals((CharSequence)"tradecfg", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().updateView(this.getCashFlowTable());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        AbstractOperate op = (AbstractOperate)source;
        if ("save".equalsIgnoreCase(op.getOperateKey()) || "submit".equalsIgnoreCase(op.getOperateKey()) || "tradecfg".equalsIgnoreCase(op.getOperateKey())) {
            boolean bizDataChanged;
            boolean relatedBizDateChanged;
            String billstatus = this.getModel().getDataEntity().getString("billstatus");
            boolean isCopy = false;
            boolean isZeroCashflow = this.getModel().getEntryRowCount(this.getCashFlowTable()) == 0;
            boolean isZeroCashflowOnDraft = TcBillStatusEnum.SAVE.getValue().equals(billstatus) && isZeroCashflow;
            FormShowParameter formParam = this.getView().getFormShowParameter();
            if (formParam.getCustomParams().containsKey("iscopy") && formParam.getStatus() == OperationStatus.ADDNEW) {
                isCopy = (Boolean)formParam.getCustomParam("iscopy") != false && isZeroCashflow;
            }
            boolean bl = relatedBizDateChanged = (bizDataChanged = this.getModel().getDataChanged()) && !this.isOnlyResetFlagChange();
            if (!(TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus) || TcBillStatusEnum.FINISH.getValue().equals(billstatus) || !relatedBizDateChanged && !isCopy && !isZeroCashflowOnDraft || "tradecfg".equalsIgnoreCase(op.getOperateKey()) && "tm_structdeposit".equals(this.getModel().getDataEntityType().getName()))) {
                Map<String, String> param;
                logger.info("\u521b\u5efa\u73b0\u91d1\u6d41\u6570\u636e");
                if (this.isCanBuild(op) && this.isCreateCashFlow()) {
                    try {
                        this.createCashFlowData();
                        this.callbackData(op.getOperateKey(), this.getPageCache());
                    }
                    catch (KDBizException e) {
                        this.getPageCache().remove("checkedPluginCount");
                        this.getPageCache().remove("emptyColumnNames");
                        throw e;
                    }
                } else {
                    this.getModel().deleteEntryData(this.getCashFlowTable());
                }
                if (op.getOption().containsVariable("cashFlowParam")) {
                    String cashFlowTable = op.getOption().getVariableValue("cashFlowParam");
                    param = (Map)JSON.parseObject((String)cashFlowTable, Map.class);
                    param.put(this.getCashFlowTable(), this.getExtendPropName());
                } else {
                    param = new HashMap<String, String>();
                    param.put(this.getCashFlowTable(), this.getExtendPropName());
                }
                op.getOption().setVariableValue("cashFlowParam", JSON.toJSONString(param));
            }
        }
        super.beforeDoOperation(args);
        if ("unAudit".equalsIgnoreCase(op.getOperateKey())) {
            this.getView().getPageCache().put("isDataChangedBeforeUnAudit", String.valueOf(this.getModel().getDataChanged()));
        }
    }

    protected void callbackData(String op, IPageCache cache) {
    }

    protected void loadCashFlowData() {
        if (this.getModel().getDataEntityType().getName().equals("tm_rateswap")) {
            this.loadCashFlowDataBatch();
            return;
        }
        boolean isDataChange = this.getModel().getDataChanged();
        long begin = System.currentTimeMillis();
        this.getModel().deleteEntryData(this.getCashFlowTable());
        QFilter filter = new QFilter("billid", "=", this.getModel().getValue("id"));
        QFilter customFilter = this.getFilter();
        if (customFilter != null) {
            filter = filter.and(customFilter);
        }
        DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(this.getCashFlowTable());
        DataEntityPropertyCollection props = colls.getDynamicObjectType().getProperties();
        ArrayList propList = new ArrayList();
        props.forEach(prop -> {
            if (!this.getNoSelectFields().contains(prop.getName()) && EmptyUtil.isEmpty((String)prop.getAlias())) {
                if (prop.getName().endsWith(this.getExtendPropName())) {
                    propList.add(prop.getName().substring(0, prop.getName().length() - this.getExtendPropName().length()));
                } else {
                    propList.add(prop.getName());
                }
            }
        });
        String selProps = "billno," + StringUtils.join(propList, (String)",");
        DynamicObject[] cashFlows = CashFlowDAOHelper.loadAsc((String)selProps, (QFilter[])filter.toArray());
        ArrayList<Integer> seqList = new ArrayList<Integer>(cashFlows.length);
        ArrayList<Integer> seqDetailList = new ArrayList<Integer>();
        for (DynamicObject cashFlow : cashFlows) {
            int index = this.getModel().createNewEntryRow(this.getCashFlowTable());
            List<Integer> seq = this.loadCashFlowPay(cashFlow, index);
            seqList.add(index);
            seqDetailList.addAll(seq);
        }
        this.expandAndBgColor(seqList, seqDetailList);
        this.getModel().setDataChanged(isDataChange);
        long end = System.currentTimeMillis();
        logger.info("\u52a0\u8f7d\u73b0\u91d1\u6d41\u6570\u636e\u8017\u65f6" + (end - begin) + "\u6beb\u79d2");
    }

    private List<Integer> loadCashFlowPay(DynamicObject cashFlow, int index) {
        List<String> extendFieldList = this.getExtendsFieldMap();
        DataEntityPropertyCollection props = cashFlow.getDynamicObjectType().getProperties();
        props.forEach(prop -> {
            String propery = prop.getName();
            if (!this.getNoSelectFields().contains(propery) && !propery.endsWith("_id")) {
                if (extendFieldList.contains(propery)) {
                    propery = prop.getName() + this.getExtendPropName();
                    if (this.getModel().getProperty(propery) != null) {
                        this.getModel().setValue(propery, cashFlow.get(prop.getName()), index);
                    }
                } else if (this.getModel().getProperty(propery) != null) {
                    this.getModel().setValue(propery, cashFlow.get(propery), index);
                }
            }
        });
        this.getModel().setValue("no" + this.getExtendPropName(), (Object)cashFlow.getString("billno"), index);
        return this.loadCashFlowDetail(cashFlow, index);
    }

    private List<Integer> loadCashFlowDetail(DynamicObject cashFlow, int pindex) {
        DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
        ArrayList<Integer> seqs = new ArrayList<Integer>();
        entrys.forEach(entry -> {
            int index = this.getModel().insertEntryRow(this.getCashFlowTable(), pindex);
            DataEntityPropertyCollection props = entry.getDataEntityType().getProperties();
            props.forEach(prop -> {
                String property = prop.getName() + this.getExtendPropName();
                if (this.getModel().getProperty(property) != null && !"id".equals(prop.getName()) && !"pid".equals(prop.getName())) {
                    this.getModel().setValue(property, entry.get(prop), index);
                }
            });
            this.getModel().setValue("no" + this.getExtendPropName(), (Object)entry.getString("no"), index);
            this.getModel().setValue("cftype" + this.getExtendPropName(), (Object)"", index);
            seqs.add(index);
        });
        return seqs;
    }

    protected void createCashFlowData() {
        if (this.getModel().getDataEntityType().getName().equals("tm_rateswap")) {
            this.createCashFlowDataBatch();
            return;
        }
        long begin = System.currentTimeMillis();
        this.getModel().deleteEntryData(this.getCashFlowTable());
        ICashFlowBuilder builder = this.getCashFlowBuilder();
        List dataMap = builder.build(this.getView(), new ModelAgent((Object)this.getModel()));
        this.fillCashFlowData(dataMap);
        long end = System.currentTimeMillis();
        logger.info("\u521b\u5efa\u73b0\u91d1\u6d41\u6570\u636e\u8017\u65f6\uff1a" + (end - begin) + "\u6beb\u79d2");
    }

    private void fillCashFlowData(List<Map<String, Object>> dataMap) {
        long begin = System.currentTimeMillis();
        boolean isChanged = this.getModel().getDataChanged();
        HashMap id2seqMap = new HashMap();
        ArrayList<Integer> seqList = new ArrayList<Integer>();
        ArrayList<Integer> seqDetailList = new ArrayList<Integer>();
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue(this.getCashFlowTable());
        DataEntityPropertyCollection props = entrys.getDynamicObjectType().getProperties();
        dataMap.forEach(data -> {
            int index;
            if (data.containsKey("pid")) {
                index = this.getModel().insertEntryRow(this.getCashFlowTable(), ((Integer)id2seqMap.get(data.get("pid"))).intValue());
            } else {
                index = this.getModel().createNewEntryRow(this.getCashFlowTable());
                id2seqMap.put((Long)data.get("id"), index);
            }
            if (data.containsKey("pid")) {
                seqDetailList.add(index);
            } else {
                seqList.add(index);
            }
            for (IDataEntityProperty prop : props) {
                String property = prop.getName();
                if (EmptyUtil.isNoEmpty((String)this.getExtendPropName()) && property.endsWith(this.getExtendPropName())) {
                    property = prop.getName().substring(0, prop.getName().length() - this.getExtendPropName().length());
                }
                if (!data.containsKey(property) || "id".equals(property) || "pid".equals(property) || !data.containsKey(property)) continue;
                this.getModel().setValue(prop.getName(), data.get(property), index);
            }
        });
        this.expandAndBgColor(seqList, seqDetailList);
        if (!isChanged) {
            this.getModel().setDataChanged(false);
        }
        long end = System.currentTimeMillis();
        logger.info("\u586b\u5145\u73b0\u91d1\u6d41\u6570\u636e\u8017\u65f6" + (end - begin) + "\u6beb\u79d2");
    }

    protected void createCashFlowDataBatch() {
        long begin = System.currentTimeMillis();
        this.getModel().deleteEntryData(this.getCashFlowTable());
        ICashFlowBuilder builder = this.getCashFlowBuilder();
        List dataMap = builder.build(this.getView(), new ModelAgent((Object)this.getModel()));
        this.fillCashFlowDataBatch(dataMap);
        this.expandAndBgColor();
        this.getView().updateView(this.getCashFlowTable());
        long end = System.currentTimeMillis();
        logger.info("createCashFlowDataBatch \u521b\u5efa\u73b0\u91d1\u6d41\u6570\u636e\u8017\u65f6\uff1a" + (end - begin) + "\u6beb\u79d2");
    }

    protected void loadCashFlowDataBatch() {
        boolean isDataChange = this.getModel().getDataChanged();
        long begin = System.currentTimeMillis();
        this.getModel().deleteEntryData(this.getCashFlowTable());
        TableValueSetter vs = this.buildCashFlowVSFromDb();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(this.getCashFlowTable(), vs);
        this.expandAndBgColor();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.getCashFlowTable());
        entrys.forEach(e -> e.getDataEntityState().setDirty(false));
        this.getModel().setDataChanged(isDataChange);
        this.getView().updateView(this.getCashFlowTable());
        long end = System.currentTimeMillis();
        logger.info("loadCashFlowDataBatch \u52a0\u8f7d\u73b0\u91d1\u6d41\u6570\u636e\u8017\u65f6" + (end - begin) + "\u6beb\u79d2");
    }

    private TableValueSetter buildCashFlowVSFromDb() {
        DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(this.getCashFlowTable());
        DataEntityPropertyCollection cashFlowEntryProps = colls.getDynamicObjectType().getProperties();
        DynamicObject[] cashFlows = this.getCashFlows(cashFlowEntryProps);
        return this.buildCashFlow(cashFlowEntryProps, cashFlows);
    }

    protected TableValueSetter buildCashFlow(DataEntityPropertyCollection cashFlowEntryProps, DynamicObject[] cashFlows) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int seqNo = 1;
        for (DynamicObject cashFlow : cashFlows) {
            DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
            for (IDataEntityProperty prop : cashFlowEntryProps) {
                String property = prop.getName();
                if (property.endsWith("_id")) continue;
                if (EmptyUtil.isNoEmpty((String)this.getExtendPropName()) && property.endsWith(this.getExtendPropName())) {
                    property = prop.getName().substring(0, prop.getName().length() - this.getExtendPropName().length());
                }
                Object value = null;
                if (cashFlow.getDataEntityType().getProperties().containsKey((Object)property) && (value = cashFlow.get(property)) instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                if (property.equals("no")) {
                    value = cashFlow.getString("billno");
                }
                if (prop.getName().equals("isGroupNode")) {
                    value = entrys.size() == 0 ? Boolean.FALSE : Boolean.TRUE;
                }
                if (prop.getName().equals("seq")) {
                    value = seqNo++;
                }
                if (prop.getName().equals("pid")) {
                    value = 0L;
                }
                vs.addField(prop.getName(), new Object[]{value});
            }
            seqNo = this.buildCashFlowResetDetail(cashFlowEntryProps, vs, cashFlow, seqNo);
        }
        return vs;
    }

    protected DynamicObject[] getCashFlows(DataEntityPropertyCollection cashFlowEntryProps) {
        QFilter filter = new QFilter("billid", "=", this.getModel().getValue("id"));
        QFilter customFilter = this.getFilter();
        if (customFilter != null) {
            filter = filter.and(customFilter);
        }
        ArrayList selectPropList = new ArrayList();
        cashFlowEntryProps.forEach(prop -> {
            if (!this.getNoSelectFields().contains(prop.getName()) && EmptyUtil.isEmpty((String)prop.getAlias())) {
                if (prop.getName().endsWith(this.getExtendPropName())) {
                    selectPropList.add(prop.getName().substring(0, prop.getName().length() - this.getExtendPropName().length()));
                } else {
                    selectPropList.add(prop.getName());
                }
            }
        });
        String selProps = "billno," + StringUtils.join(selectPropList, (String)",");
        return CashFlowDAOHelper.loadAsc((String)selProps, (QFilter[])filter.toArray());
    }

    private int buildCashFlowResetDetail(DataEntityPropertyCollection props, TableValueSetter vs, DynamicObject cashFlow, int startSeqno) {
        Long pid = cashFlow.getLong("id");
        DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entrys) {
            for (IDataEntityProperty prop : props) {
                String property = prop.getName();
                if (property.endsWith("_id")) continue;
                if (EmptyUtil.isNoEmpty((String)this.getExtendPropName()) && property.endsWith(this.getExtendPropName())) {
                    property = prop.getName().substring(0, prop.getName().length() - this.getExtendPropName().length());
                }
                Object value = null;
                if (entry.getDataEntityType().getProperties().containsKey((Object)property) && (value = entry.get(property)) instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                if (prop.getName().equals("isGroupNode")) {
                    value = Boolean.FALSE;
                }
                if (prop.getName().equals("pid")) {
                    value = pid;
                }
                if (prop.getName().equals("seq")) {
                    value = startSeqno++;
                }
                vs.addField(prop.getName(), new Object[]{value});
            }
        }
        return startSeqno;
    }

    private void fillCashFlowDataBatch(List<Map<String, Object>> dataMap) {
        long begin = System.currentTimeMillis();
        boolean isChanged = this.getModel().getDataChanged();
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue(this.getCashFlowTable());
        DataEntityPropertyCollection props = entrys.getDynamicObjectType().getProperties();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int seqno = 1;
        for (int idx = 0; idx < dataMap.size(); ++idx) {
            Map<String, Object> data = dataMap.get(idx);
            for (IDataEntityProperty prop : props) {
                String property = prop.getName();
                if (property.endsWith("_id")) continue;
                if (EmptyUtil.isNoEmpty((String)this.getExtendPropName()) && property.endsWith(this.getExtendPropName())) {
                    property = prop.getName().substring(0, prop.getName().length() - this.getExtendPropName().length());
                }
                Object value = null;
                if (data.containsKey(property) && (value = data.get(property)) instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                if (prop.getName().equals("isGroupNode")) {
                    value = !dataMap.get(idx).containsKey("pid") && idx < dataMap.size() - 1 && dataMap.get(idx + 1).containsKey("pid") ? Boolean.TRUE : Boolean.FALSE;
                }
                if (prop.getName().equals("seq")) {
                    value = seqno++;
                }
                vs.addField(prop.getName(), new Object[]{value});
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(this.getCashFlowTable(), vs);
        this.expandAndBgColor();
        if (!isChanged) {
            this.getModel().setDataChanged(false);
        }
        long end = System.currentTimeMillis();
        logger.info("fillCashFlowDataBatch\u586b\u5145\u73b0\u91d1\u6d41\u6570\u636e\u8017\u65f6" + (end - begin) + "\u6beb\u79d2");
    }

    protected void expandAndBgColor() {
        DynamicObjectCollection colls = this.getModel().getEntryEntity(this.getCashFlowTable());
        ArrayList<Integer> seqList = new ArrayList<Integer>(colls.size());
        ArrayList<Integer> seqDetailList = new ArrayList<Integer>(colls.size() + 1);
        colls.forEach(cashFlow -> {
            if (EmptyUtil.isEmpty((Long)cashFlow.getLong("pid"))) {
                seqList.add(cashFlow.getInt("seq") - 1);
            } else {
                seqDetailList.add(cashFlow.getInt("seq") - 1);
            }
        });
        this.expandAndBgColor(seqList, seqDetailList);
    }

    private void expandAndBgColor(List<Integer> seqList, List<Integer> seqDetailList) {
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getView().getControl(this.getCashFlowTable());
        int[] seqs = seqList.stream().mapToInt(Integer::intValue).toArray();
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getProperty("reset"))) {
            boolean visable = (Boolean)this.getModel().getValue("reset");
            if (visable) {
                treeGrid.expand(seqs);
            } else {
                treeGrid.collapse(seqs);
            }
        } else {
            treeGrid.expand(seqs);
        }
        seqs = seqDetailList.stream().mapToInt(Integer::intValue).toArray();
        treeGrid.setRowBackcolor("#F7F7F7", seqs);
    }

    private List<String> getExtendsFieldMap() {
        ArrayList<String> propertys = new ArrayList<String>();
        DataEntityPropertyCollection props = ((DynamicObjectCollection)this.getModel().getValue(this.getCashFlowTable())).getDynamicObjectType().getProperties();
        for (IDataEntityProperty prop : props) {
            String property = prop.getName();
            if (!property.endsWith(this.getExtendPropName())) continue;
            propertys.add(prop.getName().substring(0, prop.getName().length() - this.getExtendPropName().length()));
        }
        return propertys;
    }

    protected List<String> getNoSelectFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        fields.add("pid");
        fields.add("seq");
        fields.add("id_s");
        fields.add("seq_s");
        fields.add("billno");
        fields.add("entrys");
        return fields;
    }

    protected abstract String getCashFlowTable();

    protected abstract String getCashFlowTabName();

    protected abstract ICashFlowBuilder getCashFlowBuilder();

    protected String getExtendPropName() {
        return "";
    }

    protected QFilter getFilter() {
        return null;
    }

    protected boolean isCreateCashFlow() {
        return true;
    }

    protected boolean isTabSelectedLoad() {
        return true;
    }

    protected boolean isCanBuild(AbstractOperate op) {
        int checkedPluginCount;
        List<String> propToBuildCashFlow = this.getPropToBuildCashFlow();
        if (EmptyUtil.isEmpty(propToBuildCashFlow)) {
            return true;
        }
        boolean isCanBuild = true;
        String cachedColumnNames = this.getPageCache().get("emptyColumnNames");
        LinkedHashSet<String> columnNames = EmptyUtil.isNoEmpty((String)cachedColumnNames) ? (LinkedHashSet)SerializationUtils.fromJsonString((String)cachedColumnNames, LinkedHashSet.class) : new LinkedHashSet<String>(2);
        String prefixName = this.getPrefixName();
        for (String prop : propToBuildCashFlow) {
            if (!EmptyUtil.isEmpty((Object)this.getModel().getValue(prop))) continue;
            isCanBuild = false;
            String propName = this.getModel().getProperty(prop).getDisplayName().getLocaleValue();
            if (this.hasPrefixName(prop)) {
                columnNames.add(prefixName + propName);
                continue;
            }
            columnNames.add(propName);
        }
        String cachedCheckedPluginCount = this.getPageCache().get("checkedPluginCount");
        int n = checkedPluginCount = EmptyUtil.isEmpty((String)cachedCheckedPluginCount) ? 1 : Integer.parseInt(cachedCheckedPluginCount) + 1;
        if (EmptyUtil.isEmpty(this.allCashFlowPlugin()) || this.allCashFlowPlugin().size() == checkedPluginCount) {
            if (!(columnNames.isEmpty() || op != null && "save".equalsIgnoreCase(op.getOperateKey()))) {
                this.getView().showTipNotification(TeBizResource.propsToBuildCashflowIsNull((String)String.join((CharSequence)"\u3001", columnNames)));
            }
            this.getPageCache().remove("checkedPluginCount");
            this.getPageCache().remove("emptyColumnNames");
        } else {
            String s = SerializationUtils.toJsonString(columnNames);
            this.getPageCache().put("checkedPluginCount", String.valueOf(checkedPluginCount));
            this.getPageCache().put("emptyColumnNames", s);
        }
        return isCanBuild;
    }

    protected boolean hasPrefixName(String prop) {
        return false;
    }

    protected String getPrefixName() {
        return "";
    }

    protected void bizCallCashFlowFresh() {
        TabSelectEvent evt = new TabSelectEvent((Object)this, this.getCashFlowTabName());
        this.tabSelected(evt);
    }

    protected abstract List<String> allCashFlowPlugin();

    protected abstract List<String> getPropToBuildCashFlow();
}

