/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.cashflow.rate;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.tc.FreqPeriodListBean;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.helper.RateSwapCFCalHelper;
import kd.tmc.tm.formplugin.cashflow.AbstractCashFlowPlugin;

public abstract class AbstractRateSwapsCashFlowPlugin
extends AbstractCashFlowPlugin {
    private static final Log logger = LogFactory.getLog(AbstractRateSwapsCashFlowPlugin.class);
    private FreqPeriodListBean freqPeriodResolver = null;

    protected void referdateChanged_Swap() {
        String billstatus = this.getModel().getDataEntity().getString("billstatus");
        if (TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
            logger.info("\u53c2\u8003\u65e5\u671f\u6539\u53d8\uff0c\u5f00\u59cb\u8ba1\u7b97\u73b0\u91d1\u6d41");
            DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(this.getCashFlowTable());
            DataEntityPropertyCollection cashFlowEntryProps = colls.getDynamicObjectType().getProperties();
            DynamicObject[] cashFlows = this.getCashFlows(cashFlowEntryProps);
            ArrayList<Date> dateList = new ArrayList<Date>(cashFlows.length * 2);
            for (DynamicObject cashflow : cashFlows) {
                Date payDate = cashflow.getDate("cfpaydate");
                dateList.add(payDate);
                dateList.add(TcDateUtils.getLastDay((Date)payDate, (int)1));
            }
            DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
            Date referDate = (Date)this.getModel().getValue("referdate");
            Long market = this.getMarket();
            PriceRuleInfo prInfo = MarketDataHelper.getDiscfactor((IFormView)this.getView(), (Date)referDate, (DynamicObject)priceRule, (Long[])new Long[]{market}, (Date[])dateList.toArray(new Date[0]));
            Map dfs = prInfo.getYieldCurve()[0].getDfMap();
            DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"tm_rateswap");
            RateSwapCFCalHelper.calCashFlows_swap((DynamicObject[])cashFlows, (Date)referDate, (DynamicObject)tradeBill, (Map)dfs, (Boolean)this.ispay());
            TableValueSetter vs = this.buildCashFlow(cashFlowEntryProps, cashFlows);
            this.getModel().deleteEntryData(this.getCashFlowTable());
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(this.getCashFlowTable(), vs);
            this.expandAndBgColor();
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(this.getCashFlowTable());
            entrys.forEach(e -> e.getDataEntityState().setDirty(false));
            this.getModel().setDataChanged(false);
            this.getView().updateView(this.getCashFlowTable());
            logger.info("\u53c2\u8003\u65e5\u671f\u6539\u53d8\uff0c\u7ed3\u675f\u8ba1\u7b97\u73b0\u91d1\u6d41");
        } else if (TcBillStatusEnum.FINISH.getValue().equals(billstatus)) {
            this.getModel().setDataChanged(false);
        }
    }

    protected abstract Long getMarket();

    protected abstract Boolean ispay();
}

