/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.cashflow.rate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;
import kd.tmc.tm.business.service.builder.rate.RateSwapsBuyCashFlowBuilder;
import kd.tmc.tm.common.enums.QuotaFrequency;
import kd.tmc.tm.common.enums.RateSwapsPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.RateSwapHelper;
import kd.tmc.tm.formplugin.cashflow.rate.AbstractRateSwapsCashFlowPlugin;
import kd.tmc.tm.formplugin.cashflow.rate.RateSwapsSellCashFlowPlugin;

public class RateSwapsBuyCashFlowPlugin
extends AbstractRateSwapsCashFlowPlugin {
    @Override
    protected String getCashFlowTable() {
        return "paycashflow";
    }

    @Override
    protected String getCashFlowTabName() {
        return "tabcashflow";
    }

    @Override
    protected ICashFlowBuilder getCashFlowBuilder() {
        return new RateSwapsBuyCashFlowBuilder();
    }

    @Override
    protected String getPrefixName() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u65b9", (String)"RateSwapsBuyCashFlowPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected String getExtendPropName() {
        return "";
    }

    @Override
    protected QFilter getFilter() {
        return new QFilter("cfdirection", "=", (Object)TradeDirectionEnum.buy.getValue());
    }

    @Override
    protected List<String> getPropToBuildCashFlow() {
        ArrayList<String> list = new ArrayList<String>(20);
        list.add("startdate");
        list.add("enddate");
        list.add("rateswaptype");
        list.add("ratetype");
        list.add("stub");
        list.add("amount");
        list.add("currency");
        list.add("paytype");
        list.add("basis");
        list.add("pricerule");
        list.add("valuedate");
        list.add("dateadjustmethod");
        list.add("paydatetype");
        list.add("market");
        if (this.getModel().getValue("rateswaptype").equals(SwapTypeEnum.currency.getValue())) {
            list.add("initpriextype");
            list.add("endpriextype");
        }
        if (this.getModel().getValue("ratetype").equals(RateTypeEnum.rate_fixed.getValue())) {
            list.add("fixedrate");
            if (((Boolean)this.getModel().getValue("stub")).booleanValue()) {
                if (this.getModel().getValue("stubtype").equals("front")) {
                    list.add("firstpaycopdate");
                } else {
                    list.add("penupaycopdate");
                }
            }
        }
        if (this.getModel().getValue("ratetype").equals(RateTypeEnum.rate_float.getValue())) {
            list.add("stub");
            list.add("refindex");
            list.add("rateresettype");
            list.add("ratequotafreq");
            if (((Boolean)this.getModel().getValue("stub")).booleanValue()) {
                list.add("stubtype");
                if (this.getModel().getValue("stubtype").equals("front")) {
                    list.add("firstpaycopdate");
                    list.add("firstreferrate");
                } else {
                    list.add("penupaycopdate");
                    list.add("penureferrate");
                }
            }
            if (QuotaFrequency.Regular.getValue().equals(this.getModel().getValue("ratequotafreq"))) {
                list.add("rateresetfreq");
            }
        }
        if (this.getModel().getValue("paytype").equals(RateSwapsPayTypeEnum.pay_stages.getValue())) {
            list.add("payfrequency");
        }
        return list;
    }

    @Override
    protected boolean hasPrefixName(String prop) {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add("startdate");
        list.add("enddate");
        list.add("rateswaptype");
        list.add("pricerule");
        return !list.contains(prop);
    }

    @Override
    protected List<String> allCashFlowPlugin() {
        ArrayList<String> allCashFlowPlugin = new ArrayList<String>();
        allCashFlowPlugin.add(RateSwapsBuyCashFlowPlugin.class.getName());
        allCashFlowPlugin.add(RateSwapsSellCashFlowPlugin.class.getName());
        return allCashFlowPlugin;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"calculate", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.bizCallCashFlowFresh();
        }
    }

    @Override
    protected void visableResetColumns() {
        super.visableResetColumns();
        String rateType = (String)this.getModel().getValue("ratetype");
        boolean isShow = RateTypeEnum.rate_float.getValue().equals(rateType) && (Boolean)this.getModel().getValue("reset") != false;
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"cfratefixindex", "cfreferindexfreq", "cfresetfreq", "cfmarginamt"});
    }

    @Override
    protected void callbackData(String op, IPageCache cache) {
        if ("submit".equals(op)) {
            RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true, (boolean)false, (boolean)false, (String)this.getPrefixName(), (IPageCache)cache, this.allCashFlowPlugin(), (String)((Object)((Object)this)).getClass().getName());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "referdate": {
                Date referdate = (Date)this.getModel().getValue("referdate");
                if (EmptyUtil.isEmpty((Object)referdate)) break;
                this.referdateChanged_Swap();
            }
        }
    }

    @Override
    protected Long getMarket() {
        return ((DynamicObject)this.getModel().getValue("market")).getLong("id");
    }

    @Override
    protected Boolean ispay() {
        return Boolean.TRUE;
    }
}

