/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.cashflow.rate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;
import kd.tmc.tm.business.service.builder.rate.RateSwapsSellCashFlowBuilder;
import kd.tmc.tm.common.enums.QuotaFrequency;
import kd.tmc.tm.common.enums.RateSwapsPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.RateSwapHelper;
import kd.tmc.tm.formplugin.cashflow.rate.AbstractRateSwapsCashFlowPlugin;
import kd.tmc.tm.formplugin.cashflow.rate.RateSwapsBuyCashFlowPlugin;

public class RateSwapsSellCashFlowPlugin
extends AbstractRateSwapsCashFlowPlugin {
    @Override
    protected String getCashFlowTable() {
        return "reccashflow";
    }

    @Override
    protected String getCashFlowTabName() {
        return "tabcashflow";
    }

    @Override
    protected String getPrefixName() {
        return ResManager.loadKDString((String)"\u6536\u53d6\u65b9", (String)"RateSwapsSellCashFlowPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected ICashFlowBuilder getCashFlowBuilder() {
        return new RateSwapsSellCashFlowBuilder();
    }

    @Override
    protected String getExtendPropName() {
        return "_s";
    }

    @Override
    protected QFilter getFilter() {
        return new QFilter("cfdirection", "=", (Object)TradeDirectionEnum.sell.getValue());
    }

    @Override
    protected List<String> getPropToBuildCashFlow() {
        ArrayList<String> list = new ArrayList<String>(20);
        list.add("startdate");
        list.add("enddate");
        list.add("rateswaptype");
        list.add("recratetype");
        list.add("recstub");
        list.add("recamount");
        list.add("reccurrency");
        list.add("recpaytype");
        list.add("recbasis");
        list.add("pricerule");
        list.add("recvaluedate");
        list.add("recdateadjustmethod");
        list.add("recpaydatetype");
        list.add("recmarket");
        if (this.getModel().getValue("rateswaptype").equals(SwapTypeEnum.currency.getValue())) {
            list.add("initpriextype");
            list.add("endpriextype");
        }
        if (this.getModel().getValue("recratetype").equals(RateTypeEnum.rate_fixed.getValue())) {
            list.add("recfixedrate");
            if (((Boolean)this.getModel().getValue("recstub")).booleanValue()) {
                if (this.getModel().getValue("recstubtype").equals("front")) {
                    list.add("recfirstpaycopdate");
                } else {
                    list.add("recpenupaycopdate");
                }
            }
        }
        if (this.getModel().getValue("recratetype").equals(RateTypeEnum.rate_float.getValue())) {
            list.add("recstub");
            list.add("recrefindex");
            list.add("recrateresettype");
            list.add("recratequotafreq");
            if (((Boolean)this.getModel().getValue("recstub")).booleanValue()) {
                list.add("recstubtype");
                if (this.getModel().getValue("recstubtype").equals("front")) {
                    list.add("recfirstpaycopdate");
                    list.add("recfirstreferrate");
                } else {
                    list.add("recpenupaycopdate");
                    list.add("recpenureferrate");
                }
            }
            if (QuotaFrequency.Regular.getValue().equals(this.getModel().getValue("recratequotafreq"))) {
                list.add("recrateresetfreq");
            }
        }
        if (this.getModel().getValue("recpaytype").equals(RateSwapsPayTypeEnum.pay_stages.getValue())) {
            list.add("recpayfrequency");
        }
        return list;
    }

    @Override
    protected boolean hasPrefixName(String prop) {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add("startdate");
        list.add("enddate");
        list.add("rateswaptype");
        list.add("pricerule");
        return !list.contains(prop);
    }

    @Override
    protected List<String> allCashFlowPlugin() {
        ArrayList<String> allCashFlowPlugin = new ArrayList<String>();
        allCashFlowPlugin.add(RateSwapsBuyCashFlowPlugin.class.getName());
        allCashFlowPlugin.add(RateSwapsSellCashFlowPlugin.class.getName());
        return allCashFlowPlugin;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"calculate", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.bizCallCashFlowFresh();
        }
    }

    @Override
    protected void visableResetColumns() {
        super.visableResetColumns();
        String rateType = (String)this.getModel().getValue("recratetype");
        boolean isShow = RateTypeEnum.rate_float.getValue().equals(rateType) && (Boolean)this.getModel().getValue("reset") != false;
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"cfratefixindex" + this.getExtendPropName(), "cfreferindexfreq" + this.getExtendPropName(), "cfresetfreq" + this.getExtendPropName(), "cfmarginamt" + this.getExtendPropName()});
    }

    @Override
    protected void callbackData(String op, IPageCache cache) {
        if ("submit".equals(op)) {
            RateSwapHelper.calFirstComfirmDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false, (boolean)false, (boolean)false, (String)this.getPrefixName(), (IPageCache)cache, this.allCashFlowPlugin(), (String)((Object)((Object)this)).getClass().getName());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "referdate": {
                Date referdate = (Date)this.getModel().getValue("referdate");
                if (EmptyUtil.isEmpty((Object)referdate)) break;
                this.referdateChanged_Swap();
            }
        }
    }

    @Override
    protected Long getMarket() {
        return ((DynamicObject)this.getModel().getValue("recmarket")).getLong("id");
    }

    @Override
    protected Boolean ispay() {
        return Boolean.FALSE;
    }
}

