/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.combreqnote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.formplugin.requestnote.ReqNoteBaseEdit;

public class CombReqNoteEdit
extends ReqNoteBaseEdit {
    public static final String FBASEDATAID = "fbasedataid";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (CombReqNoteEnum value : CombReqNoteEnum.values()) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(value.getEntryOrgName());
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit producttype = (BasedataEdit)this.getControl("producttype");
        producttype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        List allEntryOrgName = CombReqNoteEnum.getAllEntryOrgName();
        if (allEntryOrgName.contains(name)) {
            this.filterEntryOrg(event);
        }
        if ("producttype".equals(name)) {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            QFilter filter = new QFilter("parent.number", "=", (Object)"01FOREX").or(new QFilter("number", "=", (Object)"01FOREX"));
            parameter.getTreeFilterParameter().getQFilters().add(filter);
        }
        if ("org".equals(name)) {
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"tm", (String)"tm_combreqnote", (String)"47150e89000000ac");
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "org": {
                this.onchangeEntryOrg();
                break;
            }
            case "producttype": {
                this.onchangeProductType();
                break;
            }
            case "spotorg": {
                this.clearFields(new String[]{"spotbusinesstype", "spotcurrencytypein", "spotcurrencytypeout"}, rowIndex);
                break;
            }
            case "fwdorg": {
                this.clearFields(new String[]{"businesstype", "currencytypein", "currencytypeout"}, rowIndex);
                break;
            }
            case "swapsorg": {
                this.clearFields(new String[]{"bustype", "currin", "currout"}, rowIndex);
                break;
            }
            case "optionsorg": {
                this.clearFields(new String[]{"opbustype", "opcurrin", "opcurrout"}, rowIndex);
            }
        }
    }

    private void clearFields(String[] props, int rowIndex) {
        for (String prop : props) {
            this.getModel().setValue(prop, null, rowIndex);
        }
    }

    private void onchangeProductType() {
        DynamicObjectCollection productType = (DynamicObjectCollection)this.getModel().getValue("producttype");
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        Set containProductType = productType.stream().map(e -> e.getDynamicObject(FBASEDATAID).getString("number")).collect(Collectors.toSet());
        Set collect = Arrays.stream(values).filter(e -> !containProductType.contains(e.getProductType())).collect(Collectors.toSet());
        for (CombReqNoteEnum combReqNote : collect) {
            this.getModel().deleteEntryData(combReqNote.getEntryName());
        }
        for (String product : containProductType) {
            CombReqNoteEnum productTypeEnum = CombReqNoteEnum.getByProductType((String)product);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(productTypeEnum.getEntryName());
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) continue;
            if (productTypeEnum == CombReqNoteEnum.SWAPS) {
                this.getModel().batchCreateNewEntryRow("swapsinfo", 2);
                int size = EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) ? entryEntity.size() : 0;
                this.getModel().setValue("end", (Object)"nearend", size - 2);
                this.getModel().setValue("end", (Object)"farend", size - 1);
                continue;
            }
            this.getModel().createNewEntryRow(productTypeEnum.getEntryName());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = TmcOrgDataHelper.checkCurrentBankOrg();
        if (org != null) {
            this.getModel().setValue("org", (Object)new Long[]{org.getLong("id")});
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setListVisible();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgs.size() > 0) {
            String entryName = e.getEntryProp().getName();
            CombReqNoteEnum combReqNote = CombReqNoteEnum.getByEntryName((String)entryName);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
            DynamicObject org = (DynamicObject)((DynamicObject)orgs.get(0)).get(FBASEDATAID);
            if (CombReqNoteEnum.SWAPS == combReqNote) {
                int rowCount = this.getModel().getEntryEntity(combReqNote.getEntryName()).getRowCount();
                if (rowCount > 1) {
                    this.getModel().setValue(combReqNote.getEntryOrgName(), (Object)org, entryEntity.size() - 1);
                    this.getModel().setValue(combReqNote.getEntryOrgName(), (Object)org, entryEntity.size() - 2);
                }
            } else {
                this.getModel().setValue(combReqNote.getEntryOrgName(), (Object)org, entryEntity.size() - 1);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        boolean success;
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"pushcombtradeop", (CharSequence)operateKey) && (success = (operationResult = args.getOperationResult()).isSuccess())) {
            this.pushCombTrade();
        }
        if (StringUtils.equals((CharSequence)"pushtrade", (CharSequence)operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"pushtrade", (CharSequence)operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void pushCombTrade() {
        IFormView view = this.getView();
        boolean isPushOption = false;
        DynamicObjectCollection productTypes = (DynamicObjectCollection)this.getModel().getValue("producttype");
        if (productTypes.size() == 1) {
            String number = ((DynamicObject)productTypes.get(0)).getDynamicObject(FBASEDATAID).getString("number");
            boolean isOnlyOption = CombReqNoteEnum.OPTIONS.getProductType().equals(number);
            if (isOnlyOption) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CombReqNoteEnum.OPTIONS.getEntryName());
                Set ids = entryEntity.stream().map(e -> e.get(CombReqNoteEnum.OPTIONS.getBillIdName())).collect(Collectors.toSet());
                DynamicObject[] trades = TmcDataServiceHelper.load((String)"tm_forex_options", (String)"id,org,pair,adjexpiredate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                Set collect = Arrays.stream(trades).map(e -> e.getDate("adjexpiredate")).collect(Collectors.toSet());
                Set pairs = Arrays.stream(trades).map(e -> e.getString("pair")).collect(Collectors.toSet());
                Set orgIds = Arrays.stream(trades).map(e -> e.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
                if (collect.size() == 1 && pairs.size() == 1 && orgIds.size() == 1) {
                    isPushOption = true;
                }
            }
        }
        if (isPushOption) {
            view.invokeOperation("pushoptioncomb");
        } else {
            view.invokeOperation("pushcombtrade");
        }
    }

    private void filterEntryOrg(BeforeF7SelectEvent event) {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CombReqNoteEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        } else {
            List orgIds = orgs.stream().map(e -> ((DynamicObject)e.get(FBASEDATAID)).getPkValue()).collect(Collectors.toList());
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            parameter.setMultiSelect(false);
            parameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", orgIds)));
        }
    }

    private void onchangeEntryOrg() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgs.size() > 0) {
            DynamicObject org = (DynamicObject)((DynamicObject)orgs.get(0)).get(FBASEDATAID);
            List<Long> orgIds = orgs.stream().map(e -> (Long)((DynamicObject)e.get(FBASEDATAID)).getPkValue()).collect(Collectors.toList());
            this.changeEntry(orgIds, CombReqNoteEnum.SPOT, org);
            this.changeEntry(orgIds, CombReqNoteEnum.FORWARD, org);
            this.changeEntry(orgIds, CombReqNoteEnum.SWAPS, org);
            this.changeEntry(orgIds, CombReqNoteEnum.OPTIONS, org);
        }
        List allEntryName = CombReqNoteEnum.getAllEntryName();
        for (String entryName : allEntryName) {
            this.getView().updateView(entryName);
        }
    }

    private void changeEntry(List<Long> orgIds, CombReqNoteEnum combReqNoteEnum, DynamicObject org) {
        String entryName = combReqNoteEnum.getEntryName();
        String orgName = combReqNoteEnum.getEntryOrgName();
        DynamicObjectCollection entry = this.getModel().getEntryEntity(entryName);
        for (DynamicObject dynamicObject : entry) {
            DynamicObject entryOrg = dynamicObject.getDynamicObject(orgName);
            if (entryOrg != null && orgIds.contains((Long)entryOrg.getPkValue())) continue;
            dynamicObject.set(orgName, (Object)org);
            for (String needClearFiled : combReqNoteEnum.getNeedClearFileds()) {
                dynamicObject.set(needClearFiled, null);
            }
        }
    }

    @Override
    protected void setListVisible() {
        DynamicObjectCollection productTypes = (DynamicObjectCollection)this.getModel().getValue("producttype");
        CombReqNoteEnum[] values = CombReqNoteEnum.values();
        for (CombReqNoteEnum value : values) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{value.getEntryControlName()});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{value.getEntryName()});
        }
        for (DynamicObject productType : productTypes) {
            String number = (productType = (DynamicObject)productType.get(FBASEDATAID)).getString("number");
            if (!CombReqNoteEnum.isContainProductType((String)number)) continue;
            String entryControlName = CombReqNoteEnum.getByProductType((String)number).getEntryControlName();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{entryControlName});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{CombReqNoteEnum.getByProductType((String)number).getEntryName()});
        }
    }

    @Override
    protected String getcurrEntity() {
        return "tm_combreqnote";
    }

    @Override
    protected List<String> getTargetEntities() {
        DynamicObjectCollection productTypes = (DynamicObjectCollection)this.getModel().getValue("producttype");
        ArrayList<String> products = new ArrayList<String>(productTypes.size());
        for (DynamicObject productType : productTypes) {
            products.add(ProductTypeEnum.getEnumByValue((String)productType.getDynamicObject(FBASEDATAID).getString("number")).getEntity());
        }
        return products;
    }

    @Override
    protected void setExtraEntryProperty(String entry, DynamicObject bill, int rowIndex) {
        CombReqNoteEnum combReqNote = CombReqNoteEnum.getByBillType((String)entry);
        this.getModel().setValue(combReqNote.getBillIdName(), bill.getPkValue(), rowIndex);
    }

    @Override
    protected void updateQuotePR() {
        super.updateQuotePR();
        DynamicObjectCollection spotEntity = this.getModel().getEntryEntity("spotinfo");
        DynamicObjectCollection forwardEntity = this.getModel().getEntryEntity("forwardinfo");
        DynamicObjectCollection optionsEntity = this.getModel().getEntryEntity("optionsinfo");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)forwardEntity)) {
            this.updateExQuoteByFormId("forwardinfo", "currencytypein", "currencytypeout", "exchangequotation");
        }
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)spotEntity)) {
            this.updateExQuoteByFormId("spotinfo", "spotcurrencytypein", "spotcurrencytypeout", "spotexchangequotation");
        }
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)optionsEntity)) {
            this.updateExQuoteByFormId("optionsinfo", "opcurrin", "opcurrout", "opquote");
        }
    }
}

