/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.combreqnote;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.tm.common.enums.CombReqNoteEnum;

public class CombRequestNoteList
extends AbstractTmcListPlugin {
    private static final String FILTER_DEFAULT_ORG = "filter_defaultorg";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long selectedId;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"pushtrade", (CharSequence)operateKey)) {
            selectedId = this.getSelectedId();
            if (selectedId == null) {
                args.setCancel(true);
                return;
            }
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (!this.getSelectedRows().get(0).getBillStatus().equals(TcBillStatusEnum.AUDIT.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u4ea4\u6613\u7533\u8bf7\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CombRequestNoteList_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"pushcombtradeop", (CharSequence)operateKey) && (selectedId = this.getSelectedId()) == null) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"pushcombtradeop", (CharSequence)operateKey)) {
            OperationResult operationResult = args.getOperationResult();
            boolean success = operationResult.isSuccess();
            if (success) {
                this.pushCombTrade();
            }
        } else if (StringUtils.equals((CharSequence)"pushtrade", (CharSequence)operateKey)) {
            ((BillList)this.getControl("billlistap")).refresh();
        }
    }

    private void pushCombTrade() {
        IFormView view = this.getView();
        boolean isPushOption = false;
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject note = BusinessDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"tm_combreqnote");
        DynamicObjectCollection productTypes = note.getDynamicObjectCollection("producttype");
        if (productTypes.size() == 1) {
            String number = ((DynamicObject)productTypes.get(0)).getDynamicObject("fbasedataid").getString("number");
            boolean isOnlyOption = CombReqNoteEnum.OPTIONS.getProductType().equals(number);
            if (isOnlyOption) {
                DynamicObjectCollection entryEntity = note.getDynamicObjectCollection(CombReqNoteEnum.OPTIONS.getEntryName());
                Set ids = entryEntity.stream().map(e -> e.get(CombReqNoteEnum.OPTIONS.getBillIdName())).collect(Collectors.toSet());
                DynamicObject[] trades = TmcDataServiceHelper.load((String)"tm_forex_options", (String)"id,org,pair,adjexpiredate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                Set collect = Arrays.stream(trades).map(e -> e.getDate("adjexpiredate")).collect(Collectors.toSet());
                Set pairs = Arrays.stream(trades).map(e -> e.getString("pair")).collect(Collectors.toSet());
                Set orgIds = Arrays.stream(trades).map(e -> e.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
                if (collect.size() == 1 && pairs.size() == 1 && orgIds.size() == 1) {
                    isPushOption = true;
                }
            }
        }
        if (isPushOption) {
            view.invokeOperation("pushoptioncomb");
        } else {
            view.invokeOperation("pushcombtrade");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().startsWith("org.")) {
            args.addCustomParam("orgFuncId", (Object)"08");
            this.orgFilter(args.getQfilters());
        }
    }

    private void orgFilter(List<QFilter> qFilters) {
        List<Long> ids = this.getAuthorizedOrgIds();
        if (EmptyUtil.isNoEmpty(ids) && EmptyUtil.isNoEmpty(qFilters)) {
            QFilter filter = new QFilter("id", "in", ids);
            qFilters.add(filter);
        } else {
            qFilters.add(new QFilter("1", "!=", (Object)1));
        }
    }

    public void setFilter(SetFilterEvent e) {
        List<Long> ids = this.getAuthorizedOrgIds();
        List qFilters = e.getQFilters();
        if (EmptyUtil.isNoEmpty(ids)) {
            qFilters.add(new QFilter("org.fbasedataid.id", "in", ids));
        } else {
            qFilters.add(new QFilter("1", "!=", (Object)1));
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if (args.getFieldName().startsWith("org.")) {
            this.orgFilter(args.getQFilters());
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterContainerInitEvent event = args.getFilterContainerInitEvent();
        FilterColumn filterColumn = event.getFilterColumn("org.fbasedataid.name");
        String appid = this.getView().getFormShowParameter().getAppId();
        String defOrgId = this.getPageCache().get(FILTER_DEFAULT_ORG);
        if (EmptyUtil.isEmpty((String)defOrgId)) {
            DynamicObject defOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appid, (String)"tm_combreqnote", (String)"47150e89000000ac");
            defOrgId = defOrg.getString("id");
            this.getPageCache().put(FILTER_DEFAULT_ORG, defOrgId);
        }
        filterColumn.setDefaultValue(defOrgId);
    }

    private List<Long> getAuthorizedOrgIds() {
        String appid = this.getView().getFormShowParameter().getAppId();
        appid = EmptyUtil.isEmpty((String)appid) ? "tm" : appid;
        return TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appid, (String)"tm_combreqnote", (String)"47150e89000000ac");
    }
}

