/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.combtrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class CombTradeEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
HyperLinkClickListener,
TabSelectListener {
    private static final String NUMBER = "number";
    private static final String CALLBACK_ACTION_ADDTRADE = "addtrade";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        if (tabap != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid floatPLEntry = (EntryGrid)this.getView().getControl("floatplamtentity");
        floatPLEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid plEntry = (EntryGrid)this.getView().getControl("plamtentity");
        plEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void tabSelected(TabSelectEvent e) {
        this.buildTab(e.getTabKey());
    }

    private void buildTab(String tab) {
        switch (tab) {
            case "cashflow_tab": {
                this.buildCashFlow();
                break;
            }
            case "plinfo_tab": {
                this.buildPlInfo();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "org": {
                this.changeEntry();
            }
        }
    }

    private void changeEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection trades = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection currOrgs = dataEntity.getDynamicObjectCollection("org");
        ArrayList<Long> orgIds = new ArrayList<Long>(currOrgs.size());
        if (currOrgs.size() > 0) {
            for (DynamicObject currOrg : currOrgs) {
                orgIds.add((Long)((DynamicObject)currOrg.get(1)).getPkValue());
            }
        }
        ArrayList<Integer> deleteIndexs = new ArrayList<Integer>(10);
        for (int i = 0; i < trades.size(); ++i) {
            DynamicObject entryentity = (DynamicObject)trades.get(i);
            DynamicObject tradeOrg = entryentity.getDynamicObject("tradeorg");
            if (tradeOrg == null || orgIds.contains((Long)tradeOrg.getPkValue())) continue;
            deleteIndexs.add(i);
        }
        if (!deleteIndexs.isEmpty()) {
            int[] deleteIndexArrs = new int[deleteIndexs.size()];
            for (int i = 0; i < deleteIndexs.size(); ++i) {
                deleteIndexArrs[i] = (Integer)deleteIndexs.get(i);
            }
            this.getModel().deleteEntryRows("entryentity", deleteIndexArrs);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String billstatus = this.getModel().getDataEntity().getString("billstatus");
        if (TcBillStatusEnum.FINISH.getValue().equals(billstatus)) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryentities = this.getModel().getEntryEntity("entryentity");
        String reqnoteno = (String)this.getModel().getValue("reqnoteno");
        if (entryentities.size() > 0) {
            boolean tradeNotExists = false;
            for (int i = 0; i < entryentities.size(); ++i) {
                DynamicObject entryentity = (DynamicObject)entryentities.get(i);
                long id = entryentity.getLong("tradebill");
                String tradeBillEntity = entryentity.getString("tradebillentity");
                if (id == 0L) continue;
                if (TmcDataServiceHelper.exists((Object)id, (String)tradeBillEntity)) {
                    DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)tradeBillEntity);
                    this.fillEntry(bill, i);
                    continue;
                }
                tradeNotExists = true;
            }
            if (tradeNotExists) {
                if (EmptyUtil.isEmpty((String)reqnoteno)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u5b9a\u4e49\u4e2d\u90e8\u5206\u4ea4\u6613\u5355\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u7ec4\u5408\u3002", (String)"CombTradeEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u4ea4\u6613\u5355\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5220\u9664\u672c\u5355\u636e\u540e\u91cd\u65b0\u4e0b\u63a8\u3002", (String)"CombTradeEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if (EmptyUtil.isNoEmpty((String)reqnoteno)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        } else if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"org"});
        }
        Tab tabap = (Tab)this.getView().getControl("tabap");
        this.buildTab(tabap.getCurrentTab());
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().setValue("reqnoteno", null);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"org"});
    }

    private void setDataChanged(boolean value) {
        if (!value) {
            this.getModel().setDataChanged(value);
        }
    }

    private void buildPlInfo() {
        List<Long> tradeIds;
        boolean isDataChange = this.getModel().getDataChanged();
        this.getModel().beginInit();
        boolean removedItemFlag = this.getModel().getDataEntity().getDataEntityState().getRemovedItems();
        this.getModel().deleteEntryData("floatplamtentity");
        this.getModel().deleteEntryData("plamtentity");
        if (!removedItemFlag) {
            this.getModel().getDataEntity().getDataEntityState().setRemovedItems(Boolean.FALSE);
        }
        if (!EmptyUtil.isEmpty(tradeIds = this.getTradeIds())) {
            QFilter qFilter = new QFilter("tradebill", "in", tradeIds);
            List<Map<String, Object>> floatplamtList = this.getFloatPlMaps(qFilter);
            List<Map<String, Object>> plamtList = this.getPLMaps(qFilter);
            if (EmptyUtil.isNoEmpty(floatplamtList)) {
                TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"floatplamtentity", floatplamtList, (boolean)false);
            }
            if (EmptyUtil.isNoEmpty(plamtList)) {
                TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"plamtentity", plamtList, (boolean)false);
            }
        }
        this.getModel().endInit();
        this.setDataChanged(isDataChange);
        this.getView().updateView("floatplamtentity");
        this.getView().updateView("plamtentity");
    }

    private List<Map<String, Object>> getPLMaps(QFilter qFilter) {
        DynamicObjectCollection pls = QueryServiceHelper.query((String)"tbo_plinfo", (String)"id,billno,tradetype,entrys.bizbillplcurrency, localcurrency, entrys.bizdate,entrys.settledate,entrys.biztype, entrys.plamt,entrys.pllocalamt, tradebill.number", (QFilter[])new QFilter[]{qFilter.and(new QFilter("entrys.id", "!=", (Object)0L))});
        ArrayList<Map<String, Object>> plamtList = new ArrayList<Map<String, Object>>(pls.size());
        int plamtIndex = 0;
        for (DynamicObject pl : pls) {
            Long plcurrencyId = pl.getLong("entrys.bizbillplcurrency");
            Long localcurrencyId = pl.getLong("localcurrency");
            HashMap<String, Object> plamtEntryMap = new HashMap<String, Object>(16);
            plamtEntryMap.put("pltradebill", pl.getString("tradebill.number"));
            plamtEntryMap.put("plinfobillno", pl.getString("billno"));
            plamtEntryMap.put("plinfoid", pl.getLong("id"));
            plamtEntryMap.put("plprotecttype", pl.getLong("tradetype"));
            plamtEntryMap.put("plcurrency", plcurrencyId);
            plamtEntryMap.put("biztype", pl.getString("entrys.biztype"));
            plamtEntryMap.put("opreatdate", pl.getDate("entrys.bizdate"));
            plamtEntryMap.put("settledate", pl.getDate("entrys.settledate"));
            plamtEntryMap.put("plamt", pl.getBigDecimal("entrys.plamt"));
            plamtEntryMap.put("plocalcurrency", localcurrencyId);
            plamtEntryMap.put("pllocalamt", plcurrencyId.equals(localcurrencyId) ? pl.getBigDecimal("entrys.plamt") : pl.getBigDecimal("entrys.pllocalamt"));
            plamtEntryMap.put("plorder", ++plamtIndex);
            plamtList.add(plamtEntryMap);
        }
        return plamtList;
    }

    private List<Map<String, Object>> getFloatPlMaps(QFilter qFilter) {
        DynamicObjectCollection floatPls = QueryServiceHelper.query((String)"tbo_plinfo", (String)"id,billno,bizop, tradetype,tradebill.number,localcurrency, plcurrency,floatplamt,floatpllocalamt, maxhistoryplinfo.updatedate, maxhistoryplinfo.floatplamt, maxhistoryplinfo.floatpllocalamt", (QFilter[])new QFilter[]{qFilter, new QFilter("tradetype.id", "!=", (Object)Long.parseLong(ProductTypeEnum.FOREXSPOT.getId()))});
        ArrayList<Map<String, Object>> floatplamtList = new ArrayList<Map<String, Object>>(floatPls.size());
        for (int i = 0; i < floatPls.size(); ++i) {
            DynamicObject floatPl = (DynamicObject)floatPls.get(i);
            Long plcurrencyId = floatPl.getLong("plcurrency");
            Long localcurrencyId = floatPl.getLong("localcurrency");
            Long tradetype = floatPl.getLong("tradetype");
            HashMap<String, Object> floatPlMap = new HashMap<String, Object>(16);
            floatPlMap.put("ftradebill", floatPl.getString("tradebill.number"));
            floatPlMap.put("fplinfobillno", floatPl.getString("billno"));
            floatPlMap.put("fplinfoid", floatPl.getLong("id"));
            floatPlMap.put("fplprotecttype", tradetype);
            if (Long.parseLong(ProductTypeEnum.STRUCTDEPOSIT.getId()) == tradetype) {
                floatPlMap.put("floatplamt", floatPl.getBigDecimal("floatplamt"));
                floatPlMap.put("floatpllocalamt", floatPl.getBigDecimal("floatpllocalamt"));
            } else {
                floatPlMap.put("fplupdatedate", floatPl.getDate("maxhistoryplinfo.updatedate"));
                floatPlMap.put("floatplamt", floatPl.getBigDecimal("maxhistoryplinfo.floatplamt"));
                floatPlMap.put("floatpllocalamt", floatPl.getBigDecimal("maxhistoryplinfo.floatpllocalamt"));
            }
            if (plcurrencyId != null && plcurrencyId.equals(localcurrencyId)) {
                floatPlMap.put("floatpllocalamt", floatPlMap.get("floatplamt"));
            }
            floatPlMap.put("fplcurrency", plcurrencyId);
            floatPlMap.put("flocalcurrency", localcurrencyId);
            String bizop = floatPl.getString("bizop");
            List<String> ctypeDefer = Arrays.asList("defer", "defer_f", "defer_n");
            List<String> ctypeMaudate = Arrays.asList("maudate", "maudate_n", "maudate_f");
            String ctype = "original";
            if (ctypeDefer.contains(bizop)) {
                ctype = "defer";
            } else if (ctypeMaudate.contains(bizop)) {
                ctype = "early";
            }
            floatPlMap.put("fplcontracttype", ctype);
            floatPlMap.put("forder", i + 1);
            floatplamtList.add(floatPlMap);
        }
        return floatplamtList;
    }

    private List<Long> getTradeIds() {
        DynamicObjectCollection billEntrys = this.getModel().getEntryEntity("entryentity");
        return billEntrys.stream().filter(v -> v.getLong("tradebill") != 0L).map(v -> v.getLong("tradebill")).collect(Collectors.toList());
    }

    private void buildCashFlow() {
        List<Map<String, Object>> rowlist;
        List<Long> tradeIds;
        boolean isDataChange = this.getModel().getDataChanged();
        boolean removedItemFlag = this.getModel().getDataEntity().getDataEntityState().getRemovedItems();
        this.getModel().beginInit();
        this.getModel().deleteEntryData("cashflow");
        if (!removedItemFlag) {
            this.getModel().getDataEntity().getDataEntityState().setRemovedItems(Boolean.FALSE);
        }
        if (!EmptyUtil.isEmpty(tradeIds = this.getTradeIds()) && EmptyUtil.isNoEmpty(rowlist = this.getCashFlowMaps(tradeIds))) {
            TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"cashflow", rowlist, (boolean)false);
        }
        this.getModel().endInit();
        this.setDataChanged(isDataChange);
        this.getView().updateView("cashflow");
    }

    private List<Map<String, Object>> getCashFlowMaps(List<Long> tradeIds) {
        QFilter cfQF = new QFilter("billid", "in", (Object)tradeIds.toArray());
        String cfSelectFields = "cftype,cfpayamount,cfcurrency,cfpaydate,billid,billnumber,billno,cfishis";
        DataSet cfDS = QueryServiceHelper.queryDataSet((String)"combtrade-case-dataset", (String)"tm_cashflow", (String)cfSelectFields, (QFilter[])new QFilter[]{cfQF}, (String)"billnumber,billno asc");
        QFilter tradeQF = new QFilter("id", "in", (Object)tradeIds.toArray());
        DataSet tradeDS = QueryServiceHelper.queryDataSet((String)"combtrade-dataset", (String)"tm_trade", (String)"id,protecttype", (QFilter[])tradeQF.toArray(), null);
        cfDS = cfDS.join(tradeDS).on("billid", "id").select(cfSelectFields.split(","), new String[]{"protecttype"}).finish().orderBy(new String[]{"billnumber", "billno"});
        ArrayList<Map<String, Object>> rowlist = new ArrayList<Map<String, Object>>(16);
        int i = 0;
        for (Row row : cfDS) {
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            map.put("cftype", row.getString("cftype"));
            map.put("cfpayamount", row.getBigDecimal("cfpayamount"));
            map.put("cfcurrency", row.getLong("cfcurrency"));
            map.put("cfpaydate", row.getDate("cfpaydate"));
            map.put("cfbillno", row.getString("billnumber"));
            map.put("cfishis", row.getBoolean("cfishis"));
            map.put("cfprotecttype", row.getLong("protecttype"));
            map.put("no", ++i);
            rowlist.add(map);
        }
        return rowlist;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)CALLBACK_ACTION_ADDTRADE, (CharSequence)formOperate.getOperateKey())) {
            this.addTrade(args);
        }
    }

    private void addTrade(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgs.size() == 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u4ea4\u6613\u4e3b\u4f53\u3002", (String)"CombTradeEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"tm_trade_f7", (boolean)true, (int)0, (boolean)true);
        showParameter.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        showParameter.setCustomParam("isF7", (Object)Boolean.TRUE);
        showParameter.setShowTitle(false);
        Object[] productTypes = new String[]{"01FOREX", ProductTypeEnum.FOREXSPOT.getValue(), ProductTypeEnum.FOREXFORWARD.getValue(), ProductTypeEnum.FOREXSWAPS.getValue(), ProductTypeEnum.FOREXOPTION.getValue(), "03RATE", ProductTypeEnum.SWAP.getValue(), "05STRUCT", ProductTypeEnum.STRUCTDEPOSIT.getValue()};
        String productTypesStr = StringUtils.join((Object[])productTypes, (String)",");
        showParameter.setCustomParam("NeedBillType", (Object)productTypesStr);
        showParameter.setCustomParam("isCombTrade", (Object)true);
        showParameter.setCustomParam("filterBillType", Arrays.asList(Long.valueOf(ProductTypeEnum.FOREXSPOT.getId()), Long.valueOf(ProductTypeEnum.FOREXFORWARD.getId()), Long.valueOf(ProductTypeEnum.FOREXSWAPS.getId()), Long.valueOf(ProductTypeEnum.FOREXOPTION.getId()), Long.valueOf(ProductTypeEnum.SWAP.getId()), Long.valueOf(ProductTypeEnum.STRUCTDEPOSIT.getId())));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_ACTION_ADDTRADE));
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        ArrayList<Long> orgIds = new ArrayList<Long>(orgs.size());
        for (DynamicObject org : orgs) {
            Long id = (Long)org.getDynamicObject(1).get("id");
            orgIds.add(id);
        }
        QFilter qFilter = new QFilter("org.id", "in", orgIds);
        String[] billStatus = new String[]{TcBillStatusEnum.AUDIT.getValue(), TcBillStatusEnum.SURVIVAL.getValue()};
        QFilter qQFilter = new QFilter("composeaudit", "=", (Object)Boolean.TRUE).and(new QFilter("billstatus", "=", (Object)TcBillStatusEnum.SUBMIT.getValue()));
        qFilter.and(new QFilter("billstatus", "in", (Object)billStatus).or(qQFilter));
        DynamicObjectCollection oldEntrys = this.getModel().getEntryEntity("entryentity");
        qFilter.and(QFilter.isNull((String)"composeno").or(new QFilter("composeno", "=", (Object)"").or(new QFilter("composeno", "=", (Object)" "))));
        qFilter.and("source", "not like", (Object)"combreqnote_%");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)oldEntrys)) {
            List tradeList = oldEntrys.stream().map(s -> s.getLong("tradebill")).collect(Collectors.toList());
            ArrayList<Long> tradeIds = new ArrayList<Long>(10);
            DynamicObjectCollection trades = QueryServiceHelper.query((String)"tm_trade", (String)String.join((CharSequence)",", "billno", "id", "billstatus", "composeno", "composeaudit"), (QFilter[])new QFilter[]{new QFilter("id", "in", tradeList)});
            for (DynamicObject trade : trades) {
                boolean validStatus;
                String billstatus = trade.getString("billstatus");
                String composeno = trade.getString("composeno");
                boolean composeaudit = trade.getBoolean("composeaudit");
                boolean bl = validStatus = TcBillStatusEnum.AUDIT.getValue().equals(billstatus) || TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus) || TcBillStatusEnum.SUBMIT.getValue().equals(billstatus) && Boolean.TRUE.equals(composeaudit);
                if (!validStatus || !EmptyUtil.isEmpty((String)composeno)) {
                    String msg = ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u5df2\u4e0d\u6ee1\u8db3\u6784\u5efa\u7ec4\u5408\u7684\u6761\u4ef6\u3002", (String)"CombTradeEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{trade.getString("billno")});
                    this.getView().showTipNotification(msg);
                    continue;
                }
                tradeIds.add(trade.getLong("id"));
            }
            if (tradeIds.size() > 0) {
                qFilter.or(new QFilter("id", "in", tradeIds));
                showParameter.setSelectedRows(tradeIds.toArray());
            }
        }
        qFilters.add(qFilter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex;
        String fieldName = event.getFieldName();
        if ("tradebillno".equals(fieldName)) {
            rowIndex = event.getRowIndex();
            String billentity = (String)this.getModel().getValue("tradebillentity", rowIndex);
            BillShowParameter param = new BillShowParameter();
            param.setFormId(billentity);
            param.setPkId(this.getModel().getValue("tradebill", rowIndex));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
        if ("fplinfobillno".equals(fieldName) || "plinfobillno".equals(fieldName)) {
            rowIndex = event.getRowIndex();
            String prop = "fplinfobillno".equals(fieldName) ? "fplinfoid" : "plinfoid";
            Long plId = (Long)this.getModel().getValue(prop, rowIndex);
            BillShowParameter param = new BillShowParameter();
            param.setFormId("tbo_plinfo");
            param.setPkId((Object)plId);
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        Object returnData1;
        super.closedCallBack(event);
        String action = event.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)CALLBACK_ACTION_ADDTRADE) && (returnData1 = event.getReturnData()) instanceof Map && EmptyUtil.isNoEmpty((Object)(returnData = (Map)event.getReturnData())) && returnData.size() > 0) {
            this.getModel().deleteEntryData("entryentity");
            for (Map.Entry entry : returnData.entrySet()) {
                String id = (String)entry.getKey();
                String tradeBillEntity = (String)entry.getValue();
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)tradeBillEntity);
                this.fillEntry(bill, rowIndex);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void fillEntry(DynamicObject bill, int rowIndex) {
        DynamicObject productType = bill.getDynamicObject("protecttype");
        this.getModel().setValue("tradebill", bill.getPkValue(), rowIndex);
        this.getModel().setValue("billorg", bill.getDynamicObject("org").getPkValue(), rowIndex);
        this.getModel().setValue("tradebillentity", (Object)bill.getDataEntityType().getName(), rowIndex);
        this.getModel().setValue("tradebillno", bill.get("billno"), rowIndex);
        this.getModel().setValue("protecttype", (Object)productType, rowIndex);
        this.getModel().setValue("tradedate", bill.get("bizdate"), rowIndex);
        this.getModel().setValue("counterparty", bill.get("counterparty"), rowIndex);
        this.getModel().setValue("tradestatus", bill.get("billstatus"), rowIndex);
        this.getModel().setValue("adjustsettledate", bill.get("adjustsettledate"), rowIndex);
        this.getModel().setValue("tradeorg", bill.get("org"), rowIndex);
        this.setCurrency(productType, bill, rowIndex);
        this.setTradeDirect(productType, bill, rowIndex);
        this.setAmout(productType, bill, rowIndex);
    }

    private void setAmout(DynamicObject protectType, DynamicObject bill, int rowIndex) {
        String protectTypeNumber = protectType.getString(NUMBER);
        List<String> protectTypeNumbers = Arrays.asList(ProductTypeEnum.FOREXSPOT.getValue(), ProductTypeEnum.FOREXFORWARD.getValue(), ProductTypeEnum.FOREXOPTION.getValue(), ProductTypeEnum.FOREXSWAPS.getValue());
        if (protectTypeNumbers.contains(protectTypeNumber)) {
            this.getModel().setValue("amount1", bill.get("amount"), rowIndex);
            this.getModel().setValue("amount2", bill.get("sellamount"), rowIndex);
        } else if (ProductTypeEnum.SWAP.getValue().equals(protectTypeNumber)) {
            this.getModel().setValue("amount1", bill.get("amount"), rowIndex);
            this.getModel().setValue("amount2", bill.get("recamount"), rowIndex);
        } else if (ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(protectTypeNumber)) {
            this.getModel().setValue("amount1", bill.get("amount"), rowIndex);
        }
    }

    private void setTradeDirect(DynamicObject protectType, DynamicObject bill, int rowIndex) {
        String protectTypeNumber = protectType.getString(NUMBER);
        List<String> protectTypeNumbers = Arrays.asList(ProductTypeEnum.FOREXSPOT.getValue(), ProductTypeEnum.FOREXFORWARD.getValue(), ProductTypeEnum.FOREXSWAPS.getValue(), ProductTypeEnum.FOREXOPTION.getValue(), ProductTypeEnum.STRUCTDEPOSIT.getValue());
        if (protectTypeNumbers.contains(protectTypeNumber)) {
            this.getModel().setValue("tradedirect", bill.get("tradedirect"), rowIndex);
        }
    }

    private void setCurrency(DynamicObject protectType, DynamicObject bill, int rowIndex) {
        String protectTypeNumber = protectType.getString(NUMBER);
        List<String> protectTypeNumbers = Arrays.asList(ProductTypeEnum.FOREXSPOT.getValue(), ProductTypeEnum.FOREXFORWARD.getValue(), ProductTypeEnum.FOREXSWAPS.getValue(), ProductTypeEnum.FOREXOPTION.getValue());
        if (protectTypeNumbers.contains(protectTypeNumber)) {
            String pair = bill.getString("pair");
            if (EmptyUtil.isEmpty((String)pair)) {
                return;
            }
            String[] pairs = pair.split("/");
            String leftCurrency = pairs[0];
            DynamicObject currency1 = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)leftCurrency)});
            this.getModel().setValue("currency1", (Object)currency1, rowIndex);
            if (pairs.length >= 2) {
                String rightCurrency = pairs[1];
                DynamicObject currency2 = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)rightCurrency)});
                this.getModel().setValue("currency2", (Object)currency2, rowIndex);
            }
        } else if (ProductTypeEnum.SWAP.getValue().equals(protectTypeNumber)) {
            this.getModel().setValue("currency1", bill.get("currency"), rowIndex);
            this.getModel().setValue("currency2", bill.get("reccurrency"), rowIndex);
        } else if (ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(protectTypeNumber)) {
            this.getModel().setValue("currency1", bill.get("currency"), rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("org".equals(name)) {
            String appid = this.getView().getFormShowParameter().getAppId();
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appid, (String)"tm_combtrade", (String)"47150e89000000ac");
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (!EmptyUtil.isEmpty((Collection)orgIds)) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIds));
            } else {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("1", "!=", (Object)1));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && opResult.isSuccess()) {
            switch (opKey) {
                case "save": 
                case "submit": 
                case "unaudit": 
                case "audit": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
            }
        }
    }
}

