/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.PlConfirmStatusEnum;

public abstract class AbsForexTrade2ExpireDeyConvertPlugin
extends AbstractConvertPlugIn {
    protected void set(DynamicObject bizBill, DynamicObject tradeBill, DynamicObject bizRecord, Date bizDate) {
        BigDecimal restAmt = bizRecord.getBigDecimal("restAmt");
        BigDecimal exRate = bizRecord.getBigDecimal("exRate");
        String fxQuote = tradeBill.getString("fxquote");
        DynamicObject leftCurrency = tradeBill.getDynamicObject("currency");
        DynamicObject rightCurrency = tradeBill.getDynamicObject("sellcurrency");
        int amtPrecision = rightCurrency.getInt("amtPrecision");
        String currencyNumber = leftCurrency.getString("number");
        BigDecimal bizAmt2 = fxQuote.startsWith(currencyNumber) ? restAmt.multiply(exRate).setScale(amtPrecision, RoundingMode.HALF_UP) : (EmptyUtil.isEmpty((BigDecimal)exRate) ? BigDecimal.ZERO : restAmt.divide(exRate, amtPrecision, RoundingMode.HALF_UP));
        bizBill.set("bizamt1", (Object)restAmt);
        bizBill.set("bizamt2", (Object)bizAmt2);
        bizBill.set("bizdate", (Object)bizDate);
        bizBill.set("paycurrency", tradeBill.get("sell_currency"));
        bizBill.set("reccurrency", tradeBill.get("buy_currency"));
        bizBill.set("fq", tradeBill.get("fxquote"));
        bizBill.set("deliverydate", (Object)bizDate);
        bizBill.set("bizrecordid", bizRecord.get("id"));
        bizBill.set("restamt_src", (Object)restAmt);
        bizBill.set("exrate_src", (Object)exRate);
        bizBill.set("date_src", (Object)bizDate);
        bizBill.set("enddate_src", bizRecord.get("endDate"));
        bizBill.set("isplconfirm", (Object)true);
        bizBill.set("plconfirmstatus", (Object)PlConfirmStatusEnum.Confirmed.getValue());
    }

    protected void setBaseInfo_PL(Date currentDate, DynamicObject bizBill, DynamicObject tradeBill, DynamicObject plCurrency, DynamicObject localCurrency, BigDecimal pl) {
        long localCurrencyId = localCurrency.getLong("id");
        if (plCurrency.getLong("id") != localCurrencyId) {
            BigDecimal baseAmt;
            BigDecimal baseExRate;
            if (tradeBill.getDynamicObject("pricerule") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613%s\u672a\u8bbe\u7f6e\u5b9a\u4ef7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizBillEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{tradeBill.getString("number")}));
            }
            String pair = localCurrency.getString("number") + "/" + plCurrency.getString("number");
            Long priceRuleId = tradeBill.getDynamicObject("pricerule").getLong("id");
            DynamicObject priceRule = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexQuote.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)priceRuleId)});
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexQuote.id"), (String)pair, (Date)currentDate, null);
            bizBill.set("basefq", (Object)fqInfo.getFxquote());
            int amtPrecision = localCurrency.getInt("amtPrecision");
            if (plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0])) {
                baseExRate = fqInfo.getBuyPrice();
                baseAmt = pl.multiply(baseExRate).setScale(amtPrecision, RoundingMode.HALF_UP);
            } else {
                baseExRate = fqInfo.getSellPrice();
                baseAmt = pl.divide(baseExRate, amtPrecision, RoundingMode.HALF_UP);
            }
            bizBill.set("baseexrate", (Object)baseExRate);
            bizBill.set("baseplamt", (Object)baseAmt);
        }
    }

    protected void setVoucherPl(Date bizDate, DynamicObject bizBill, DynamicObject tradeBill, DynamicObject localCurrency) {
        BigDecimal sellExAmt;
        BigDecimal sellExRate;
        BigDecimal buyExAmt;
        BigDecimal buyExRate;
        BigDecimal sellAmt;
        BigDecimal buyAmt;
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        if (BizOperateEnum.expiredey_f.getValue().equals(bizBill.get("operate"))) {
            buyCurrency = tradeBill.getDynamicObject("sell_currency");
            sellCurrency = tradeBill.getDynamicObject("buy_currency");
            buyAmt = tradeBill.getBigDecimal("sell_amount");
            sellAmt = tradeBill.getBigDecimal("buy_amount");
        } else {
            buyCurrency = tradeBill.getDynamicObject("buy_currency");
            sellCurrency = tradeBill.getDynamicObject("sell_currency");
            buyAmt = tradeBill.getBigDecimal("buy_amount");
            sellAmt = tradeBill.getBigDecimal("sell_amount");
        }
        int buyAmtPrecision = buyCurrency.getInt("amtPrecision");
        buyAmt = buyAmt.setScale(buyAmtPrecision, RoundingMode.HALF_UP);
        int sellAmtPrecision = sellCurrency.getInt("amtPrecision");
        sellAmt = sellAmt.setScale(sellAmtPrecision, RoundingMode.HALF_UP);
        String buyCurrencyNumber = buyCurrency.getString("number");
        String sellCurrencyNumber = sellCurrency.getString("number");
        int amtPrecision = localCurrency.getInt("amtPrecision");
        DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
        ForexQuoteInfo buyCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexQuote.id"), (String)(buyCurrencyNumber + "/" + localCurrency.getString("number")), (Date)bizDate, null);
        String buyCurFxQuote = buyCurFqInfo.getFxquote();
        if (buyCurrencyNumber.equals(buyCurFxQuote.split("/")[0])) {
            buyExRate = buyCurFqInfo.getBuyPrice();
            buyExAmt = buyAmt.multiply(buyExRate).setScale(amtPrecision, RoundingMode.HALF_UP);
        } else {
            buyExRate = buyCurFqInfo.getSellPrice();
            buyExAmt = buyAmt.divide(buyExRate, amtPrecision, RoundingMode.HALF_UP);
        }
        ForexQuoteInfo sellCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexQuote.id"), (String)(sellCurrencyNumber + "/" + localCurrency.getString("number")), (Date)bizDate, null);
        String sellCurFxQuote = sellCurFqInfo.getFxquote();
        if (sellCurrencyNumber.equals(sellCurFxQuote.split("/")[0])) {
            sellExRate = sellCurFqInfo.getBuyPrice();
            sellExAmt = sellAmt.multiply(sellExRate).setScale(amtPrecision, RoundingMode.HALF_UP);
        } else {
            sellExRate = sellCurFqInfo.getSellPrice();
            sellExAmt = sellAmt.divide(sellExRate, amtPrecision, RoundingMode.HALF_UP);
        }
        bizBill.set("buy_local_fq", (Object)buyCurFxQuote);
        bizBill.set("buy_local_exrate", (Object)buyExRate);
        bizBill.set("sell_local_fq", (Object)sellCurFxQuote);
        bizBill.set("sell_local_exrate", (Object)sellExRate);
        bizBill.set("voucher_pl", (Object)buyExAmt.subtract(sellExAmt));
    }

    protected DynamicObject queryLocalCurrency(DynamicObject bizBill) {
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)bizBill.getDynamicObject("org").getLong("id"));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        if (EmptyUtil.isEmpty((Long)localCurrencyId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5f53\u524d\u4ea4\u6613\u4e3b\u4f53\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u3002", (String)"BizBillEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        return TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
    }

    protected void validate(Date currentDate, DynamicObject tradeBill, DynamicObjectCollection bizRecordCol) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)bizRecordCol)) {
            throw new KDBizException(ResManager.loadKDString((String)"%1$s\u65e5\u975e\u201c%2$s\u201d\u7684\u4ea4\u5272\u65e5\u6216\u4e0d\u5728\u4ea4\u5272\u65e5\u533a\u95f4\u5185\u3002", (String)"AbsForexTrade2ExpireDeyConvertPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{DateUtils.formatString((Date)currentDate, (String)"yyyy-MM-dd"), tradeBill.get("billno")}));
        }
    }
}

