/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.ExRateTypeEnum;
import kd.tmc.tm.common.enums.ExchangeBillTypeEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import org.apache.commons.lang.StringUtils;

public class BizBill2ExchangeBillConvertPlugin
extends AbstractConvertPlugIn {
    private List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("id");
        sic.add("billno");
        sic.add("settleamount");
        sic.add("settlecurrency");
        sic.add("operate");
        sic.add("cashflow");
        sic.add("tradebill");
        sic.add("isrollsettle");
        sic.add("cfpayamount");
        sic.add("bizamt1");
        sic.add("bizamt2");
        sic.add("deliverydate");
        sic.add("plcurrency");
        sic.add("plamt");
        sic.add("plsettledate");
        sic.add("protecttype");
        sic.add("paycurrency");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        sic.add("basecurrency");
        sic.add("execexrate");
        sic.add("sell_local_fq");
        sic.add("buy_local_fq");
        sic.add("buy_local_exrate");
        sic.add("sell_local_exrate");
        sic.add("voucher_pl");
        sic.add("fq");
        sic.add("bizdate");
        sic.add("exratecalmtd");
        sic.add("spotrate_dey");
        return sic;
    }

    public void beforeGetSourceData(BeforeGetSourceDataEventArgs e) {
        if (!EmptyUtil.isNoEmpty((Object)this.getOption()) || !this.getOption().containsVariable("call_by_settle")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u901a\u8fc7\u7ed3\u7b97\u751f\u6210\u5916\u6c47\u5151\u6362\u5355\u3002", (String)"BizBillEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] targetExtDataEntitySet;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : targetExtDataEntitySet = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject exchangeBill = dataEntity.getDataEntity();
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            Object srcId = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName(), (String)StringUtils.join(this.getSelector(), (String)","));
            this.setValue(exchangeBill, bizBill);
            this.setSource(exchangeBill, bizBill);
        }
    }

    protected void setSource(DynamicObject exchangeBill, DynamicObject bizBill) {
    }

    private void setValue(DynamicObject exchangeBill, DynamicObject bizBill) {
        String operate = bizBill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        switch (bizOp) {
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: 
            case expiredey: 
            case expiredey_f: 
            case expiredey_n: 
            case interestpay: 
            case capitalpay: 
            case exercise: {
                this.setValue(exchangeBill, bizBill, tradeBill);
                break;
            }
        }
    }

    private void setValue(DynamicObject exchangeBill, DynamicObject bizBill, DynamicObject tradeBill) {
        String buyCurrencyNumber;
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        BigDecimal sellAmount;
        BigDecimal buyAmount;
        exchangeBill.set("bizdate", (Object)TcDateUtils.getCurrentDate());
        exchangeBill.set("exratedate", bizBill.get("bizdate"));
        DynamicObject protectType = tradeBill.getDynamicObject("protecttype");
        String fxquote = tradeBill.getString("fxquote");
        if (EmptyUtil.isEmpty((String)fxquote)) {
            fxquote = this.getFxquote(tradeBill, fxquote);
        }
        String protectId = protectType.getString("id");
        String op = bizBill.getString("operate");
        if (ProductTypeEnum.SWAP.getId().equals(protectId)) {
            buyAmount = bizBill.getBigDecimal("bizamt2");
            sellAmount = bizBill.getBigDecimal("bizamt1");
            buyCurrency = tradeBill.getDynamicObject("reccurrency");
            sellCurrency = tradeBill.getDynamicObject("currency");
            exchangeBill.set("exchangedate", bizBill.get("plsettledate"));
        } else {
            boolean flag = true;
            String tradeType = tradeBill.getString("tradetype");
            String dir = tradeBill.getString("tradedirect");
            if (ProductTypeEnum.FOREXOPTION.getId().equals(protectId)) {
                if (OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir)) {
                    flag = false;
                }
            } else if (op.indexOf("_f") < 0 && "sell".equals(dir) || op.indexOf("_f") > 0 && "buy".equals(dir)) {
                flag = false;
            }
            if (flag) {
                buyAmount = bizBill.getBigDecimal("bizamt1");
                sellAmount = bizBill.getBigDecimal("bizamt2");
                buyCurrency = tradeBill.getDynamicObject("currency");
                sellCurrency = tradeBill.getDynamicObject("sellcurrency");
            } else {
                buyAmount = bizBill.getBigDecimal("bizamt2");
                sellAmount = bizBill.getBigDecimal("bizamt1");
                buyCurrency = tradeBill.getDynamicObject("sellcurrency");
                sellCurrency = tradeBill.getDynamicObject("currency");
            }
            exchangeBill.set("exchangedate", bizBill.get("deliverydate"));
        }
        int buyAmtPrecision = buyCurrency.getInt("amtprecision");
        buyAmount = buyAmount.setScale(buyAmtPrecision, 4);
        int sellAmtPrecision = sellCurrency.getInt("amtprecision");
        sellAmount = sellAmount.setScale(sellAmtPrecision, 4);
        exchangeBill.set("buyingcurrency", (Object)buyCurrency);
        exchangeBill.set("sellingcurrency", (Object)sellCurrency);
        exchangeBill.set("buyamount", (Object)buyAmount);
        exchangeBill.set("sellamount", (Object)sellAmount);
        DynamicObject baseCurrency = bizBill.getDynamicObject("basecurrency");
        if (baseCurrency == null) {
            Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradeBill.getDynamicObject("org").getLong("id"));
            Long baseCurrencyId = (Long)result.get("baseCurrencyID");
            if (EmptyUtil.isEmpty((Long)baseCurrencyId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5f53\u524d\u4ea4\u6613\u4e3b\u4f53\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u3002", (String)"BizBillEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            baseCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)baseCurrencyId, (String)"bd_currency");
        }
        if (baseCurrency.getLong("id") != buyCurrency.getLong("id") && baseCurrency.getLong("id") != sellCurrency.getLong("id")) {
            exchangeBill.set("biztype", (Object)ExchangeBillTypeEnum.EXCHANGEBILL.getValue());
            exchangeBill.set("buyingexchangerate", bizBill.get("buy_local_exrate"));
            exchangeBill.set("sellingexchangerate", bizBill.get("sell_local_exrate"));
            buyCurrencyNumber = buyCurrency.getString("number");
            if (buyCurrencyNumber.equals(bizBill.getString("buy_local_fq").split("/")[0])) {
                exchangeBill.set("quotation", (Object)ExRateTypeEnum.direct.getValue());
            } else {
                exchangeBill.set("quotation", (Object)ExRateTypeEnum.indirect.getValue());
            }
            String sellCurrencyNumber = sellCurrency.getString("number");
            if (sellCurrencyNumber.equals(bizBill.getString("sell_local_fq").split("/")[0])) {
                exchangeBill.set("salequotation", (Object)ExRateTypeEnum.direct.getValue());
            } else {
                exchangeBill.set("salequotation", (Object)ExRateTypeEnum.indirect.getValue());
            }
        } else if (baseCurrency.getLong("id") == buyCurrency.getLong("id")) {
            exchangeBill.set("biztype", (Object)ExchangeBillTypeEnum.EXCHANGESETTLEMENTBILL.getValue());
            exchangeBill.set("buyingexchangerate", (Object)BigDecimal.ONE);
            if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectId) && (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(tradeBill.getString("swaptype")) || ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(tradeBill.getString("swaptype"))) && BizOperateEnum.expiredey_n.getValue().equals(op)) {
                exchangeBill.set("sellingexchangerate", tradeBill.get("spotrate"));
            } else if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectId) && ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(tradeBill.getString("swaptype")) && BizOperateEnum.expiredey_f.getValue().equals(op)) {
                exchangeBill.set("sellingexchangerate", tradeBill.get("forwrate"));
            } else if (ProductTypeEnum.FOREXSPOT.getId().equals(protectId) && BizOperateEnum.expiredey.getValue().equals(op)) {
                exchangeBill.set("sellingexchangerate", tradeBill.get("spotrate"));
            } else {
                exchangeBill.set("sellingexchangerate", bizBill.get("execexrate"));
            }
            exchangeBill.set("quotation", (Object)ExRateTypeEnum.direct.getValue());
            String sellCurrencyNumber = sellCurrency.getString("number");
            if (sellCurrencyNumber.equals(fxquote.split("/")[0])) {
                exchangeBill.set("salequotation", (Object)ExRateTypeEnum.direct.getValue());
            } else {
                exchangeBill.set("salequotation", (Object)ExRateTypeEnum.indirect.getValue());
            }
        } else {
            exchangeBill.set("biztype", (Object)ExchangeBillTypeEnum.EXCHANGPAYEBILL.getValue());
            exchangeBill.set("sellingexchangerate", (Object)BigDecimal.ONE);
            if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectId) && (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(tradeBill.getString("swaptype")) || ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(tradeBill.getString("swaptype"))) && BizOperateEnum.expiredey_n.getValue().equals(op)) {
                exchangeBill.set("buyingexchangerate", tradeBill.get("spotrate"));
            } else if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectId) && ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(tradeBill.getString("swaptype")) && BizOperateEnum.expiredey_f.getValue().equals(op)) {
                exchangeBill.set("buyingexchangerate", tradeBill.get("forwrate"));
            } else if (ProductTypeEnum.FOREXSPOT.getId().equals(protectId) && BizOperateEnum.expiredey.getValue().equals(op)) {
                exchangeBill.set("buyingexchangerate", tradeBill.get("spotrate"));
            } else if ((ProductTypeEnum.FOREXFORWARD.getId().equals(protectId) && BizOperateEnum.bdelivery.getValue().equals(op) || ProductTypeEnum.FOREXSWAPS.getId().equals(protectId) && (BizOperateEnum.bdelivery_n.getValue().equals(op) || BizOperateEnum.bdelivery_f.getValue().equals(op))) && ExRateCalMethodEnum.Rate.getValue().equals(bizBill.get("exratecalmtd"))) {
                exchangeBill.set("buyingexchangerate", bizBill.get("spotrate_dey"));
            } else {
                exchangeBill.set("buyingexchangerate", bizBill.get("execexrate"));
            }
            exchangeBill.set("salequotation", (Object)ExRateTypeEnum.direct.getValue());
            buyCurrencyNumber = buyCurrency.getString("number");
            if (buyCurrencyNumber.equals(fxquote.split("/")[0])) {
                exchangeBill.set("quotation", (Object)ExRateTypeEnum.direct.getValue());
            } else {
                exchangeBill.set("quotation", (Object)ExRateTypeEnum.indirect.getValue());
            }
        }
        this.setLocAmt(exchangeBill, baseCurrency, "quotation", "buyamount", "buyinglocalamount", "buyingexchangerate");
        this.setLocAmt(exchangeBill, baseCurrency, "salequotation", "sellamount", "sellinglocalamount", "sellingexchangerate");
        BigDecimal sellinglocalamount = exchangeBill.getBigDecimal("sellinglocalamount");
        BigDecimal buyinglocalamount = exchangeBill.getBigDecimal("buyinglocalamount");
        exchangeBill.set("exchangegainorloss", (Object)sellinglocalamount.subtract(buyinglocalamount));
        exchangeBill.set("sourcebillnumber", bizBill.get("billno"));
        exchangeBill.set("sourcebillid", bizBill.get("id"));
        exchangeBill.set("sourcebilltype", (Object)"tm_businessbill");
    }

    private String getFxquote(DynamicObject tradeBill, String fxquote) {
        String entity;
        DynamicObject tradeBillDb;
        ProductTypeEnum productTypeEnum;
        long id = tradeBill.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject productType = tradeBill.getDynamicObject("protecttype");
        if (productType != null && (productTypeEnum = ProductTypeEnum.getEnumByValue((String)productType.getString("number"))) != null && (tradeBillDb = QueryServiceHelper.queryOne((String)(entity = productTypeEnum.getEntity()), (String)"fxquote", (QFilter[])qFilter.toArray())) != null) {
            fxquote = tradeBillDb.getString("fxquote");
        }
        return fxquote;
    }

    private void setLocAmt(DynamicObject tarBill, DynamicObject baseCurrency, String quotationName, String amtName, String locAmtName, String exchangeRateName) {
        String quotation = tarBill.getString(quotationName);
        BigDecimal amt = tarBill.getBigDecimal(amtName);
        BigDecimal rate = tarBill.getBigDecimal(exchangeRateName);
        if ("0".equals(quotation)) {
            tarBill.set(locAmtName, (Object)amt.multiply(rate).setScale(baseCurrency.getInt("amtprecision"), RoundingMode.HALF_UP));
        } else if (!EmptyUtil.isEmpty((BigDecimal)rate)) {
            tarBill.set(locAmtName, (Object)amt.divide(rate, baseCurrency.getInt("amtprecision"), RoundingMode.HALF_UP));
        }
    }
}

