/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.formplugin.convert.AbsForexTrade2ExpireDeyConvertPlugin;

public class ForexSpot2ExpireDeyConvertPlugin
extends AbsForexTrade2ExpireDeyConvertPlugin {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        Date currentDate = DateUtils.getCurrentDate();
        DynamicObject protectType = TmcDataServiceHelper.loadSingle((Object)ProductTypeEnum.FOREXSPOT.getId(), (String)"tbd_tradetype", (String)"id");
        DynamicObject billType = TmcDataServiceHelper.loadSingle((Object)BizBillTypeEnum.c_expiredey.getId(), (String)"bos_billtype", (String)"id");
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject bizBill = dataEntity.getDataEntity();
            bizBill.set("protecttype", (Object)protectType);
            bizBill.set("billtype", (Object)billType);
            bizBill.set("operate", (Object)BizOperateEnum.expiredey.getValue());
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            Object tradeId = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)tradeId, (String)this.getSrcMainType().getName(), (String)"billNo,priceRule,deliveryWay,tradeDirect,bizDate,buy_currency,buy_amount,sell_currency,sell_amount,currency,sellCurrency,settleCurrency,pair,fxQuote,adjustSettleDate");
            DynamicObjectCollection bizRecordCol = QueryServiceHelper.query((String)"tm_bizrecord", (String)"id,bizDate,endDate,exRate,restAmt", (QFilter[])new QFilter("tradeBillId", "=", tradeId).and("restAmt", ">", (Object)BigDecimal.ZERO).and(new QFilter("bizDate", "=", (Object)currentDate).and(QFilter.isNull((String)"endDate")).or(new QFilter("bizDate", "<=", (Object)currentDate).and("endDate", ">=", (Object)currentDate))).toArray(), (String)"lv,seqNo");
            this.validate(currentDate, tradeBill, bizRecordCol);
            DynamicObject bizRecord = (DynamicObject)bizRecordCol.get(0);
            DynamicObject leftCurrency = tradeBill.getDynamicObject("currency");
            DynamicObject rightCurrency = tradeBill.getDynamicObject("sellcurrency");
            this.set(bizBill, tradeBill, bizRecord, currentDate);
            bizBill.set("plcurrency", tradeBill.get("sellcurrency"));
            DynamicObject localCurrency = this.queryLocalCurrency(bizBill);
            long localCurrencyId = localCurrency.getLong("id");
            bizBill.set("basecurrency", (Object)localCurrency);
            long leftCurrencyId = leftCurrency.getLong("id");
            long rightCurrencyId = rightCurrency.getLong("id");
            boolean show_voucher_pl_panel = leftCurrencyId != localCurrencyId && rightCurrencyId != localCurrencyId;
            bizBill.set("show_voucher_pl_panel", (Object)show_voucher_pl_panel);
            if (!show_voucher_pl_panel) continue;
            this.setVoucherPl(currentDate, bizBill, tradeBill, localCurrency);
        }
    }
}

