/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.common.helper.ReqNoteHelper;

public class ReqNote2ForexConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject tarBill = dataEntity.getDataEntity();
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            String producttype = tarBill.getString("source");
            if (producttype.contains("combreqnote_")) {
                producttype = producttype.replace("combreqnote_", "");
            }
            if (!"optionsinfo".equals(producttype)) {
                this.setTradeDir(e, tarBill, srcRows, producttype);
            }
            Long pricerule = (Long)((DynamicProperty)e.getFldProperties().get("pricerule")).getValue(srcRows.get(0));
            dataEntity.setValue("bizrestamt", dataEntity.getValue("amount"));
            if ("swapsinfo".equals(producttype)) {
                dataEntity.setValue("farbizrestamt", dataEntity.getValue("amount"));
                long srcId = (Long)((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
                int seq = (Integer)((DynamicProperty)e.getFldProperties().get("swapsinfo.seq")).getValue(srcRows.get(0));
                DynamicObject note = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName(), (String)"id,swapsinfo.seq,swapsinfo.swsettledate");
                DynamicObjectCollection rows = note.getDynamicObjectCollection("swapsinfo");
                for (DynamicObject row : rows) {
                    long farseq = row.getLong("seq");
                    if (farseq != (long)(seq + 1)) continue;
                    tarBill.set("settledate_far", (Object)row.getDate("swsettledate"));
                }
            } else if ("forwardinfo".equals(producttype)) {
                Date deldate = (Date)((DynamicProperty)e.getFldProperties().get("deliverydate")).getValue(srcRows.get(0));
                Date delstdate = (Date)((DynamicProperty)e.getFldProperties().get("deliverystartdate")).getValue(srcRows.get(0));
                Date delenddate = (Date)((DynamicProperty)e.getFldProperties().get("deliveryenddate")).getValue(srcRows.get(0));
                boolean isop = (Boolean)((DynamicProperty)e.getFldProperties().get("isoptionaltraction")).getValue(srcRows.get(0));
                if (isop) {
                    tarBill.set("settledate_start", (Object)delstdate);
                    tarBill.set("settledate_end", (Object)delenddate);
                } else {
                    tarBill.set("settledate", (Object)deldate);
                }
            }
            ReqNoteHelper.buildOtherForPush((DynamicObject)tarBill, (Long)pricerule, (List)srcRows, (AfterFieldMappingEventArgs)e);
        }
    }

    private void setTradeDir(AfterFieldMappingEventArgs e, DynamicObject tarBill, List<DynamicObject> srcRows, String producttype) {
        String currMetaDataName = this.getCurrMetaDataName(producttype);
        String currinno = (String)((DynamicProperty)e.getFldProperties().get(currMetaDataName)).getValue((Object)srcRows.get(0));
        String pair = tarBill.getString("pair");
        String[] split = pair.split("/");
        if (split[0].equals(currinno)) {
            tarBill.set("tradedirect", (Object)"buy");
        } else {
            tarBill.set("tradedirect", (Object)"sell");
        }
    }

    private String getCurrMetaDataName(String producttype) {
        if ("forwardinfo".equals(producttype)) {
            return "currencytypein.number";
        }
        if ("spotinfo".equals(producttype)) {
            return "spotcurrencytypein.number";
        }
        if ("swapsinfo".equals(producttype)) {
            return "currin.number";
        }
        if ("optionsinfo".equals(producttype)) {
            return "opcurrin.number";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u7533\u8bf7\u5355\u6765\u6e90%s\u4e0d\u6b63\u786e\u3002", (String)"ReqNote2ForexConvertPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{producttype}));
    }
}

