/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBill2ExchangeBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject tarBill = dataEntity.getDataEntity();
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            DynamicObject sourceBill = (DynamicObject)srcRows.get(0);
            this.setTarBillData(tarBill, sourceBill);
        }
    }

    private void setTarBillData(DynamicObject tarBill, DynamicObject srcBill) {
        String name = this.getSrcMainType().getName();
        if ("tm_rateswap".equals(name)) {
            this.setTarBillData_reteSwap(tarBill, srcBill);
        }
    }

    private void setTarBillData_reteSwap(DynamicObject tarBill, DynamicObject sourceBill) {
        DynamicObject srcBill = TmcDataServiceHelper.loadSingle((Object)sourceBill.get("id"), (String)this.getSrcMainType().getName(), (String)"rateswaptype,initpriextype,pricerule,currency,reccurrency,basecurrency,fxquote,reclocalexrate,paylocalexrate,spotrate,reclocalfq,paylocalfq,voucherpl,plamt");
        DynamicObject currency = srcBill.getDynamicObject("currency");
        DynamicObject reccurrency = srcBill.getDynamicObject("reccurrency");
        DynamicObject basecurrency = srcBill.getDynamicObject("basecurrency");
        if (currency.getLong("id") == basecurrency.getLong("id")) {
            tarBill.set("biztype", (Object)"exchangesettlementbill");
            tarBill.set("buyingexchangerate", (Object)1);
            tarBill.set("sellingexchangerate", (Object)srcBill.getBigDecimal("spotrate"));
            this.setTarBillQuotation_rateSwap(tarBill, srcBill, true, currency, "fxquote", "quotation");
            this.setTarBillQuotation_rateSwap(tarBill, srcBill, false, reccurrency, "fxquote", "salequotation");
        } else if (reccurrency.getLong("id") == basecurrency.getLong("id")) {
            tarBill.set("biztype", (Object)"exchangpayebill");
            tarBill.set("buyingexchangerate", (Object)srcBill.getBigDecimal("spotrate"));
            tarBill.set("sellingexchangerate", (Object)1);
            this.setTarBillQuotation_rateSwap(tarBill, srcBill, false, currency, "fxquote", "quotation");
            this.setTarBillQuotation_rateSwap(tarBill, srcBill, true, reccurrency, "fxquote", "salequotation");
        } else {
            tarBill.set("biztype", (Object)"exchangebill");
            tarBill.set("buyingexchangerate", (Object)srcBill.getBigDecimal("reclocalexrate"));
            tarBill.set("sellingexchangerate", (Object)srcBill.getBigDecimal("paylocalexrate"));
            this.setTarBillQuotation_rateSwap(tarBill, srcBill, false, currency, "reclocalfq", "quotation");
            this.setTarBillQuotation_rateSwap(tarBill, srcBill, false, reccurrency, "paylocalfq", "salequotation");
        }
        this.setLocAmt(tarBill, basecurrency, "quotation", "buyamount", "buyinglocalamount", "buyingexchangerate");
        this.setLocAmt(tarBill, basecurrency, "salequotation", "sellamount", "sellinglocalamount", "sellingexchangerate");
        this.setExchangegainorloss_rateSwap(tarBill);
    }

    private void setLocAmt(DynamicObject tarBill, DynamicObject basecurrency, String quotationName, String amtName, String locAmtName, String exchangeRateName) {
        String quotation = tarBill.getString(quotationName);
        BigDecimal amt = tarBill.getBigDecimal(amtName);
        BigDecimal rate = tarBill.getBigDecimal(exchangeRateName);
        if ("0".equals(quotation)) {
            tarBill.set(locAmtName, (Object)amt.multiply(rate).setScale(basecurrency.getInt("amtprecision"), RoundingMode.HALF_UP));
        } else if (!EmptyUtil.isEmpty((BigDecimal)rate)) {
            tarBill.set(locAmtName, (Object)amt.divide(rate, basecurrency.getInt("amtprecision"), 4));
        }
    }

    private void setExchangegainorloss_rateSwap(DynamicObject tarBill) {
        BigDecimal sellinglocalamount = tarBill.getBigDecimal("sellinglocalamount");
        BigDecimal buyinglocalamount = tarBill.getBigDecimal("buyinglocalamount");
        tarBill.set("exchangegainorloss", (Object)sellinglocalamount.subtract(buyinglocalamount));
    }

    private void setTarBillQuotation_rateSwap(DynamicObject tarBill, DynamicObject srcBill, boolean isBaseCurrency, DynamicObject currency, String localfqName, String filedName) {
        if (isBaseCurrency) {
            tarBill.set(filedName, (Object)"0");
        } else {
            String localfq = srcBill.getString(localfqName);
            if (currency.getString("number").equals(localfq.split("/")[0])) {
                tarBill.set(filedName, (Object)"0");
            } else {
                tarBill.set(filedName, (Object)"1");
            }
        }
    }
}

