/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forex;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;

public class ForexEdit
extends AbstractTmcBillEdit
implements ItemClickListener {
    public static final String SELLCASHFLOWPANEL = "sellcashflowpanel";
    public static final String SELLCASHFLOW = "sellcashflow";
    public static final String BUYCASHFLOWPANEL = "buycashflowpanel";
    public static final String BUYCASHFLOW = "buycashflow";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initControlByBillStatus();
        this.initControlCashFlow();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "deliveryway": 
            case "settlecurrency": 
            case "currency": {
                this.initControlCashFlow();
            }
        }
    }

    private void initControlCashFlow() {
        String deliveryWay = (String)this.getModel().getValue("deliveryway");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (settleCurrency != null && currency != null) {
                long settleCurrencyId = settleCurrency.getLong("id");
                if (settleCurrencyId == currency.getLong("id")) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{SELLCASHFLOWPANEL});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{BUYCASHFLOWPANEL});
                    ((TreeEntryGrid)this.getControl(BUYCASHFLOW)).setCollapseable(false);
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{SELLCASHFLOWPANEL});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{BUYCASHFLOWPANEL});
                    ((TreeEntryGrid)this.getControl(SELLCASHFLOW)).setCollapseable(false);
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUYCASHFLOWPANEL, SELLCASHFLOWPANEL});
            ((TreeEntryGrid)this.getControl(BUYCASHFLOW)).setCollapseable(true);
            ((TreeEntryGrid)this.getControl(SELLCASHFLOW)).setCollapseable(true);
        }
    }

    private void initControlByBillStatus() {
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus) || TcBillStatusEnum.FINISH.getValue().equals(billstatus)) {
            this.setFxEnable(Boolean.FALSE);
        } else if (TcBillStatusEnum.AUDIT.getValue().equals(billstatus) || TcBillStatusEnum.SAVE.getValue().equals(billstatus)) {
            this.setFxEnable(Boolean.TRUE);
        }
    }

    private void setFxEnable(Boolean enableFlag) {
        String entityType;
        DynamicObject productType = (DynamicObject)this.getModel().getValue("protecttype");
        switch (entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity()) {
            case "tm_forex": {
                this.getView().setEnable(enableFlag, new String[]{"attachmentpanelT", "contractnumber", "spotrate"});
                break;
            }
            case "tm_forex_forward": {
                this.getView().setEnable(enableFlag, new String[]{"attachmentpanelT", "contractnumber", "spotrate", "settledate", "settledaterange"});
                break;
            }
            case "tm_forex_swaps": {
                if (enableFlag.booleanValue()) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanelT", "contractnumber", "spotrate", "forwrate"});
                    Object swapType = this.getModel().getValue("swaptype");
                    if (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(swapType)) {
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{"settledate"});
                        break;
                    }
                    if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType)) {
                        if (((Boolean)this.getModel().getValue("isovernight")).booleanValue()) break;
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{"settledate", "settledate_far"});
                        break;
                    }
                    if (!ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swapType)) break;
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"settledate", "settledate_far"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelT", "contractnumber", "spotrate", "forwrate", "settledate", "settledate_far"});
                break;
            }
            case "tm_forex_options": {
                this.getView().setEnable(enableFlag, new String[]{"attachmentpanelT", "contractnumber", "exchangerate", "settledate", "adjexpiredate"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operate = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("unaudit".equals(operate)) {
            this.initControlByBillStatus();
        }
        if ("tracelife".equals(operate)) {
            Long id = (Long)this.getModel().getValue("id");
            QFilter qFilter = new QFilter("tradebill", "=", (Object)id);
            if (id.equals(0L) || !QueryServiceHelper.exists((String)"tm_businessbill", (QFilter[])new QFilter[]{qFilter})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u67e5\u751f\u547d\u5468\u671f\u5355\uff0c\u65e0\u6570\u636e\u3002", (String)"ForexList_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return;
            }
            if (EmptyUtil.isNoEmpty((Long)id)) {
                DynamicObject forexObj = QueryServiceHelper.queryOne((String)"tm_trade", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                ListShowParameter param = ShowFormHelper.createShowListForm((String)"tm_businessbill", (boolean)true, (int)0, (boolean)false);
                ListFilterParameter filterParameter = new ListFilterParameter();
                filterParameter.setFilter(qFilter);
                param.setListFilterParameter(filterParameter);
                this.getView().getPageCache().put("org", forexObj.getString("org"));
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }
}

