/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forex;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class ForexSpotAdjustPlugin
extends AbstractTmcBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW) && EmptyUtil.isEmpty((Object)this.getModel().getValue("reqnoteno"))) {
            this.callSettleDate();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "bizdate": {
                Date bizdate = (Date)newValue;
                if (EmptyUtil.isNoEmpty((Object)bizdate)) {
                    DateEdit edit = (DateEdit)this.getView().getControl("settledate");
                    edit.setMinDate(bizdate);
                }
                this.callSettleDate();
                break;
            }
            case "settledelay": 
            case "workcalendar": {
                this.callSettleDate();
                break;
            }
            case "settledate": {
                if (EmptyUtil.isNoEmpty((Object)newValue) && !WorkCalendarHelper.isWorkDay((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)((Date)newValue))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u9009\u62e9\u7684\u4ea4\u5272\u65e5\u671f\u4e3a\u975e\u5de5\u4f5c\u65e5\u3002", (String)"DeliveryDate_NoWorkDate", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                }
                this.callSettleDelay();
            }
        }
    }

    private void callSettleDate() {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        if (EmptyUtil.isNoEmpty((Object)bizDate)) {
            int settleDelay = (Integer)this.getModel().getValue("settledelay");
            Date settleDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)TcDateUtils.truncateDate((Date)bizDate), (int)settleDelay);
            this.getModel().setValue("settledate", (Object)settleDate);
        }
    }

    private void callSettleDelay() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date settledate = (Date)this.getModel().getValue("settledate");
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        if (EmptyUtil.isNoEmpty((Object)bizdate) && EmptyUtil.isNoEmpty((Object)settledate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)bizdate, (Date)settledate));
        }
    }
}

