/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forex;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class ForexSpotEdit
extends AbstractTradeBillEdit {
    private static Log logger = LogFactory.getLog(ForexSpotEdit.class);

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        String sourse = (String)this.getModel().getValue("source");
        if (TcBillStatusEnum.SAVE.getValue().equals(billStatus) && EmptyUtil.isNotEmpty((CharSequence)sourse) && sourse.contains("combreqnote")) {
            this.dealForexQuoteInfo();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "bizdate": 
            case "settledate": 
            case "pricerule": 
            case "tradedirect": {
                this.dealForexQuoteInfo();
                break;
            }
            case "pair": {
                if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("sourcebillid"))) {
                    if ("buy".equals(this.getModel().getValue("tradedirect"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradedirect", (Object)"sell");
                    } else if ("sell".equals(this.getModel().getValue("tradedirect"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradedirect", (Object)"buy");
                    }
                }
                this.dealForexQuoteInfo();
            }
        }
    }

    private void dealForexQuoteInfo() {
        Date settleDate;
        String pair;
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair = (String)this.getModel().getValue("pair"), settleDate = (Date)this.getModel().getValue("settledate")})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)settleDate);
            String forexQuote = info.getFxquote();
            String dir = (String)this.getModel().getValue("tradedirect");
            BigDecimal exRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(forexQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(forexQuote) ? info.getSellPrice() : info.getBuyPrice();
            this.getModel().setValue("fxquote", (Object)forexQuote);
            this.getModel().setValue("spotrate", (Object)exRate);
        } else {
            this.getModel().setValue("spotrate", null);
        }
    }
}

