/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import kd.tmc.tm.formplugin.forex.ForexSpotImportPlugin;

public class ForexSwapsImportPlugin
extends ForexSpotImportPlugin {
    @Override
    public void afterImportData(ImportDataEventArgs e) {
        ArrayList<String> errorMsgList = new ArrayList<String>();
        this.validate(e, errorMsgList);
        this.validate_swaps(errorMsgList);
        this.dealErrorMsgList(errorMsgList);
        this.setValue_swaps();
        this.useCreditLimit();
    }

    @Override
    protected boolean isCreditUse() {
        return (Boolean)this.getModel().getValue("nearend") != false || (Boolean)this.getModel().getValue("farend") != false;
    }

    @Override
    protected void dealForexQuoteInfo(String entityName, List<String> errorMsgList) {
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (EmptyUtil.isNoEmpty((DynamicObject)priceRule)) {
            String pair = (String)this.getModel().getValue("pair");
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                errorMsgList.add(ResManager.loadResFormat((String)"\u5b9a\u4ef7\u89c4\u5219%s\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"ForexSwapsImportPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{priceRule.get("number")}));
                return;
            }
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizDate, null);
            this.getModel().setValue("fxquote", (Object)info.getFxquote());
            BigDecimal pips = ((BigDecimal)this.getModel().getValue("forwrate")).subtract((BigDecimal)this.getModel().getValue("spotrate")).multiply(Constants.TEN_THOUSAND);
            this.getModel().setValue("pips", (Object)pips);
        }
    }

    private void setValue_swaps() {
        this.getModel().setValue("bizrestamt", this.getModel().getValue("amount"));
        this.getModel().setValue("farbizrestamt", this.getModel().getValue("amount"));
        this.setValue_finAssetType();
        this.setValue_deliveryWay();
        this.setValue_dateAdjustMethod();
        this.setValue_settleDelay();
        this.setTerm();
        this.setAdjDate("settledate", "adjustsettledate");
        this.setFarTerm();
        this.setAdjDate("settledate_far", "adjustsettledate_far");
        this.getModel().setValue("offset", this.getModel().getValue("settledelay"));
        this.getModel().setValue("offset_far", (Object)1);
        this.setValue_bizType();
        this.setValue_currency();
        this.buildEntryBS();
        this.amountBsChange(0, (BigDecimal)this.getModel().getValue("amount"));
    }

    private void setValue_currency() {
        String pair = (String)this.getModel().getValue("pair");
        String[] array = pair.split("/");
        DynamicObject leftCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)array[0])});
        DynamicObject rightCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)array[1])});
        this.getModel().setValue("currency", leftCurrency.get("id"));
        this.getModel().setValue("sellcurrency", rightCurrency.get("id"));
        this.getModel().setValue("buycurrency_far", rightCurrency.get("id"));
        this.getModel().setValue("sellcurrency_far", leftCurrency.get("id"));
    }

    private void buildEntryBS() {
        String tradeDirect = (String)this.getModel().getValue("tradedirect");
        this.getModel().batchCreateNewEntryRow("entry_bs", 4);
        if (TradeDirectionEnum.buy.getValue().equals(tradeDirect)) {
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.buy.getValue(), 0);
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.sell.getValue(), 1);
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.sell.getValue(), 2);
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.buy.getValue(), 3);
        } else {
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.sell.getValue(), 0);
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.buy.getValue(), 1);
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.buy.getValue(), 2);
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.sell.getValue(), 3);
        }
        this.getModel().setValue("currency_bs", this.getModel().getValue("currency"), 0);
        this.getModel().setValue("currency_bs", this.getModel().getValue("sellcurrency"), 1);
        this.getModel().setValue("currency_bs", this.getModel().getValue("currency"), 2);
        this.getModel().setValue("currency_bs", this.getModel().getValue("sellcurrency"), 3);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("amount"), (int)0);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("amount"), (int)2);
    }

    private void amountBsChange(int rowIndex, BigDecimal amountBs) {
        BigDecimal spotRate = (BigDecimal)this.getModel().getValue("spotrate");
        if (rowIndex == 0) {
            this.getModel().setValue("amount", (Object)amountBs);
            this.setSecondAmt(0, 1, spotRate);
            this.getModel().setValue("buyamount_far", (Object)amountBs);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amountBs, (int)2);
            BigDecimal forwardRate = (BigDecimal)this.getModel().getValue("forwrate");
            this.setSecondAmt(2, 3, forwardRate);
        } else {
            this.getModel().setValue("sellamount", (Object)amountBs);
            this.setFirstAmt(spotRate);
        }
    }

    private void setFirstAmt(BigDecimal exRate) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) {
            BigDecimal amtSecondRow = (BigDecimal)this.getModel().getValue("amount_bs", 1);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRate, amtSecondRow})) {
                return;
            }
            boolean isSame = this.isSameFX();
            BigDecimal amtFirstRow = isSame ? amtSecondRow.divide(exRate, 6, 4) : amtSecondRow.multiply(exRate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtFirstRow, (int)0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtFirstRow, (int)2);
            this.getModel().setValue("amount", (Object)amtFirstRow);
            this.getModel().setValue("buyamount_far", (Object)amtFirstRow);
            BigDecimal forwardRate = (BigDecimal)this.getModel().getValue("forwrate");
            if (EmptyUtil.isNoEmpty((BigDecimal)forwardRate)) {
                BigDecimal amtSecondRowFar = isSame ? amtFirstRow.multiply(forwardRate) : amtFirstRow.divide(forwardRate, 6, 4);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtSecondRowFar, (int)3);
                this.getModel().setValue("sellamount_far", (Object)amtFirstRow);
            }
        }
    }

    private void setSecondAmt(int firstRowIndex, int secondRowIndex, BigDecimal exRate) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) {
            BigDecimal amtFirstRow = (BigDecimal)this.getModel().getValue("amount_bs", firstRowIndex);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amtFirstRow, exRate})) {
                return;
            }
            BigDecimal amtSecondRow = this.isSameFX() ? amtFirstRow.multiply(exRate) : amtFirstRow.divide(exRate, 6, 4);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtSecondRow, (int)secondRowIndex);
            if (secondRowIndex == 1) {
                this.getModel().setValue("sellamount", (Object)amtSecondRow);
            } else {
                this.getModel().setValue("sellamount_far", (Object)amtSecondRow);
            }
        }
    }

    private boolean isSameFX() {
        String pair = (String)this.getModel().getValue("pair");
        String fxQuote = (String)this.getModel().getValue("fxquote");
        return pair.equals(fxQuote);
    }

    private void setTerm() {
        String adjMtd = (String)this.getModel().getValue("dateadjustmethod");
        Date settleDate = (Date)this.getModel().getValue("settledate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)adjMtd);
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        int settleDelay = (Integer)this.getModel().getValue("settledelay");
        Date temp = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)wc, (Date)bizDate, (int)settleDelay, (AdjustMethodEnum)adjMtdEnum);
        String term = TcDateUtils.getDiffYMD((Date)temp, (Date)settleDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)term);
    }

    private void setAdjDate(String dateProp, String adjDateProp) {
        Date settleDate = (Date)this.getModel().getValue(dateProp);
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        String adjMtd = (String)this.getModel().getValue("dateadjustmethod");
        AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)adjMtd);
        Date adjDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)settleDate, (AdjustMethodEnum)adjMtdEnum);
        this.getModel().setValue(adjDateProp, (Object)adjDate);
    }

    private void setFarTerm() {
        Date farDate = (Date)this.getModel().getValue("settledate_far");
        Date date = (Date)this.getModel().getValue("settledate");
        String term = TcDateUtils.getDiffYMD((Date)date, (Date)farDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term_far", (Object)term);
    }

    @Override
    protected void setValue_settleDelay() {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        Date date = (Date)this.getModel().getValue("settledate");
        int diffWorkDays = Math.min(TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)workCalendar, (Date)bizDate, (Date)date), 2);
        this.getModel().setValue("settledelay", (Object)diffWorkDays);
    }

    private void validate_swaps(List<String> errorMsgList) {
        if (((Date)this.getModel().getValue("settledate")).before((Date)this.getModel().getValue("bizdate"))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u8fd1\u7aef\u4ea4\u5272\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSwapsImportPlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if (!((Date)this.getModel().getValue("settledate_far")).after((Date)this.getModel().getValue("settledate"))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u8fdc\u7aef\u4ea4\u5272\u65e5\u5fc5\u987b\u5927\u4e8e\u8fd1\u7aef\u4ea4\u5272\u65e5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSwapsImportPlugin_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if (((Boolean)this.getModel().getValue("isovernight")).booleanValue()) {
            if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(this.getModel().getValue("swaptype"))) {
                errorMsgList.add(ResManager.loadKDString((String)"\u9694\u591c\u62c6\u501f=\u662f\uff0c\u6389\u671f\u7c7b\u578b\u4e0d\u80fd\u662f\u201c\u8fdc\u671f-\u8fdc\u671f\u201d\u3002", (String)"ForexSwapsImportPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        } else if (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(this.getModel().getValue("swaptype"))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u9694\u591c\u62c6\u501f=\u5426\uff0c\u6389\u671f\u7c7b\u578b\u4e0d\u80fd\u662f\u201c\u5373\u671f-\u5373\u671f\u201d\u3002", (String)"ForexSwapsImportPlugin_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }
}

