/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forexward;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class ForexCreditUsePlugin
extends AbstractTradeBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit credituse = (BasedataEdit)this.getView().getControl("credituse");
        credituse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"credituse")) {
            if ("getLookUpList".equals(e.getSourceMethod())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6253\u5f00\u5217\u8868\u9009\u62e9\u3002", (String)"ForexCreditUsePlugin_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long id = (Long)this.getModel().getValue("id");
            if (id == null || id.equals(0L)) {
                id = DB.genLongId((String)this.getModel().getDataEntityType().getName());
                this.getModel().setValue("id", (Object)id);
            }
            if (!this.checkCreditlimitParams()) {
                e.setCancel(true);
                return;
            }
            CreditLimitUseBean useBean = this.getUseBean(id);
            FormShowParameter showParameter = e.getFormShowParameter();
            showParameter.setCustomParam("KEY_F7PARAM", (Object)useBean);
            showParameter.getOpenStyle().setShowType(ShowType.NonModal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creditlimit"));
        }
    }

    private CreditLimitUseBean getUseBean(Long id) {
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(id);
        String entityName = this.getModel().getDataEntityType().getName();
        useBean.setEntityName(entityName);
        useBean.setOrgId(Long.valueOf(((DynamicObject)this.getModel().getValue("org")).getLong("id")));
        DynamicObject counterparty = (DynamicObject)this.getModel().getValue("counterparty");
        String partytype = counterparty.getString("partytype");
        if (!"bd_finorginfo".equals(partytype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7c7b\u578b\u4e3a\u5408\u4f5c\u91d1\u878d\u673a\u6784\u7684\u4ea4\u6613\u5bf9\u624b\u3002", (String)"ForexCreditUsePlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return null;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)counterparty.getString("number"));
        DynamicObject object = TmcDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{qFilter});
        useBean.setFinOrgId(Long.valueOf(object.getLong("id")));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        useBean.setCurrencyId((Long)currency.getPkValue());
        DynamicObject creditvariety = (DynamicObject)this.getModel().getValue("creditvariety");
        useBean.setCreditTypeId(Long.valueOf(creditvariety.getLong("id")));
        useBean.setCreditVariety(null);
        useBean.setPreOccupy(Boolean.valueOf(false));
        useBean.setSourceBillId(null);
        useBean.setSourceType(null);
        useBean.setStartDate(null);
        useBean.setEndDate(null);
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if ("tm_forex_swaps".equals(entityName)) {
            boolean near = (Boolean)this.getModel().getValue("nearend");
            boolean far = (Boolean)this.getModel().getValue("farend");
            if (near && far) {
                amount = amount.add(amount);
            }
        }
        useBean.setMaxAmt(amount);
        useBean.setCreditRatio(Constants.ONE_HUNDRED);
        useBean.setBizAmt(amount);
        useBean.setRealScale(null);
        useBean.setCreditLimitId(null);
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("credituse");
        if (creditLimit != null) {
            useBean.setCreditLimitId((Long)creditLimit.getPkValue());
        } else {
            useBean.setCreditLimitId((Long)null);
        }
        return useBean;
    }

    private boolean checkCreditlimitParams() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("creditvariety"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6388\u4fe1\u7c7b\u522b\u3002", (String)"ForexCreditUsePlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("counterparty"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea4\u6613\u5bf9\u624b\u3002", (String)"ForexCreditUsePlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("org"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ea4\u6613\u4fe1\u606f\u57fa\u672c\u4fe1\u606f\u7ec4\u7ec7\u3002", (String)"ForexCreditUsePlugin_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("currency"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e70\u5165\u5e01\u79cd\u3002", (String)"ForexCreditUsePlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if ("creditlimit".equals(event.getActionId()) && returnData instanceof String) {
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
            this.getModel().setValue("credituse", (Object)res.getCreditLimitId());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        switch (propName = args.getProperty().getName()) {
            case "counterparty": {
                this.setEnableIsCredit();
                break;
            }
            case "iscredituse": {
                if (!((Boolean)this.getModel().getValue("iscredituse")).booleanValue()) {
                    this.getModel().setValue("creditvariety", null);
                    this.getModel().setValue("credituse", null);
                }
                this.setCMVisible();
                break;
            }
            case "farend": 
            case "nearend": {
                this.setCMVisible();
                this.getModel().setValue("credituse", null);
                break;
            }
            case "pair": {
                this.getModel().setValue("credituse", null);
                break;
            }
            case "amount": {
                this.getModel().setValue("credituse", null);
                break;
            }
            case "creditvariety": {
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("creditvariety"))) break;
                this.getModel().setValue("credituse", null);
            }
        }
    }

    private void setEnableIsCredit() {
        DynamicObject counterparty = (DynamicObject)this.getModel().getValue("counterparty");
        String partytype = EmptyUtil.isNoEmpty((DynamicObject)counterparty) ? counterparty.getString("partytype") : "";
        String entityName = this.getModel().getDataEntityType().getName();
        if (!"bd_finorginfo".equals(partytype)) {
            this.getModel().setValue("credituse", null);
            this.closeCredit(entityName);
        } else {
            this.getModel().setValue("credituse", null);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"credituse"});
            this.openCredit(entityName);
        }
    }

    public void afterCopyData(EventObject e) {
        this.setEnableIsCredit();
    }

    private void openCredit(String entityName) {
        if (ProductTypeEnum.FOREXFORWARD.getEntity().equals(entityName) || ProductTypeEnum.FOREXSPOT.getEntity().equals(entityName) || ProductTypeEnum.FOREXOPTION.getEntity().equals(entityName)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"iscredituse"});
        } else if (ProductTypeEnum.FOREXSWAPS.getEntity().equals(entityName)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"nearend"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"farend"});
        }
    }

    private void closeCredit(String entityName) {
        if (ProductTypeEnum.FOREXFORWARD.getEntity().equals(entityName) || ProductTypeEnum.FOREXSPOT.getEntity().equals(entityName) || ProductTypeEnum.FOREXOPTION.getEntity().equals(entityName)) {
            this.getModel().setValue("iscredituse", (Object)false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"iscredituse"});
        } else if (ProductTypeEnum.FOREXSWAPS.getEntity().equals(entityName)) {
            this.getModel().setValue("nearend", (Object)false);
            this.getModel().setValue("farend", (Object)false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"farend"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"nearend"});
        }
    }

    public void beforeBindData(EventObject e) {
        this.setCMVisible();
    }

    private void setCMVisible() {
        String entityName = this.getModel().getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)"tm_forex_forward", (CharSequence)entityName) || StringUtils.equals((CharSequence)"tm_forex", (CharSequence)entityName) || StringUtils.equals((CharSequence)"tm_forex_options", (CharSequence)entityName)) {
            boolean iscredituse = (Boolean)this.getModel().getValue("iscredituse");
            if (iscredituse) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"credituse", "cm_org", "cmcounterparty", "creditvariety"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"credituse", "cm_org", "cmcounterparty", "creditvariety"});
            }
        } else if (StringUtils.equals((CharSequence)"tm_forex_swaps", (CharSequence)entityName)) {
            boolean farend = (Boolean)this.getModel().getValue("farend");
            boolean nearend = (Boolean)this.getModel().getValue("nearend");
            if (farend || nearend) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"credituse", "cm_org", "cmcounterparty", "creditvariety"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"credituse", "cm_org", "cmcounterparty", "creditvariety"});
            }
        }
    }
}

