/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forxoption;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.OptionsBizHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.OptionTypeEnum;

public class ForexOptionsTheoryEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit calculateCurrency = (BasedataEdit)this.getView().getControl("calculatecurrency");
        calculateCurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setSpecRateEnable();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPecificvolonMust();
        this.setSpecRateEnable();
        int operationStatus = this.getView().getFormShowParameter().getStatus().getValue();
        if (OperationStatus.ADDNEW.getValue() == operationStatus) {
            this.getModel().setValue("calculatecurrency", this.getModel().getValue("sellcurrency"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("calculatecurrency".equals(key)) {
            this.setCalculateCurrencyFilter(evt);
        }
    }

    private void setCalculateCurrencyFilter(BeforeF7SelectEvent evt) {
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject termCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (EmptyUtil.isNoEmpty((DynamicObject)baseCurrency) && EmptyUtil.isNoEmpty((DynamicObject)termCurrency)) {
            QFilter baseFilter = new QFilter("id", "=", baseCurrency.getPkValue());
            QFilter termFilter = new QFilter("id", "=", termCurrency.getPkValue());
            showParameter.getListFilterParameter().setFilter(baseFilter.or(termFilter));
        } else {
            QFilter noFilter = new QFilter("id", "=", (Object)DBServiceHelper.genGlobalLongId());
            showParameter.getListFilterParameter().setFilter(noFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "pricerule": 
            case "pair": 
            case "isspecexrate": {
                this.setSpecificExRateonMust();
                this.queryRateForexQuote("spotrate");
                this.queryRateForexQuote("forwrate");
                this.calculateInfo();
                break;
            }
            case "isspecvol": {
                this.setPecificvolonMust();
                break;
            }
            case "isspecrate": {
                this.calculateInfo();
                break;
            }
            case "adjustsettledate": {
                this.queryRateForexQuote("forwrate");
                this.calculateInfo();
                break;
            }
            case "spotrate": 
            case "forwrate": {
                this.calculateForwardPips();
                this.calculateInfo();
                break;
            }
            case "pips": {
                this.calculateForwrate();
                break;
            }
            case "buymarket": 
            case "sellmarket": {
                this.setSpecRateEnable();
                this.calculateInfo();
                break;
            }
            case "volatility": {
                this.calculateVolatility();
                this.calculateInfo();
                break;
            }
            case "tradetype": 
            case "fxquote": 
            case "tradedirect": 
            case "bizrestamt": 
            case "adjexpiredate": 
            case "referdate": 
            case "calculatecurrency": 
            case "optiontype": 
            case "exchangerate": 
            case "currencyrate": 
            case "sellcurrencyrate": 
            case "bizdate": 
            case "settledelay": {
                this.calculateInfo();
            }
        }
    }

    private void queryRateForexQuote(String rate) {
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        String pair = (String)this.getModel().getValue("pair");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            Date dm = null;
            if ("forwrate".equals(rate)) {
                dm = (Date)this.getModel().getValue("adjustsettledate");
            }
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, null, (Date)dm);
            this.getModel().setValue(rate, (Object)info.getMiddleprice());
        }
    }

    private void calculateForwrate() {
        boolean isSpecExRate = (Boolean)this.getModel().getValue("isspecexrate");
        if (isSpecExRate) {
            BigDecimal forwardPips = (BigDecimal)this.getModel().getValue("pips");
            BigDecimal spotRate = (BigDecimal)this.getModel().getValue("spotrate");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"forwrate", (Object)spotRate.add(forwardPips.divide(Constants.TEN_THOUSAND, RoundingMode.HALF_UP)));
        }
    }

    private void calculateForwardPips() {
        BigDecimal forwrate = (BigDecimal)this.getModel().getValue("forwrate");
        BigDecimal spotRate = (BigDecimal)this.getModel().getValue("spotrate");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)forwrate.subtract(spotRate).multiply(Constants.TEN_THOUSAND));
    }

    private void setPecificvolonMust() {
        boolean isSpecVol = (Boolean)this.getModel().getValue("isspecvol");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isSpecVol, (String[])new String[]{"volatility"});
        if (!isSpecVol) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"volatility", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"calvol", (Object)BigDecimal.ZERO);
            this.clearTheoryInfo();
        }
    }

    private void clearTheoryInfo() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"calculatepv", (Object)BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"delta", (Object)BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"vega", (Object)BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"caltheta", (Object)BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamma", (Object)BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"hedgeamount", (Object)BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pvpercent", (Object)BigDecimal.ZERO);
    }

    private void setSpecificExRateonMust() {
        boolean isSpecexRate = (Boolean)this.getModel().getValue("isspecexrate");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isSpecexRate, (String[])new String[]{"spotrate", "pips", "forwrate"});
    }

    private void setSpecRateEnable() {
        boolean dataChanged = this.getModel().getDataChanged();
        DynamicObject buyMarket = (DynamicObject)this.getModel().getValue("buymarket");
        DynamicObject sellMarket = (DynamicObject)this.getModel().getValue("sellmarket");
        boolean anyoneEmpty = EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyMarket, sellMarket});
        this.getView().setEnable(Boolean.valueOf(!anyoneEmpty), new String[]{"isspecrate"});
        this.getModel().setValue("isspecrate", (Object)anyoneEmpty);
        this.getModel().setDataChanged(dataChanged);
    }

    private BigDecimal calculateVolatility() {
        boolean specificvolon = (Boolean)this.getModel().getValue("isspecvol");
        BigDecimal volatility = (BigDecimal)this.getModel().getValue("volatility");
        if (specificvolon) {
            this.getModel().setValue("calvol", (Object)volatility);
        }
        return volatility;
    }

    private void calculateInfo() {
        BigDecimal Zd;
        BigDecimal Zsq;
        BigDecimal Zq;
        BigDecimal r_f;
        BigDecimal r;
        BigDecimal volatility;
        BigDecimal pv = Constants.ZERO;
        BigDecimal delta = Constants.ZERO;
        BigDecimal vega = Constants.ZERO;
        BigDecimal theta = Constants.ZERO;
        BigDecimal gamma = Constants.ZERO;
        String optionType = (String)this.getModel().getValue("optiontype");
        Date lastExerDate = (Date)this.getModel().getValue("adjexpiredate");
        Date referDate = (Date)this.getModel().getValue("referdate");
        if (referDate == null) {
            referDate = TcDateUtils.getCurrentDate();
        }
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        String forexTradeType = (String)this.getModel().getValue("tradetype");
        BigDecimal Ao = (BigDecimal)this.getModel().getValue("bizrestamt");
        BigDecimal K = (BigDecimal)this.getModel().getValue("exchangerate");
        Integer settleDelay = (Integer)this.getModel().getValue("settledelay");
        Date adjustSettleDate = (Date)this.getModel().getValue("adjustsettledate");
        BigDecimal forwrate = (BigDecimal)this.getModel().getValue("forwrate");
        BigDecimal spotrate = (BigDecimal)this.getModel().getValue("spotrate");
        String pair = (String)this.getModel().getValue("pair");
        String fxQuote = (String)this.getModel().getValue("fxquote");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{optionType, lastExerDate, forexTradeType, K, referDate, pair, bizDate, adjustSettleDate, forwrate, spotrate})) {
            return;
        }
        if (!pair.equals(fxQuote)) {
            spotrate = Constants.ONE.divide(spotrate, 10, RoundingMode.HALF_UP);
            forwrate = Constants.ONE.divide(forwrate, 10, RoundingMode.HALF_UP);
            K = Constants.ONE.divide(K, 10, RoundingMode.HALF_UP);
        }
        DynamicObject calCurrency = (DynamicObject)this.getModel().getValue("calculatecurrency");
        DynamicObject termCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        BigDecimal temp_one = new BigDecimal("0.0001");
        BigDecimal temp_two = new BigDecimal("0.0002");
        BigDecimal CF = temp_one;
        boolean isRight = true;
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{calCurrency, termCurrency}) && calCurrency.getLong("id") != termCurrency.getLong("id")) {
            isRight = false;
            spotrate = Constants.ONE.divide(spotrate, 10, RoundingMode.HALF_UP);
            forwrate = Constants.ONE.divide(forwrate, 10, RoundingMode.HALF_UP);
            Ao = Ao.multiply(K);
            K = Constants.ONE.divide(K, 10, RoundingMode.HALF_UP);
            forexTradeType = OptionsTradeTypeEnum.call.getValue().equals(forexTradeType) ? OptionsTradeTypeEnum.put.getValue() : OptionsTradeTypeEnum.call.getValue();
            CF = Constants.ONE.divide(Constants.ONE.divide(spotrate, 10, RoundingMode.HALF_UP).add(temp_one), 10, RoundingMode.HALF_UP).subtract(spotrate);
        }
        if (EmptyUtil.isEmpty((BigDecimal)(volatility = this.calculateVolatility()))) {
            return;
        }
        BigDecimal \u03c3 = volatility.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
        BigDecimal T = BigDecimal.valueOf((double)TcDateUtils.getDiffDays((Date)OptionsBizHelper.getMaxDate((Date)referDate, (Date)bizDate), (Date)lastExerDate) / 365.25);
        Date maxRefBizDate = OptionsBizHelper.getMaxDate((Date)referDate, (Date)bizDate);
        Date maxRefBizSetDate = TradeBusinessHelper.callSettleDelayDate(null, (Date)maxRefBizDate, (int)settleDelay);
        boolean isSpecRate = (Boolean)this.getModel().getValue("isspecrate");
        if (isSpecRate) {
            r = (BigDecimal)this.getModel().getValue("sellcurrencyrate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{r, r_f = (BigDecimal)this.getModel().getValue("currencyrate")})) {
                this.clearTheoryInfo();
                return;
            }
            if (!isRight) {
                r = (BigDecimal)this.getModel().getValue("currencyrate");
                r_f = (BigDecimal)this.getModel().getValue("sellcurrencyrate");
            }
            r = r.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
            r_f = r_f.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
            BigDecimal Ts = BigDecimal.valueOf((double)TcDateUtils.getDiffDays((Date)maxRefBizDate, (Date)adjustSettleDate) / 365.25);
            Zq = BigDecimal.valueOf(Math.pow(Math.E, Constants._ONE.multiply(r).multiply(Ts).doubleValue()));
            BigDecimal calDate = BigDecimal.valueOf((double)TcDateUtils.getDiffDays((Date)maxRefBizDate, (Date)maxRefBizSetDate) / 365.25);
            Zsq = BigDecimal.valueOf(Math.pow(Math.E, Constants._ONE.multiply(r_f).multiply(calDate).doubleValue()));
            Zd = BigDecimal.valueOf(Math.pow(Math.E, Constants._ONE.multiply(r).multiply(BigDecimal.valueOf(TcDateUtils.getDiffDays((Date)lastExerDate, (Date)adjustSettleDate))).doubleValue() / 365.25));
        } else {
            DynamicObject termMarket;
            DynamicObject baseMarket;
            DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, baseMarket = (DynamicObject)this.getModel().getValue("buymarket"), termMarket = (DynamicObject)this.getModel().getValue("sellmarket")})) {
                return;
            }
            Date[] queryList = new Date[]{adjustSettleDate, maxRefBizSetDate};
            PriceRuleInfo termPrInfo = MarketDataHelper.getDiscfactor(null, (Date)maxRefBizDate, (DynamicObject)priceRule, (Long[])new Long[]{termMarket.getLong("id")}, (Date[])queryList);
            Zq = OptionsBizHelper.getDfMapValue((YieldCurveInfo)termPrInfo.getYieldCurve()[0], (Date)adjustSettleDate);
            r = (BigDecimal)MarketDataHelper.getRateByYieldCurve(null, (YieldTypeEnum)YieldTypeEnum.ref, (DynamicObject)priceRule, (Long)termMarket.getLong("id"), (Date)maxRefBizDate, (Date[])new Date[]{maxRefBizSetDate}).get(maxRefBizSetDate);
            PriceRuleInfo basePrInfo = MarketDataHelper.getDiscfactor(null, (Date)maxRefBizDate, (DynamicObject)priceRule, (Long[])new Long[]{baseMarket.getLong("id")}, (Date[])queryList);
            r_f = (BigDecimal)MarketDataHelper.getRateByYieldCurve(null, (YieldTypeEnum)YieldTypeEnum.ref, (DynamicObject)priceRule, (Long)baseMarket.getLong("id"), (Date)maxRefBizDate, (Date[])new Date[]{maxRefBizSetDate}).get(maxRefBizSetDate);
            r = r.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
            r_f = r_f.divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP);
            Zsq = OptionsBizHelper.getDfMapValue((YieldCurveInfo)basePrInfo.getYieldCurve()[0], (Date)maxRefBizSetDate);
            PriceRuleInfo ZdPrInfo = MarketDataHelper.getDiscfactor(null, (Date)lastExerDate, (DynamicObject)priceRule, (Long[])new Long[]{termMarket.getLong("id")}, (Date[])queryList);
            Zd = OptionsBizHelper.getDfMapValue((YieldCurveInfo)ZdPrInfo.getYieldCurve()[0], (Date)adjustSettleDate);
        }
        if (T.compareTo(Constants.ZERO) <= 0) {
            return;
        }
        BigDecimal D_k = OptionsBizHelper.getFlagByTradeType((String)forexTradeType);
        if (OptionTypeEnum.european.getValue().equals(optionType)) {
            pv = OptionsBizHelper.calculateOptionPV((BigDecimal)forwrate, (BigDecimal)K, (BigDecimal)T, (BigDecimal)\u03c3, (BigDecimal)Ao, (BigDecimal)Zq, (BigDecimal)D_k).multiply(D_k);
            delta = this.getFLagByTradeDirect().multiply(OptionsBizHelper.calculateBsmDelta((BigDecimal)Ao, (BigDecimal)Zq, (BigDecimal)D_k, (BigDecimal)forwrate, (BigDecimal)T, (BigDecimal)K, (BigDecimal)\u03c3)).multiply(forwrate).divide(spotrate, 6, RoundingMode.HALF_UP);
            vega = OptionsBizHelper.calculateEuroBsmVega((BigDecimal)Ao, (BigDecimal)Zq, (BigDecimal)forwrate, (BigDecimal)T, (BigDecimal)K, (BigDecimal)\u03c3).multiply(this.getFLagByTradeDirect()).multiply(temp_one);
            BigDecimal gma = OptionsBizHelper.calculateEuroBsmGamma((BigDecimal)Ao, (BigDecimal)Zq, (BigDecimal)forwrate, (BigDecimal)T, (BigDecimal)K, (BigDecimal)\u03c3);
            gamma = gma.multiply(BigDecimal.valueOf(Math.pow(forwrate.doubleValue() / spotrate.doubleValue(), 2.0))).multiply(this.getFLagByTradeDirect());
            theta = OptionsBizHelper.calculateEuroBsmTheta((BigDecimal)Ao, (BigDecimal)Zq, (BigDecimal)forwrate, (BigDecimal)T, (BigDecimal)K, (BigDecimal)\u03c3, (BigDecimal)D_k, (BigDecimal)r, (BigDecimal)r_f).multiply(this.getFLagByTradeDirect());
        } else if (OptionTypeEnum.american.getValue().equals(optionType)) {
            BigDecimal T_sub;
            BigDecimal \u03c3_sub;
            BigDecimal \u03c3_add;
            BigDecimal s_sub;
            BigDecimal s_add;
            BigDecimal b = r.subtract(r_f);
            BigDecimal normal = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)K, (BigDecimal)spotrate, (BigDecimal)T, (BigDecimal)r, (BigDecimal)b, (BigDecimal)\u03c3);
            if (OptionsTradeTypeEnum.call.getValue().equals(forexTradeType)) {
                pv = normal;
                s_add = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)K, (BigDecimal)spotrate.add(temp_one), (BigDecimal)T, (BigDecimal)r, (BigDecimal)b, (BigDecimal)\u03c3);
                s_sub = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)K, (BigDecimal)spotrate.subtract(temp_one), (BigDecimal)T, (BigDecimal)r, (BigDecimal)b, (BigDecimal)\u03c3);
                \u03c3_add = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)K, (BigDecimal)spotrate, (BigDecimal)T, (BigDecimal)r, (BigDecimal)b, (BigDecimal)\u03c3.add(temp_one));
                \u03c3_sub = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)K, (BigDecimal)spotrate, (BigDecimal)T, (BigDecimal)r, (BigDecimal)b, (BigDecimal)\u03c3.subtract(temp_one));
                T_sub = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)K, (BigDecimal)spotrate, (BigDecimal)T.subtract(temp_one), (BigDecimal)r, (BigDecimal)b, (BigDecimal)\u03c3);
            } else {
                pv = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)spotrate, (BigDecimal)K, (BigDecimal)T, (BigDecimal)r.subtract(b), (BigDecimal)Constants._ONE.multiply(b), (BigDecimal)\u03c3);
                s_add = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)spotrate.add(temp_one), (BigDecimal)K, (BigDecimal)T, (BigDecimal)r.subtract(b), (BigDecimal)Constants._ONE.multiply(b), (BigDecimal)\u03c3);
                s_sub = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)spotrate.subtract(temp_one), (BigDecimal)K, (BigDecimal)T, (BigDecimal)r.subtract(b), (BigDecimal)Constants._ONE.multiply(b), (BigDecimal)\u03c3);
                normal = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)spotrate, (BigDecimal)K, (BigDecimal)T, (BigDecimal)r.subtract(b), (BigDecimal)Constants._ONE.multiply(b), (BigDecimal)\u03c3);
                \u03c3_add = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)spotrate, (BigDecimal)K, (BigDecimal)T, (BigDecimal)r.subtract(b), (BigDecimal)Constants._ONE.multiply(b), (BigDecimal)\u03c3.add(temp_one));
                \u03c3_sub = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)spotrate, (BigDecimal)K, (BigDecimal)T, (BigDecimal)r.subtract(b), (BigDecimal)Constants._ONE.multiply(b), (BigDecimal)\u03c3.subtract(temp_one));
                T_sub = OptionsBizHelper.americanCal((BigDecimal)Ao, (BigDecimal)Zd, (BigDecimal)spotrate, (BigDecimal)K, (BigDecimal)T.subtract(temp_one), (BigDecimal)r.subtract(b), (BigDecimal)Constants._ONE.multiply(b), (BigDecimal)\u03c3);
            }
            delta = s_add.subtract(s_sub).divide(temp_two, 10, RoundingMode.HALF_UP).multiply(this.getFLagByTradeDirect());
            gamma = s_add.subtract(new BigDecimal(2).multiply(normal)).add(s_sub).divide(BigDecimal.valueOf(Math.pow(temp_one.doubleValue(), 2.0)), 10, RoundingMode.HALF_UP).multiply(this.getFLagByTradeDirect());
            vega = \u03c3_add.subtract(\u03c3_sub).divide(new BigDecimal("2"), 10, RoundingMode.HALF_UP);
            theta = Constants._ONE.multiply(normal.subtract(T_sub).divide(temp_one.multiply(BigDecimal.valueOf(365.25)), 10, RoundingMode.HALF_UP).multiply(this.getFLagByTradeDirect()));
        }
        if (pv.scale() > 10) {
            pv = pv.setScale(10, 4);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"calculatepv", (Object)pv);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"delta", (Object)delta.multiply(CF));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"vega", (Object)vega);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"caltheta", (Object)theta);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"gamma", (Object)gamma.multiply(BigDecimal.valueOf(Math.pow(CF.doubleValue(), 2.0))));
        if (EmptyUtil.isNoEmpty((BigDecimal)Ao)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pvpercent", (Object)pv.divide(Ao, 6, RoundingMode.HALF_UP));
        }
        BigDecimal calculateHedgeAmount = OptionsBizHelper.calculateHedgeAmount((boolean)isRight, (BigDecimal)spotrate, (BigDecimal)delta.multiply(CF), (BigDecimal)Zsq);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"hedgeamount", (Object)calculateHedgeAmount);
    }

    private BigDecimal getFLagByTradeDirect() {
        String tradedirect = (String)this.getModel().getValue("tradedirect");
        return TradeDirectionEnum.sell.getValue().equals(tradedirect) ? Constants._ONE : Constants.ONE;
    }
}

