/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forxoption;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class ForxOptionAdjustPlugin
extends AbstractTmcBillEdit {
    private static Log logger = LogFactory.getLog(ForxOptionAdjustPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("reqnoteno"))) {
                return;
            }
            this.callSettleDate();
            this.callAdjustSettleDate();
            this.setAdjexpireDateRange();
            this.calculatePremiumDate();
        } else {
            this.setAdjexpireDateRange();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "adjustsettledate": {
                this.calAdjustExpireDate();
                this.setAdjexpireDateRange();
                break;
            }
            case "bizdate": 
            case "settledelay": 
            case "term": 
            case "dateadjustmethod": {
                this.callSettleDate();
                this.callAdjustSettleDate();
                this.calAdjustExpireDate();
                this.calculatePremiumDate();
                this.setAdjexpireDateRange();
                break;
            }
            case "settledate": {
                int oldSettleDelay = (Integer)this.getModel().getValue("settledelay");
                this.callTerm();
                this.callAdjustSettleDate();
                this.calAdjustExpireDate();
                int newSettleDelay = (Integer)this.getModel().getValue("settledelay");
                if (oldSettleDelay == newSettleDelay) break;
                this.calculatePremiumDate();
                break;
            }
            case "workcalendar": {
                this.callAdjustSettleDate();
            }
        }
    }

    private void callSettleDate() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        logger.info("[bizdate] = " + bizdate);
        if (!EmptyUtil.isEmpty((Object)bizdate)) {
            int settleDelay = (Integer)this.getModel().getValue("settledelay");
            DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            Date settleDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizdate, (int)settleDelay);
            if (this.getModel().getProperty("term") != null) {
                String term = (String)this.getModel().getValue("term");
                settleDate = TermUtils.getDateByBaseDate4ymd((String)term, (Date)settleDate);
            }
            ((DateEdit)this.getControl("settledate")).setMinDate(bizdate);
            logger.info("[settleDate0] = " + settleDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate", (Object)settleDate);
        }
    }

    private void callAdjustSettleDate() {
        Date settleDate = (Date)this.getModel().getValue("settledate");
        logger.info("[settleDate1] = " + settleDate);
        if (EmptyUtil.isNoEmpty((Object)settleDate)) {
            AdjustMethodEnum adjustmethod = AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod")));
            DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            Date ad_settleDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)TcDateUtils.truncateDate((Date)settleDate), (AdjustMethodEnum)adjustmethod);
            logger.info("[ad_settleDate] = " + ad_settleDate);
            this.getModel().setValue("adjustsettledate", (Object)ad_settleDate);
        }
    }

    private void calAdjustExpireDate() {
        Date ad_settleDate = (Date)this.getModel().getValue("adjustsettledate");
        IDataEntityProperty property = this.getModel().getProperty("adjexpiredate");
        int settleDelay = (Integer)this.getModel().getValue("settledelay");
        if (EmptyUtil.isNoEmpty((Object)ad_settleDate) && EmptyUtil.isNoEmpty((Object)property)) {
            DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            this.getModel().setValue("adjexpiredate", (Object)TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)ad_settleDate, (int)(-settleDelay)));
        }
    }

    private void calculatePremiumDate() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        int settleDelay = (Integer)this.getModel().getValue("settledelay");
        if (EmptyUtil.isNoEmpty((Object)bizdate)) {
            DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            Date premiumDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizdate, (int)settleDelay);
            this.getModel().setValue("premiumdate", (Object)premiumDate);
        }
    }

    private void setAdjexpireDateRange() {
        Date adjustSettleDate;
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        DateEdit dateEdit = (DateEdit)this.getControl("adjexpiredate");
        if (bizdate != null) {
            dateEdit.setMinDate(bizdate);
        }
        if ((adjustSettleDate = (Date)this.getModel().getValue("adjustsettledate")) != null) {
            dateEdit.setMaxDate(adjustSettleDate);
        }
    }

    private void callTerm() {
        Date settleDate = (Date)this.getModel().getValue("settledate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        if (EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)settleDate)) {
            DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            Date offsetDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)2);
            if (!settleDate.after(offsetDate)) {
                int offset_new = TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)bizDate, (Date)settleDate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)offset_new);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)2);
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TcDateUtils.getDiffYMD((Date)offsetDate, (Date)settleDate));
        }
    }
}

