/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.chart.AbstractLineChartEdit;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class AppHomeIncreasedPlugin
extends AbstractLineChartEdit {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        super.drawChart();
    }

    protected String getXTitleName() {
        return "";
    }

    protected String getYTitleName() {
        return "";
    }

    protected String getChartCtlName() {
        return "barchartap";
    }

    protected boolean isSwitchXY() {
        return true;
    }

    protected void initSeriesStyle(int index, Chart chart, Series series, String color) {
        super.initSeriesStyle(index, chart, series, color);
        BarSeries barSeries = (BarSeries)series;
        Label label = barSeries.getLabel();
        label.setShow(Boolean.TRUE.booleanValue());
        label.setPosition(Position.right);
        barSeries.setLabel(label);
        barSeries.setItemColor("#40A9FF");
        barSeries.setBarWidth("15px");
    }

    protected String[] getXValue() {
        ArrayList<String> dem = new ArrayList<String>();
        List<Map<String, BigDecimal>> amountAndCount = this.getAmountAndCount();
        for (int i = amountAndCount.size() - 1; i >= 0; --i) {
            Map<String, BigDecimal> map = amountAndCount.get(i);
            for (String key : map.keySet()) {
                QFilter[] filter;
                DynamicObject currency;
                if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AppHomeIncreasedPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]), (CharSequence)key)) {
                    dem.add(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AppHomeIncreasedPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"total", (CharSequence)key) || StringUtils.equals((CharSequence)"0", (CharSequence)key) || (currency = TmcDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,name", (QFilter[])(filter = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(key))}))) == null) continue;
                dem.add(currency.getString("name"));
            }
        }
        return dem.toArray(new String[dem.size()]);
    }

    protected List<Object> getSeriesValue() {
        ArrayList<Object> turnover = new ArrayList<Object>();
        ArrayList<BigDecimal> v = new ArrayList<BigDecimal>();
        List<Map<String, BigDecimal>> amountAndCount = this.getAmountAndCount();
        for (int i = amountAndCount.size() - 1; i >= 0; --i) {
            Map<String, BigDecimal> map = amountAndCount.get(i);
            for (Map.Entry<String, BigDecimal> entry : map.entrySet()) {
                String mapKey = entry.getKey();
                BigDecimal mapValue = entry.getValue();
                if (!StringUtils.equals((CharSequence)"total", (CharSequence)mapKey) && !StringUtils.equals((CharSequence)"0", (CharSequence)mapKey)) {
                    v.add(mapValue);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"total", (CharSequence)mapKey)) continue;
                kd.bos.form.control.Label labelName = (kd.bos.form.control.Label)this.getView().getControl("total");
                labelName.setText(mapValue.toString());
            }
        }
        turnover.add(v.toArray(new Number[v.size()]));
        return turnover;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        super.drawChart();
    }

    private List<Map<String, BigDecimal>> getAmountAndCount() {
        Date endDate;
        Date startDate;
        Date now = TcDateUtils.getDataFormat((Date)new Date(), (boolean)true);
        String datetype = (String)this.getModel().getValue("datetype");
        if (StringUtils.equals((CharSequence)"define", (CharSequence)datetype)) {
            startDate = (Date)this.getModel().getValue("daterange_startdate");
            endDate = (Date)this.getModel().getValue("daterange_enddate");
            if (startDate == null || endDate == null) {
                kd.bos.form.control.Label labelName = (kd.bos.form.control.Label)this.getView().getControl("total");
                labelName.setText("0");
                return new ArrayList<Map<String, BigDecimal>>();
            }
            endDate = TcDateUtils.getDataFormat((Date)endDate, (boolean)false);
        } else {
            startDate = TermUtils.getLastDateByBaseDate4ymd((String)datetype, (Date)now);
            endDate = new Date();
        }
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"tm_trade", (String)"47150e89000000ac");
        Long[] fxIds = new Long[]{Long.parseLong(ProductTypeEnum.FOREXSPOT.getId()), Long.parseLong(ProductTypeEnum.FOREXFORWARD.getId()), Long.parseLong(ProductTypeEnum.FOREXOPTION.getId()), Long.parseLong(ProductTypeEnum.FOREXSWAPS.getId())};
        QFilter pQF = new QFilter("protecttype", "in", (Object)fxIds);
        QFilter dateQF = new QFilter("createtime", ">=", (Object)startDate);
        dateQF.and(new QFilter("createtime", "<=", (Object)endDate));
        QFilter orgQF = new QFilter("org", "in", (Object)authOrgIds);
        DataSet fxDS = QueryServiceHelper.queryDataSet((String)"home-inc-trade-fx", (String)"tm_forex", (String)String.join((CharSequence)",", "amount", "currency", "sellcurrency", "sellamount"), (QFilter[])new QFilter[]{pQF, dateQF, orgQF}, null);
        int total = 0;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(15);
        if (!fxDS.isEmpty()) {
            for (Row row : fxDS) {
                String currencyId = row.getString("currency");
                BigDecimal amount = row.getBigDecimal("amount");
                this.recordMap(map, currencyId, amount);
                String sellcurrencyId = row.getString("sellcurrency");
                BigDecimal sellamount = row.getBigDecimal("sellamount");
                this.recordMap(map, sellcurrencyId, sellamount);
                ++total;
            }
        }
        Long[] ratePIds = new Long[]{Long.parseLong(ProductTypeEnum.FORWRATEAGREE.getId()), Long.parseLong(ProductTypeEnum.STRUCTDEPOSIT.getId())};
        QFilter ratePQF = new QFilter("protecttype", "in", (Object)ratePIds);
        DataSet rateDS = QueryServiceHelper.queryDataSet((String)"home-inc-trade-rate", (String)"tm_trade", (String)String.join((CharSequence)",", "currency", "amount"), (QFilter[])new QFilter[]{ratePQF, dateQF, orgQF}, null);
        if (!rateDS.isEmpty()) {
            for (Row row : rateDS) {
                String currencyId = row.getString("currency");
                BigDecimal amount = row.getBigDecimal("amount");
                this.recordMap(map, currencyId, amount);
                ++total;
            }
        }
        QFilter swQF = new QFilter("protecttype", "=", (Object)Long.parseLong(ProductTypeEnum.SWAP.getId()));
        DataSet swDS = QueryServiceHelper.queryDataSet((String)"home-inc-trade-rateswp", (String)"tm_rateswap", (String)String.join((CharSequence)",", "currency", "amount", "rateswaptype", "recamount", "reccurrency"), (QFilter[])new QFilter[]{swQF, dateQF, orgQF}, null);
        if (!swDS.isEmpty()) {
            for (Row row : swDS) {
                String currencyId = row.getString("currency");
                BigDecimal amount = row.getBigDecimal("amount");
                this.recordMap(map, currencyId, amount);
                String swapType = row.getString("rateswaptype");
                if (SwapTypeEnum.currency.getValue().equals(swapType)) {
                    String reccurrency = row.getString("reccurrency");
                    BigDecimal recamount = row.getBigDecimal("recamount");
                    this.recordMap(map, reccurrency, recamount);
                }
                ++total;
            }
        }
        List<Map<String, BigDecimal>> returnList = this.sortMapValue(map);
        HashMap<String, BigDecimal> totalMap = new HashMap<String, BigDecimal>();
        totalMap.put("total", new BigDecimal(total));
        returnList.add(totalMap);
        return returnList;
    }

    private List<Map<String, BigDecimal>> sortMapValue(Map<String, BigDecimal> map) {
        ArrayList<Map.Entry<String, BigDecimal>> list = new ArrayList<Map.Entry<String, BigDecimal>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        BigDecimal other = BigDecimal.ZERO;
        ArrayList<Map<String, BigDecimal>> returnList = new ArrayList<Map<String, BigDecimal>>();
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            HashMap<String, BigDecimal> newMap = new HashMap<String, BigDecimal>();
            if (i > 4) {
                other = other.add((BigDecimal)e.getValue());
                if (i != list.size() - 1) continue;
                newMap.put(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AppHomeIncreasedPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]), other.divide(Constants.TEN_THOUSAND, 2, 4));
                returnList.add(newMap);
                continue;
            }
            newMap.put((String)e.getKey(), ((BigDecimal)e.getValue()).divide(Constants.TEN_THOUSAND, 2, 4));
            returnList.add(newMap);
        }
        return returnList;
    }

    private void recordMap(Map<String, BigDecimal> map, String currency, BigDecimal amount) {
        if (currency == null) {
            return;
        }
        if (amount == null || BigDecimal.ZERO.compareTo(amount) == 0) {
            return;
        }
        if (map.isEmpty()) {
            map.put(currency, amount);
        } else {
            BigDecimal totalAmt = map.get(currency);
            if (totalAmt != null) {
                map.put(currency, totalAmt.add(amount));
            } else {
                map.put(currency, amount);
            }
        }
    }
}

