/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.home;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class TmConditionEdit
extends AbstractFormPlugin {
    private static final String KEY_FILTERGRIDAP = "filtergridap";
    private static final String KEY_BUTTON_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button ok = (Button)this.getView().getControl(KEY_BUTTON_OK);
        ok.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRIDAP);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        filterGrid.setEntityNumber(entityNumber);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRIDAP);
        FilterCondition filterCondition = this.loadFilter();
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    private FilterCondition loadFilter() {
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        if (StringUtils.isBlank((CharSequence)conditonJson)) {
            return null;
        }
        CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditonJson, CRCondition.class);
        FilterCondition filterCondition = conditionObj.getFilterCondition();
        return filterCondition;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTON_OK)) {
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
            CRFormula formulaObj = this.deserialize(conditonJson);
            FilterCondition filterCondition = this.getFilter(formulaObj);
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
            String filter = this.saveFilter(filterCondition, formulaObj);
            this.getView().returnDataToParent((Object)filter);
            this.getView().close();
        }
    }

    private FilterCondition getFilter(CRFormula formulaObj) {
        CRCondition conditionObj = (CRCondition)formulaObj;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        conditionObj.setFilterCondition(condition);
        return condition;
    }

    private String saveFilter(FilterCondition filterCondition, CRFormula formulaObj) {
        String filter = "";
        if (filterCondition != null) {
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
            filter = SerializationUtils.toJsonString((Object)formulaObj);
        }
        return filter;
    }

    protected CRFormula deserialize(String json) {
        CRCondition conditionObj = null;
        conditionObj = StringUtils.isBlank((CharSequence)json) ? new CRCondition() : (CRCondition)SerializationUtils.fromJsonString((String)json, CRCondition.class);
        return conditionObj;
    }

    protected String tranFormula(CRFormula formulaObj) {
        String tranExpr = "";
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray());
        }
        return tranExpr;
    }
}

